﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include <nn/nn_Common.h>
#include <nn/nn_Result.h>
#include <nn/lcs/detail/lcs_ApplicationShareInfo.h>
#include <nn/lcs/detail/lcs_SystemShareInfo.h>
#include <nn/lcs/detail/lcs_Util.h>
#include <nn/ns/ns_Async.h>
#include <nn/ns/ns_RequestServerStopper.h>

namespace nn { namespace lcs { namespace detail
{

    void GetRequestServerStopper(nn::ns::RequestServerStopper* request) NN_NOEXCEPT;

    Result CanGetApplicationInfo(Bit64 id) NN_NOEXCEPT;

    Result GetApplicationDeliveryInfo(int* pOutCount, ApplicationDeliveryInfo *pOutInfoList,
        int listCount, const Bit64 id) NN_NOEXCEPT;

    Result HasAllContentsToDeliver(
        bool* outValue, const ApplicationDeliveryInfo* appInfoList, int listCount) NN_NOEXCEPT;

    Result CompareApplicationDeliveryInfo(int* pOutValue,
        ApplicationDeliveryInfo* lhs, int lhsCount,
        ApplicationDeliveryInfo* rhs, int rhsCount) NN_NOEXCEPT;

    Result CanDeliverApplication(
        bool* outValue, const ApplicationDeliveryInfo* receiverInfoList, int receiverInfoListCount,
        const ApplicationDeliveryInfo* senderInfoList, int senderInfoListCount) NN_NOEXCEPT;

    Result CanDeliverApplication(
        const ApplicationDeliveryInfo* senderInfoList, int senderInfoListCount,
        void* appDeliveryInfoBuffer, size_t appDeliveryInfoBufferSize) NN_NOEXCEPT;

    Result NeedsSystemUpdateToDeliverApplication(
        bool* outValue, const ApplicationDeliveryInfo* appInfoList, int appInfoListCount,
        const SystemDeliveryInfo& receiverSystemInfo) NN_NOEXCEPT;

    Result ListContentMetaKeyToDeliverApplication(
        int* outCount, ContentMetaKey* outList, int listCount, Bit64 id) NN_NOEXCEPT;

    Result RequestReceiveApplication(nn::ns::AsyncResult* asyncResult,
        Ipv4Address fromAddress, uint16_t port,
        Bit64 id, ContentMetaKey* key, int keyCount) NN_NOEXCEPT;

    Result CommitReceiveApplication(Bit64 id) NN_NOEXCEPT;

    Result GetReceiveApplicationProgress(
        uint64_t* downloadedSize, uint64_t* totalSize, Bit64 id) NN_NOEXCEPT;

    Result ConfirmSendApplication(const ApplicationInfo& appInfo) NN_NOEXCEPT;

    Result RequestSendApplication(nn::ns::AsyncResult* asyncResult,
        Ipv4Address toAddress, uint16_t port, Bit64 id) NN_NOEXCEPT;

    Result GetSendApplicationProgress(
        uint64_t* deliveredSize, uint64_t* totalSize, Bit64 id) NN_NOEXCEPT;

    Result EvacuateDownloadTask(DownloadTaskInfo* pOutDownloadTaskInfo, Bit64 id) NN_NOEXCEPT;

    Result RecreateDownloadTask(const DownloadTaskInfo& DownloadTaskInfo) NN_NOEXCEPT;

    void ShowApplicationDeliveryInfo(const ApplicationDeliveryInfo& info) NN_NOEXCEPT;

    void ShowContentMetaKey(const ContentMetaKey& key) NN_NOEXCEPT;

}}} // end of namespace nn::lcs
