﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include <nn/nn_Common.h>
#include <nn/nn_Result.h>
#include <nn/lcs/lcs_Types.h>
#include <nn/lcs/detail/lcs_Resource.h>
#include <nn/lcs/detail/Advertise/lcs_Advertise.h>

namespace nn { namespace lcs { namespace detail
{

    class AdvertiseManager
    {
    public:
        Result MakeAdvertiseData(const SessionSettings& settings,
            const Version& version, const char* name, char* buffer, size_t bufferSize) NN_NOEXCEPT;

        void GetAdvertiseData(AdvertiseData* pOutData) NN_NOEXCEPT;

        void SetAdvertiseData(const AdvertiseData& data) NN_NOEXCEPT;

        void SetNodeCount(int count) NN_NOEXCEPT;

        void SetContentInfo(size_t requiredSize, char* displayVersion, int appIndex) NN_NOEXCEPT;

        void SetSessionSetting(SessionAttribute attribute) NN_NOEXCEPT;

        void SetSessionState(SessionState state) NN_NOEXCEPT;

        void SetNodeProgress(AdvertiseNodeProgress *progress, int progressCount) NN_NOEXCEPT;

        void SetConteShareSucceeded(bool isSuccess) NN_NOEXCEPT;

        Result UpdateAdvertiseData() NN_NOEXCEPT;


    private:
        AdvertiseData m_AdvertiseData;
    };

}}} // end of namespace nn::lcs
