﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include <nn/kpr/detail/kpr_KeyCodeMap.h>

namespace nn { namespace kpr { namespace detail {

namespace {

const KeyCodeMapStorage KeyCodeMapSpanish =
{ { { 0x01000001 } }, 4, 100, 3, {}, {
    BasicLetter, 0x0061, 0x0041, 0x0000, // A
    BasicLetter, 0x0062, 0x0042, 0x0000, // B
    BasicLetter, 0x0063, 0x0043, 0x0000, // C
    BasicLetter, 0x0064, 0x0044, 0x0000, // D
    BasicLetter, 0x0065, 0x0045, 0x20AC, // E €
    BasicLetter, 0x0066, 0x0046, 0x0000, // F
    BasicLetter, 0x0067, 0x0047, 0x0000, // G
    BasicLetter, 0x0068, 0x0048, 0x0000, // H
    BasicLetter, 0x0069, 0x0049, 0x0000, // I
    BasicLetter, 0x006A, 0x004A, 0x0000, // J
    BasicLetter, 0x006B, 0x004B, 0x0000, // K
    BasicLetter, 0x006C, 0x004C, 0x0000, // L
    BasicLetter, 0x006D, 0x004D, 0x0000, // M
    BasicLetter, 0x006E, 0x004E, 0x0000, // N
    BasicLetter, 0x006F, 0x004F, 0x0000, // O
    BasicLetter, 0x0070, 0x0050, 0x0000, // P
    BasicLetter, 0x0071, 0x0051, 0x0000, // Q
    BasicLetter, 0x0072, 0x0052, 0x0000, // R
    BasicLetter, 0x0073, 0x0053, 0x0000, // S
    BasicLetter, 0x0074, 0x0054, 0x0000, // T
    BasicLetter, 0x0075, 0x0055, 0x0000, // U
    BasicLetter, 0x0076, 0x0056, 0x0000, // V
    BasicLetter, 0x0077, 0x0057, 0x0000, // W
    BasicLetter, 0x0078, 0x0058, 0x0000, // X
    BasicLetter, 0x0079, 0x0059, 0x0000, // Y
    BasicLetter, 0x007A, 0x005A, 0x0000, // Z
    BasicSymbol, 0x0031, 0x0021, 0x007C, // 1 ! |
    BasicSymbol, 0x0032, 0x0022, 0x0040, // 2 " @
    BasicSymbol, 0x0033, 0x00B7, 0x0023, // 3 · #
    BasicSymbol, 0x0034, 0x0024, 0x0303, // 4 $ ~
    BasicSymbol, 0x0035, 0x0025, 0x20AC, // 5 % €
    BasicSymbol, 0x0036, 0x0026, 0x00AC, // 6 & ¬
    BasicSymbol, 0x0037, 0x002F, 0x0000, // 7 /
    BasicSymbol, 0x0038, 0x0028, 0x0000, // 8 (
    BasicSymbol, 0x0039, 0x0029, 0x0000, // 9 )
    BasicSymbol, 0x0030, 0x003D, 0x0000, // 0 =
    BasicSystem, 0x0000, 0x0000, 0x0000, // Enter
    BasicSystem, 0x0000, 0x0000, 0x0000, // Escape
    BasicSystem, 0x0000, 0x0000, 0x0000, // Backspace
    BasicSystem, 0x0000, 0x0000, 0x0000, // Tab
    BasicSymbol, 0x0020, 0x0020, 0x0020, // Space
    BasicSymbol, 0x0027, 0x003F, 0x0000, // ' ?
    BasicSymbol, 0x00A1, 0x00BF, 0x0000, // ¡ ¿
    BasicSymbol, 0x0300, 0x0302, 0x005B, // ` ^ [
    BasicSymbol, 0x002B, 0x002A, 0x005D, // + * ]
    BasicLetter, 0x00E7, 0x00C7, 0x007D, // Ç }
    BasicLetter, 0x00E7, 0x00C7, 0x007D, // Ç }
    BasicLetter, 0x00F1, 0x00D1, 0x0000, // Ñ
    BasicSymbol, 0x0301, 0x0308, 0x007B, // ´ ¨ {
    BasicSymbol, 0x00BA, 0x00AA, 0x005C, // º ª Backslash
    BasicSymbol, 0x002C, 0x003B, 0x0000, // , ;
    BasicSymbol, 0x002E, 0x003A, 0x0000, // . :
    BasicSymbol, 0x002D, 0x005F, 0x0000, // - _
    BasicSystem, 0x0000, 0x0000, 0x0000, // Caps Lock
    BasicSystem, 0x0000, 0x0000, 0x0000, // F1
    BasicSystem, 0x0000, 0x0000, 0x0000, // F2
    BasicSystem, 0x0000, 0x0000, 0x0000, // F3
    BasicSystem, 0x0000, 0x0000, 0x0000, // F4
    BasicSystem, 0x0000, 0x0000, 0x0000, // F5
    BasicSystem, 0x0000, 0x0000, 0x0000, // F6
    BasicSystem, 0x0000, 0x0000, 0x0000, // F7
    BasicSystem, 0x0000, 0x0000, 0x0000, // F8
    BasicSystem, 0x0000, 0x0000, 0x0000, // F9
    BasicSystem, 0x0000, 0x0000, 0x0000, // F10
    BasicSystem, 0x0000, 0x0000, 0x0000, // F11
    BasicSystem, 0x0000, 0x0000, 0x0000, // F12
    BasicSystem, 0x0000, 0x0000, 0x0000, // PrintScreen
    BasicSystem, 0x0000, 0x0000, 0x0000, // Scroll Lock
    BasicSystem, 0x0000, 0x0000, 0x0000, // Pause
    BasicSystem, 0x0000, 0x0000, 0x0000, // Insert
    BasicSystem, 0x0000, 0x0000, 0x0000, // Home
    BasicSystem, 0x0000, 0x0000, 0x0000, // PageUp
    BasicSystem, 0x0000, 0x0000, 0x0000, // Delete
    BasicSystem, 0x0000, 0x0000, 0x0000, // End
    BasicSystem, 0x0000, 0x0000, 0x0000, // PageDown
    BasicSystem, 0x0000, 0x0000, 0x0000, // →
    BasicSystem, 0x0000, 0x0000, 0x0000, // ←
    BasicSystem, 0x0000, 0x0000, 0x0000, // ↓
    BasicSystem, 0x0000, 0x0000, 0x0000, // ↑
    BasicSystem, 0x0000, 0x0000, 0x0000, // Num Lock
    BasicSymbol, 0x002F, 0x002F, 0x002F, // Keypad /
    BasicSymbol, 0x002A, 0x002A, 0x002A, // Keypad *
    BasicSymbol, 0x002D, 0x002D, 0x002D, // Keypad -
    BasicSymbol, 0x002B, 0x002B, 0x002B, // Keypad +
    BasicSystem, 0x0000, 0x0000, 0x0000, // Keypad Enter
    BasicKeypad, 0x0000, 0x0031, 0x0000, // Keypad 1
    BasicKeypad, 0x0000, 0x0032, 0x0000, // Keypad 2
    BasicKeypad, 0x0000, 0x0033, 0x0000, // Keypad 3
    BasicKeypad, 0x0000, 0x0034, 0x0000, // Keypad 4
    BasicKeypad, 0x0020, 0x0035, 0x0000, // Keypad 5
    BasicKeypad, 0x0000, 0x0036, 0x0000, // Keypad 6
    BasicKeypad, 0x0000, 0x0037, 0x0000, // Keypad 7
    BasicKeypad, 0x0000, 0x0038, 0x0000, // Keypad 8
    BasicKeypad, 0x0000, 0x0039, 0x0000, // Keypad 9
    BasicKeypad, 0x0000, 0x0030, 0x0000, // Keypad 0
    BasicKeypad, 0x0000, 0x002E, 0x0000, // Keypad .
    BasicSymbol, 0x003C, 0x003E, 0x0000, // < >
    BasicSystem, 0x0000, 0x0000, 0x0000, // Application
    BasicSystem, 0x0000, 0x0000, 0x0000, // Power
    BasicSymbol, 0x003D, 0x003D, 0x003D, // Keypad =
} };

} // namespace

}}} // namespace nn::kpr::detail
