﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include <nn/kpr/detail/kpr_KeyCodeMap.h>

namespace nn { namespace kpr { namespace detail {

namespace {

const KeyCodeMapStorage KeyCodeMapJapanese =
{ { { 0x00000007 } }, 7, 136, 0, {}, {
    BasicLetter, 0x0061, 0x0041, 0x3061, 0x3061, 0x30C1, 0x30C1, // A ち
    BasicLetter, 0x0062, 0x0042, 0x3053, 0x3053, 0x30B3, 0x30B3, // B こ
    BasicLetter, 0x0063, 0x0043, 0x305D, 0x305D, 0x30BD, 0x30BD, // C そ
    BasicLetter, 0x0064, 0x0044, 0x3057, 0x3057, 0x30B7, 0x30B7, // D し
    BasicLetter, 0x0065, 0x0045, 0x3044, 0x3043, 0x30A4, 0x30A3, // E い
    BasicLetter, 0x0066, 0x0046, 0x306F, 0x306F, 0x30CF, 0x30CF, // F は
    BasicLetter, 0x0067, 0x0047, 0x304D, 0x304D, 0x30AD, 0x30AD, // G き
    BasicLetter, 0x0068, 0x0048, 0x304F, 0x304F, 0x30AF, 0x30AF, // H く
    BasicLetter, 0x0069, 0x0049, 0x306B, 0x306B, 0x30CB, 0x30CB, // I に
    BasicLetter, 0x006A, 0x004A, 0x307E, 0x307E, 0x30DE, 0x30DE, // J ま
    BasicLetter, 0x006B, 0x004B, 0x306E, 0x306E, 0x30CE, 0x30CE, // K の
    BasicLetter, 0x006C, 0x004C, 0x308A, 0x308A, 0x30EA, 0x30EA, // L り
    BasicLetter, 0x006D, 0x004D, 0x3082, 0x3082, 0x30E2, 0x30E2, // M も
    BasicLetter, 0x006E, 0x004E, 0x307F, 0x307F, 0x30DF, 0x30DF, // N み
    BasicLetter, 0x006F, 0x004F, 0x3089, 0x3089, 0x30E9, 0x30E9, // O ら
    BasicLetter, 0x0070, 0x0050, 0x305B, 0x305B, 0x30BB, 0x30BB, // P せ
    BasicLetter, 0x0071, 0x0051, 0x305F, 0x305F, 0x30BF, 0x30BF, // Q た
    BasicLetter, 0x0072, 0x0052, 0x3059, 0x3059, 0x30B9, 0x30B9, // R す
    BasicLetter, 0x0073, 0x0053, 0x3068, 0x3068, 0x30C8, 0x30C8, // S と
    BasicLetter, 0x0074, 0x0054, 0x304B, 0x304B, 0x30AB, 0x30AB, // T か
    BasicLetter, 0x0075, 0x0055, 0x306A, 0x306A, 0x30CA, 0x30CA, // U な
    BasicLetter, 0x0076, 0x0056, 0x3072, 0x3072, 0x30D2, 0x30D2, // V ひ
    BasicLetter, 0x0077, 0x0057, 0x3066, 0x3066, 0x30C6, 0x30C6, // W て
    BasicLetter, 0x0078, 0x0058, 0x3055, 0x3055, 0x30B5, 0x30B5, // X さ
    BasicLetter, 0x0079, 0x0059, 0x3093, 0x3093, 0x30F3, 0x30F3, // Y ん
    BasicLetter, 0x007A, 0x005A, 0x3064, 0x3063, 0x30C4, 0x30C3, // Z つ
    BasicSymbol, 0x0031, 0x0021, 0x306C, 0x306C, 0x30CC, 0x30CC, // 1 ! ぬ
    BasicSymbol, 0x0032, 0x0022, 0x3075, 0x3075, 0x30D5, 0x30D5, // 2 " ふ
    BasicSymbol, 0x0033, 0x0023, 0x3042, 0x3041, 0x30A2, 0x30A1, // 3 # あ ぁ
    BasicSymbol, 0x0034, 0x0024, 0x3046, 0x3045, 0x30A6, 0x30A5, // 4 $ う ぅ
    BasicSymbol, 0x0035, 0x0025, 0x3048, 0x3047, 0x30A8, 0x30A7, // 5 % え ぇ
    BasicSymbol, 0x0036, 0x0026, 0x304A, 0x3049, 0x30AA, 0x30A9, // 6 & お ぉ
    BasicSymbol, 0x0037, 0x0027, 0x3084, 0x3083, 0x30E4, 0x30E3, // 7 ' や ゃ
    BasicSymbol, 0x0038, 0x0028, 0x3086, 0x3085, 0x30E6, 0x30E5, // 8 ( ゆ ゅ
    BasicSymbol, 0x0039, 0x0029, 0x3088, 0x3087, 0x30E8, 0x30E7, // 9 ) よ ょ
    BasicSymbol, 0x0030, 0x0000, 0x308F, 0x3092, 0x30EF, 0x30F2, // 0   わ を
    BasicSystem, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, // Enter
    BasicSystem, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, // Escape
    BasicSystem, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, // Backspace
    BasicSystem, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, // Tab
    BasicSymbol, 0x0020, 0x0020, 0x0020, 0x0020, 0x0020, 0x0020, // Space
    BasicSymbol, 0x002D, 0x003D, 0x307B, 0x307B, 0x30DB, 0x30DB, // - = ほ
    BasicSymbol, 0x005E, 0x007E, 0x3078, 0x3078, 0x30D8, 0x30D8, // ^ ~ へ
    BasicSymbol, 0x0040, 0x0060, 0xFF9E, 0xFF9E, 0xFF9E, 0xFF9E, // @ ` ゛
    BasicSymbol, 0x005B, 0x007B, 0xFF9F, 0xFF62, 0xFF9F, 0xFF62, // [ { ゜ ｢
    BasicSymbol, 0x005D, 0x007D, 0x3080, 0xFF63, 0x30E0, 0xFF63, // ] } む ｣
    BasicSymbol, 0x005D, 0x007D, 0x3080, 0xFF63, 0x30E0, 0xFF63, // for SunRace
    BasicSymbol, 0x003B, 0x002B, 0x308C, 0x308C, 0x30EC, 0x30EC, // ; + れ
    BasicSymbol, 0x003A, 0x002A, 0x3051, 0x3051, 0x30B1, 0x30B1, // : * け
    BasicSystem, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, // 半角/全角
    BasicSymbol, 0x002C, 0x003C, 0x306D, 0xFF64, 0x30CD, 0xFF64, // , < ね ､
    BasicSymbol, 0x002E, 0x003E, 0x308B, 0xFF61, 0x30EB, 0xFF61, // . > る ｡
    BasicSymbol, 0x002F, 0x003F, 0x3081, 0xFF65, 0x30E1, 0xFF65, // / ? め ･
    BasicSystem, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, // Caps Lock
    BasicSystem, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, // F1
    BasicSystem, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, // F2
    BasicSystem, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, // F3
    BasicSystem, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, // F4
    BasicSystem, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, // F5
    BasicSystem, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, // F6
    BasicSystem, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, // F7
    BasicSystem, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, // F8
    BasicSystem, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, // F9
    BasicSystem, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, // F10
    BasicSystem, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, // F11
    BasicSystem, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, // F12
    BasicSystem, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, // PrintScreen
    BasicSystem, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, // Scroll Lock
    BasicSystem, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, // Pause
    BasicSystem, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, // Insert
    BasicSystem, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, // Home
    BasicSystem, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, // PageUp
    BasicSystem, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, // Delete
    BasicSystem, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, // End
    BasicSystem, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, // PageDown
    BasicSystem, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, // →
    BasicSystem, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, // ←
    BasicSystem, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, // ↓
    BasicSystem, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, // ↑
    BasicSystem, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, // Num Lock
    BasicSymbol, 0x002F, 0x002F, 0x002F, 0x002F, 0x002F, 0x002F, // Keypad /
    BasicSymbol, 0x002A, 0x002A, 0x002A, 0x002A, 0x002A, 0x002A, // Keypad *
    BasicSymbol, 0x002D, 0x002D, 0x002D, 0x002D, 0x002D, 0x002D, // Keypad -
    BasicSymbol, 0x002B, 0x002B, 0x002B, 0x002B, 0x002B, 0x002B, // Keypad +
    BasicSystem, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, // Keypad Enter
    BasicKeypad, 0x0000, 0x0031, 0x0000, 0x0031, 0x0000, 0x0031, // Keypad 1
    BasicKeypad, 0x0000, 0x0032, 0x0000, 0x0032, 0x0000, 0x0032, // Keypad 2
    BasicKeypad, 0x0000, 0x0033, 0x0000, 0x0033, 0x0000, 0x0033, // Keypad 3
    BasicKeypad, 0x0000, 0x0034, 0x0000, 0x0034, 0x0000, 0x0034, // Keypad 4
    BasicKeypad, 0x0020, 0x0035, 0x0020, 0x0035, 0x0020, 0x0035, // Keypad 5
    BasicKeypad, 0x0000, 0x0036, 0x0000, 0x0036, 0x0000, 0x0036, // Keypad 6
    BasicKeypad, 0x0000, 0x0037, 0x0000, 0x0037, 0x0000, 0x0037, // Keypad 7
    BasicKeypad, 0x0000, 0x0038, 0x0000, 0x0038, 0x0000, 0x0038, // Keypad 8
    BasicKeypad, 0x0000, 0x0039, 0x0000, 0x0039, 0x0000, 0x0039, // Keypad 9
    BasicKeypad, 0x0000, 0x0030, 0x0000, 0x0030, 0x0000, 0x0030, // Keypad 0
    BasicKeypad, 0x0000, 0x002E, 0x0000, 0x002E, 0x0000, 0x002E, // Keypad .
    BasicSymbol, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    BasicSystem, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, // Application
    BasicSystem, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, // Power
    BasicSymbol, 0x003D, 0x003D, 0x003D, 0x003D, 0x003D, 0x003D, // Keypad =
    BasicSystem, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, // F13
    BasicSystem, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, // F14
    BasicSystem, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, // F15
    BasicSystem, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, // F16
    BasicSystem, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, // F17
    BasicSystem, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, // F18
    BasicSystem, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, // F19
    BasicSystem, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, // F20
    BasicSystem, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, // F21
    BasicSystem, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, // F22
    BasicSystem, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, // F23
    BasicSystem, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, // F24
    BasicSystem, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, // Execute
    BasicSystem, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, // Help
    BasicSystem, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, // Menu
    BasicSystem, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, // Select
    BasicSystem, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, // Stop
    BasicSystem, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, // Again
    BasicSystem, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, // Undo
    BasicSystem, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, // Cut
    BasicSystem, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, // Copy
    BasicSystem, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, // Paste
    BasicSystem, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, // Find
    BasicSystem, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, // Mute
    BasicSystem, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, // Volume Up
    BasicSystem, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, // Volume Down
    BasicSystem, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    BasicSystem, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    BasicSystem, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    BasicSymbol, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    BasicSymbol, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    BasicSymbol, 0x005C, 0x005F, 0x308D, 0x308D, 0x30ED, 0x30ED, // \ _ ろ
    BasicSystem, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, // ローマ字
    BasicSymbol, 0x005C, 0x007C, 0xFF70, 0xFF70, 0xFF70, 0xFF70, // \ | ー
    BasicSystem, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, // 変換
    BasicSystem, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, // 無変換
} };

} // namespace

}}} // namespace nn::kpr::detail
