﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include <nn/kpr/detail/kpr_KeyCodeMap.h>

namespace nn { namespace kpr { namespace detail {

namespace {

const KeyCodeMapStorage KeyCodeMapEnglishUs =
{ { { 0x00000001 } }, 3, 100, 0, {}, {
    BasicLetter, 0x0061, 0x0041, // A
    BasicLetter, 0x0062, 0x0042, // B
    BasicLetter, 0x0063, 0x0043, // C
    BasicLetter, 0x0064, 0x0044, // D
    BasicLetter, 0x0065, 0x0045, // E
    BasicLetter, 0x0066, 0x0046, // F
    BasicLetter, 0x0067, 0x0047, // G
    BasicLetter, 0x0068, 0x0048, // H
    BasicLetter, 0x0069, 0x0049, // I
    BasicLetter, 0x006A, 0x004A, // J
    BasicLetter, 0x006B, 0x004B, // K
    BasicLetter, 0x006C, 0x004C, // L
    BasicLetter, 0x006D, 0x004D, // M
    BasicLetter, 0x006E, 0x004E, // N
    BasicLetter, 0x006F, 0x004F, // O
    BasicLetter, 0x0070, 0x0050, // P
    BasicLetter, 0x0071, 0x0051, // Q
    BasicLetter, 0x0072, 0x0052, // R
    BasicLetter, 0x0073, 0x0053, // S
    BasicLetter, 0x0074, 0x0054, // T
    BasicLetter, 0x0075, 0x0055, // U
    BasicLetter, 0x0076, 0x0056, // V
    BasicLetter, 0x0077, 0x0057, // W
    BasicLetter, 0x0078, 0x0058, // X
    BasicLetter, 0x0079, 0x0059, // Y
    BasicLetter, 0x007A, 0x005A, // Z
    BasicSymbol, 0x0031, 0x0021, // 1 !
    BasicSymbol, 0x0032, 0x0040, // 2 @
    BasicSymbol, 0x0033, 0x0023, // 3 #
    BasicSymbol, 0x0034, 0x0024, // 4 $
    BasicSymbol, 0x0035, 0x0025, // 5 %
    BasicSymbol, 0x0036, 0x005E, // 6 ^
    BasicSymbol, 0x0037, 0x0026, // 7 &
    BasicSymbol, 0x0038, 0x002A, // 8 *
    BasicSymbol, 0x0039, 0x0028, // 9 (
    BasicSymbol, 0x0030, 0x0029, // 0 )
    BasicSystem, 0x0000, 0x0000, // Enter
    BasicSystem, 0x0000, 0x0000, // Escape
    BasicSystem, 0x0000, 0x0000, // Backspace
    BasicSystem, 0x0000, 0x0000, // Tab
    BasicSymbol, 0x0020, 0x0020, // Space
    BasicSymbol, 0x002D, 0x005F, // - _
    BasicSymbol, 0x003D, 0x002B, // = +
    BasicSymbol, 0x005B, 0x007B, // [ {
    BasicSymbol, 0x005D, 0x007D, // ] }
    BasicSymbol, 0x005C, 0x007C, // \ |
    BasicSymbol, 0x005C, 0x007C, // \ |
    BasicSymbol, 0x003B, 0x003A, // ; :
    BasicSymbol, 0x0027, 0x0022, // ' "
    BasicSymbol, 0x0060, 0x007E, // ` ~
    BasicSymbol, 0x002C, 0x003C, // , <
    BasicSymbol, 0x002E, 0x003E, // . >
    BasicSymbol, 0x002F, 0x003F, // / ?
    BasicSystem, 0x0000, 0x0000, // Caps Lock
    BasicSystem, 0x0000, 0x0000, // F1
    BasicSystem, 0x0000, 0x0000, // F2
    BasicSystem, 0x0000, 0x0000, // F3
    BasicSystem, 0x0000, 0x0000, // F4
    BasicSystem, 0x0000, 0x0000, // F5
    BasicSystem, 0x0000, 0x0000, // F6
    BasicSystem, 0x0000, 0x0000, // F7
    BasicSystem, 0x0000, 0x0000, // F8
    BasicSystem, 0x0000, 0x0000, // F9
    BasicSystem, 0x0000, 0x0000, // F10
    BasicSystem, 0x0000, 0x0000, // F11
    BasicSystem, 0x0000, 0x0000, // F12
    BasicSystem, 0x0000, 0x0000, // PrintScreen
    BasicSystem, 0x0000, 0x0000, // Scroll Lock
    BasicSystem, 0x0000, 0x0000, // Pause
    BasicSystem, 0x0000, 0x0000, // Insert
    BasicSystem, 0x0000, 0x0000, // Home
    BasicSystem, 0x0000, 0x0000, // PageUp
    BasicSystem, 0x0000, 0x0000, // Delete
    BasicSystem, 0x0000, 0x0000, // End
    BasicSystem, 0x0000, 0x0000, // PageDown
    BasicSystem, 0x0000, 0x0000, // →
    BasicSystem, 0x0000, 0x0000, // ←
    BasicSystem, 0x0000, 0x0000, // ↓
    BasicSystem, 0x0000, 0x0000, // ↑
    BasicSystem, 0x0000, 0x0000, // Num Lock
    BasicSymbol, 0x002F, 0x002F, // Keypad /
    BasicSymbol, 0x002A, 0x002A, // Keypad *
    BasicSymbol, 0x002D, 0x002D, // Keypad -
    BasicSymbol, 0x002B, 0x002B, // Keypad +
    BasicSystem, 0x0000, 0x0000, // Keypad Enter
    BasicKeypad, 0x0000, 0x0031, // Keypad 1
    BasicKeypad, 0x0000, 0x0032, // Keypad 2
    BasicKeypad, 0x0000, 0x0033, // Keypad 3
    BasicKeypad, 0x0000, 0x0034, // Keypad 4
    BasicKeypad, 0x0020, 0x0035, // Keypad 5
    BasicKeypad, 0x0000, 0x0036, // Keypad 6
    BasicKeypad, 0x0000, 0x0037, // Keypad 7
    BasicKeypad, 0x0000, 0x0038, // Keypad 8
    BasicKeypad, 0x0000, 0x0039, // Keypad 9
    BasicKeypad, 0x0000, 0x0030, // Keypad 0
    BasicKeypad, 0x0000, 0x002E, // Keypad .
    BasicSymbol, 0x0000, 0x0000,
    BasicSystem, 0x0000, 0x0000, // Application
    BasicSystem, 0x0000, 0x0000, // Power
    BasicSymbol, 0x003D, 0x003D, // Keypad =
} };

} // namespace

}}} // namespace nn::kpr::detail
