﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include <nn/kpr/detail/kpr_KeyCodeMap.h>

namespace nn { namespace kpr { namespace detail {

namespace {

const KeyCodeMapStorage KeyCodeMapChineseTraditional =
{ { { 0x00000061 } }, 7, 100, 0, {}, {
    BasicLetter, 0x0061, 0x0041, 0x3107, 0x0000, 0x65E5, 0x0000, // A ㄇ 日
    BasicLetter, 0x0062, 0x0042, 0x3116, 0x0000, 0x6708, 0x0000, // B ㄖ 月
    BasicLetter, 0x0063, 0x0043, 0x310F, 0x0000, 0x91D1, 0x0000, // C ㄏ 金
    BasicLetter, 0x0064, 0x0044, 0x310E, 0x0000, 0x6728, 0x0000, // D ㄎ 木
    BasicLetter, 0x0065, 0x0045, 0x310D, 0x0000, 0x6C34, 0x0000, // E ㄍ 水
    BasicLetter, 0x0066, 0x0046, 0x3111, 0x0000, 0x706B, 0x0000, // F ㄑ 火
    BasicLetter, 0x0067, 0x0047, 0x3115, 0x0000, 0x571F, 0x0000, // G ㄕ 土
    BasicLetter, 0x0068, 0x0048, 0x3118, 0x0000, 0x7AF9, 0x0000, // H ㄘ 竹
    BasicLetter, 0x0069, 0x0049, 0x311B, 0x0000, 0x6208, 0x0000, // I ㄛ 戈
    BasicLetter, 0x006A, 0x004A, 0x3128, 0x0000, 0x5341, 0x0000, // J ㄨ 十
    BasicLetter, 0x006B, 0x004B, 0x311C, 0x0000, 0x5927, 0x0000, // K ㄜ 大
    BasicLetter, 0x006C, 0x004C, 0x3120, 0x0000, 0x4E2D, 0x0000, // L ㄠ 中
    BasicLetter, 0x006D, 0x004D, 0x3129, 0x0000, 0x4E00, 0x0000, // M ㄩ 一
    BasicLetter, 0x006E, 0x004E, 0x3119, 0x0000, 0x5F13, 0x0000, // N ㄙ 弓
    BasicLetter, 0x006F, 0x004F, 0x311F, 0x0000, 0x4EBA, 0x0000, // O ㄟ 人
    BasicLetter, 0x0070, 0x0050, 0x3123, 0x0000, 0x5FC3, 0x0000, // P ㄣ 心
    BasicLetter, 0x0071, 0x0051, 0x3106, 0x0000, 0x624B, 0x0000, // Q ㄆ 手
    BasicLetter, 0x0072, 0x0052, 0x3110, 0x0000, 0x53E3, 0x0000, // R ㄐ 口
    BasicLetter, 0x0073, 0x0053, 0x310B, 0x0000, 0x5C38, 0x0000, // S ㄋ 尸
    BasicLetter, 0x0074, 0x0054, 0x3114, 0x0000, 0x5EFF, 0x0000, // T ㄔ 廿
    BasicLetter, 0x0075, 0x0055, 0x3127, 0x0000, 0x5C71, 0x0000, // U ㄧ 山
    BasicLetter, 0x0076, 0x0056, 0x3112, 0x0000, 0x5973, 0x0000, // V ㄒ 女
    BasicLetter, 0x0077, 0x0057, 0x310A, 0x0000, 0x7530, 0x0000, // W ㄊ 田
    BasicLetter, 0x0078, 0x0058, 0x310C, 0x0000, 0x96E3, 0x0000, // X ㄌ 難
    BasicLetter, 0x0079, 0x0059, 0x3117, 0x0000, 0x535C, 0x0000, // Y ㄗ 卜
    BasicLetter, 0x007A, 0x005A, 0x3108, 0x0000, 0x005A, 0x0000, // Z ㄈ
    BasicSymbol, 0x0031, 0x0021, 0x3105, 0x0000, 0x0031, 0x0021, // 1 ! ㄅ
    BasicSymbol, 0x0032, 0x0040, 0x3109, 0x0000, 0x0032, 0x0040, // 2 @ ㄉ
    BasicSymbol, 0x0033, 0x0023, 0x02C7, 0x0000, 0x0033, 0x0023, // 3 # ˇ
    BasicSymbol, 0x0034, 0x0024, 0x02CB, 0x0000, 0x0034, 0x0024, // 4 $ ˋ
    BasicSymbol, 0x0035, 0x0025, 0x3113, 0x0000, 0x0035, 0x0025, // 5 % ㄓ
    BasicSymbol, 0x0036, 0x005E, 0x02CA, 0x0000, 0x0036, 0x005E, // 6 ^ ˊ
    BasicSymbol, 0x0037, 0x0026, 0x02D9, 0x0000, 0x0037, 0x0026, // 7 & ˙
    BasicSymbol, 0x0038, 0x002A, 0x311A, 0x0000, 0x0038, 0x002A, // 8 * ㄚ
    BasicSymbol, 0x0039, 0x0028, 0x311E, 0x0000, 0x0039, 0x0028, // 9 ( ㄞ
    BasicSymbol, 0x0030, 0x0029, 0x3122, 0x0000, 0x0030, 0x0029, // 0 ) ㄢ
    BasicSystem, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, // Enter
    BasicSystem, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, // Escape
    BasicSystem, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, // Backspace
    BasicSystem, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, // Tab
    BasicSymbol, 0x0020, 0x0020, 0x0020, 0x0020, 0x0020, 0x0020, // Space
    BasicSymbol, 0x002D, 0x005F, 0x3126, 0x0000, 0x002D, 0x005F, // - _ ㄦ
    BasicSymbol, 0x003D, 0x002B, 0x003D, 0x002B, 0x003D, 0x002B, // = +
    BasicSymbol, 0x005B, 0x007B, 0x005B, 0x007B, 0x005B, 0x007B, // [ {
    BasicSymbol, 0x005D, 0x007D, 0x005D, 0x007D, 0x005D, 0x007D, // ] }
    BasicSymbol, 0x005C, 0x007C, 0x005C, 0x007C, 0x005C, 0x007C, // \ |
    BasicSymbol, 0x005C, 0x007C, 0x005C, 0x007C, 0x005C, 0x007C, // \ |
    BasicSymbol, 0x003B, 0x003A, 0x3124, 0x0000, 0x003B, 0x003A, // ; : ㄤ
    BasicSymbol, 0x0027, 0x0022, 0x0027, 0x0022, 0x0027, 0x0022, // ' "
    BasicSymbol, 0x0060, 0x007E, 0x0060, 0x007E, 0x0060, 0x007E, // ` ~
    BasicSymbol, 0x002C, 0x003C, 0x311D, 0x0000, 0x002C, 0x003C, // , < ㄝ
    BasicSymbol, 0x002E, 0x003E, 0x3121, 0x0000, 0x002E, 0x003E, // . > ㄡ
    BasicSymbol, 0x002F, 0x003F, 0x3125, 0x0000, 0x002F, 0x003F, // / ? ㄥ
    BasicSystem, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, // Caps Lock
    BasicSystem, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, // F1
    BasicSystem, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, // F2
    BasicSystem, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, // F3
    BasicSystem, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, // F4
    BasicSystem, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, // F5
    BasicSystem, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, // F6
    BasicSystem, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, // F7
    BasicSystem, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, // F8
    BasicSystem, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, // F9
    BasicSystem, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, // F10
    BasicSystem, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, // F11
    BasicSystem, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, // F12
    BasicSystem, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, // PrintScreen
    BasicSystem, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, // Scroll Lock
    BasicSystem, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, // Pause
    BasicSystem, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, // Insert
    BasicSystem, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, // Home
    BasicSystem, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, // PageUp
    BasicSystem, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, // Delete
    BasicSystem, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, // End
    BasicSystem, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, // PageDown
    BasicSystem, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, // →
    BasicSystem, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, // ←
    BasicSystem, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, // ↓
    BasicSystem, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, // ↑
    BasicSystem, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, // Num Lock
    BasicSymbol, 0x002F, 0x002F, 0x002F, 0x002F, 0x002F, 0x002F, // Keypad /
    BasicSymbol, 0x002A, 0x002A, 0x002A, 0x002A, 0x002A, 0x002A, // Keypad *
    BasicSymbol, 0x002D, 0x002D, 0x002D, 0x002D, 0x002D, 0x002D, // Keypad -
    BasicSymbol, 0x002B, 0x002B, 0x002B, 0x002B, 0x002B, 0x002B, // Keypad +
    BasicSystem, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, // Keypad Enter
    BasicKeypad, 0x0000, 0x0031, 0x0000, 0x0031, 0x0000, 0x0031, // Keypad 1
    BasicKeypad, 0x0000, 0x0032, 0x0000, 0x0032, 0x0000, 0x0032, // Keypad 2
    BasicKeypad, 0x0000, 0x0033, 0x0000, 0x0033, 0x0000, 0x0033, // Keypad 3
    BasicKeypad, 0x0000, 0x0034, 0x0000, 0x0034, 0x0000, 0x0034, // Keypad 4
    BasicKeypad, 0x0020, 0x0035, 0x0020, 0x0035, 0x0020, 0x0035, // Keypad 5
    BasicKeypad, 0x0000, 0x0036, 0x0000, 0x0036, 0x0000, 0x0036, // Keypad 6
    BasicKeypad, 0x0000, 0x0037, 0x0000, 0x0037, 0x0000, 0x0037, // Keypad 7
    BasicKeypad, 0x0000, 0x0038, 0x0000, 0x0038, 0x0000, 0x0038, // Keypad 8
    BasicKeypad, 0x0000, 0x0039, 0x0000, 0x0039, 0x0000, 0x0039, // Keypad 9
    BasicKeypad, 0x0000, 0x0030, 0x0000, 0x0030, 0x0000, 0x0030, // Keypad 0
    BasicKeypad, 0x0000, 0x002E, 0x0000, 0x002E, 0x0000, 0x002E, // Keypad .
    BasicSymbol, 0x005C, 0x007C, 0x005C, 0x007C, 0x005C, 0x007C, // \ |
    BasicSystem, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, // Application
    BasicSystem, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, // Power
    BasicSymbol, 0x003D, 0x003D, 0x003D, 0x003D, 0x003D, 0x003D, // Keypad =
} };

} // namespace

}}} // namespace nn::kpr::detail
