﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include <nn/nn_Common.h>
#include <nn/irsensor/irsensor_IrCameraTypes.h>

namespace nn { namespace irsensor {

const int TeraPluginProcessorStateCountMax = 5;

const int TeraPluginProcessorStateDataSize = 300;

const int HandAnalysisModeSilhouette = 8;
const int HandAnalysisModeImage = 9;
const int HandAnalysisModeSilhouetteAndImage = 10;
const int HandAnalysisModeSilhouette_v2 = 13;
const int HandAnalysisModeImage_v2 = 14;
const int HandAnalysisModeSilhouetteAndImage_v2 = 15;
const int HandAnalysisModeSilhouetteOnly_v2 = 18;

const int MarkerPositionReader = 21;

const int AdaptiveClusteringStaticFov = 23;
const int AdaptiveClusteringDynamicFov = 24;

const size_t TeraPluginParameterSize = 2;    //!< IPC 互換性維持のため、現状与えられるパラメータは2Byteまで。

struct TeraPluginProcessorState
{
    int64_t samplingNumber;
    ::nn::TimeSpanType timeStamp;                //!< 処理開始から処理結果を取得した時点までの時間情報です。
    IrCameraAmbientNoiseLevel ambientNoiseLevel; //!< 検出した環境ノイズの状態です。
    uint8_t data[TeraPluginProcessorStateDataSize];
};

struct TeraPluginParameter
{
    char data[TeraPluginParameterSize];
};

struct TeraPluginProcessorConfig
{
    uint8_t modeOffset;
    bool    isParameterEnabled;
    TeraPluginParameter param;
};

}} // namespace nn::irsensor
