﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include <nn/nn_Macro.h>
#include <nn/nn_Result.h>
#include <nn/irsensor/irsensor_IrCameraTypes.h>
#include <nn/irsensor/irsensor_TeraPluginProcessorTypesPrivate.h>

namespace nn { namespace irsensor {

::nn::Result RunTeraPluginProcessor(
    const IrCameraHandle& handle,
    const TeraPluginProcessorConfig& config) NN_NOEXCEPT;

::nn::Result GetTeraPluginProcessorStates(
    TeraPluginProcessorState* pOutStates,
    int* pOutCount,
    int countMax,
    int64_t infSamplingNumber,
    uint32_t prefix,
    int prefixSize,
    const IrCameraHandle& handle) NN_NOEXCEPT;

}} // namespace nn::irsensor
