﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

// このファイルは SFDL による自動生成ファイルです。
// 手動で変更しないでください。
// This file is auto-generated by the SFDL code generator.
// Do not modify manually.

#include <cstdint>
#include <nn/applet/applet_FundamentalTypes.h>
#include <nn/hid/hid_Npad.h>
#include <nn/irsensor/irsensor_ImageTransferProcessorTypes.h>
#include <nn/irsensor/irsensor_IrCameraTypes.h>
#include <nn/irsensor/irsensor_PackedTypes.h>
#include <nn/nn_Result.h>
#include <nn/sf/sf_NativeHandle.h>
#include <nn/sf/sf_Types.h>
#include <nn/sf/cmif/detail/sf_CmifAutogenInterfaceIncludes.h>
#include <nn/sf/detail/sf_AutogenInterfaceIncludes.h>
#include <nn/sf/impl/detail/sf_AutogenImplIncludes.h>

namespace nn { namespace irsensor { // NOLINT(whitespace/braces)

class IIrSensorServer;

NN_SF_DETAIL_DEFINE_SERVICE_INTERFACE(IIrSensorServer, (::nn::sf::IServiceObject))

    NN_SF_DETAIL_SERVICE_INTERFACE_BEGIN_SYNC_METHOD(IIrSensorServer)
        NN_SF_DETAIL_INTERNAL_INTERFACE_DEFINE_SYNC_METHOD_RESULT_N(ActivateIrsensor, (::nn::applet::AppletResourceUserId aruid))
        NN_SF_DETAIL_INTERNAL_INTERFACE_DEFINE_SYNC_METHOD_RESULT_N(DeactivateIrsensor, (::nn::applet::AppletResourceUserId aruid))
        NN_SF_DETAIL_INTERNAL_INTERFACE_DEFINE_SYNC_METHOD_RESULT_N(GetIrsensorSharedMemoryHandle, (::nn::sf::Out<::nn::sf::NativeHandle> outValue, ::nn::applet::AppletResourceUserId aruid))
        NN_SF_DETAIL_INTERNAL_INTERFACE_DEFINE_SYNC_METHOD_RESULT_N(StopImageProcessor, (::nn::applet::AppletResourceUserId aruid, ::nn::irsensor::IrCameraHandle handle))
        NN_SF_DETAIL_INTERNAL_INTERFACE_DEFINE_SYNC_METHOD_RESULT_N(RunMomentProcessor, (::nn::applet::AppletResourceUserId aruid, ::nn::irsensor::IrCameraHandle handle, const ::nn::irsensor::PackedMomentProcessorConfig& config))
        NN_SF_DETAIL_INTERNAL_INTERFACE_DEFINE_SYNC_METHOD_RESULT_N(RunClusteringProcessor, (::nn::applet::AppletResourceUserId aruid, ::nn::irsensor::IrCameraHandle handle, const ::nn::irsensor::PackedClusteringProcessorConfig& config))
        NN_SF_DETAIL_INTERNAL_INTERFACE_DEFINE_SYNC_METHOD_RESULT_N(RunImageTransferProcessor, (::nn::applet::AppletResourceUserId aruid, ::nn::irsensor::IrCameraHandle handle, const ::nn::irsensor::PackedImageTransferProcessorConfig& config, ::nn::sf::NativeHandle&& transferMemoryHandle, ::std::uint64_t size))
        NN_SF_DETAIL_INTERNAL_INTERFACE_DEFINE_SYNC_METHOD_RESULT_N(GetImageTransferProcessorState, (::nn::applet::AppletResourceUserId aruid, ::nn::sf::Out<::nn::irsensor::ImageTransferProcessorState> outState, const ::nn::sf::OutBuffer& outBuffer, ::nn::irsensor::IrCameraHandle handle))
        NN_SF_DETAIL_INTERNAL_INTERFACE_DEFINE_SYNC_METHOD_RESULT_N(RunTeraPluginProcessor, (::nn::applet::AppletResourceUserId aruid, ::nn::irsensor::IrCameraHandle handle, ::nn::irsensor::PackedTeraPluginProcessorConfig config))
        NN_SF_DETAIL_INTERNAL_INTERFACE_DEFINE_SYNC_METHOD_RESULT_N(GetNpadIrCameraHandle, (::nn::sf::Out<::nn::irsensor::IrCameraHandle> outValue, ::nn::hid::NpadIdType npadIdType))
        NN_SF_DETAIL_INTERNAL_INTERFACE_DEFINE_SYNC_METHOD_RESULT_N(RunPointingProcessor, (::nn::applet::AppletResourceUserId aruid, ::nn::irsensor::IrCameraHandle handle, const ::nn::irsensor::PackedPointingProcessorConfig& config))
        NN_SF_DETAIL_INTERNAL_INTERFACE_DEFINE_SYNC_METHOD_RESULT_N(SuspendImageProcessor, (::nn::applet::AppletResourceUserId aruid, ::nn::irsensor::IrCameraHandle handle))
        NN_SF_DETAIL_INTERNAL_INTERFACE_DEFINE_SYNC_METHOD_RESULT_N(CheckFirmwareVersion, (::nn::applet::AppletResourceUserId aruid, ::nn::irsensor::IrCameraHandle handle, ::nn::irsensor::PackedMcuVersion requiredVersion))
        NN_SF_DETAIL_INTERNAL_INTERFACE_DEFINE_SYNC_METHOD_RESULT_N(SetFunctionLevel, (::nn::applet::AppletResourceUserId aruid, ::nn::irsensor::IrCameraHandle handle, ::nn::irsensor::PackedFunctionLevel functionLevel))
        NN_SF_DETAIL_INTERNAL_INTERFACE_DEFINE_SYNC_METHOD_RESULT_N(RunImageTransferExProcessor, (::nn::applet::AppletResourceUserId aruid, ::nn::irsensor::IrCameraHandle handle, const ::nn::irsensor::PackedImageTransferProcessorExConfig& config, ::nn::sf::NativeHandle&& transferMemoryHandle, ::std::uint64_t size))
        NN_SF_DETAIL_INTERNAL_INTERFACE_DEFINE_SYNC_METHOD_RESULT_N(RunIrLedProcessor, (::nn::applet::AppletResourceUserId aruid, ::nn::irsensor::IrCameraHandle handle, ::nn::irsensor::PackedIrLedProcessorConfig config))
        NN_SF_DETAIL_INTERNAL_INTERFACE_DEFINE_SYNC_METHOD_RESULT_N(StopImageProcessorAsync, (::nn::applet::AppletResourceUserId aruid, ::nn::irsensor::IrCameraHandle handle))
        NN_SF_DETAIL_INTERNAL_INTERFACE_DEFINE_SYNC_METHOD_RESULT_N(ActivateIrsensorWithFunctionLevel, (::nn::applet::AppletResourceUserId aruid, ::nn::irsensor::PackedFunctionLevel functionLevel))
    NN_SF_DETAIL_SERVICE_INTERFACE_END_SYNC_METHOD

    NN_SF_DETAIL_SERVICE_INTERFACE_BEGIN_ACCESSOR(IIrSensorServer)

        ::nn::Result ActivateIrsensor(::nn::applet::AppletResourceUserId aruid) NN_NOEXCEPT
        {
            NN_SF_DETAIL_RETURN_INTERNAL_SYNC_METHOD_RESULT_N(ActivateIrsensor, (aruid));
        }

        ::nn::Result DeactivateIrsensor(::nn::applet::AppletResourceUserId aruid) NN_NOEXCEPT
        {
            NN_SF_DETAIL_RETURN_INTERNAL_SYNC_METHOD_RESULT_N(DeactivateIrsensor, (aruid));
        }

        ::nn::Result GetIrsensorSharedMemoryHandle(::nn::sf::Out<::nn::sf::NativeHandle> outValue, ::nn::applet::AppletResourceUserId aruid) NN_NOEXCEPT
        {
            NN_SF_DETAIL_RETURN_INTERNAL_SYNC_METHOD_RESULT_N(GetIrsensorSharedMemoryHandle, (outValue, aruid));
        }

        ::nn::Result StopImageProcessor(::nn::applet::AppletResourceUserId aruid, ::nn::irsensor::IrCameraHandle handle) NN_NOEXCEPT
        {
            NN_SF_DETAIL_RETURN_INTERNAL_SYNC_METHOD_RESULT_N(StopImageProcessor, (aruid, handle));
        }

        ::nn::Result RunMomentProcessor(::nn::applet::AppletResourceUserId aruid, ::nn::irsensor::IrCameraHandle handle, const ::nn::irsensor::PackedMomentProcessorConfig& config) NN_NOEXCEPT
        {
            NN_SF_DETAIL_RETURN_INTERNAL_SYNC_METHOD_RESULT_N(RunMomentProcessor, (aruid, handle, config));
        }

        ::nn::Result RunClusteringProcessor(::nn::applet::AppletResourceUserId aruid, ::nn::irsensor::IrCameraHandle handle, const ::nn::irsensor::PackedClusteringProcessorConfig& config) NN_NOEXCEPT
        {
            NN_SF_DETAIL_RETURN_INTERNAL_SYNC_METHOD_RESULT_N(RunClusteringProcessor, (aruid, handle, config));
        }

        ::nn::Result RunImageTransferProcessor(::nn::applet::AppletResourceUserId aruid, ::nn::irsensor::IrCameraHandle handle, const ::nn::irsensor::PackedImageTransferProcessorConfig& config, ::nn::sf::NativeHandle&& transferMemoryHandle, ::std::uint64_t size) NN_NOEXCEPT
        {
            NN_SF_DETAIL_RETURN_INTERNAL_SYNC_METHOD_RESULT_N(RunImageTransferProcessor, (aruid, handle, config, ::std::move(transferMemoryHandle), size));
        }

        ::nn::Result GetImageTransferProcessorState(::nn::applet::AppletResourceUserId aruid, ::nn::sf::Out<::nn::irsensor::ImageTransferProcessorState> outState, const ::nn::sf::OutBuffer& outBuffer, ::nn::irsensor::IrCameraHandle handle) NN_NOEXCEPT
        {
            NN_SF_DETAIL_RETURN_INTERNAL_SYNC_METHOD_RESULT_N(GetImageTransferProcessorState, (aruid, outState, outBuffer, handle));
        }

        ::nn::Result RunTeraPluginProcessor(::nn::applet::AppletResourceUserId aruid, ::nn::irsensor::IrCameraHandle handle, ::nn::irsensor::PackedTeraPluginProcessorConfig config) NN_NOEXCEPT
        {
            NN_SF_DETAIL_RETURN_INTERNAL_SYNC_METHOD_RESULT_N(RunTeraPluginProcessor, (aruid, handle, config));
        }

        ::nn::Result GetNpadIrCameraHandle(::nn::sf::Out<::nn::irsensor::IrCameraHandle> outValue, ::nn::hid::NpadIdType npadIdType) NN_NOEXCEPT
        {
            NN_SF_DETAIL_RETURN_INTERNAL_SYNC_METHOD_RESULT_N(GetNpadIrCameraHandle, (outValue, npadIdType));
        }

        ::nn::Result RunPointingProcessor(::nn::applet::AppletResourceUserId aruid, ::nn::irsensor::IrCameraHandle handle, const ::nn::irsensor::PackedPointingProcessorConfig& config) NN_NOEXCEPT
        {
            NN_SF_DETAIL_RETURN_INTERNAL_SYNC_METHOD_RESULT_N(RunPointingProcessor, (aruid, handle, config));
        }

        ::nn::Result SuspendImageProcessor(::nn::applet::AppletResourceUserId aruid, ::nn::irsensor::IrCameraHandle handle) NN_NOEXCEPT
        {
            NN_SF_DETAIL_RETURN_INTERNAL_SYNC_METHOD_RESULT_N(SuspendImageProcessor, (aruid, handle));
        }

        ::nn::Result CheckFirmwareVersion(::nn::applet::AppletResourceUserId aruid, ::nn::irsensor::IrCameraHandle handle, ::nn::irsensor::PackedMcuVersion requiredVersion) NN_NOEXCEPT
        {
            NN_SF_DETAIL_RETURN_INTERNAL_SYNC_METHOD_RESULT_N(CheckFirmwareVersion, (aruid, handle, requiredVersion));
        }

        ::nn::Result SetFunctionLevel(::nn::applet::AppletResourceUserId aruid, ::nn::irsensor::IrCameraHandle handle, ::nn::irsensor::PackedFunctionLevel functionLevel) NN_NOEXCEPT
        {
            NN_SF_DETAIL_RETURN_INTERNAL_SYNC_METHOD_RESULT_N(SetFunctionLevel, (aruid, handle, functionLevel));
        }

        ::nn::Result RunImageTransferExProcessor(::nn::applet::AppletResourceUserId aruid, ::nn::irsensor::IrCameraHandle handle, const ::nn::irsensor::PackedImageTransferProcessorExConfig& config, ::nn::sf::NativeHandle&& transferMemoryHandle, ::std::uint64_t size) NN_NOEXCEPT
        {
            NN_SF_DETAIL_RETURN_INTERNAL_SYNC_METHOD_RESULT_N(RunImageTransferExProcessor, (aruid, handle, config, ::std::move(transferMemoryHandle), size));
        }

        ::nn::Result RunIrLedProcessor(::nn::applet::AppletResourceUserId aruid, ::nn::irsensor::IrCameraHandle handle, ::nn::irsensor::PackedIrLedProcessorConfig config) NN_NOEXCEPT
        {
            NN_SF_DETAIL_RETURN_INTERNAL_SYNC_METHOD_RESULT_N(RunIrLedProcessor, (aruid, handle, config));
        }

        ::nn::Result StopImageProcessorAsync(::nn::applet::AppletResourceUserId aruid, ::nn::irsensor::IrCameraHandle handle) NN_NOEXCEPT
        {
            NN_SF_DETAIL_RETURN_INTERNAL_SYNC_METHOD_RESULT_N(StopImageProcessorAsync, (aruid, handle));
        }

        ::nn::Result ActivateIrsensorWithFunctionLevel(::nn::applet::AppletResourceUserId aruid, ::nn::irsensor::PackedFunctionLevel functionLevel) NN_NOEXCEPT
        {
            NN_SF_DETAIL_RETURN_INTERNAL_SYNC_METHOD_RESULT_N(ActivateIrsensorWithFunctionLevel, (aruid, functionLevel));
        }

    NN_SF_DETAIL_SERVICE_INTERFACE_END_ACCESSOR

NN_SF_DETAIL_DEFINE_SERVICE_INTERFACE_END

#if 0
    class IIrSensorServer
    {
    public:
        nn::Result ActivateIrsensor(nn::applet::AppletResourceUserId aruid) NN_NOEXCEPT;
        nn::Result DeactivateIrsensor(nn::applet::AppletResourceUserId aruid) NN_NOEXCEPT;
        nn::Result GetIrsensorSharedMemoryHandle(nn::sf::Out<nn::sf::NativeHandle> outValue, nn::applet::AppletResourceUserId aruid) NN_NOEXCEPT;
        nn::Result StopImageProcessor(nn::applet::AppletResourceUserId aruid, nn::irsensor::IrCameraHandle handle) NN_NOEXCEPT;
        nn::Result RunMomentProcessor(nn::applet::AppletResourceUserId aruid, nn::irsensor::IrCameraHandle handle, const nn::irsensor::PackedMomentProcessorConfig& config) NN_NOEXCEPT;
        nn::Result RunClusteringProcessor(nn::applet::AppletResourceUserId aruid, nn::irsensor::IrCameraHandle handle, const nn::irsensor::PackedClusteringProcessorConfig& config) NN_NOEXCEPT;
        nn::Result RunImageTransferProcessor(nn::applet::AppletResourceUserId aruid, nn::irsensor::IrCameraHandle handle, const nn::irsensor::PackedImageTransferProcessorConfig& config, nn::sf::NativeHandle&& transferMemoryHandle, std::uint64_t size) NN_NOEXCEPT;
        nn::Result GetImageTransferProcessorState(nn::applet::AppletResourceUserId aruid, nn::sf::Out<nn::irsensor::ImageTransferProcessorState> outState, const nn::sf::OutBuffer& outBuffer, nn::irsensor::IrCameraHandle handle) NN_NOEXCEPT;
        nn::Result RunTeraPluginProcessor(nn::applet::AppletResourceUserId aruid, nn::irsensor::IrCameraHandle handle, nn::irsensor::PackedTeraPluginProcessorConfig config) NN_NOEXCEPT;
        nn::Result GetNpadIrCameraHandle(nn::sf::Out<nn::irsensor::IrCameraHandle> outValue, nn::hid::NpadIdType npadIdType) NN_NOEXCEPT;
        nn::Result RunPointingProcessor(nn::applet::AppletResourceUserId aruid, nn::irsensor::IrCameraHandle handle, const nn::irsensor::PackedPointingProcessorConfig& config) NN_NOEXCEPT;
        nn::Result SuspendImageProcessor(nn::applet::AppletResourceUserId aruid, nn::irsensor::IrCameraHandle handle) NN_NOEXCEPT;
        nn::Result CheckFirmwareVersion(nn::applet::AppletResourceUserId aruid, nn::irsensor::IrCameraHandle handle, nn::irsensor::PackedMcuVersion requiredVersion) NN_NOEXCEPT;
        nn::Result SetFunctionLevel(nn::applet::AppletResourceUserId aruid, nn::irsensor::IrCameraHandle handle, nn::irsensor::PackedFunctionLevel functionLevel) NN_NOEXCEPT;
        nn::Result RunImageTransferExProcessor(nn::applet::AppletResourceUserId aruid, nn::irsensor::IrCameraHandle handle, const nn::irsensor::PackedImageTransferProcessorExConfig& config, nn::sf::NativeHandle&& transferMemoryHandle, std::uint64_t size) NN_NOEXCEPT;
        nn::Result RunIrLedProcessor(nn::applet::AppletResourceUserId aruid, nn::irsensor::IrCameraHandle handle, nn::irsensor::PackedIrLedProcessorConfig config) NN_NOEXCEPT;
        nn::Result StopImageProcessorAsync(nn::applet::AppletResourceUserId aruid, nn::irsensor::IrCameraHandle handle) NN_NOEXCEPT;
        nn::Result ActivateIrsensorWithFunctionLevel(nn::applet::AppletResourceUserId aruid, nn::irsensor::PackedFunctionLevel functionLevel) NN_NOEXCEPT;
    };
#endif

}}

#if 0

// Template for implementation users
class Impl
{
public:
    nn::Result ActivateIrsensor(nn::applet::AppletResourceUserId aruid) NN_NOEXCEPT;
    nn::Result DeactivateIrsensor(nn::applet::AppletResourceUserId aruid) NN_NOEXCEPT;
    nn::Result GetIrsensorSharedMemoryHandle(nn::sf::Out<nn::sf::NativeHandle> outValue, nn::applet::AppletResourceUserId aruid) NN_NOEXCEPT;
    nn::Result StopImageProcessor(nn::applet::AppletResourceUserId aruid, nn::irsensor::IrCameraHandle handle) NN_NOEXCEPT;
    nn::Result RunMomentProcessor(nn::applet::AppletResourceUserId aruid, nn::irsensor::IrCameraHandle handle, const nn::irsensor::PackedMomentProcessorConfig& config) NN_NOEXCEPT;
    nn::Result RunClusteringProcessor(nn::applet::AppletResourceUserId aruid, nn::irsensor::IrCameraHandle handle, const nn::irsensor::PackedClusteringProcessorConfig& config) NN_NOEXCEPT;
    nn::Result RunImageTransferProcessor(nn::applet::AppletResourceUserId aruid, nn::irsensor::IrCameraHandle handle, const nn::irsensor::PackedImageTransferProcessorConfig& config, nn::sf::NativeHandle&& transferMemoryHandle, std::uint64_t size) NN_NOEXCEPT;
    nn::Result GetImageTransferProcessorState(nn::applet::AppletResourceUserId aruid, nn::sf::Out<nn::irsensor::ImageTransferProcessorState> outState, const nn::sf::OutBuffer& outBuffer, nn::irsensor::IrCameraHandle handle) NN_NOEXCEPT;
    nn::Result RunTeraPluginProcessor(nn::applet::AppletResourceUserId aruid, nn::irsensor::IrCameraHandle handle, nn::irsensor::PackedTeraPluginProcessorConfig config) NN_NOEXCEPT;
    nn::Result GetNpadIrCameraHandle(nn::sf::Out<nn::irsensor::IrCameraHandle> outValue, nn::hid::NpadIdType npadIdType) NN_NOEXCEPT;
    nn::Result RunPointingProcessor(nn::applet::AppletResourceUserId aruid, nn::irsensor::IrCameraHandle handle, const nn::irsensor::PackedPointingProcessorConfig& config) NN_NOEXCEPT;
    nn::Result SuspendImageProcessor(nn::applet::AppletResourceUserId aruid, nn::irsensor::IrCameraHandle handle) NN_NOEXCEPT;
    nn::Result CheckFirmwareVersion(nn::applet::AppletResourceUserId aruid, nn::irsensor::IrCameraHandle handle, nn::irsensor::PackedMcuVersion requiredVersion) NN_NOEXCEPT;
    nn::Result SetFunctionLevel(nn::applet::AppletResourceUserId aruid, nn::irsensor::IrCameraHandle handle, nn::irsensor::PackedFunctionLevel functionLevel) NN_NOEXCEPT;
    nn::Result RunImageTransferExProcessor(nn::applet::AppletResourceUserId aruid, nn::irsensor::IrCameraHandle handle, const nn::irsensor::PackedImageTransferProcessorExConfig& config, nn::sf::NativeHandle&& transferMemoryHandle, std::uint64_t size) NN_NOEXCEPT;
    nn::Result RunIrLedProcessor(nn::applet::AppletResourceUserId aruid, nn::irsensor::IrCameraHandle handle, nn::irsensor::PackedIrLedProcessorConfig config) NN_NOEXCEPT;
    nn::Result StopImageProcessorAsync(nn::applet::AppletResourceUserId aruid, nn::irsensor::IrCameraHandle handle) NN_NOEXCEPT;
    nn::Result ActivateIrsensorWithFunctionLevel(nn::applet::AppletResourceUserId aruid, nn::irsensor::PackedFunctionLevel functionLevel) NN_NOEXCEPT;
};

#endif

NN_SF_IMPL_DETAIL_DEFINE_IMPL_TEMPLATE_BASE((::nn::irsensor::IIrSensorServer))

    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(ActivateIrsensor, (::nn::applet::AppletResourceUserId aruid))
    {
        NN_SF_IMPL_DETAIL_RETURN_IMPL_METHOD_RESULT_N(ActivateIrsensor, (aruid));
    }

    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(DeactivateIrsensor, (::nn::applet::AppletResourceUserId aruid))
    {
        NN_SF_IMPL_DETAIL_RETURN_IMPL_METHOD_RESULT_N(DeactivateIrsensor, (aruid));
    }

    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(GetIrsensorSharedMemoryHandle, (::nn::sf::Out<::nn::sf::NativeHandle> outValue, ::nn::applet::AppletResourceUserId aruid))
    {
        NN_SF_IMPL_DETAIL_RETURN_IMPL_METHOD_RESULT_N(GetIrsensorSharedMemoryHandle, (outValue, aruid));
    }

    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(StopImageProcessor, (::nn::applet::AppletResourceUserId aruid, ::nn::irsensor::IrCameraHandle handle))
    {
        NN_SF_IMPL_DETAIL_RETURN_IMPL_METHOD_RESULT_N(StopImageProcessor, (aruid, handle));
    }

    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(RunMomentProcessor, (::nn::applet::AppletResourceUserId aruid, ::nn::irsensor::IrCameraHandle handle, const ::nn::irsensor::PackedMomentProcessorConfig& config))
    {
        NN_SF_IMPL_DETAIL_RETURN_IMPL_METHOD_RESULT_N(RunMomentProcessor, (aruid, handle, config));
    }

    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(RunClusteringProcessor, (::nn::applet::AppletResourceUserId aruid, ::nn::irsensor::IrCameraHandle handle, const ::nn::irsensor::PackedClusteringProcessorConfig& config))
    {
        NN_SF_IMPL_DETAIL_RETURN_IMPL_METHOD_RESULT_N(RunClusteringProcessor, (aruid, handle, config));
    }

    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(RunImageTransferProcessor, (::nn::applet::AppletResourceUserId aruid, ::nn::irsensor::IrCameraHandle handle, const ::nn::irsensor::PackedImageTransferProcessorConfig& config, ::nn::sf::NativeHandle&& transferMemoryHandle, ::std::uint64_t size))
    {
        NN_SF_IMPL_DETAIL_RETURN_IMPL_METHOD_RESULT_N(RunImageTransferProcessor, (aruid, handle, config, ::std::move(transferMemoryHandle), size));
    }

    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(GetImageTransferProcessorState, (::nn::applet::AppletResourceUserId aruid, ::nn::sf::Out<::nn::irsensor::ImageTransferProcessorState> outState, const ::nn::sf::OutBuffer& outBuffer, ::nn::irsensor::IrCameraHandle handle))
    {
        NN_SF_IMPL_DETAIL_RETURN_IMPL_METHOD_RESULT_N(GetImageTransferProcessorState, (aruid, outState, outBuffer, handle));
    }

    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(RunTeraPluginProcessor, (::nn::applet::AppletResourceUserId aruid, ::nn::irsensor::IrCameraHandle handle, ::nn::irsensor::PackedTeraPluginProcessorConfig config))
    {
        NN_SF_IMPL_DETAIL_RETURN_IMPL_METHOD_RESULT_N(RunTeraPluginProcessor, (aruid, handle, config));
    }

    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(GetNpadIrCameraHandle, (::nn::sf::Out<::nn::irsensor::IrCameraHandle> outValue, ::nn::hid::NpadIdType npadIdType))
    {
        NN_SF_IMPL_DETAIL_RETURN_IMPL_METHOD_RESULT_N(GetNpadIrCameraHandle, (outValue, npadIdType));
    }

    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(RunPointingProcessor, (::nn::applet::AppletResourceUserId aruid, ::nn::irsensor::IrCameraHandle handle, const ::nn::irsensor::PackedPointingProcessorConfig& config))
    {
        NN_SF_IMPL_DETAIL_RETURN_IMPL_METHOD_RESULT_N(RunPointingProcessor, (aruid, handle, config));
    }

    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(SuspendImageProcessor, (::nn::applet::AppletResourceUserId aruid, ::nn::irsensor::IrCameraHandle handle))
    {
        NN_SF_IMPL_DETAIL_RETURN_IMPL_METHOD_RESULT_N(SuspendImageProcessor, (aruid, handle));
    }

    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(CheckFirmwareVersion, (::nn::applet::AppletResourceUserId aruid, ::nn::irsensor::IrCameraHandle handle, ::nn::irsensor::PackedMcuVersion requiredVersion))
    {
        NN_SF_IMPL_DETAIL_RETURN_IMPL_METHOD_RESULT_N(CheckFirmwareVersion, (aruid, handle, requiredVersion));
    }

    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(SetFunctionLevel, (::nn::applet::AppletResourceUserId aruid, ::nn::irsensor::IrCameraHandle handle, ::nn::irsensor::PackedFunctionLevel functionLevel))
    {
        NN_SF_IMPL_DETAIL_RETURN_IMPL_METHOD_RESULT_N(SetFunctionLevel, (aruid, handle, functionLevel));
    }

    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(RunImageTransferExProcessor, (::nn::applet::AppletResourceUserId aruid, ::nn::irsensor::IrCameraHandle handle, const ::nn::irsensor::PackedImageTransferProcessorExConfig& config, ::nn::sf::NativeHandle&& transferMemoryHandle, ::std::uint64_t size))
    {
        NN_SF_IMPL_DETAIL_RETURN_IMPL_METHOD_RESULT_N(RunImageTransferExProcessor, (aruid, handle, config, ::std::move(transferMemoryHandle), size));
    }

    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(RunIrLedProcessor, (::nn::applet::AppletResourceUserId aruid, ::nn::irsensor::IrCameraHandle handle, ::nn::irsensor::PackedIrLedProcessorConfig config))
    {
        NN_SF_IMPL_DETAIL_RETURN_IMPL_METHOD_RESULT_N(RunIrLedProcessor, (aruid, handle, config));
    }

    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(StopImageProcessorAsync, (::nn::applet::AppletResourceUserId aruid, ::nn::irsensor::IrCameraHandle handle))
    {
        NN_SF_IMPL_DETAIL_RETURN_IMPL_METHOD_RESULT_N(StopImageProcessorAsync, (aruid, handle));
    }

    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(ActivateIrsensorWithFunctionLevel, (::nn::applet::AppletResourceUserId aruid, ::nn::irsensor::PackedFunctionLevel functionLevel))
    {
        NN_SF_IMPL_DETAIL_RETURN_IMPL_METHOD_RESULT_N(ActivateIrsensorWithFunctionLevel, (aruid, functionLevel));
    }

NN_SF_IMPL_DETAIL_DEFINE_IMPL_TEMPLATE_BASE_END

// template <> struct nn::sf::cmif::detail::MethodInfos<nn::irsensor::IIrSensorServer>
NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFOS((::nn::irsensor::IIrSensorServer))

    // nn::Result ActivateIrsensor(nn::applet::AppletResourceUserId aruid) NN_NOEXCEPT
    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO(ActivateIrsensor)

        NN_SF_CMIF_DETAIL_METHOD_INFO_METHOD_ID(302)
        NN_SF_CMIF_DETAIL_METHOD_INFO_RETURN_TYPE_IS_RESULT(true)

        NN_SF_CMIF_DETAIL_METHOD_INFO_IN_PROCESS_ID_ENABLE()

        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_MEMBER(aruid, (::nn::applet::AppletResourceUserId), 0)
        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_END(1, (aruid))
        NN_SF_CMIF_DETAIL_METHOD_INFO_IN_RAW_SIZE(8)

        NN_SF_CMIF_DETAIL_METHOD_INFO_ARGUMENT_INFOS((NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(aruid)))

    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO_END(ActivateIrsensor)

    // nn::Result DeactivateIrsensor(nn::applet::AppletResourceUserId aruid) NN_NOEXCEPT
    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO(DeactivateIrsensor)

        NN_SF_CMIF_DETAIL_METHOD_INFO_METHOD_ID(303)
        NN_SF_CMIF_DETAIL_METHOD_INFO_RETURN_TYPE_IS_RESULT(true)

        NN_SF_CMIF_DETAIL_METHOD_INFO_IN_PROCESS_ID_ENABLE()

        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_MEMBER(aruid, (::nn::applet::AppletResourceUserId), 0)
        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_END(1, (aruid))
        NN_SF_CMIF_DETAIL_METHOD_INFO_IN_RAW_SIZE(8)

        NN_SF_CMIF_DETAIL_METHOD_INFO_ARGUMENT_INFOS((NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(aruid)))

    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO_END(DeactivateIrsensor)

    // nn::Result GetIrsensorSharedMemoryHandle(nn::sf::Out<nn::sf::NativeHandle> outValue, nn::applet::AppletResourceUserId aruid) NN_NOEXCEPT
    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO(GetIrsensorSharedMemoryHandle)

        NN_SF_CMIF_DETAIL_METHOD_INFO_METHOD_ID(304)
        NN_SF_CMIF_DETAIL_METHOD_INFO_RETURN_TYPE_IS_RESULT(true)

        NN_SF_CMIF_DETAIL_METHOD_INFO_IN_PROCESS_ID_ENABLE()

        NN_SF_CMIF_DETAIL_METHOD_INFO_OUT_NATIVE_HANDLE_COUNT(1)
        NN_SF_CMIF_DETAIL_METHOD_INFO_OUT_NATIVE_HANDLE_INFOS
            NN_SF_CMIF_DETAIL_METHOD_INFO_OUT_NATIVE_HANDLE_INFO(outValue, 0, NN_SF_CMIF_DETAIL_NATIVE_HANDLE_ATTRIBUTE_HIPC_COPY)
        NN_SF_CMIF_DETAIL_METHOD_INFO_OUT_NATIVE_HANDLE_INFOS_END(1, (outValue))

        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_MEMBER(aruid, (::nn::applet::AppletResourceUserId), 0)
        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_END(1, (aruid))
        NN_SF_CMIF_DETAIL_METHOD_INFO_IN_RAW_SIZE(8)

        NN_SF_CMIF_DETAIL_METHOD_INFO_ARGUMENT_INFOS((NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(outValue), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(aruid)))

    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO_END(GetIrsensorSharedMemoryHandle)

    // nn::Result StopImageProcessor(nn::applet::AppletResourceUserId aruid, nn::irsensor::IrCameraHandle handle) NN_NOEXCEPT
    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO(StopImageProcessor)

        NN_SF_CMIF_DETAIL_METHOD_INFO_METHOD_ID(305)
        NN_SF_CMIF_DETAIL_METHOD_INFO_RETURN_TYPE_IS_RESULT(true)

        NN_SF_CMIF_DETAIL_METHOD_INFO_IN_PROCESS_ID_ENABLE()

        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_MEMBER(handle, (::nn::irsensor::IrCameraHandle), 0)
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_MEMBER(aruid, (::nn::applet::AppletResourceUserId), 8)
        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_END(2, (handle, aruid))
        NN_SF_CMIF_DETAIL_METHOD_INFO_IN_RAW_SIZE(16)

        NN_SF_CMIF_DETAIL_METHOD_INFO_ARGUMENT_INFOS((NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(aruid), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(handle)))

    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO_END(StopImageProcessor)

    // nn::Result RunMomentProcessor(nn::applet::AppletResourceUserId aruid, nn::irsensor::IrCameraHandle handle, const nn::irsensor::PackedMomentProcessorConfig& config) NN_NOEXCEPT
    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO(RunMomentProcessor)

        NN_SF_CMIF_DETAIL_METHOD_INFO_METHOD_ID(306)
        NN_SF_CMIF_DETAIL_METHOD_INFO_RETURN_TYPE_IS_RESULT(true)

        NN_SF_CMIF_DETAIL_METHOD_INFO_IN_PROCESS_ID_ENABLE()

        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_MEMBER(handle, (::nn::irsensor::IrCameraHandle), 0)
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_MEMBER(aruid, (::nn::applet::AppletResourceUserId), 8)
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_MEMBER(config, (::nn::irsensor::PackedMomentProcessorConfig), 16)
        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_END(3, (handle, aruid, config))
        NN_SF_CMIF_DETAIL_METHOD_INFO_IN_RAW_SIZE(48)

        NN_SF_CMIF_DETAIL_METHOD_INFO_ARGUMENT_INFOS((NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(aruid), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(handle), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(config)))

    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO_END(RunMomentProcessor)

    // nn::Result RunClusteringProcessor(nn::applet::AppletResourceUserId aruid, nn::irsensor::IrCameraHandle handle, const nn::irsensor::PackedClusteringProcessorConfig& config) NN_NOEXCEPT
    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO(RunClusteringProcessor)

        NN_SF_CMIF_DETAIL_METHOD_INFO_METHOD_ID(307)
        NN_SF_CMIF_DETAIL_METHOD_INFO_RETURN_TYPE_IS_RESULT(true)

        NN_SF_CMIF_DETAIL_METHOD_INFO_IN_PROCESS_ID_ENABLE()

        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_MEMBER(handle, (::nn::irsensor::IrCameraHandle), 0)
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_MEMBER(aruid, (::nn::applet::AppletResourceUserId), 8)
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_MEMBER(config, (::nn::irsensor::PackedClusteringProcessorConfig), 16)
        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_END(3, (handle, aruid, config))
        NN_SF_CMIF_DETAIL_METHOD_INFO_IN_RAW_SIZE(56)

        NN_SF_CMIF_DETAIL_METHOD_INFO_ARGUMENT_INFOS((NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(aruid), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(handle), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(config)))

    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO_END(RunClusteringProcessor)

    // nn::Result RunImageTransferProcessor(nn::applet::AppletResourceUserId aruid, nn::irsensor::IrCameraHandle handle, const nn::irsensor::PackedImageTransferProcessorConfig& config, nn::sf::NativeHandle&& transferMemoryHandle, std::uint64_t size) NN_NOEXCEPT
    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO(RunImageTransferProcessor)

        NN_SF_CMIF_DETAIL_METHOD_INFO_METHOD_ID(308)
        NN_SF_CMIF_DETAIL_METHOD_INFO_RETURN_TYPE_IS_RESULT(true)

        NN_SF_CMIF_DETAIL_METHOD_INFO_IN_PROCESS_ID_ENABLE()

        NN_SF_CMIF_DETAIL_METHOD_INFO_IN_NATIVE_HANDLE_COUNT(1)
        NN_SF_CMIF_DETAIL_METHOD_INFO_IN_NATIVE_HANDLE_INFOS
            NN_SF_CMIF_DETAIL_METHOD_INFO_IN_NATIVE_HANDLE_INFO(transferMemoryHandle, 0, NN_SF_CMIF_DETAIL_NATIVE_HANDLE_ATTRIBUTE_HIPC_COPY)
        NN_SF_CMIF_DETAIL_METHOD_INFO_IN_NATIVE_HANDLE_INFOS_END(1, (transferMemoryHandle))

        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_MEMBER(handle, (::nn::irsensor::IrCameraHandle), 0)
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_MEMBER(aruid, (::nn::applet::AppletResourceUserId), 8)
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_MEMBER(config, (::nn::irsensor::PackedImageTransferProcessorConfig), 16)
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_MEMBER(size, (::std::uint64_t), 40)
        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_END(4, (handle, aruid, config, size))
        NN_SF_CMIF_DETAIL_METHOD_INFO_IN_RAW_SIZE(48)

        NN_SF_CMIF_DETAIL_METHOD_INFO_ARGUMENT_INFOS((NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(aruid), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(handle), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(config), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(transferMemoryHandle), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(size)))

    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO_END(RunImageTransferProcessor)

    // nn::Result GetImageTransferProcessorState(nn::applet::AppletResourceUserId aruid, nn::sf::Out<nn::irsensor::ImageTransferProcessorState> outState, const nn::sf::OutBuffer& outBuffer, nn::irsensor::IrCameraHandle handle) NN_NOEXCEPT
    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO(GetImageTransferProcessorState)

        NN_SF_CMIF_DETAIL_METHOD_INFO_METHOD_ID(309)
        NN_SF_CMIF_DETAIL_METHOD_INFO_RETURN_TYPE_IS_RESULT(true)

        NN_SF_CMIF_DETAIL_METHOD_INFO_IN_PROCESS_ID_ENABLE()

        NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_COUNT(1)
        NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_INFOS
            NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_INFO(outBuffer, 0, (const ::nn::sf::OutBuffer&), NN_SF_CMIF_DETAIL_BUFFER_ATTRIBUTE_OUT | NN_SF_CMIF_DETAIL_BUFFER_ATTRIBUTE_HIPC_MAP_ALIAS)
        NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_INFOS_END(1, (outBuffer))

        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_MEMBER(handle, (::nn::irsensor::IrCameraHandle), 0)
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_MEMBER(aruid, (::nn::applet::AppletResourceUserId), 8)
        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_END(2, (handle, aruid))
        NN_SF_CMIF_DETAIL_METHOD_INFO_IN_RAW_SIZE(16)

        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT_MEMBER(outState, (::nn::irsensor::ImageTransferProcessorState), 0)
        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT_END(1, (outState))
        NN_SF_CMIF_DETAIL_METHOD_INFO_OUT_RAW_SIZE(16)

        NN_SF_CMIF_DETAIL_METHOD_INFO_ARGUMENT_INFOS((NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(aruid), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(outState), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(outBuffer), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(handle)))

    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO_END(GetImageTransferProcessorState)

    // nn::Result RunTeraPluginProcessor(nn::applet::AppletResourceUserId aruid, nn::irsensor::IrCameraHandle handle, nn::irsensor::PackedTeraPluginProcessorConfig config) NN_NOEXCEPT
    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO(RunTeraPluginProcessor)

        NN_SF_CMIF_DETAIL_METHOD_INFO_METHOD_ID(310)
        NN_SF_CMIF_DETAIL_METHOD_INFO_RETURN_TYPE_IS_RESULT(true)

        NN_SF_CMIF_DETAIL_METHOD_INFO_IN_PROCESS_ID_ENABLE()

        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_MEMBER(handle, (::nn::irsensor::IrCameraHandle), 0)
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_MEMBER(config, (::nn::irsensor::PackedTeraPluginProcessorConfig), 4)
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_MEMBER(aruid, (::nn::applet::AppletResourceUserId), 16)
        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_END(3, (handle, config, aruid))
        NN_SF_CMIF_DETAIL_METHOD_INFO_IN_RAW_SIZE(24)

        NN_SF_CMIF_DETAIL_METHOD_INFO_ARGUMENT_INFOS((NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(aruid), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(handle), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(config)))

    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO_END(RunTeraPluginProcessor)

    // nn::Result GetNpadIrCameraHandle(nn::sf::Out<nn::irsensor::IrCameraHandle> outValue, nn::hid::NpadIdType npadIdType) NN_NOEXCEPT
    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO(GetNpadIrCameraHandle)

        NN_SF_CMIF_DETAIL_METHOD_INFO_METHOD_ID(311)
        NN_SF_CMIF_DETAIL_METHOD_INFO_RETURN_TYPE_IS_RESULT(true)

        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_MEMBER(npadIdType, (::nn::hid::NpadIdType), 0)
        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_END(1, (npadIdType))
        NN_SF_CMIF_DETAIL_METHOD_INFO_IN_RAW_SIZE(4)

        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT_MEMBER(outValue, (::nn::irsensor::IrCameraHandle), 0)
        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT_END(1, (outValue))
        NN_SF_CMIF_DETAIL_METHOD_INFO_OUT_RAW_SIZE(4)

        NN_SF_CMIF_DETAIL_METHOD_INFO_ARGUMENT_INFOS((NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(outValue), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(npadIdType)))

    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO_END(GetNpadIrCameraHandle)

    // nn::Result RunPointingProcessor(nn::applet::AppletResourceUserId aruid, nn::irsensor::IrCameraHandle handle, const nn::irsensor::PackedPointingProcessorConfig& config) NN_NOEXCEPT
    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO(RunPointingProcessor)

        NN_SF_CMIF_DETAIL_METHOD_INFO_METHOD_ID(312)
        NN_SF_CMIF_DETAIL_METHOD_INFO_RETURN_TYPE_IS_RESULT(true)

        NN_SF_CMIF_DETAIL_METHOD_INFO_IN_PROCESS_ID_ENABLE()

        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_MEMBER(handle, (::nn::irsensor::IrCameraHandle), 0)
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_MEMBER(config, (::nn::irsensor::PackedPointingProcessorConfig), 4)
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_MEMBER(aruid, (::nn::applet::AppletResourceUserId), 16)
        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_END(3, (handle, config, aruid))
        NN_SF_CMIF_DETAIL_METHOD_INFO_IN_RAW_SIZE(24)

        NN_SF_CMIF_DETAIL_METHOD_INFO_ARGUMENT_INFOS((NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(aruid), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(handle), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(config)))

    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO_END(RunPointingProcessor)

    // nn::Result SuspendImageProcessor(nn::applet::AppletResourceUserId aruid, nn::irsensor::IrCameraHandle handle) NN_NOEXCEPT
    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO(SuspendImageProcessor)

        NN_SF_CMIF_DETAIL_METHOD_INFO_METHOD_ID(313)
        NN_SF_CMIF_DETAIL_METHOD_INFO_RETURN_TYPE_IS_RESULT(true)

        NN_SF_CMIF_DETAIL_METHOD_INFO_IN_PROCESS_ID_ENABLE()

        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_MEMBER(handle, (::nn::irsensor::IrCameraHandle), 0)
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_MEMBER(aruid, (::nn::applet::AppletResourceUserId), 8)
        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_END(2, (handle, aruid))
        NN_SF_CMIF_DETAIL_METHOD_INFO_IN_RAW_SIZE(16)

        NN_SF_CMIF_DETAIL_METHOD_INFO_ARGUMENT_INFOS((NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(aruid), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(handle)))

    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO_END(SuspendImageProcessor)

    // nn::Result CheckFirmwareVersion(nn::applet::AppletResourceUserId aruid, nn::irsensor::IrCameraHandle handle, nn::irsensor::PackedMcuVersion requiredVersion) NN_NOEXCEPT
    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO(CheckFirmwareVersion)

        NN_SF_CMIF_DETAIL_METHOD_INFO_METHOD_ID(314)
        NN_SF_CMIF_DETAIL_METHOD_INFO_RETURN_TYPE_IS_RESULT(true)

        NN_SF_CMIF_DETAIL_METHOD_INFO_IN_PROCESS_ID_ENABLE()

        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_MEMBER(handle, (::nn::irsensor::IrCameraHandle), 0)
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_MEMBER(requiredVersion, (::nn::irsensor::PackedMcuVersion), 4)
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_MEMBER(aruid, (::nn::applet::AppletResourceUserId), 8)
        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_END(3, (handle, requiredVersion, aruid))
        NN_SF_CMIF_DETAIL_METHOD_INFO_IN_RAW_SIZE(16)

        NN_SF_CMIF_DETAIL_METHOD_INFO_ARGUMENT_INFOS((NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(aruid), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(handle), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(requiredVersion)))

    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO_END(CheckFirmwareVersion)

    // nn::Result SetFunctionLevel(nn::applet::AppletResourceUserId aruid, nn::irsensor::IrCameraHandle handle, nn::irsensor::PackedFunctionLevel functionLevel) NN_NOEXCEPT
    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO(SetFunctionLevel)

        NN_SF_CMIF_DETAIL_METHOD_INFO_METHOD_ID(315)
        NN_SF_CMIF_DETAIL_METHOD_INFO_RETURN_TYPE_IS_RESULT(true)

        NN_SF_CMIF_DETAIL_METHOD_INFO_IN_PROCESS_ID_ENABLE()

        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_MEMBER(handle, (::nn::irsensor::IrCameraHandle), 0)
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_MEMBER(functionLevel, (::nn::irsensor::PackedFunctionLevel), 4)
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_MEMBER(aruid, (::nn::applet::AppletResourceUserId), 8)
        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_END(3, (handle, functionLevel, aruid))
        NN_SF_CMIF_DETAIL_METHOD_INFO_IN_RAW_SIZE(16)

        NN_SF_CMIF_DETAIL_METHOD_INFO_ARGUMENT_INFOS((NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(aruid), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(handle), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(functionLevel)))

    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO_END(SetFunctionLevel)

    // nn::Result RunImageTransferExProcessor(nn::applet::AppletResourceUserId aruid, nn::irsensor::IrCameraHandle handle, const nn::irsensor::PackedImageTransferProcessorExConfig& config, nn::sf::NativeHandle&& transferMemoryHandle, std::uint64_t size) NN_NOEXCEPT
    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO(RunImageTransferExProcessor)

        NN_SF_CMIF_DETAIL_METHOD_INFO_METHOD_ID(316)
        NN_SF_CMIF_DETAIL_METHOD_INFO_RETURN_TYPE_IS_RESULT(true)

        NN_SF_CMIF_DETAIL_METHOD_INFO_IN_PROCESS_ID_ENABLE()

        NN_SF_CMIF_DETAIL_METHOD_INFO_IN_NATIVE_HANDLE_COUNT(1)
        NN_SF_CMIF_DETAIL_METHOD_INFO_IN_NATIVE_HANDLE_INFOS
            NN_SF_CMIF_DETAIL_METHOD_INFO_IN_NATIVE_HANDLE_INFO(transferMemoryHandle, 0, NN_SF_CMIF_DETAIL_NATIVE_HANDLE_ATTRIBUTE_HIPC_COPY)
        NN_SF_CMIF_DETAIL_METHOD_INFO_IN_NATIVE_HANDLE_INFOS_END(1, (transferMemoryHandle))

        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_MEMBER(handle, (::nn::irsensor::IrCameraHandle), 0)
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_MEMBER(aruid, (::nn::applet::AppletResourceUserId), 8)
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_MEMBER(config, (::nn::irsensor::PackedImageTransferProcessorExConfig), 16)
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_MEMBER(size, (::std::uint64_t), 48)
        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_END(4, (handle, aruid, config, size))
        NN_SF_CMIF_DETAIL_METHOD_INFO_IN_RAW_SIZE(56)

        NN_SF_CMIF_DETAIL_METHOD_INFO_ARGUMENT_INFOS((NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(aruid), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(handle), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(config), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(transferMemoryHandle), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(size)))

    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO_END(RunImageTransferExProcessor)

    // nn::Result RunIrLedProcessor(nn::applet::AppletResourceUserId aruid, nn::irsensor::IrCameraHandle handle, nn::irsensor::PackedIrLedProcessorConfig config) NN_NOEXCEPT
    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO(RunIrLedProcessor)

        NN_SF_CMIF_DETAIL_METHOD_INFO_METHOD_ID(317)
        NN_SF_CMIF_DETAIL_METHOD_INFO_RETURN_TYPE_IS_RESULT(true)

        NN_SF_CMIF_DETAIL_METHOD_INFO_IN_PROCESS_ID_ENABLE()

        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_MEMBER(handle, (::nn::irsensor::IrCameraHandle), 0)
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_MEMBER(config, (::nn::irsensor::PackedIrLedProcessorConfig), 4)
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_MEMBER(aruid, (::nn::applet::AppletResourceUserId), 16)
        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_END(3, (handle, config, aruid))
        NN_SF_CMIF_DETAIL_METHOD_INFO_IN_RAW_SIZE(24)

        NN_SF_CMIF_DETAIL_METHOD_INFO_ARGUMENT_INFOS((NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(aruid), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(handle), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(config)))

    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO_END(RunIrLedProcessor)

    // nn::Result StopImageProcessorAsync(nn::applet::AppletResourceUserId aruid, nn::irsensor::IrCameraHandle handle) NN_NOEXCEPT
    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO(StopImageProcessorAsync)

        NN_SF_CMIF_DETAIL_METHOD_INFO_METHOD_ID(318)
        NN_SF_CMIF_DETAIL_METHOD_INFO_RETURN_TYPE_IS_RESULT(true)

        NN_SF_CMIF_DETAIL_METHOD_INFO_IN_PROCESS_ID_ENABLE()

        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_MEMBER(handle, (::nn::irsensor::IrCameraHandle), 0)
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_MEMBER(aruid, (::nn::applet::AppletResourceUserId), 8)
        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_END(2, (handle, aruid))
        NN_SF_CMIF_DETAIL_METHOD_INFO_IN_RAW_SIZE(16)

        NN_SF_CMIF_DETAIL_METHOD_INFO_ARGUMENT_INFOS((NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(aruid), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(handle)))

    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO_END(StopImageProcessorAsync)

    // nn::Result ActivateIrsensorWithFunctionLevel(nn::applet::AppletResourceUserId aruid, nn::irsensor::PackedFunctionLevel functionLevel) NN_NOEXCEPT
    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO(ActivateIrsensorWithFunctionLevel)

        NN_SF_CMIF_DETAIL_METHOD_INFO_METHOD_ID(319)
        NN_SF_CMIF_DETAIL_METHOD_INFO_RETURN_TYPE_IS_RESULT(true)

        NN_SF_CMIF_DETAIL_METHOD_INFO_IN_PROCESS_ID_ENABLE()

        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_MEMBER(functionLevel, (::nn::irsensor::PackedFunctionLevel), 0)
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_MEMBER(aruid, (::nn::applet::AppletResourceUserId), 8)
        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_END(2, (functionLevel, aruid))
        NN_SF_CMIF_DETAIL_METHOD_INFO_IN_RAW_SIZE(16)

        NN_SF_CMIF_DETAIL_METHOD_INFO_ARGUMENT_INFOS((NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(aruid), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(functionLevel)))

    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO_END(ActivateIrsensorWithFunctionLevel)

    NN_SF_CMIF_DETAIL_METHOD_INFO_REFERRED_STRUCT_ASSERTION_CHECK((::nn::applet::AppletResourceUserId), 8, 8)
    NN_SF_CMIF_DETAIL_METHOD_INFO_REFERRED_STRUCT_ASSERTION_CHECK((::nn::irsensor::IrCameraHandle), 4, 4)
    NN_SF_CMIF_DETAIL_METHOD_INFO_REFERRED_STRUCT_ASSERTION_CHECK((::nn::irsensor::PackedMomentProcessorConfig), 32, 8)
    NN_SF_CMIF_DETAIL_METHOD_INFO_REFERRED_STRUCT_ASSERTION_CHECK((::nn::irsensor::PackedClusteringProcessorConfig), 40, 8)
    NN_SF_CMIF_DETAIL_METHOD_INFO_REFERRED_STRUCT_ASSERTION_CHECK((::nn::irsensor::PackedImageTransferProcessorConfig), 24, 8)
    NN_SF_CMIF_DETAIL_METHOD_INFO_REFERRED_STRUCT_ASSERTION_CHECK((::nn::irsensor::ImageTransferProcessorState), 16, 8)
    NN_SF_CMIF_DETAIL_METHOD_INFO_REFERRED_STRUCT_ASSERTION_CHECK((::nn::irsensor::PackedTeraPluginProcessorConfig), 8, 4)
    NN_SF_CMIF_DETAIL_METHOD_INFO_REFERRED_STRUCT_ASSERTION_CHECK((::nn::hid::NpadIdType), 4, 4)
    NN_SF_CMIF_DETAIL_METHOD_INFO_REFERRED_STRUCT_ASSERTION_CHECK((::nn::irsensor::PackedPointingProcessorConfig), 12, 4)
    NN_SF_CMIF_DETAIL_METHOD_INFO_REFERRED_STRUCT_ASSERTION_CHECK((::nn::irsensor::PackedMcuVersion), 4, 4)
    NN_SF_CMIF_DETAIL_METHOD_INFO_REFERRED_STRUCT_ASSERTION_CHECK((::nn::irsensor::PackedFunctionLevel), 4, 4)
    NN_SF_CMIF_DETAIL_METHOD_INFO_REFERRED_STRUCT_ASSERTION_CHECK((::nn::irsensor::PackedImageTransferProcessorExConfig), 32, 8)
    NN_SF_CMIF_DETAIL_METHOD_INFO_REFERRED_STRUCT_ASSERTION_CHECK((::nn::irsensor::PackedIrLedProcessorConfig), 8, 4)

NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFOS_END

// template <...> class nn::sf::client::detail::CmifProxy<nn::irsensor::IIrSensorServer, ...>
NN_SF_CMIF_CLIENT_DETAIL_DEFINE_PROXY((::nn::irsensor::IIrSensorServer))

    // nn::Result ActivateIrsensor(nn::applet::AppletResourceUserId aruid) NN_NOEXCEPT
    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(ActivateIrsensor, (::nn::applet::AppletResourceUserId aruid))
    {
        NN_SF_CMIF_CLIENT_DETAIL_CALL_BEGIN(ActivateIrsensor)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(aruid)
        NN_SF_CMIF_CLIENT_DETAIL_CALL_END(ActivateIrsensor)
    }

    // nn::Result DeactivateIrsensor(nn::applet::AppletResourceUserId aruid) NN_NOEXCEPT
    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(DeactivateIrsensor, (::nn::applet::AppletResourceUserId aruid))
    {
        NN_SF_CMIF_CLIENT_DETAIL_CALL_BEGIN(DeactivateIrsensor)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(aruid)
        NN_SF_CMIF_CLIENT_DETAIL_CALL_END(DeactivateIrsensor)
    }

    // nn::Result GetIrsensorSharedMemoryHandle(nn::sf::Out<nn::sf::NativeHandle> outValue, nn::applet::AppletResourceUserId aruid) NN_NOEXCEPT
    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(GetIrsensorSharedMemoryHandle, (::nn::sf::Out<::nn::sf::NativeHandle> outValue, ::nn::applet::AppletResourceUserId aruid))
    {
        NN_SF_CMIF_CLIENT_DETAIL_CALL_BEGIN(GetIrsensorSharedMemoryHandle)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(outValue)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(aruid)
        NN_SF_CMIF_CLIENT_DETAIL_CALL_END(GetIrsensorSharedMemoryHandle)
    }

    // nn::Result StopImageProcessor(nn::applet::AppletResourceUserId aruid, nn::irsensor::IrCameraHandle handle) NN_NOEXCEPT
    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(StopImageProcessor, (::nn::applet::AppletResourceUserId aruid, ::nn::irsensor::IrCameraHandle handle))
    {
        NN_SF_CMIF_CLIENT_DETAIL_CALL_BEGIN(StopImageProcessor)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(aruid)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(handle)
        NN_SF_CMIF_CLIENT_DETAIL_CALL_END(StopImageProcessor)
    }

    // nn::Result RunMomentProcessor(nn::applet::AppletResourceUserId aruid, nn::irsensor::IrCameraHandle handle, const nn::irsensor::PackedMomentProcessorConfig& config) NN_NOEXCEPT
    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(RunMomentProcessor, (::nn::applet::AppletResourceUserId aruid, ::nn::irsensor::IrCameraHandle handle, const ::nn::irsensor::PackedMomentProcessorConfig& config))
    {
        NN_SF_CMIF_CLIENT_DETAIL_CALL_BEGIN(RunMomentProcessor)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(aruid)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(handle)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(config)
        NN_SF_CMIF_CLIENT_DETAIL_CALL_END(RunMomentProcessor)
    }

    // nn::Result RunClusteringProcessor(nn::applet::AppletResourceUserId aruid, nn::irsensor::IrCameraHandle handle, const nn::irsensor::PackedClusteringProcessorConfig& config) NN_NOEXCEPT
    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(RunClusteringProcessor, (::nn::applet::AppletResourceUserId aruid, ::nn::irsensor::IrCameraHandle handle, const ::nn::irsensor::PackedClusteringProcessorConfig& config))
    {
        NN_SF_CMIF_CLIENT_DETAIL_CALL_BEGIN(RunClusteringProcessor)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(aruid)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(handle)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(config)
        NN_SF_CMIF_CLIENT_DETAIL_CALL_END(RunClusteringProcessor)
    }

    // nn::Result RunImageTransferProcessor(nn::applet::AppletResourceUserId aruid, nn::irsensor::IrCameraHandle handle, const nn::irsensor::PackedImageTransferProcessorConfig& config, nn::sf::NativeHandle&& transferMemoryHandle, std::uint64_t size) NN_NOEXCEPT
    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(RunImageTransferProcessor, (::nn::applet::AppletResourceUserId aruid, ::nn::irsensor::IrCameraHandle handle, const ::nn::irsensor::PackedImageTransferProcessorConfig& config, ::nn::sf::NativeHandle&& transferMemoryHandle, ::std::uint64_t size))
    {
        NN_SF_CMIF_CLIENT_DETAIL_CALL_BEGIN(RunImageTransferProcessor)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(aruid)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(handle)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(config)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(transferMemoryHandle)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(size)
        NN_SF_CMIF_CLIENT_DETAIL_CALL_END(RunImageTransferProcessor)
    }

    // nn::Result GetImageTransferProcessorState(nn::applet::AppletResourceUserId aruid, nn::sf::Out<nn::irsensor::ImageTransferProcessorState> outState, const nn::sf::OutBuffer& outBuffer, nn::irsensor::IrCameraHandle handle) NN_NOEXCEPT
    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(GetImageTransferProcessorState, (::nn::applet::AppletResourceUserId aruid, ::nn::sf::Out<::nn::irsensor::ImageTransferProcessorState> outState, const ::nn::sf::OutBuffer& outBuffer, ::nn::irsensor::IrCameraHandle handle))
    {
        NN_SF_CMIF_CLIENT_DETAIL_CALL_BEGIN(GetImageTransferProcessorState)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(aruid)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(outState)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(outBuffer)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(handle)
        NN_SF_CMIF_CLIENT_DETAIL_CALL_END(GetImageTransferProcessorState)
    }

    // nn::Result RunTeraPluginProcessor(nn::applet::AppletResourceUserId aruid, nn::irsensor::IrCameraHandle handle, nn::irsensor::PackedTeraPluginProcessorConfig config) NN_NOEXCEPT
    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(RunTeraPluginProcessor, (::nn::applet::AppletResourceUserId aruid, ::nn::irsensor::IrCameraHandle handle, ::nn::irsensor::PackedTeraPluginProcessorConfig config))
    {
        NN_SF_CMIF_CLIENT_DETAIL_CALL_BEGIN(RunTeraPluginProcessor)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(aruid)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(handle)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(config)
        NN_SF_CMIF_CLIENT_DETAIL_CALL_END(RunTeraPluginProcessor)
    }

    // nn::Result GetNpadIrCameraHandle(nn::sf::Out<nn::irsensor::IrCameraHandle> outValue, nn::hid::NpadIdType npadIdType) NN_NOEXCEPT
    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(GetNpadIrCameraHandle, (::nn::sf::Out<::nn::irsensor::IrCameraHandle> outValue, ::nn::hid::NpadIdType npadIdType))
    {
        NN_SF_CMIF_CLIENT_DETAIL_CALL_BEGIN(GetNpadIrCameraHandle)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(outValue)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(npadIdType)
        NN_SF_CMIF_CLIENT_DETAIL_CALL_END(GetNpadIrCameraHandle)
    }

    // nn::Result RunPointingProcessor(nn::applet::AppletResourceUserId aruid, nn::irsensor::IrCameraHandle handle, const nn::irsensor::PackedPointingProcessorConfig& config) NN_NOEXCEPT
    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(RunPointingProcessor, (::nn::applet::AppletResourceUserId aruid, ::nn::irsensor::IrCameraHandle handle, const ::nn::irsensor::PackedPointingProcessorConfig& config))
    {
        NN_SF_CMIF_CLIENT_DETAIL_CALL_BEGIN(RunPointingProcessor)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(aruid)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(handle)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(config)
        NN_SF_CMIF_CLIENT_DETAIL_CALL_END(RunPointingProcessor)
    }

    // nn::Result SuspendImageProcessor(nn::applet::AppletResourceUserId aruid, nn::irsensor::IrCameraHandle handle) NN_NOEXCEPT
    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(SuspendImageProcessor, (::nn::applet::AppletResourceUserId aruid, ::nn::irsensor::IrCameraHandle handle))
    {
        NN_SF_CMIF_CLIENT_DETAIL_CALL_BEGIN(SuspendImageProcessor)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(aruid)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(handle)
        NN_SF_CMIF_CLIENT_DETAIL_CALL_END(SuspendImageProcessor)
    }

    // nn::Result CheckFirmwareVersion(nn::applet::AppletResourceUserId aruid, nn::irsensor::IrCameraHandle handle, nn::irsensor::PackedMcuVersion requiredVersion) NN_NOEXCEPT
    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(CheckFirmwareVersion, (::nn::applet::AppletResourceUserId aruid, ::nn::irsensor::IrCameraHandle handle, ::nn::irsensor::PackedMcuVersion requiredVersion))
    {
        NN_SF_CMIF_CLIENT_DETAIL_CALL_BEGIN(CheckFirmwareVersion)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(aruid)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(handle)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(requiredVersion)
        NN_SF_CMIF_CLIENT_DETAIL_CALL_END(CheckFirmwareVersion)
    }

    // nn::Result SetFunctionLevel(nn::applet::AppletResourceUserId aruid, nn::irsensor::IrCameraHandle handle, nn::irsensor::PackedFunctionLevel functionLevel) NN_NOEXCEPT
    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(SetFunctionLevel, (::nn::applet::AppletResourceUserId aruid, ::nn::irsensor::IrCameraHandle handle, ::nn::irsensor::PackedFunctionLevel functionLevel))
    {
        NN_SF_CMIF_CLIENT_DETAIL_CALL_BEGIN(SetFunctionLevel)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(aruid)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(handle)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(functionLevel)
        NN_SF_CMIF_CLIENT_DETAIL_CALL_END(SetFunctionLevel)
    }

    // nn::Result RunImageTransferExProcessor(nn::applet::AppletResourceUserId aruid, nn::irsensor::IrCameraHandle handle, const nn::irsensor::PackedImageTransferProcessorExConfig& config, nn::sf::NativeHandle&& transferMemoryHandle, std::uint64_t size) NN_NOEXCEPT
    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(RunImageTransferExProcessor, (::nn::applet::AppletResourceUserId aruid, ::nn::irsensor::IrCameraHandle handle, const ::nn::irsensor::PackedImageTransferProcessorExConfig& config, ::nn::sf::NativeHandle&& transferMemoryHandle, ::std::uint64_t size))
    {
        NN_SF_CMIF_CLIENT_DETAIL_CALL_BEGIN(RunImageTransferExProcessor)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(aruid)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(handle)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(config)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(transferMemoryHandle)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(size)
        NN_SF_CMIF_CLIENT_DETAIL_CALL_END(RunImageTransferExProcessor)
    }

    // nn::Result RunIrLedProcessor(nn::applet::AppletResourceUserId aruid, nn::irsensor::IrCameraHandle handle, nn::irsensor::PackedIrLedProcessorConfig config) NN_NOEXCEPT
    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(RunIrLedProcessor, (::nn::applet::AppletResourceUserId aruid, ::nn::irsensor::IrCameraHandle handle, ::nn::irsensor::PackedIrLedProcessorConfig config))
    {
        NN_SF_CMIF_CLIENT_DETAIL_CALL_BEGIN(RunIrLedProcessor)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(aruid)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(handle)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(config)
        NN_SF_CMIF_CLIENT_DETAIL_CALL_END(RunIrLedProcessor)
    }

    // nn::Result StopImageProcessorAsync(nn::applet::AppletResourceUserId aruid, nn::irsensor::IrCameraHandle handle) NN_NOEXCEPT
    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(StopImageProcessorAsync, (::nn::applet::AppletResourceUserId aruid, ::nn::irsensor::IrCameraHandle handle))
    {
        NN_SF_CMIF_CLIENT_DETAIL_CALL_BEGIN(StopImageProcessorAsync)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(aruid)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(handle)
        NN_SF_CMIF_CLIENT_DETAIL_CALL_END(StopImageProcessorAsync)
    }

    // nn::Result ActivateIrsensorWithFunctionLevel(nn::applet::AppletResourceUserId aruid, nn::irsensor::PackedFunctionLevel functionLevel) NN_NOEXCEPT
    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(ActivateIrsensorWithFunctionLevel, (::nn::applet::AppletResourceUserId aruid, ::nn::irsensor::PackedFunctionLevel functionLevel))
    {
        NN_SF_CMIF_CLIENT_DETAIL_CALL_BEGIN(ActivateIrsensorWithFunctionLevel)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(aruid)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(functionLevel)
        NN_SF_CMIF_CLIENT_DETAIL_CALL_END(ActivateIrsensorWithFunctionLevel)
    }

NN_SF_CMIF_CLIENT_DETAIL_DEFINE_PROXY_END

// template <> class nn::sf::server::detail::CmifProcessFunctionTableGetterImpl<nn::irsensor::IIrSensorServer>
NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCHER((::nn::irsensor::IIrSensorServer))

    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD(ActivateIrsensor)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_CHECK_PRE(NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_APPLY_PROCESS_ID(_, CheckAppletResourceUserId(_processId, _), NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(aruid)))
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE(ActivateIrsensor)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(aruid)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE_END
    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_END

    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD(DeactivateIrsensor)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_CHECK_PRE(NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_APPLY_PROCESS_ID(_, CheckAppletResourceUserId(_processId, _), NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(aruid)))
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE(DeactivateIrsensor)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(aruid)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE_END
    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_END

    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD(GetIrsensorSharedMemoryHandle)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_OUT_NATIVE_HANDLES
                NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_OUT_NATIVE_HANDLE(outValue)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_OUT_NATIVE_HANDLES_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_CHECK_PRE(NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_APPLY_PROCESS_ID(_, CheckAppletResourceUserId(_processId, _), NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(aruid)))
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE(GetIrsensorSharedMemoryHandle)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_OUT_NATIVE_HANDLE(outValue),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(aruid)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE_END
    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_END

    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD(StopImageProcessor)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_CHECK_PRE(NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_APPLY_PROCESS_ID(_, CheckAppletResourceUserId(_processId, _), NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(aruid)))
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE(StopImageProcessor)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(aruid),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(handle)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE_END
    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_END

    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD(RunMomentProcessor)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_CHECK_PRE(NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_APPLY_PROCESS_ID(_, CheckAppletResourceUserId(_processId, _), NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(aruid)))
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE(RunMomentProcessor)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(aruid),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(handle),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(config)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE_END
    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_END

    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD(RunClusteringProcessor)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_CHECK_PRE(NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_APPLY_PROCESS_ID(_, CheckAppletResourceUserId(_processId, _), NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(aruid)))
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE(RunClusteringProcessor)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(aruid),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(handle),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(config)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE_END
    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_END

    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD(RunImageTransferProcessor)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_IN_NATIVE_HANDLES
                NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_IN_NATIVE_HANDLE(transferMemoryHandle)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_IN_NATIVE_HANDLES_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_CHECK_PRE(NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_APPLY_PROCESS_ID(_, CheckAppletResourceUserId(_processId, _), NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(aruid)))
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE(RunImageTransferProcessor)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(aruid),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(handle),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(config),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_NATIVE_HANDLE(transferMemoryHandle),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(size)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE_END
    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_END

    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD(GetImageTransferProcessorState)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_BUFFERS
                NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_BUFFER(outBuffer)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_BUFFERS_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_CHECK_PRE(NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_APPLY_PROCESS_ID(_, CheckAppletResourceUserId(_processId, _), NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(aruid)))
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE(GetImageTransferProcessorState)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(aruid),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_OUT_MEMBER(outState),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_BUFFER(outBuffer),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(handle)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE_END
    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_END

    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD(RunTeraPluginProcessor)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_CHECK_PRE(NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_APPLY_PROCESS_ID(_, CheckAppletResourceUserId(_processId, _), NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(aruid)))
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE(RunTeraPluginProcessor)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(aruid),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(handle),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(config)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE_END
    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_END

    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD(GetNpadIrCameraHandle)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE(GetNpadIrCameraHandle)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_OUT_MEMBER(outValue),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(npadIdType)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE_END
    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_END

    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD(RunPointingProcessor)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_CHECK_PRE(NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_APPLY_PROCESS_ID(_, CheckAppletResourceUserId(_processId, _), NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(aruid)))
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE(RunPointingProcessor)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(aruid),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(handle),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(config)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE_END
    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_END

    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD(SuspendImageProcessor)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_CHECK_PRE(NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_APPLY_PROCESS_ID(_, CheckAppletResourceUserId(_processId, _), NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(aruid)))
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE(SuspendImageProcessor)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(aruid),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(handle)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE_END
    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_END

    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD(CheckFirmwareVersion)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_CHECK_PRE(NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_APPLY_PROCESS_ID(_, CheckAppletResourceUserId(_processId, _), NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(aruid)))
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE(CheckFirmwareVersion)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(aruid),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(handle),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(requiredVersion)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE_END
    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_END

    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD(SetFunctionLevel)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_CHECK_PRE(NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_APPLY_PROCESS_ID(_, CheckAppletResourceUserId(_processId, _), NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(aruid)))
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE(SetFunctionLevel)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(aruid),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(handle),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(functionLevel)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE_END
    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_END

    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD(RunImageTransferExProcessor)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_IN_NATIVE_HANDLES
                NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_IN_NATIVE_HANDLE(transferMemoryHandle)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_IN_NATIVE_HANDLES_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_CHECK_PRE(NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_APPLY_PROCESS_ID(_, CheckAppletResourceUserId(_processId, _), NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(aruid)))
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE(RunImageTransferExProcessor)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(aruid),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(handle),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(config),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_NATIVE_HANDLE(transferMemoryHandle),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(size)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE_END
    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_END

    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD(RunIrLedProcessor)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_CHECK_PRE(NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_APPLY_PROCESS_ID(_, CheckAppletResourceUserId(_processId, _), NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(aruid)))
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE(RunIrLedProcessor)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(aruid),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(handle),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(config)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE_END
    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_END

    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD(StopImageProcessorAsync)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_CHECK_PRE(NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_APPLY_PROCESS_ID(_, CheckAppletResourceUserId(_processId, _), NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(aruid)))
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE(StopImageProcessorAsync)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(aruid),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(handle)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE_END
    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_END

    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD(ActivateIrsensorWithFunctionLevel)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_CHECK_PRE(NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_APPLY_PROCESS_ID(_, CheckAppletResourceUserId(_processId, _), NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(aruid)))
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE(ActivateIrsensorWithFunctionLevel)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(aruid),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(functionLevel)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE_END
    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_END

    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE_CASE(ActivateIrsensor)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE_CASE(DeactivateIrsensor)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE_CASE(GetIrsensorSharedMemoryHandle)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE_CASE(StopImageProcessor)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE_CASE(RunMomentProcessor)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE_CASE(RunClusteringProcessor)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE_CASE(RunImageTransferProcessor)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE_CASE(GetImageTransferProcessorState)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE_CASE(RunTeraPluginProcessor)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE_CASE(GetNpadIrCameraHandle)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE_CASE(RunPointingProcessor)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE_CASE(SuspendImageProcessor)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE_CASE(CheckFirmwareVersion)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE_CASE(SetFunctionLevel)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE_CASE(RunImageTransferExProcessor)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE_CASE(RunIrLedProcessor)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE_CASE(StopImageProcessorAsync)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE_CASE(ActivateIrsensorWithFunctionLevel)
    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE_END

NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCHER_END

NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCHER_FUNCTION_TABLE((::nn::irsensor::IIrSensorServer))
