﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

/**
 * @file
 * @brief       Pro Controller 有線 USB 通信機能に関する API の宣言
 */

#pragma once

#include <nn/hid/system/hid_UniquePad.h>

namespace nn { namespace hid { namespace system {

//! @name Pro Controller 有線 USB 通信機能関連 API
//! @{

/**
 * @brief       Pro Controller 有線 USB 通信機能が有効か否かを取得します。
 *
 * @return      Pro Controller 有線 USB 通信機能が有効か否かを表す値です。
 */
bool IsUsbFullKeyControllerEnabled() NN_NOEXCEPT;

/**
 * @brief       Pro Controller 有線 USB 通信機能の有効/無効を設定します。
 *
 * @param[in]   enable                   Pro Controller 有線 USB 通信機能を有効にするか
 *
 */
void EnableUsbFullKeyController(bool enable) NN_NOEXCEPT;

/**
 * @brief       コントローラーが USB 接続されているかどうかを取得します。
 *
 * @details     UniquePadId で指定した UniquePad に対して、
 *              USB 接続されているかどうかを取得します。
 *
 * @param[in]   id                      コントローラーの UniquePadId
 *
 * @return      コントローラーが USB 接続されているかどうかを返します。
 */
bool IsUsbConnected(UniquePadId id) NN_NOEXCEPT;

//! @}

}}} // namespace nn::hid::system
