﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

/**
 * @file
 * @brief   コントローラーサポートの UI 呼び出しに関する型等の宣言（非公開）
 */

#pragma once

namespace nn { namespace hid { namespace system {

// 1.0.0 NUP : 初期
const uint32_t c_Version_1_0_0 = 1u;

// 1.0.0 NUP : ControllerSupportArgVersion2 から ControllerSupportArg にバージョンアップ
const uint32_t c_Version_1_0_0_UpdateToControllerSupportArg = 2u;

// 1.0.0 NUP : 指定文字列のバッファ長修正
const uint32_t c_Version_1_0_0_ChangeExplainTextBufferLength = 3u;

// 2.0.0 NUP : 1.0.0 NUP から変化なし
const uint32_t c_Version_2_0_0 = c_Version_1_0_0_ChangeExplainTextBufferLength;

// 3.0.0 NUP : 58113 : Mode, Caller 変数が ControllerSupportArgPrivate に追加された
const uint32_t c_Version_3_0_0 = 4u;
const uint32_t c_Version_3_0_0_AddModeAndCaller = c_Version_3_0_0;

// 5.1.0 NUP : 特殊なストラップガイド対応
const uint32_t c_Version_5_1_0 = 5u;
const uint32_t c_Version_5_1_0_AddStrapGuideForPalma = c_Version_5_1_0;

// 以下、アップデートがあれば追加していく
// const uint32_t c_Version_3_0_0_XXX = ?;
// const uint32_t c_Version_4_0_0 = ?;

// 現在のバージョン
const uint32_t c_CurrentVersion      = c_Version_5_1_0;
const uint16_t c_CurrentMajorVersion = c_CurrentVersion >> 16;
const uint16_t c_CurrentMinorVersion = c_CurrentVersion & 0xFFFFu;

}}} // namespace nn::hid::system

