﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

/**
 * @file
 * @brief   本体機能での利用を想定した、コントローラーサポートの UI 呼び出しに関する型の宣言
 */

#pragma once

namespace nn { namespace hid { namespace system {

/**
* @brief コントローラーサポートの呼び出し元を示す列挙子です。
*/
enum ControllerSupportCaller : uint8_t
{
    ControllerSupportCaller_Application = 0,     //!< アプリケーション（デフォルト）
    ControllerSupportCaller_Settings,            //!< 本体設定
    ControllerSupportCaller_SettingsUsb,         //!< 本体設定（USB 有線通信）
    ControllerSupportCaller_HomeMenu,            //!< HOMEメニュー

    ControllerSupportCaller_OtherSystem = 0xFFu, //!< その他の本体機能（互換性のため）
};


}}} // namespace nn::hid::system

