﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

/**
 * @file
 * @brief       デバイスの電源状態に関する API の宣言
 */

#pragma once

namespace nn { namespace hid {

/**
 * @brief       デバイスの電源状態の定義です。
 */
enum PowerState
{
    PowerState_Disconnected,     //!< デバイスは切断されています。
    PowerState_OnBattery,        //!< デバイスは切断されておりバッテリーで動作しています。
    PowerState_NoBattery,        //!< デバイスは接続されておりバッテリーを持っていません。
    PowerState_Charging,         //!< デバイスは接続されており充電中です。
    PowerState_Charged,          //!< デバイスは接続されており充電済みです。
};

}} // namespace nn::hid
