﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

/**
 * @file
 * @brief       Npad のホームボタンに関する API の宣言
 */

#pragma once

#include <nn/nn_Macro.h>
#include <nn/hid/hid_NpadCommonTypes.h>

namespace nn { namespace hid {

//! @name Npad のホームボタン関連 API
//! @{

/**
 * @brief       Npad の意図しないホームボタン入力を保護する機能が有効かどうかを取得します。
 *
 * @details     Npad ID で指定した Npad に対して、
 *              意図しないホームボタン入力を無視する機能が有効かどうかを取得します。
 *
 * @param[in]   id                      Npad ID
 *
 * @return      ホームボタン保護機能が有効かどうかを返します。
 */
bool IsUnintendedHomeButtonInputProtectionEnabled(const NpadIdType& id) NN_NOEXCEPT;

/**
 * @brief       Npad の意図しないホームボタン入力を保護する機能の有効/無効を設定します。
 *
 * @details     Npad ID で指定した Npad に対して、
 *              意図しないホームボタン入力を無視する機能の有効/無効を設定します。
 *
 *              このホームボタン入力を保護する機能は、アプリケーションの特定のシーンなどで、
 *              ユーザーが意図しないホームボタン入力をしてしまうような場合に限り、
 *              ホームボタン入力を無視する目的で有効化することができます。
 *
 * @param[in]   id                      Npad ID
 * @param[in]   enable                  ホームボタンを有効にするか
 *
 */
void EnableUnintendedHomeButtonInputProtection(const NpadIdType& id, bool enable) NN_NOEXCEPT;

//! @}

}} // namespace nn::hid
