﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

// このファイルは SFDL による自動生成ファイルです。
// 手動で変更しないでください。
// This file is auto-generated by the SFDL code generator.
// Do not modify manually.

#include <cstdint>
#include <nn/applet/applet_FundamentalTypes.h>
#include <nn/hid/hid_ConsoleSixAxisSensor.h>
#include <nn/hid/hid_JoyXpad.h>
#include <nn/hid/hid_NpadCommonTypes.h>
#include <nn/hid/hid_PalmaTypes.h>
#include <nn/hid/hid_SixAxisSensor.h>
#include <nn/hid/hid_VibrationDeviceApi.h>
#include <nn/hid/hid_VibrationGcErm.h>
#include <nn/hid/hid_VibrationTypesForIpc.h>
#include <nn/hid/hid_VibrationValueTypes.h>
#include <nn/hid/hid_Xpad.h>
#include <nn/hid/system/hid_CommonTypes.h>
#include <nn/nn_Result.h>
#include <nn/sf/sf_NativeHandle.h>
#include <nn/sf/sf_Types.h>
#include <nn/sf/cmif/detail/sf_CmifAutogenInterfaceIncludes.h>
#include <nn/sf/detail/sf_AutogenInterfaceIncludes.h>
#include <nn/sf/impl/detail/sf_AutogenImplIncludes.h>

namespace nn { namespace hid { // NOLINT(whitespace/braces)

class IActiveVibrationDeviceList;

class IAppletResource;

class IHidServer;

NN_SF_DETAIL_DEFINE_SERVICE_INTERFACE(IActiveVibrationDeviceList, (::nn::sf::IServiceObject))

    NN_SF_DETAIL_SERVICE_INTERFACE_BEGIN_SYNC_METHOD(IActiveVibrationDeviceList)
        NN_SF_DETAIL_INTERNAL_INTERFACE_DEFINE_SYNC_METHOD_RESULT_N(ActivateVibrationDevice, (::nn::hid::VibrationDeviceHandle handle))
    NN_SF_DETAIL_SERVICE_INTERFACE_END_SYNC_METHOD

    NN_SF_DETAIL_SERVICE_INTERFACE_BEGIN_ACCESSOR(IActiveVibrationDeviceList)

        ::nn::Result ActivateVibrationDevice(::nn::hid::VibrationDeviceHandle handle) NN_NOEXCEPT
        {
            NN_SF_DETAIL_RETURN_INTERNAL_SYNC_METHOD_RESULT_N(ActivateVibrationDevice, (handle));
        }

    NN_SF_DETAIL_SERVICE_INTERFACE_END_ACCESSOR

NN_SF_DETAIL_DEFINE_SERVICE_INTERFACE_END

#if 0
    class IActiveVibrationDeviceList
    {
    public:
        nn::Result ActivateVibrationDevice(nn::hid::VibrationDeviceHandle handle) NN_NOEXCEPT;
    };
#endif

}}

#if 0

// Template for implementation users
class Impl
{
public:
    nn::Result ActivateVibrationDevice(nn::hid::VibrationDeviceHandle handle) NN_NOEXCEPT;
};

#endif

NN_SF_IMPL_DETAIL_DEFINE_IMPL_TEMPLATE_BASE((::nn::hid::IActiveVibrationDeviceList))

    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(ActivateVibrationDevice, (::nn::hid::VibrationDeviceHandle handle))
    {
        NN_SF_IMPL_DETAIL_RETURN_IMPL_METHOD_RESULT_N(ActivateVibrationDevice, (handle));
    }

NN_SF_IMPL_DETAIL_DEFINE_IMPL_TEMPLATE_BASE_END

// template <> struct nn::sf::cmif::detail::MethodInfos<nn::hid::IActiveVibrationDeviceList>
NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFOS((::nn::hid::IActiveVibrationDeviceList))

    // nn::Result ActivateVibrationDevice(nn::hid::VibrationDeviceHandle handle) NN_NOEXCEPT
    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO(ActivateVibrationDevice)

        NN_SF_CMIF_DETAIL_METHOD_INFO_METHOD_ID(0)
        NN_SF_CMIF_DETAIL_METHOD_INFO_RETURN_TYPE_IS_RESULT(true)

        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_MEMBER(handle, (::nn::hid::VibrationDeviceHandle), 0)
        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_END(1, (handle))
        NN_SF_CMIF_DETAIL_METHOD_INFO_IN_RAW_SIZE(4)

        NN_SF_CMIF_DETAIL_METHOD_INFO_ARGUMENT_INFOS((NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(handle)))

    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO_END(ActivateVibrationDevice)

    NN_SF_CMIF_DETAIL_METHOD_INFO_REFERRED_STRUCT_ASSERTION_CHECK((::nn::hid::VibrationDeviceHandle), 4, 4)

NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFOS_END

// template <...> class nn::sf::client::detail::CmifProxy<nn::hid::IActiveVibrationDeviceList, ...>
NN_SF_CMIF_CLIENT_DETAIL_DEFINE_PROXY((::nn::hid::IActiveVibrationDeviceList))

    // nn::Result ActivateVibrationDevice(nn::hid::VibrationDeviceHandle handle) NN_NOEXCEPT
    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(ActivateVibrationDevice, (::nn::hid::VibrationDeviceHandle handle))
    {
        NN_SF_CMIF_CLIENT_DETAIL_CALL_BEGIN(ActivateVibrationDevice)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(handle)
        NN_SF_CMIF_CLIENT_DETAIL_CALL_END(ActivateVibrationDevice)
    }

NN_SF_CMIF_CLIENT_DETAIL_DEFINE_PROXY_END

// template <> class nn::sf::server::detail::CmifProcessFunctionTableGetterImpl<nn::hid::IActiveVibrationDeviceList>
NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCHER((::nn::hid::IActiveVibrationDeviceList))

    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD(ActivateVibrationDevice)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE(ActivateVibrationDevice)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(handle)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE_END
    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_END

    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE_CASE(ActivateVibrationDevice)
    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE_END

NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCHER_END

NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCHER_FUNCTION_TABLE((::nn::hid::IActiveVibrationDeviceList))

namespace nn { namespace hid { // NOLINT(whitespace/braces)

NN_SF_DETAIL_DEFINE_SERVICE_INTERFACE(IAppletResource, (::nn::sf::IServiceObject))

    NN_SF_DETAIL_SERVICE_INTERFACE_BEGIN_SYNC_METHOD(IAppletResource)
        NN_SF_DETAIL_INTERNAL_INTERFACE_DEFINE_SYNC_METHOD_RESULT_N(GetSharedMemoryHandle, (::nn::sf::Out<::nn::sf::NativeHandle> outValue))
    NN_SF_DETAIL_SERVICE_INTERFACE_END_SYNC_METHOD

    NN_SF_DETAIL_SERVICE_INTERFACE_BEGIN_ACCESSOR(IAppletResource)

        ::nn::Result GetSharedMemoryHandle(::nn::sf::Out<::nn::sf::NativeHandle> outValue) NN_NOEXCEPT
        {
            NN_SF_DETAIL_RETURN_INTERNAL_SYNC_METHOD_RESULT_N(GetSharedMemoryHandle, (outValue));
        }

    NN_SF_DETAIL_SERVICE_INTERFACE_END_ACCESSOR

NN_SF_DETAIL_DEFINE_SERVICE_INTERFACE_END

#if 0
    class IAppletResource
    {
    public:
        nn::Result GetSharedMemoryHandle(nn::sf::Out<nn::sf::NativeHandle> outValue) NN_NOEXCEPT;
    };
#endif

}}

#if 0

// Template for implementation users
class Impl
{
public:
    nn::Result GetSharedMemoryHandle(nn::sf::Out<nn::sf::NativeHandle> outValue) NN_NOEXCEPT;
};

#endif

NN_SF_IMPL_DETAIL_DEFINE_IMPL_TEMPLATE_BASE((::nn::hid::IAppletResource))

    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(GetSharedMemoryHandle, (::nn::sf::Out<::nn::sf::NativeHandle> outValue))
    {
        NN_SF_IMPL_DETAIL_RETURN_IMPL_METHOD_RESULT_N(GetSharedMemoryHandle, (outValue));
    }

NN_SF_IMPL_DETAIL_DEFINE_IMPL_TEMPLATE_BASE_END

// template <> struct nn::sf::cmif::detail::MethodInfos<nn::hid::IAppletResource>
NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFOS((::nn::hid::IAppletResource))

    // nn::Result GetSharedMemoryHandle(nn::sf::Out<nn::sf::NativeHandle> outValue) NN_NOEXCEPT
    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO(GetSharedMemoryHandle)

        NN_SF_CMIF_DETAIL_METHOD_INFO_METHOD_ID(0)
        NN_SF_CMIF_DETAIL_METHOD_INFO_RETURN_TYPE_IS_RESULT(true)

        NN_SF_CMIF_DETAIL_METHOD_INFO_OUT_NATIVE_HANDLE_COUNT(1)
        NN_SF_CMIF_DETAIL_METHOD_INFO_OUT_NATIVE_HANDLE_INFOS
            NN_SF_CMIF_DETAIL_METHOD_INFO_OUT_NATIVE_HANDLE_INFO(outValue, 0, NN_SF_CMIF_DETAIL_NATIVE_HANDLE_ATTRIBUTE_HIPC_COPY)
        NN_SF_CMIF_DETAIL_METHOD_INFO_OUT_NATIVE_HANDLE_INFOS_END(1, (outValue))

        NN_SF_CMIF_DETAIL_METHOD_INFO_ARGUMENT_INFOS((NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(outValue)))

    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO_END(GetSharedMemoryHandle)

NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFOS_END

// template <...> class nn::sf::client::detail::CmifProxy<nn::hid::IAppletResource, ...>
NN_SF_CMIF_CLIENT_DETAIL_DEFINE_PROXY((::nn::hid::IAppletResource))

    // nn::Result GetSharedMemoryHandle(nn::sf::Out<nn::sf::NativeHandle> outValue) NN_NOEXCEPT
    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(GetSharedMemoryHandle, (::nn::sf::Out<::nn::sf::NativeHandle> outValue))
    {
        NN_SF_CMIF_CLIENT_DETAIL_CALL_BEGIN(GetSharedMemoryHandle)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(outValue)
        NN_SF_CMIF_CLIENT_DETAIL_CALL_END(GetSharedMemoryHandle)
    }

NN_SF_CMIF_CLIENT_DETAIL_DEFINE_PROXY_END

// template <> class nn::sf::server::detail::CmifProcessFunctionTableGetterImpl<nn::hid::IAppletResource>
NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCHER((::nn::hid::IAppletResource))

    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD(GetSharedMemoryHandle)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_OUT_NATIVE_HANDLES
                NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_OUT_NATIVE_HANDLE(outValue)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_OUT_NATIVE_HANDLES_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE(GetSharedMemoryHandle)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_OUT_NATIVE_HANDLE(outValue)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE_END
    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_END

    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE_CASE(GetSharedMemoryHandle)
    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE_END

NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCHER_END

NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCHER_FUNCTION_TABLE((::nn::hid::IAppletResource))

namespace nn { namespace hid { // NOLINT(whitespace/braces)

NN_SF_DETAIL_DEFINE_SERVICE_INTERFACE(IHidServer, (::nn::sf::IServiceObject))

    NN_SF_DETAIL_SERVICE_INTERFACE_BEGIN_SYNC_METHOD(IHidServer)
        NN_SF_DETAIL_INTERNAL_INTERFACE_DEFINE_SYNC_METHOD_RESULT_N(CreateAppletResource, (::nn::sf::Out<::nn::sf::SharedPointer<::nn::hid::IAppletResource>> outValue, ::nn::applet::AppletResourceUserId aruid))
        NN_SF_DETAIL_INTERNAL_INTERFACE_DEFINE_SYNC_METHOD_RESULT_N(ActivateDebugPad, (::nn::applet::AppletResourceUserId aruid))
        NN_SF_DETAIL_INTERNAL_INTERFACE_DEFINE_SYNC_METHOD_RESULT_N(ActivateTouchScreen, (::nn::applet::AppletResourceUserId aruid))
        NN_SF_DETAIL_INTERNAL_INTERFACE_DEFINE_SYNC_METHOD_RESULT_N(ActivateMouse, (::nn::applet::AppletResourceUserId aruid))
        NN_SF_DETAIL_INTERNAL_INTERFACE_DEFINE_SYNC_METHOD_RESULT_N(ActivateKeyboard, (::nn::applet::AppletResourceUserId aruid))
        NN_SF_DETAIL_INTERNAL_INTERFACE_DEFINE_SYNC_METHOD_RESULT_N(AcquireXpadIdEventHandle, (::nn::sf::Out<::nn::sf::NativeHandle> outValue, ::std::uint64_t clientId))
        NN_SF_DETAIL_INTERNAL_INTERFACE_DEFINE_SYNC_METHOD_RESULT_N(ReleaseXpadIdEventHandle, (::std::uint64_t clientId))
        NN_SF_DETAIL_INTERNAL_INTERFACE_DEFINE_SYNC_METHOD_RESULT_N(ActivateXpad, (::nn::applet::AppletResourceUserId aruid, ::nn::hid::BasicXpadId xpadId))
        NN_SF_DETAIL_INTERNAL_INTERFACE_DEFINE_SYNC_METHOD_RESULT_N(GetXpadIds, (::nn::sf::Out<::std::int64_t> outCount, const ::nn::sf::OutArray<::nn::hid::BasicXpadId>& outXpadIds))
        NN_SF_DETAIL_INTERNAL_INTERFACE_DEFINE_SYNC_METHOD_RESULT_N(ActivateJoyXpad, (::nn::hid::JoyXpadId xpadId))
        NN_SF_DETAIL_INTERNAL_INTERFACE_DEFINE_SYNC_METHOD_RESULT_N(GetJoyXpadLifoHandle, (::nn::sf::Out<::nn::sf::NativeHandle> outValue, ::nn::hid::JoyXpadId xpadId))
        NN_SF_DETAIL_INTERNAL_INTERFACE_DEFINE_SYNC_METHOD_RESULT_N(GetJoyXpadIds, (::nn::sf::Out<::std::int64_t> outGotCount, const ::nn::sf::OutArray<::nn::hid::JoyXpadId>& outXpadIds))
        NN_SF_DETAIL_INTERNAL_INTERFACE_DEFINE_SYNC_METHOD_RESULT_N(ActivateSixAxisSensor, (::nn::hid::BasicXpadId xpadId))
        NN_SF_DETAIL_INTERNAL_INTERFACE_DEFINE_SYNC_METHOD_RESULT_N(DeactivateSixAxisSensor, (::nn::hid::BasicXpadId xpadId))
        NN_SF_DETAIL_INTERNAL_INTERFACE_DEFINE_SYNC_METHOD_RESULT_N(GetSixAxisSensorLifoHandle, (::nn::sf::Out<::nn::sf::NativeHandle> outValue, ::nn::hid::BasicXpadId xpadId))
        NN_SF_DETAIL_INTERNAL_INTERFACE_DEFINE_SYNC_METHOD_RESULT_N(ActivateJoySixAxisSensor, (::nn::hid::JoyXpadId xpadId))
        NN_SF_DETAIL_INTERNAL_INTERFACE_DEFINE_SYNC_METHOD_RESULT_N(DeactivateJoySixAxisSensor, (::nn::hid::JoyXpadId xpadId))
        NN_SF_DETAIL_INTERNAL_INTERFACE_DEFINE_SYNC_METHOD_RESULT_N(GetJoySixAxisSensorLifoHandle, (::nn::sf::Out<::nn::sf::NativeHandle> outValue, ::nn::hid::JoyXpadId xpadId))
        NN_SF_DETAIL_INTERNAL_INTERFACE_DEFINE_SYNC_METHOD_RESULT_N(StartSixAxisSensor, (::nn::applet::AppletResourceUserId aruid, ::nn::hid::SixAxisSensorHandle handle))
        NN_SF_DETAIL_INTERNAL_INTERFACE_DEFINE_SYNC_METHOD_RESULT_N(StopSixAxisSensor, (::nn::applet::AppletResourceUserId aruid, ::nn::hid::SixAxisSensorHandle handle))
        NN_SF_DETAIL_INTERNAL_INTERFACE_DEFINE_SYNC_METHOD_RESULT_N(IsSixAxisSensorFusionEnabled, (::nn::sf::Out<bool> outIsEnabled, ::nn::applet::AppletResourceUserId aruid, ::nn::hid::SixAxisSensorHandle handle))
        NN_SF_DETAIL_INTERNAL_INTERFACE_DEFINE_SYNC_METHOD_RESULT_N(EnableSixAxisSensorFusion, (::nn::applet::AppletResourceUserId aruid, ::nn::hid::SixAxisSensorHandle handle, bool enable))
        NN_SF_DETAIL_INTERNAL_INTERFACE_DEFINE_SYNC_METHOD_RESULT_N(SetSixAxisSensorFusionParameters, (::nn::applet::AppletResourceUserId aruid, ::nn::hid::SixAxisSensorHandle handle, float revisePower, float reviseRange))
        NN_SF_DETAIL_INTERNAL_INTERFACE_DEFINE_SYNC_METHOD_RESULT_N(GetSixAxisSensorFusionParameters, (::nn::sf::Out<float> outRevisePower, ::nn::sf::Out<float> outReviseRange, ::nn::applet::AppletResourceUserId aruid, ::nn::hid::SixAxisSensorHandle handle))
        NN_SF_DETAIL_INTERNAL_INTERFACE_DEFINE_SYNC_METHOD_RESULT_N(ResetSixAxisSensorFusionParameters, (::nn::applet::AppletResourceUserId aruid, ::nn::hid::SixAxisSensorHandle handle))
        NN_SF_DETAIL_INTERNAL_INTERFACE_DEFINE_SYNC_METHOD_RESULT_N(SetAccelerometerParameters, (::nn::applet::AppletResourceUserId aruid, ::nn::hid::SixAxisSensorHandle handle, float playRadius, float sensitivity))
        NN_SF_DETAIL_INTERNAL_INTERFACE_DEFINE_SYNC_METHOD_RESULT_N(GetAccelerometerParameters, (::nn::sf::Out<float> outPlayRadius, ::nn::sf::Out<float> outSensitivity, ::nn::applet::AppletResourceUserId aruid, ::nn::hid::SixAxisSensorHandle handle))
        NN_SF_DETAIL_INTERNAL_INTERFACE_DEFINE_SYNC_METHOD_RESULT_N(ResetAccelerometerParameters, (::nn::applet::AppletResourceUserId aruid, ::nn::hid::SixAxisSensorHandle handle))
        NN_SF_DETAIL_INTERNAL_INTERFACE_DEFINE_SYNC_METHOD_RESULT_N(SetAccelerometerPlayMode, (::nn::applet::AppletResourceUserId aruid, ::nn::hid::SixAxisSensorHandle handle, ::std::uint32_t mode))
        NN_SF_DETAIL_INTERNAL_INTERFACE_DEFINE_SYNC_METHOD_RESULT_N(GetAccelerometerPlayMode, (::nn::sf::Out<::std::uint32_t> outMode, ::nn::applet::AppletResourceUserId aruid, ::nn::hid::SixAxisSensorHandle handle))
        NN_SF_DETAIL_INTERNAL_INTERFACE_DEFINE_SYNC_METHOD_RESULT_N(ResetAccelerometerPlayMode, (::nn::applet::AppletResourceUserId aruid, ::nn::hid::SixAxisSensorHandle handle))
        NN_SF_DETAIL_INTERNAL_INTERFACE_DEFINE_SYNC_METHOD_RESULT_N(SetGyroscopeZeroDriftMode, (::nn::applet::AppletResourceUserId aruid, ::nn::hid::SixAxisSensorHandle handle, ::std::uint32_t mode))
        NN_SF_DETAIL_INTERNAL_INTERFACE_DEFINE_SYNC_METHOD_RESULT_N(GetGyroscopeZeroDriftMode, (::nn::sf::Out<::std::uint32_t> outMode, ::nn::applet::AppletResourceUserId aruid, ::nn::hid::SixAxisSensorHandle handle))
        NN_SF_DETAIL_INTERNAL_INTERFACE_DEFINE_SYNC_METHOD_RESULT_N(ResetGyroscopeZeroDriftMode, (::nn::applet::AppletResourceUserId aruid, ::nn::hid::SixAxisSensorHandle handle))
        NN_SF_DETAIL_INTERNAL_INTERFACE_DEFINE_SYNC_METHOD_RESULT_N(IsSixAxisSensorAtRest, (::nn::sf::Out<bool> outIsAtRest, ::nn::applet::AppletResourceUserId aruid, ::nn::hid::SixAxisSensorHandle handle))
        NN_SF_DETAIL_INTERNAL_INTERFACE_DEFINE_SYNC_METHOD_RESULT_N(ActivateGesture, (::nn::applet::AppletResourceUserId aruid, ::std::int32_t version))
        NN_SF_DETAIL_INTERNAL_INTERFACE_DEFINE_SYNC_METHOD_RESULT_N(SetSupportedNpadStyleSet, (::nn::applet::AppletResourceUserId aruid, ::nn::hid::NpadStyleSet style))
        NN_SF_DETAIL_INTERNAL_INTERFACE_DEFINE_SYNC_METHOD_RESULT_N(GetSupportedNpadStyleSet, (::nn::applet::AppletResourceUserId aruid, ::nn::sf::Out<::nn::hid::NpadStyleSet> outValue))
        NN_SF_DETAIL_INTERNAL_INTERFACE_DEFINE_SYNC_METHOD_RESULT_N(SetSupportedNpadIdType, (::nn::applet::AppletResourceUserId aruid, const ::nn::sf::InArray<::nn::hid::NpadIdType>& ids))
        NN_SF_DETAIL_INTERNAL_INTERFACE_DEFINE_SYNC_METHOD_RESULT_N(ActivateNpad, (::nn::applet::AppletResourceUserId aruid))
        NN_SF_DETAIL_INTERNAL_INTERFACE_DEFINE_SYNC_METHOD_RESULT_N(DeactivateNpad, (::nn::applet::AppletResourceUserId aruid))
        NN_SF_DETAIL_INTERNAL_INTERFACE_DEFINE_SYNC_METHOD_RESULT_N(AcquireNpadStyleSetUpdateEventHandle, (::nn::applet::AppletResourceUserId aruid, ::nn::sf::Out<::nn::sf::NativeHandle> outValue, ::nn::hid::NpadIdType id, ::std::uint64_t clientId))
        NN_SF_DETAIL_INTERNAL_INTERFACE_DEFINE_SYNC_METHOD_RESULT_N(DisconnectNpad, (::nn::applet::AppletResourceUserId aruid, ::nn::hid::NpadIdType id))
        NN_SF_DETAIL_INTERNAL_INTERFACE_DEFINE_SYNC_METHOD_RESULT_N(GetPlayerLedPattern, (::nn::sf::Out<::std::uint64_t> outValue, ::nn::hid::NpadIdType id))
        NN_SF_DETAIL_INTERNAL_INTERFACE_DEFINE_SYNC_METHOD_RESULT_N(ActivateNpadWithRevision, (::nn::applet::AppletResourceUserId aruid, ::std::int32_t revision))
        NN_SF_DETAIL_INTERNAL_INTERFACE_DEFINE_SYNC_METHOD_RESULT_N(SetNpadJoyHoldType, (::nn::applet::AppletResourceUserId aruid, ::std::int64_t holdType))
        NN_SF_DETAIL_INTERNAL_INTERFACE_DEFINE_SYNC_METHOD_RESULT_N(GetNpadJoyHoldType, (::nn::applet::AppletResourceUserId aruid, ::nn::sf::Out<::std::int64_t> outValue))
        NN_SF_DETAIL_INTERNAL_INTERFACE_DEFINE_SYNC_METHOD_RESULT_N(SetNpadJoyAssignmentModeSingleByDefault, (::nn::applet::AppletResourceUserId aruid, ::nn::hid::NpadIdType id))
        NN_SF_DETAIL_INTERNAL_INTERFACE_DEFINE_SYNC_METHOD_RESULT_N(SetNpadJoyAssignmentModeSingle, (::nn::applet::AppletResourceUserId aruid, ::nn::hid::NpadIdType id, ::std::int64_t type))
        NN_SF_DETAIL_INTERNAL_INTERFACE_DEFINE_SYNC_METHOD_RESULT_N(SetNpadJoyAssignmentModeDual, (::nn::applet::AppletResourceUserId aruid, ::nn::hid::NpadIdType id))
        NN_SF_DETAIL_INTERNAL_INTERFACE_DEFINE_SYNC_METHOD_RESULT_N(MergeSingleJoyAsDualJoy, (::nn::applet::AppletResourceUserId aruid, ::nn::hid::NpadIdType id1, ::nn::hid::NpadIdType id2))
        NN_SF_DETAIL_INTERNAL_INTERFACE_DEFINE_SYNC_METHOD_RESULT_N(StartLrAssignmentMode, (::nn::applet::AppletResourceUserId aruid))
        NN_SF_DETAIL_INTERNAL_INTERFACE_DEFINE_SYNC_METHOD_RESULT_N(StopLrAssignmentMode, (::nn::applet::AppletResourceUserId aruid))
        NN_SF_DETAIL_INTERNAL_INTERFACE_DEFINE_SYNC_METHOD_RESULT_N(SetNpadHandheldActivationMode, (::nn::applet::AppletResourceUserId aruid, ::std::int64_t mode))
        NN_SF_DETAIL_INTERNAL_INTERFACE_DEFINE_SYNC_METHOD_RESULT_N(GetNpadHandheldActivationMode, (::nn::applet::AppletResourceUserId aruid, ::nn::sf::Out<::std::int64_t> outValue))
        NN_SF_DETAIL_INTERNAL_INTERFACE_DEFINE_SYNC_METHOD_RESULT_N(SwapNpadAssignment, (::nn::applet::AppletResourceUserId aruid, ::nn::hid::NpadIdType id1, ::nn::hid::NpadIdType id2))
        NN_SF_DETAIL_INTERNAL_INTERFACE_DEFINE_SYNC_METHOD_RESULT_N(IsUnintendedHomeButtonInputProtectionEnabled, (::nn::sf::Out<bool> outIsEnabled, ::nn::applet::AppletResourceUserId aruid, ::nn::hid::NpadIdType id))
        NN_SF_DETAIL_INTERNAL_INTERFACE_DEFINE_SYNC_METHOD_RESULT_N(EnableUnintendedHomeButtonInputProtection, (::nn::applet::AppletResourceUserId aruid, ::nn::hid::NpadIdType id, bool enabled))
        NN_SF_DETAIL_INTERNAL_INTERFACE_DEFINE_SYNC_METHOD_RESULT_N(SetNpadJoyAssignmentModeSingleWithDestination, (::nn::sf::Out<bool> outIsAssigned, ::nn::sf::Out<::nn::hid::NpadIdType> outId, ::nn::applet::AppletResourceUserId aruid, ::nn::hid::NpadIdType id, ::std::int64_t type))
        NN_SF_DETAIL_INTERNAL_INTERFACE_DEFINE_SYNC_METHOD_RESULT_N(GetVibrationDeviceInfo, (::nn::sf::Out<::nn::hid::VibrationDeviceInfoForIpc> outValue, ::nn::hid::VibrationDeviceHandle handle))
        NN_SF_DETAIL_INTERNAL_INTERFACE_DEFINE_SYNC_METHOD_RESULT_N(SendVibrationValue, (::nn::applet::AppletResourceUserId aruid, ::nn::hid::VibrationDeviceHandle handle, const ::nn::hid::VibrationValue& value))
        NN_SF_DETAIL_INTERNAL_INTERFACE_DEFINE_SYNC_METHOD_RESULT_N(GetActualVibrationValue, (::nn::sf::Out<::nn::hid::VibrationValue> outValue, ::nn::applet::AppletResourceUserId aruid, ::nn::hid::VibrationDeviceHandle handle))
        NN_SF_DETAIL_INTERNAL_INTERFACE_DEFINE_SYNC_METHOD_RESULT_N(CreateActiveVibrationDeviceList, (::nn::sf::Out<::nn::sf::SharedPointer<::nn::hid::IActiveVibrationDeviceList>> outValue))
        NN_SF_DETAIL_INTERNAL_INTERFACE_DEFINE_SYNC_METHOD_RESULT_N(PermitVibration, (bool isPermitted))
        NN_SF_DETAIL_INTERNAL_INTERFACE_DEFINE_SYNC_METHOD_RESULT_N(IsVibrationPermitted, (::nn::sf::Out<bool> outValue))
        NN_SF_DETAIL_INTERNAL_INTERFACE_DEFINE_SYNC_METHOD_RESULT_N(SendVibrationValues, (::nn::applet::AppletResourceUserId aruid, const ::nn::sf::InArray<::nn::hid::VibrationDeviceHandle>& handles, const ::nn::sf::InArray<::nn::hid::VibrationValue>& values))
        NN_SF_DETAIL_INTERNAL_INTERFACE_DEFINE_SYNC_METHOD_RESULT_N(SendVibrationGcErmCommand, (::nn::applet::AppletResourceUserId aruid, ::nn::hid::VibrationDeviceHandle handle, ::nn::hid::VibrationGcErmCommand command))
        NN_SF_DETAIL_INTERNAL_INTERFACE_DEFINE_SYNC_METHOD_RESULT_N(GetActualVibrationGcErmCommand, (::nn::sf::Out<::nn::hid::VibrationGcErmCommand> outValue, ::nn::applet::AppletResourceUserId aruid, ::nn::hid::VibrationDeviceHandle handle))
        NN_SF_DETAIL_INTERNAL_INTERFACE_DEFINE_SYNC_METHOD_RESULT_N(BeginPermitVibrationSession, (::nn::applet::AppletResourceUserId aruid))
        NN_SF_DETAIL_INTERNAL_INTERFACE_DEFINE_SYNC_METHOD_RESULT_0(EndPermitVibrationSession)
        NN_SF_DETAIL_INTERNAL_INTERFACE_DEFINE_SYNC_METHOD_RESULT_N(ActivateConsoleSixAxisSensor, (::nn::applet::AppletResourceUserId aruid))
        NN_SF_DETAIL_INTERNAL_INTERFACE_DEFINE_SYNC_METHOD_RESULT_N(StartConsoleSixAxisSensor, (::nn::applet::AppletResourceUserId aruid, ::nn::hid::ConsoleSixAxisSensorHandle handle))
        NN_SF_DETAIL_INTERNAL_INTERFACE_DEFINE_SYNC_METHOD_RESULT_N(StopConsoleSixAxisSensor, (::nn::applet::AppletResourceUserId aruid, ::nn::hid::ConsoleSixAxisSensorHandle handle))
        NN_SF_DETAIL_INTERNAL_INTERFACE_DEFINE_SYNC_METHOD_RESULT_N(ActivateSevenSixAxisSensor, (::nn::applet::AppletResourceUserId aruid))
        NN_SF_DETAIL_INTERNAL_INTERFACE_DEFINE_SYNC_METHOD_RESULT_N(StartSevenSixAxisSensor, (::nn::applet::AppletResourceUserId aruid))
        NN_SF_DETAIL_INTERNAL_INTERFACE_DEFINE_SYNC_METHOD_RESULT_N(StopSevenSixAxisSensor, (::nn::applet::AppletResourceUserId aruid))
        NN_SF_DETAIL_INTERNAL_INTERFACE_DEFINE_SYNC_METHOD_RESULT_N(InitializeSevenSixAxisSensor, (::nn::applet::AppletResourceUserId aruid, ::nn::sf::NativeHandle&& stateBufferHandle, ::std::uint64_t stateBufferSize, ::nn::sf::NativeHandle&& workBufferHandle, ::std::uint64_t workBufferSize))
        NN_SF_DETAIL_INTERNAL_INTERFACE_DEFINE_SYNC_METHOD_RESULT_N(FinalizeSevenSixAxisSensor, (::nn::applet::AppletResourceUserId aruid))
        NN_SF_DETAIL_INTERNAL_INTERFACE_DEFINE_SYNC_METHOD_RESULT_N(SetSevenSixAxisSensorFusionStrength, (::nn::applet::AppletResourceUserId aruid, float strength))
        NN_SF_DETAIL_INTERNAL_INTERFACE_DEFINE_SYNC_METHOD_RESULT_N(GetSevenSixAxisSensorFusionStrength, (::nn::sf::Out<float> strength, ::nn::applet::AppletResourceUserId aruid))
        NN_SF_DETAIL_INTERNAL_INTERFACE_DEFINE_SYNC_METHOD_RESULT_N(IsUsbFullKeyControllerEnabled, (::nn::sf::Out<bool> outIsEnabled))
        NN_SF_DETAIL_INTERNAL_INTERFACE_DEFINE_SYNC_METHOD_RESULT_N(EnableUsbFullKeyController, (bool enabled))
        NN_SF_DETAIL_INTERNAL_INTERFACE_DEFINE_SYNC_METHOD_RESULT_N(IsUsbFullKeyControllerConnected, (::nn::sf::Out<bool> outIsConnected, ::nn::hid::NpadIdType id))
        NN_SF_DETAIL_INTERNAL_INTERFACE_DEFINE_SYNC_METHOD_RESULT_N(HasBattery, (::nn::sf::Out<bool> outHasBattery, ::nn::hid::NpadIdType id))
        NN_SF_DETAIL_INTERNAL_INTERFACE_DEFINE_SYNC_METHOD_RESULT_N(HasLeftRightBattery, (::nn::sf::Out<bool> outLeftJoyHasBattery, ::nn::sf::Out<bool> outRightJoyHasBattery, ::nn::hid::NpadIdType id))
        NN_SF_DETAIL_INTERNAL_INTERFACE_DEFINE_SYNC_METHOD_RESULT_N(GetNpadInterfaceType, (::nn::sf::Out<::nn::hid::system::InterfaceType> outInterfaceType, ::nn::hid::NpadIdType id))
        NN_SF_DETAIL_INTERNAL_INTERFACE_DEFINE_SYNC_METHOD_RESULT_N(GetNpadLeftRightInterfaceType, (::nn::sf::Out<::nn::hid::system::InterfaceType> outLeftJoyInterfaceType, ::nn::sf::Out<::nn::hid::system::InterfaceType> outRightJoyInterfaceType, ::nn::hid::NpadIdType id))
        NN_SF_DETAIL_INTERNAL_INTERFACE_DEFINE_SYNC_METHOD_RESULT_N(GetPalmaConnectionHandle, (::nn::sf::Out<::nn::hid::PalmaConnectionHandle> outHandle, ::nn::hid::NpadIdType id, ::nn::applet::AppletResourceUserId aruid))
        NN_SF_DETAIL_INTERNAL_INTERFACE_DEFINE_SYNC_METHOD_RESULT_N(InitializePalma, (::nn::hid::PalmaConnectionHandle handle))
        NN_SF_DETAIL_INTERNAL_INTERFACE_DEFINE_SYNC_METHOD_RESULT_N(AcquirePalmaOperationCompleteEvent, (::nn::sf::Out<::nn::sf::NativeHandle> outValue, ::nn::hid::PalmaConnectionHandle handle))
        NN_SF_DETAIL_INTERNAL_INTERFACE_DEFINE_SYNC_METHOD_RESULT_N(GetPalmaOperationInfo, (::nn::sf::Out<::std::uint64_t> outType, const ::nn::sf::OutBuffer& outBuffer, ::nn::hid::PalmaConnectionHandle handle))
        NN_SF_DETAIL_INTERNAL_INTERFACE_DEFINE_SYNC_METHOD_RESULT_N(PlayPalmaActivity, (::nn::hid::PalmaConnectionHandle handle, ::std::uint64_t index))
        NN_SF_DETAIL_INTERNAL_INTERFACE_DEFINE_SYNC_METHOD_RESULT_N(SetPalmaFrModeType, (::nn::hid::PalmaConnectionHandle handle, ::std::uint64_t type))
        NN_SF_DETAIL_INTERNAL_INTERFACE_DEFINE_SYNC_METHOD_RESULT_N(ReadPalmaStep, (::nn::hid::PalmaConnectionHandle handle))
        NN_SF_DETAIL_INTERNAL_INTERFACE_DEFINE_SYNC_METHOD_RESULT_N(EnablePalmaStep, (::nn::hid::PalmaConnectionHandle handle, bool isEnabled))
        NN_SF_DETAIL_INTERNAL_INTERFACE_DEFINE_SYNC_METHOD_RESULT_N(ResetPalmaStep, (::nn::hid::PalmaConnectionHandle handle))
        NN_SF_DETAIL_INTERNAL_INTERFACE_DEFINE_SYNC_METHOD_RESULT_N(ReadPalmaApplicationSection, (::nn::hid::PalmaConnectionHandle handle, ::std::uint64_t address, ::std::uint64_t size))
        NN_SF_DETAIL_INTERNAL_INTERFACE_DEFINE_SYNC_METHOD_RESULT_N(WritePalmaApplicationSection, (::nn::hid::PalmaConnectionHandle handle, ::std::uint64_t address, ::std::uint64_t size, const ::nn::hid::PalmaApplicationSectionAccessBuffer& buffer))
        NN_SF_DETAIL_INTERNAL_INTERFACE_DEFINE_SYNC_METHOD_RESULT_N(ReadPalmaUniqueCode, (::nn::hid::PalmaConnectionHandle handle))
        NN_SF_DETAIL_INTERNAL_INTERFACE_DEFINE_SYNC_METHOD_RESULT_N(SetPalmaUniqueCodeInvalid, (::nn::hid::PalmaConnectionHandle handle))
        NN_SF_DETAIL_INTERNAL_INTERFACE_DEFINE_SYNC_METHOD_RESULT_N(WritePalmaActivityEntry, (::nn::hid::PalmaConnectionHandle handle, ::std::uint64_t index, ::std::uint64_t ledIndex, ::std::uint64_t waveSet, ::std::uint64_t waveIndex))
        NN_SF_DETAIL_INTERNAL_INTERFACE_DEFINE_SYNC_METHOD_RESULT_N(WritePalmaRgbLedPatternEntry, (::nn::hid::PalmaConnectionHandle handle, ::std::uint64_t index, const ::nn::sf::InBuffer& pInBuffer))
        NN_SF_DETAIL_INTERNAL_INTERFACE_DEFINE_SYNC_METHOD_RESULT_N(WritePalmaWaveEntry, (::nn::hid::PalmaConnectionHandle handle, ::std::uint64_t waveSet, ::std::uint64_t index, ::nn::sf::NativeHandle&& transferMemoryHandle, ::std::uint64_t transferMemorySize, ::std::uint64_t waveDataSize))
        NN_SF_DETAIL_INTERNAL_INTERFACE_DEFINE_SYNC_METHOD_RESULT_N(SetPalmaDataBaseIdentificationVersion, (::nn::hid::PalmaConnectionHandle handle, ::std::int32_t version))
        NN_SF_DETAIL_INTERNAL_INTERFACE_DEFINE_SYNC_METHOD_RESULT_N(GetPalmaDataBaseIdentificationVersion, (::nn::hid::PalmaConnectionHandle handle))
        NN_SF_DETAIL_INTERNAL_INTERFACE_DEFINE_SYNC_METHOD_RESULT_N(SuspendPalmaFeature, (::nn::hid::PalmaConnectionHandle handle, ::nn::hid::PalmaFeatureSet suspendFeatureSet))
        NN_SF_DETAIL_INTERNAL_INTERFACE_DEFINE_SYNC_METHOD_RESULT_N(GetPalmaOperationResult, (::nn::hid::PalmaConnectionHandle handle))
        NN_SF_DETAIL_INTERNAL_INTERFACE_DEFINE_SYNC_METHOD_RESULT_N(ReadPalmaPlayLog, (::nn::hid::PalmaConnectionHandle handle, ::std::uint16_t index))
        NN_SF_DETAIL_INTERNAL_INTERFACE_DEFINE_SYNC_METHOD_RESULT_N(ResetPalmaPlayLog, (::nn::hid::PalmaConnectionHandle handle, ::std::uint16_t index))
        NN_SF_DETAIL_INTERNAL_INTERFACE_DEFINE_SYNC_METHOD_RESULT_N(SetIsPalmaAllConnectable, (::nn::applet::AppletResourceUserId aruid, bool connectable))
        NN_SF_DETAIL_INTERNAL_INTERFACE_DEFINE_SYNC_METHOD_RESULT_N(SetIsPalmaPairedConnectable, (::nn::applet::AppletResourceUserId aruid, bool connectable))
        NN_SF_DETAIL_INTERNAL_INTERFACE_DEFINE_SYNC_METHOD_RESULT_N(PairPalma, (::nn::hid::PalmaConnectionHandle handle))
        NN_SF_DETAIL_INTERNAL_INTERFACE_DEFINE_SYNC_METHOD_RESULT_N(SetPalmaBoostMode, (bool enabled))
        NN_SF_DETAIL_INTERNAL_INTERFACE_DEFINE_SYNC_METHOD_RESULT_N(SetNpadCommunicationMode, (::nn::applet::AppletResourceUserId aruid, ::std::int64_t mode))
        NN_SF_DETAIL_INTERNAL_INTERFACE_DEFINE_SYNC_METHOD_RESULT_N(GetNpadCommunicationMode, (::nn::sf::Out<::std::int64_t> outValue))
    NN_SF_DETAIL_SERVICE_INTERFACE_END_SYNC_METHOD

    NN_SF_DETAIL_SERVICE_INTERFACE_BEGIN_ACCESSOR(IHidServer)

        ::nn::Result CreateAppletResource(::nn::sf::Out<::nn::sf::SharedPointer<::nn::hid::IAppletResource>> outValue, ::nn::applet::AppletResourceUserId aruid) NN_NOEXCEPT
        {
            NN_SF_DETAIL_RETURN_INTERNAL_SYNC_METHOD_RESULT_N(CreateAppletResource, (outValue, aruid));
        }

        ::nn::Result ActivateDebugPad(::nn::applet::AppletResourceUserId aruid) NN_NOEXCEPT
        {
            NN_SF_DETAIL_RETURN_INTERNAL_SYNC_METHOD_RESULT_N(ActivateDebugPad, (aruid));
        }

        ::nn::Result ActivateTouchScreen(::nn::applet::AppletResourceUserId aruid) NN_NOEXCEPT
        {
            NN_SF_DETAIL_RETURN_INTERNAL_SYNC_METHOD_RESULT_N(ActivateTouchScreen, (aruid));
        }

        ::nn::Result ActivateMouse(::nn::applet::AppletResourceUserId aruid) NN_NOEXCEPT
        {
            NN_SF_DETAIL_RETURN_INTERNAL_SYNC_METHOD_RESULT_N(ActivateMouse, (aruid));
        }

        ::nn::Result ActivateKeyboard(::nn::applet::AppletResourceUserId aruid) NN_NOEXCEPT
        {
            NN_SF_DETAIL_RETURN_INTERNAL_SYNC_METHOD_RESULT_N(ActivateKeyboard, (aruid));
        }

        ::nn::Result AcquireXpadIdEventHandle(::nn::sf::Out<::nn::sf::NativeHandle> outValue, ::std::uint64_t clientId) NN_NOEXCEPT
        {
            NN_SF_DETAIL_RETURN_INTERNAL_SYNC_METHOD_RESULT_N(AcquireXpadIdEventHandle, (outValue, clientId));
        }

        ::nn::Result ReleaseXpadIdEventHandle(::std::uint64_t clientId) NN_NOEXCEPT
        {
            NN_SF_DETAIL_RETURN_INTERNAL_SYNC_METHOD_RESULT_N(ReleaseXpadIdEventHandle, (clientId));
        }

        ::nn::Result ActivateXpad(::nn::applet::AppletResourceUserId aruid, ::nn::hid::BasicXpadId xpadId) NN_NOEXCEPT
        {
            NN_SF_DETAIL_RETURN_INTERNAL_SYNC_METHOD_RESULT_N(ActivateXpad, (aruid, xpadId));
        }

        ::nn::Result GetXpadIds(::nn::sf::Out<::std::int64_t> outCount, const ::nn::sf::OutArray<::nn::hid::BasicXpadId>& outXpadIds) NN_NOEXCEPT
        {
            NN_SF_DETAIL_RETURN_INTERNAL_SYNC_METHOD_RESULT_N(GetXpadIds, (outCount, outXpadIds));
        }

        ::nn::Result ActivateJoyXpad(::nn::hid::JoyXpadId xpadId) NN_NOEXCEPT
        {
            NN_SF_DETAIL_RETURN_INTERNAL_SYNC_METHOD_RESULT_N(ActivateJoyXpad, (xpadId));
        }

        ::nn::Result GetJoyXpadLifoHandle(::nn::sf::Out<::nn::sf::NativeHandle> outValue, ::nn::hid::JoyXpadId xpadId) NN_NOEXCEPT
        {
            NN_SF_DETAIL_RETURN_INTERNAL_SYNC_METHOD_RESULT_N(GetJoyXpadLifoHandle, (outValue, xpadId));
        }

        ::nn::Result GetJoyXpadIds(::nn::sf::Out<::std::int64_t> outGotCount, const ::nn::sf::OutArray<::nn::hid::JoyXpadId>& outXpadIds) NN_NOEXCEPT
        {
            NN_SF_DETAIL_RETURN_INTERNAL_SYNC_METHOD_RESULT_N(GetJoyXpadIds, (outGotCount, outXpadIds));
        }

        ::nn::Result ActivateSixAxisSensor(::nn::hid::BasicXpadId xpadId) NN_NOEXCEPT
        {
            NN_SF_DETAIL_RETURN_INTERNAL_SYNC_METHOD_RESULT_N(ActivateSixAxisSensor, (xpadId));
        }

        ::nn::Result DeactivateSixAxisSensor(::nn::hid::BasicXpadId xpadId) NN_NOEXCEPT
        {
            NN_SF_DETAIL_RETURN_INTERNAL_SYNC_METHOD_RESULT_N(DeactivateSixAxisSensor, (xpadId));
        }

        ::nn::Result GetSixAxisSensorLifoHandle(::nn::sf::Out<::nn::sf::NativeHandle> outValue, ::nn::hid::BasicXpadId xpadId) NN_NOEXCEPT
        {
            NN_SF_DETAIL_RETURN_INTERNAL_SYNC_METHOD_RESULT_N(GetSixAxisSensorLifoHandle, (outValue, xpadId));
        }

        ::nn::Result ActivateJoySixAxisSensor(::nn::hid::JoyXpadId xpadId) NN_NOEXCEPT
        {
            NN_SF_DETAIL_RETURN_INTERNAL_SYNC_METHOD_RESULT_N(ActivateJoySixAxisSensor, (xpadId));
        }

        ::nn::Result DeactivateJoySixAxisSensor(::nn::hid::JoyXpadId xpadId) NN_NOEXCEPT
        {
            NN_SF_DETAIL_RETURN_INTERNAL_SYNC_METHOD_RESULT_N(DeactivateJoySixAxisSensor, (xpadId));
        }

        ::nn::Result GetJoySixAxisSensorLifoHandle(::nn::sf::Out<::nn::sf::NativeHandle> outValue, ::nn::hid::JoyXpadId xpadId) NN_NOEXCEPT
        {
            NN_SF_DETAIL_RETURN_INTERNAL_SYNC_METHOD_RESULT_N(GetJoySixAxisSensorLifoHandle, (outValue, xpadId));
        }

        ::nn::Result StartSixAxisSensor(::nn::applet::AppletResourceUserId aruid, ::nn::hid::SixAxisSensorHandle handle) NN_NOEXCEPT
        {
            NN_SF_DETAIL_RETURN_INTERNAL_SYNC_METHOD_RESULT_N(StartSixAxisSensor, (aruid, handle));
        }

        ::nn::Result StopSixAxisSensor(::nn::applet::AppletResourceUserId aruid, ::nn::hid::SixAxisSensorHandle handle) NN_NOEXCEPT
        {
            NN_SF_DETAIL_RETURN_INTERNAL_SYNC_METHOD_RESULT_N(StopSixAxisSensor, (aruid, handle));
        }

        ::nn::Result IsSixAxisSensorFusionEnabled(::nn::sf::Out<bool> outIsEnabled, ::nn::applet::AppletResourceUserId aruid, ::nn::hid::SixAxisSensorHandle handle) NN_NOEXCEPT
        {
            NN_SF_DETAIL_RETURN_INTERNAL_SYNC_METHOD_RESULT_N(IsSixAxisSensorFusionEnabled, (outIsEnabled, aruid, handle));
        }

        ::nn::Result EnableSixAxisSensorFusion(::nn::applet::AppletResourceUserId aruid, ::nn::hid::SixAxisSensorHandle handle, bool enable) NN_NOEXCEPT
        {
            NN_SF_DETAIL_RETURN_INTERNAL_SYNC_METHOD_RESULT_N(EnableSixAxisSensorFusion, (aruid, handle, enable));
        }

        ::nn::Result SetSixAxisSensorFusionParameters(::nn::applet::AppletResourceUserId aruid, ::nn::hid::SixAxisSensorHandle handle, float revisePower, float reviseRange) NN_NOEXCEPT
        {
            NN_SF_DETAIL_RETURN_INTERNAL_SYNC_METHOD_RESULT_N(SetSixAxisSensorFusionParameters, (aruid, handle, revisePower, reviseRange));
        }

        ::nn::Result GetSixAxisSensorFusionParameters(::nn::sf::Out<float> outRevisePower, ::nn::sf::Out<float> outReviseRange, ::nn::applet::AppletResourceUserId aruid, ::nn::hid::SixAxisSensorHandle handle) NN_NOEXCEPT
        {
            NN_SF_DETAIL_RETURN_INTERNAL_SYNC_METHOD_RESULT_N(GetSixAxisSensorFusionParameters, (outRevisePower, outReviseRange, aruid, handle));
        }

        ::nn::Result ResetSixAxisSensorFusionParameters(::nn::applet::AppletResourceUserId aruid, ::nn::hid::SixAxisSensorHandle handle) NN_NOEXCEPT
        {
            NN_SF_DETAIL_RETURN_INTERNAL_SYNC_METHOD_RESULT_N(ResetSixAxisSensorFusionParameters, (aruid, handle));
        }

        ::nn::Result SetAccelerometerParameters(::nn::applet::AppletResourceUserId aruid, ::nn::hid::SixAxisSensorHandle handle, float playRadius, float sensitivity) NN_NOEXCEPT
        {
            NN_SF_DETAIL_RETURN_INTERNAL_SYNC_METHOD_RESULT_N(SetAccelerometerParameters, (aruid, handle, playRadius, sensitivity));
        }

        ::nn::Result GetAccelerometerParameters(::nn::sf::Out<float> outPlayRadius, ::nn::sf::Out<float> outSensitivity, ::nn::applet::AppletResourceUserId aruid, ::nn::hid::SixAxisSensorHandle handle) NN_NOEXCEPT
        {
            NN_SF_DETAIL_RETURN_INTERNAL_SYNC_METHOD_RESULT_N(GetAccelerometerParameters, (outPlayRadius, outSensitivity, aruid, handle));
        }

        ::nn::Result ResetAccelerometerParameters(::nn::applet::AppletResourceUserId aruid, ::nn::hid::SixAxisSensorHandle handle) NN_NOEXCEPT
        {
            NN_SF_DETAIL_RETURN_INTERNAL_SYNC_METHOD_RESULT_N(ResetAccelerometerParameters, (aruid, handle));
        }

        ::nn::Result SetAccelerometerPlayMode(::nn::applet::AppletResourceUserId aruid, ::nn::hid::SixAxisSensorHandle handle, ::std::uint32_t mode) NN_NOEXCEPT
        {
            NN_SF_DETAIL_RETURN_INTERNAL_SYNC_METHOD_RESULT_N(SetAccelerometerPlayMode, (aruid, handle, mode));
        }

        ::nn::Result GetAccelerometerPlayMode(::nn::sf::Out<::std::uint32_t> outMode, ::nn::applet::AppletResourceUserId aruid, ::nn::hid::SixAxisSensorHandle handle) NN_NOEXCEPT
        {
            NN_SF_DETAIL_RETURN_INTERNAL_SYNC_METHOD_RESULT_N(GetAccelerometerPlayMode, (outMode, aruid, handle));
        }

        ::nn::Result ResetAccelerometerPlayMode(::nn::applet::AppletResourceUserId aruid, ::nn::hid::SixAxisSensorHandle handle) NN_NOEXCEPT
        {
            NN_SF_DETAIL_RETURN_INTERNAL_SYNC_METHOD_RESULT_N(ResetAccelerometerPlayMode, (aruid, handle));
        }

        ::nn::Result SetGyroscopeZeroDriftMode(::nn::applet::AppletResourceUserId aruid, ::nn::hid::SixAxisSensorHandle handle, ::std::uint32_t mode) NN_NOEXCEPT
        {
            NN_SF_DETAIL_RETURN_INTERNAL_SYNC_METHOD_RESULT_N(SetGyroscopeZeroDriftMode, (aruid, handle, mode));
        }

        ::nn::Result GetGyroscopeZeroDriftMode(::nn::sf::Out<::std::uint32_t> outMode, ::nn::applet::AppletResourceUserId aruid, ::nn::hid::SixAxisSensorHandle handle) NN_NOEXCEPT
        {
            NN_SF_DETAIL_RETURN_INTERNAL_SYNC_METHOD_RESULT_N(GetGyroscopeZeroDriftMode, (outMode, aruid, handle));
        }

        ::nn::Result ResetGyroscopeZeroDriftMode(::nn::applet::AppletResourceUserId aruid, ::nn::hid::SixAxisSensorHandle handle) NN_NOEXCEPT
        {
            NN_SF_DETAIL_RETURN_INTERNAL_SYNC_METHOD_RESULT_N(ResetGyroscopeZeroDriftMode, (aruid, handle));
        }

        ::nn::Result IsSixAxisSensorAtRest(::nn::sf::Out<bool> outIsAtRest, ::nn::applet::AppletResourceUserId aruid, ::nn::hid::SixAxisSensorHandle handle) NN_NOEXCEPT
        {
            NN_SF_DETAIL_RETURN_INTERNAL_SYNC_METHOD_RESULT_N(IsSixAxisSensorAtRest, (outIsAtRest, aruid, handle));
        }

        ::nn::Result ActivateGesture(::nn::applet::AppletResourceUserId aruid, ::std::int32_t version) NN_NOEXCEPT
        {
            NN_SF_DETAIL_RETURN_INTERNAL_SYNC_METHOD_RESULT_N(ActivateGesture, (aruid, version));
        }

        ::nn::Result SetSupportedNpadStyleSet(::nn::applet::AppletResourceUserId aruid, ::nn::hid::NpadStyleSet style) NN_NOEXCEPT
        {
            NN_SF_DETAIL_RETURN_INTERNAL_SYNC_METHOD_RESULT_N(SetSupportedNpadStyleSet, (aruid, style));
        }

        ::nn::Result GetSupportedNpadStyleSet(::nn::applet::AppletResourceUserId aruid, ::nn::sf::Out<::nn::hid::NpadStyleSet> outValue) NN_NOEXCEPT
        {
            NN_SF_DETAIL_RETURN_INTERNAL_SYNC_METHOD_RESULT_N(GetSupportedNpadStyleSet, (aruid, outValue));
        }

        ::nn::Result SetSupportedNpadIdType(::nn::applet::AppletResourceUserId aruid, const ::nn::sf::InArray<::nn::hid::NpadIdType>& ids) NN_NOEXCEPT
        {
            NN_SF_DETAIL_RETURN_INTERNAL_SYNC_METHOD_RESULT_N(SetSupportedNpadIdType, (aruid, ids));
        }

        ::nn::Result ActivateNpad(::nn::applet::AppletResourceUserId aruid) NN_NOEXCEPT
        {
            NN_SF_DETAIL_RETURN_INTERNAL_SYNC_METHOD_RESULT_N(ActivateNpad, (aruid));
        }

        ::nn::Result DeactivateNpad(::nn::applet::AppletResourceUserId aruid) NN_NOEXCEPT
        {
            NN_SF_DETAIL_RETURN_INTERNAL_SYNC_METHOD_RESULT_N(DeactivateNpad, (aruid));
        }

        ::nn::Result AcquireNpadStyleSetUpdateEventHandle(::nn::applet::AppletResourceUserId aruid, ::nn::sf::Out<::nn::sf::NativeHandle> outValue, ::nn::hid::NpadIdType id, ::std::uint64_t clientId) NN_NOEXCEPT
        {
            NN_SF_DETAIL_RETURN_INTERNAL_SYNC_METHOD_RESULT_N(AcquireNpadStyleSetUpdateEventHandle, (aruid, outValue, id, clientId));
        }

        ::nn::Result DisconnectNpad(::nn::applet::AppletResourceUserId aruid, ::nn::hid::NpadIdType id) NN_NOEXCEPT
        {
            NN_SF_DETAIL_RETURN_INTERNAL_SYNC_METHOD_RESULT_N(DisconnectNpad, (aruid, id));
        }

        ::nn::Result GetPlayerLedPattern(::nn::sf::Out<::std::uint64_t> outValue, ::nn::hid::NpadIdType id) NN_NOEXCEPT
        {
            NN_SF_DETAIL_RETURN_INTERNAL_SYNC_METHOD_RESULT_N(GetPlayerLedPattern, (outValue, id));
        }

        ::nn::Result ActivateNpadWithRevision(::nn::applet::AppletResourceUserId aruid, ::std::int32_t revision) NN_NOEXCEPT
        {
            NN_SF_DETAIL_RETURN_INTERNAL_SYNC_METHOD_RESULT_N(ActivateNpadWithRevision, (aruid, revision));
        }

        ::nn::Result SetNpadJoyHoldType(::nn::applet::AppletResourceUserId aruid, ::std::int64_t holdType) NN_NOEXCEPT
        {
            NN_SF_DETAIL_RETURN_INTERNAL_SYNC_METHOD_RESULT_N(SetNpadJoyHoldType, (aruid, holdType));
        }

        ::nn::Result GetNpadJoyHoldType(::nn::applet::AppletResourceUserId aruid, ::nn::sf::Out<::std::int64_t> outValue) NN_NOEXCEPT
        {
            NN_SF_DETAIL_RETURN_INTERNAL_SYNC_METHOD_RESULT_N(GetNpadJoyHoldType, (aruid, outValue));
        }

        ::nn::Result SetNpadJoyAssignmentModeSingleByDefault(::nn::applet::AppletResourceUserId aruid, ::nn::hid::NpadIdType id) NN_NOEXCEPT
        {
            NN_SF_DETAIL_RETURN_INTERNAL_SYNC_METHOD_RESULT_N(SetNpadJoyAssignmentModeSingleByDefault, (aruid, id));
        }

        ::nn::Result SetNpadJoyAssignmentModeSingle(::nn::applet::AppletResourceUserId aruid, ::nn::hid::NpadIdType id, ::std::int64_t type) NN_NOEXCEPT
        {
            NN_SF_DETAIL_RETURN_INTERNAL_SYNC_METHOD_RESULT_N(SetNpadJoyAssignmentModeSingle, (aruid, id, type));
        }

        ::nn::Result SetNpadJoyAssignmentModeDual(::nn::applet::AppletResourceUserId aruid, ::nn::hid::NpadIdType id) NN_NOEXCEPT
        {
            NN_SF_DETAIL_RETURN_INTERNAL_SYNC_METHOD_RESULT_N(SetNpadJoyAssignmentModeDual, (aruid, id));
        }

        ::nn::Result MergeSingleJoyAsDualJoy(::nn::applet::AppletResourceUserId aruid, ::nn::hid::NpadIdType id1, ::nn::hid::NpadIdType id2) NN_NOEXCEPT
        {
            NN_SF_DETAIL_RETURN_INTERNAL_SYNC_METHOD_RESULT_N(MergeSingleJoyAsDualJoy, (aruid, id1, id2));
        }

        ::nn::Result StartLrAssignmentMode(::nn::applet::AppletResourceUserId aruid) NN_NOEXCEPT
        {
            NN_SF_DETAIL_RETURN_INTERNAL_SYNC_METHOD_RESULT_N(StartLrAssignmentMode, (aruid));
        }

        ::nn::Result StopLrAssignmentMode(::nn::applet::AppletResourceUserId aruid) NN_NOEXCEPT
        {
            NN_SF_DETAIL_RETURN_INTERNAL_SYNC_METHOD_RESULT_N(StopLrAssignmentMode, (aruid));
        }

        ::nn::Result SetNpadHandheldActivationMode(::nn::applet::AppletResourceUserId aruid, ::std::int64_t mode) NN_NOEXCEPT
        {
            NN_SF_DETAIL_RETURN_INTERNAL_SYNC_METHOD_RESULT_N(SetNpadHandheldActivationMode, (aruid, mode));
        }

        ::nn::Result GetNpadHandheldActivationMode(::nn::applet::AppletResourceUserId aruid, ::nn::sf::Out<::std::int64_t> outValue) NN_NOEXCEPT
        {
            NN_SF_DETAIL_RETURN_INTERNAL_SYNC_METHOD_RESULT_N(GetNpadHandheldActivationMode, (aruid, outValue));
        }

        ::nn::Result SwapNpadAssignment(::nn::applet::AppletResourceUserId aruid, ::nn::hid::NpadIdType id1, ::nn::hid::NpadIdType id2) NN_NOEXCEPT
        {
            NN_SF_DETAIL_RETURN_INTERNAL_SYNC_METHOD_RESULT_N(SwapNpadAssignment, (aruid, id1, id2));
        }

        ::nn::Result IsUnintendedHomeButtonInputProtectionEnabled(::nn::sf::Out<bool> outIsEnabled, ::nn::applet::AppletResourceUserId aruid, ::nn::hid::NpadIdType id) NN_NOEXCEPT
        {
            NN_SF_DETAIL_RETURN_INTERNAL_SYNC_METHOD_RESULT_N(IsUnintendedHomeButtonInputProtectionEnabled, (outIsEnabled, aruid, id));
        }

        ::nn::Result EnableUnintendedHomeButtonInputProtection(::nn::applet::AppletResourceUserId aruid, ::nn::hid::NpadIdType id, bool enabled) NN_NOEXCEPT
        {
            NN_SF_DETAIL_RETURN_INTERNAL_SYNC_METHOD_RESULT_N(EnableUnintendedHomeButtonInputProtection, (aruid, id, enabled));
        }

        ::nn::Result SetNpadJoyAssignmentModeSingleWithDestination(::nn::sf::Out<bool> outIsAssigned, ::nn::sf::Out<::nn::hid::NpadIdType> outId, ::nn::applet::AppletResourceUserId aruid, ::nn::hid::NpadIdType id, ::std::int64_t type) NN_NOEXCEPT
        {
            NN_SF_DETAIL_RETURN_INTERNAL_SYNC_METHOD_RESULT_N(SetNpadJoyAssignmentModeSingleWithDestination, (outIsAssigned, outId, aruid, id, type));
        }

        ::nn::Result GetVibrationDeviceInfo(::nn::sf::Out<::nn::hid::VibrationDeviceInfoForIpc> outValue, ::nn::hid::VibrationDeviceHandle handle) NN_NOEXCEPT
        {
            NN_SF_DETAIL_RETURN_INTERNAL_SYNC_METHOD_RESULT_N(GetVibrationDeviceInfo, (outValue, handle));
        }

        ::nn::Result SendVibrationValue(::nn::applet::AppletResourceUserId aruid, ::nn::hid::VibrationDeviceHandle handle, const ::nn::hid::VibrationValue& value) NN_NOEXCEPT
        {
            NN_SF_DETAIL_RETURN_INTERNAL_SYNC_METHOD_RESULT_N(SendVibrationValue, (aruid, handle, value));
        }

        ::nn::Result GetActualVibrationValue(::nn::sf::Out<::nn::hid::VibrationValue> outValue, ::nn::applet::AppletResourceUserId aruid, ::nn::hid::VibrationDeviceHandle handle) NN_NOEXCEPT
        {
            NN_SF_DETAIL_RETURN_INTERNAL_SYNC_METHOD_RESULT_N(GetActualVibrationValue, (outValue, aruid, handle));
        }

        ::nn::Result CreateActiveVibrationDeviceList(::nn::sf::Out<::nn::sf::SharedPointer<::nn::hid::IActiveVibrationDeviceList>> outValue) NN_NOEXCEPT
        {
            NN_SF_DETAIL_RETURN_INTERNAL_SYNC_METHOD_RESULT_N(CreateActiveVibrationDeviceList, (outValue));
        }

        ::nn::Result PermitVibration(bool isPermitted) NN_NOEXCEPT
        {
            NN_SF_DETAIL_RETURN_INTERNAL_SYNC_METHOD_RESULT_N(PermitVibration, (isPermitted));
        }

        ::nn::Result IsVibrationPermitted(::nn::sf::Out<bool> outValue) NN_NOEXCEPT
        {
            NN_SF_DETAIL_RETURN_INTERNAL_SYNC_METHOD_RESULT_N(IsVibrationPermitted, (outValue));
        }

        ::nn::Result SendVibrationValues(::nn::applet::AppletResourceUserId aruid, const ::nn::sf::InArray<::nn::hid::VibrationDeviceHandle>& handles, const ::nn::sf::InArray<::nn::hid::VibrationValue>& values) NN_NOEXCEPT
        {
            NN_SF_DETAIL_RETURN_INTERNAL_SYNC_METHOD_RESULT_N(SendVibrationValues, (aruid, handles, values));
        }

        ::nn::Result SendVibrationGcErmCommand(::nn::applet::AppletResourceUserId aruid, ::nn::hid::VibrationDeviceHandle handle, ::nn::hid::VibrationGcErmCommand command) NN_NOEXCEPT
        {
            NN_SF_DETAIL_RETURN_INTERNAL_SYNC_METHOD_RESULT_N(SendVibrationGcErmCommand, (aruid, handle, command));
        }

        ::nn::Result GetActualVibrationGcErmCommand(::nn::sf::Out<::nn::hid::VibrationGcErmCommand> outValue, ::nn::applet::AppletResourceUserId aruid, ::nn::hid::VibrationDeviceHandle handle) NN_NOEXCEPT
        {
            NN_SF_DETAIL_RETURN_INTERNAL_SYNC_METHOD_RESULT_N(GetActualVibrationGcErmCommand, (outValue, aruid, handle));
        }

        ::nn::Result BeginPermitVibrationSession(::nn::applet::AppletResourceUserId aruid) NN_NOEXCEPT
        {
            NN_SF_DETAIL_RETURN_INTERNAL_SYNC_METHOD_RESULT_N(BeginPermitVibrationSession, (aruid));
        }

        ::nn::Result EndPermitVibrationSession() NN_NOEXCEPT
        {
            NN_SF_DETAIL_RETURN_INTERNAL_SYNC_METHOD_RESULT_0(EndPermitVibrationSession);
        }

        ::nn::Result ActivateConsoleSixAxisSensor(::nn::applet::AppletResourceUserId aruid) NN_NOEXCEPT
        {
            NN_SF_DETAIL_RETURN_INTERNAL_SYNC_METHOD_RESULT_N(ActivateConsoleSixAxisSensor, (aruid));
        }

        ::nn::Result StartConsoleSixAxisSensor(::nn::applet::AppletResourceUserId aruid, ::nn::hid::ConsoleSixAxisSensorHandle handle) NN_NOEXCEPT
        {
            NN_SF_DETAIL_RETURN_INTERNAL_SYNC_METHOD_RESULT_N(StartConsoleSixAxisSensor, (aruid, handle));
        }

        ::nn::Result StopConsoleSixAxisSensor(::nn::applet::AppletResourceUserId aruid, ::nn::hid::ConsoleSixAxisSensorHandle handle) NN_NOEXCEPT
        {
            NN_SF_DETAIL_RETURN_INTERNAL_SYNC_METHOD_RESULT_N(StopConsoleSixAxisSensor, (aruid, handle));
        }

        ::nn::Result ActivateSevenSixAxisSensor(::nn::applet::AppletResourceUserId aruid) NN_NOEXCEPT
        {
            NN_SF_DETAIL_RETURN_INTERNAL_SYNC_METHOD_RESULT_N(ActivateSevenSixAxisSensor, (aruid));
        }

        ::nn::Result StartSevenSixAxisSensor(::nn::applet::AppletResourceUserId aruid) NN_NOEXCEPT
        {
            NN_SF_DETAIL_RETURN_INTERNAL_SYNC_METHOD_RESULT_N(StartSevenSixAxisSensor, (aruid));
        }

        ::nn::Result StopSevenSixAxisSensor(::nn::applet::AppletResourceUserId aruid) NN_NOEXCEPT
        {
            NN_SF_DETAIL_RETURN_INTERNAL_SYNC_METHOD_RESULT_N(StopSevenSixAxisSensor, (aruid));
        }

        ::nn::Result InitializeSevenSixAxisSensor(::nn::applet::AppletResourceUserId aruid, ::nn::sf::NativeHandle&& stateBufferHandle, ::std::uint64_t stateBufferSize, ::nn::sf::NativeHandle&& workBufferHandle, ::std::uint64_t workBufferSize) NN_NOEXCEPT
        {
            NN_SF_DETAIL_RETURN_INTERNAL_SYNC_METHOD_RESULT_N(InitializeSevenSixAxisSensor, (aruid, ::std::move(stateBufferHandle), stateBufferSize, ::std::move(workBufferHandle), workBufferSize));
        }

        ::nn::Result FinalizeSevenSixAxisSensor(::nn::applet::AppletResourceUserId aruid) NN_NOEXCEPT
        {
            NN_SF_DETAIL_RETURN_INTERNAL_SYNC_METHOD_RESULT_N(FinalizeSevenSixAxisSensor, (aruid));
        }

        ::nn::Result SetSevenSixAxisSensorFusionStrength(::nn::applet::AppletResourceUserId aruid, float strength) NN_NOEXCEPT
        {
            NN_SF_DETAIL_RETURN_INTERNAL_SYNC_METHOD_RESULT_N(SetSevenSixAxisSensorFusionStrength, (aruid, strength));
        }

        ::nn::Result GetSevenSixAxisSensorFusionStrength(::nn::sf::Out<float> strength, ::nn::applet::AppletResourceUserId aruid) NN_NOEXCEPT
        {
            NN_SF_DETAIL_RETURN_INTERNAL_SYNC_METHOD_RESULT_N(GetSevenSixAxisSensorFusionStrength, (strength, aruid));
        }

        ::nn::Result IsUsbFullKeyControllerEnabled(::nn::sf::Out<bool> outIsEnabled) NN_NOEXCEPT
        {
            NN_SF_DETAIL_RETURN_INTERNAL_SYNC_METHOD_RESULT_N(IsUsbFullKeyControllerEnabled, (outIsEnabled));
        }

        ::nn::Result EnableUsbFullKeyController(bool enabled) NN_NOEXCEPT
        {
            NN_SF_DETAIL_RETURN_INTERNAL_SYNC_METHOD_RESULT_N(EnableUsbFullKeyController, (enabled));
        }

        ::nn::Result IsUsbFullKeyControllerConnected(::nn::sf::Out<bool> outIsConnected, ::nn::hid::NpadIdType id) NN_NOEXCEPT
        {
            NN_SF_DETAIL_RETURN_INTERNAL_SYNC_METHOD_RESULT_N(IsUsbFullKeyControllerConnected, (outIsConnected, id));
        }

        ::nn::Result HasBattery(::nn::sf::Out<bool> outHasBattery, ::nn::hid::NpadIdType id) NN_NOEXCEPT
        {
            NN_SF_DETAIL_RETURN_INTERNAL_SYNC_METHOD_RESULT_N(HasBattery, (outHasBattery, id));
        }

        ::nn::Result HasLeftRightBattery(::nn::sf::Out<bool> outLeftJoyHasBattery, ::nn::sf::Out<bool> outRightJoyHasBattery, ::nn::hid::NpadIdType id) NN_NOEXCEPT
        {
            NN_SF_DETAIL_RETURN_INTERNAL_SYNC_METHOD_RESULT_N(HasLeftRightBattery, (outLeftJoyHasBattery, outRightJoyHasBattery, id));
        }

        ::nn::Result GetNpadInterfaceType(::nn::sf::Out<::nn::hid::system::InterfaceType> outInterfaceType, ::nn::hid::NpadIdType id) NN_NOEXCEPT
        {
            NN_SF_DETAIL_RETURN_INTERNAL_SYNC_METHOD_RESULT_N(GetNpadInterfaceType, (outInterfaceType, id));
        }

        ::nn::Result GetNpadLeftRightInterfaceType(::nn::sf::Out<::nn::hid::system::InterfaceType> outLeftJoyInterfaceType, ::nn::sf::Out<::nn::hid::system::InterfaceType> outRightJoyInterfaceType, ::nn::hid::NpadIdType id) NN_NOEXCEPT
        {
            NN_SF_DETAIL_RETURN_INTERNAL_SYNC_METHOD_RESULT_N(GetNpadLeftRightInterfaceType, (outLeftJoyInterfaceType, outRightJoyInterfaceType, id));
        }

        ::nn::Result GetPalmaConnectionHandle(::nn::sf::Out<::nn::hid::PalmaConnectionHandle> outHandle, ::nn::hid::NpadIdType id, ::nn::applet::AppletResourceUserId aruid) NN_NOEXCEPT
        {
            NN_SF_DETAIL_RETURN_INTERNAL_SYNC_METHOD_RESULT_N(GetPalmaConnectionHandle, (outHandle, id, aruid));
        }

        ::nn::Result InitializePalma(::nn::hid::PalmaConnectionHandle handle) NN_NOEXCEPT
        {
            NN_SF_DETAIL_RETURN_INTERNAL_SYNC_METHOD_RESULT_N(InitializePalma, (handle));
        }

        ::nn::Result AcquirePalmaOperationCompleteEvent(::nn::sf::Out<::nn::sf::NativeHandle> outValue, ::nn::hid::PalmaConnectionHandle handle) NN_NOEXCEPT
        {
            NN_SF_DETAIL_RETURN_INTERNAL_SYNC_METHOD_RESULT_N(AcquirePalmaOperationCompleteEvent, (outValue, handle));
        }

        ::nn::Result GetPalmaOperationInfo(::nn::sf::Out<::std::uint64_t> outType, const ::nn::sf::OutBuffer& outBuffer, ::nn::hid::PalmaConnectionHandle handle) NN_NOEXCEPT
        {
            NN_SF_DETAIL_RETURN_INTERNAL_SYNC_METHOD_RESULT_N(GetPalmaOperationInfo, (outType, outBuffer, handle));
        }

        ::nn::Result PlayPalmaActivity(::nn::hid::PalmaConnectionHandle handle, ::std::uint64_t index) NN_NOEXCEPT
        {
            NN_SF_DETAIL_RETURN_INTERNAL_SYNC_METHOD_RESULT_N(PlayPalmaActivity, (handle, index));
        }

        ::nn::Result SetPalmaFrModeType(::nn::hid::PalmaConnectionHandle handle, ::std::uint64_t type) NN_NOEXCEPT
        {
            NN_SF_DETAIL_RETURN_INTERNAL_SYNC_METHOD_RESULT_N(SetPalmaFrModeType, (handle, type));
        }

        ::nn::Result ReadPalmaStep(::nn::hid::PalmaConnectionHandle handle) NN_NOEXCEPT
        {
            NN_SF_DETAIL_RETURN_INTERNAL_SYNC_METHOD_RESULT_N(ReadPalmaStep, (handle));
        }

        ::nn::Result EnablePalmaStep(::nn::hid::PalmaConnectionHandle handle, bool isEnabled) NN_NOEXCEPT
        {
            NN_SF_DETAIL_RETURN_INTERNAL_SYNC_METHOD_RESULT_N(EnablePalmaStep, (handle, isEnabled));
        }

        ::nn::Result ResetPalmaStep(::nn::hid::PalmaConnectionHandle handle) NN_NOEXCEPT
        {
            NN_SF_DETAIL_RETURN_INTERNAL_SYNC_METHOD_RESULT_N(ResetPalmaStep, (handle));
        }

        ::nn::Result ReadPalmaApplicationSection(::nn::hid::PalmaConnectionHandle handle, ::std::uint64_t address, ::std::uint64_t size) NN_NOEXCEPT
        {
            NN_SF_DETAIL_RETURN_INTERNAL_SYNC_METHOD_RESULT_N(ReadPalmaApplicationSection, (handle, address, size));
        }

        ::nn::Result WritePalmaApplicationSection(::nn::hid::PalmaConnectionHandle handle, ::std::uint64_t address, ::std::uint64_t size, const ::nn::hid::PalmaApplicationSectionAccessBuffer& buffer) NN_NOEXCEPT
        {
            NN_SF_DETAIL_RETURN_INTERNAL_SYNC_METHOD_RESULT_N(WritePalmaApplicationSection, (handle, address, size, buffer));
        }

        ::nn::Result ReadPalmaUniqueCode(::nn::hid::PalmaConnectionHandle handle) NN_NOEXCEPT
        {
            NN_SF_DETAIL_RETURN_INTERNAL_SYNC_METHOD_RESULT_N(ReadPalmaUniqueCode, (handle));
        }

        ::nn::Result SetPalmaUniqueCodeInvalid(::nn::hid::PalmaConnectionHandle handle) NN_NOEXCEPT
        {
            NN_SF_DETAIL_RETURN_INTERNAL_SYNC_METHOD_RESULT_N(SetPalmaUniqueCodeInvalid, (handle));
        }

        ::nn::Result WritePalmaActivityEntry(::nn::hid::PalmaConnectionHandle handle, ::std::uint64_t index, ::std::uint64_t ledIndex, ::std::uint64_t waveSet, ::std::uint64_t waveIndex) NN_NOEXCEPT
        {
            NN_SF_DETAIL_RETURN_INTERNAL_SYNC_METHOD_RESULT_N(WritePalmaActivityEntry, (handle, index, ledIndex, waveSet, waveIndex));
        }

        ::nn::Result WritePalmaRgbLedPatternEntry(::nn::hid::PalmaConnectionHandle handle, ::std::uint64_t index, const ::nn::sf::InBuffer& pInBuffer) NN_NOEXCEPT
        {
            NN_SF_DETAIL_RETURN_INTERNAL_SYNC_METHOD_RESULT_N(WritePalmaRgbLedPatternEntry, (handle, index, pInBuffer));
        }

        ::nn::Result WritePalmaWaveEntry(::nn::hid::PalmaConnectionHandle handle, ::std::uint64_t waveSet, ::std::uint64_t index, ::nn::sf::NativeHandle&& transferMemoryHandle, ::std::uint64_t transferMemorySize, ::std::uint64_t waveDataSize) NN_NOEXCEPT
        {
            NN_SF_DETAIL_RETURN_INTERNAL_SYNC_METHOD_RESULT_N(WritePalmaWaveEntry, (handle, waveSet, index, ::std::move(transferMemoryHandle), transferMemorySize, waveDataSize));
        }

        ::nn::Result SetPalmaDataBaseIdentificationVersion(::nn::hid::PalmaConnectionHandle handle, ::std::int32_t version) NN_NOEXCEPT
        {
            NN_SF_DETAIL_RETURN_INTERNAL_SYNC_METHOD_RESULT_N(SetPalmaDataBaseIdentificationVersion, (handle, version));
        }

        ::nn::Result GetPalmaDataBaseIdentificationVersion(::nn::hid::PalmaConnectionHandle handle) NN_NOEXCEPT
        {
            NN_SF_DETAIL_RETURN_INTERNAL_SYNC_METHOD_RESULT_N(GetPalmaDataBaseIdentificationVersion, (handle));
        }

        ::nn::Result SuspendPalmaFeature(::nn::hid::PalmaConnectionHandle handle, ::nn::hid::PalmaFeatureSet suspendFeatureSet) NN_NOEXCEPT
        {
            NN_SF_DETAIL_RETURN_INTERNAL_SYNC_METHOD_RESULT_N(SuspendPalmaFeature, (handle, suspendFeatureSet));
        }

        ::nn::Result GetPalmaOperationResult(::nn::hid::PalmaConnectionHandle handle) NN_NOEXCEPT
        {
            NN_SF_DETAIL_RETURN_INTERNAL_SYNC_METHOD_RESULT_N(GetPalmaOperationResult, (handle));
        }

        ::nn::Result ReadPalmaPlayLog(::nn::hid::PalmaConnectionHandle handle, ::std::uint16_t index) NN_NOEXCEPT
        {
            NN_SF_DETAIL_RETURN_INTERNAL_SYNC_METHOD_RESULT_N(ReadPalmaPlayLog, (handle, index));
        }

        ::nn::Result ResetPalmaPlayLog(::nn::hid::PalmaConnectionHandle handle, ::std::uint16_t index) NN_NOEXCEPT
        {
            NN_SF_DETAIL_RETURN_INTERNAL_SYNC_METHOD_RESULT_N(ResetPalmaPlayLog, (handle, index));
        }

        ::nn::Result SetIsPalmaAllConnectable(::nn::applet::AppletResourceUserId aruid, bool connectable) NN_NOEXCEPT
        {
            NN_SF_DETAIL_RETURN_INTERNAL_SYNC_METHOD_RESULT_N(SetIsPalmaAllConnectable, (aruid, connectable));
        }

        ::nn::Result SetIsPalmaPairedConnectable(::nn::applet::AppletResourceUserId aruid, bool connectable) NN_NOEXCEPT
        {
            NN_SF_DETAIL_RETURN_INTERNAL_SYNC_METHOD_RESULT_N(SetIsPalmaPairedConnectable, (aruid, connectable));
        }

        ::nn::Result PairPalma(::nn::hid::PalmaConnectionHandle handle) NN_NOEXCEPT
        {
            NN_SF_DETAIL_RETURN_INTERNAL_SYNC_METHOD_RESULT_N(PairPalma, (handle));
        }

        ::nn::Result SetPalmaBoostMode(bool enabled) NN_NOEXCEPT
        {
            NN_SF_DETAIL_RETURN_INTERNAL_SYNC_METHOD_RESULT_N(SetPalmaBoostMode, (enabled));
        }

        ::nn::Result SetNpadCommunicationMode(::nn::applet::AppletResourceUserId aruid, ::std::int64_t mode) NN_NOEXCEPT
        {
            NN_SF_DETAIL_RETURN_INTERNAL_SYNC_METHOD_RESULT_N(SetNpadCommunicationMode, (aruid, mode));
        }

        ::nn::Result GetNpadCommunicationMode(::nn::sf::Out<::std::int64_t> outValue) NN_NOEXCEPT
        {
            NN_SF_DETAIL_RETURN_INTERNAL_SYNC_METHOD_RESULT_N(GetNpadCommunicationMode, (outValue));
        }

    NN_SF_DETAIL_SERVICE_INTERFACE_END_ACCESSOR

NN_SF_DETAIL_DEFINE_SERVICE_INTERFACE_END

#if 0
    class IHidServer
    {
    public:
        nn::Result CreateAppletResource(nn::sf::Out<nn::sf::SharedPointer<nn::hid::IAppletResource>> outValue, nn::applet::AppletResourceUserId aruid) NN_NOEXCEPT;
        nn::Result ActivateDebugPad(nn::applet::AppletResourceUserId aruid) NN_NOEXCEPT;
        nn::Result ActivateTouchScreen(nn::applet::AppletResourceUserId aruid) NN_NOEXCEPT;
        nn::Result ActivateMouse(nn::applet::AppletResourceUserId aruid) NN_NOEXCEPT;
        nn::Result ActivateKeyboard(nn::applet::AppletResourceUserId aruid) NN_NOEXCEPT;
        nn::Result AcquireXpadIdEventHandle(nn::sf::Out<nn::sf::NativeHandle> outValue, std::uint64_t clientId) NN_NOEXCEPT;
        nn::Result ReleaseXpadIdEventHandle(std::uint64_t clientId) NN_NOEXCEPT;
        nn::Result ActivateXpad(nn::applet::AppletResourceUserId aruid, nn::hid::BasicXpadId xpadId) NN_NOEXCEPT;
        nn::Result GetXpadIds(nn::sf::Out<std::int64_t> outCount, const nn::sf::OutArray<nn::hid::BasicXpadId>& outXpadIds) NN_NOEXCEPT;
        nn::Result ActivateJoyXpad(nn::hid::JoyXpadId xpadId) NN_NOEXCEPT;
        nn::Result GetJoyXpadLifoHandle(nn::sf::Out<nn::sf::NativeHandle> outValue, nn::hid::JoyXpadId xpadId) NN_NOEXCEPT;
        nn::Result GetJoyXpadIds(nn::sf::Out<std::int64_t> outGotCount, const nn::sf::OutArray<nn::hid::JoyXpadId>& outXpadIds) NN_NOEXCEPT;
        nn::Result ActivateSixAxisSensor(nn::hid::BasicXpadId xpadId) NN_NOEXCEPT;
        nn::Result DeactivateSixAxisSensor(nn::hid::BasicXpadId xpadId) NN_NOEXCEPT;
        nn::Result GetSixAxisSensorLifoHandle(nn::sf::Out<nn::sf::NativeHandle> outValue, nn::hid::BasicXpadId xpadId) NN_NOEXCEPT;
        nn::Result ActivateJoySixAxisSensor(nn::hid::JoyXpadId xpadId) NN_NOEXCEPT;
        nn::Result DeactivateJoySixAxisSensor(nn::hid::JoyXpadId xpadId) NN_NOEXCEPT;
        nn::Result GetJoySixAxisSensorLifoHandle(nn::sf::Out<nn::sf::NativeHandle> outValue, nn::hid::JoyXpadId xpadId) NN_NOEXCEPT;
        nn::Result StartSixAxisSensor(nn::applet::AppletResourceUserId aruid, nn::hid::SixAxisSensorHandle handle) NN_NOEXCEPT;
        nn::Result StopSixAxisSensor(nn::applet::AppletResourceUserId aruid, nn::hid::SixAxisSensorHandle handle) NN_NOEXCEPT;
        nn::Result IsSixAxisSensorFusionEnabled(nn::sf::Out<bool> outIsEnabled, nn::applet::AppletResourceUserId aruid, nn::hid::SixAxisSensorHandle handle) NN_NOEXCEPT;
        nn::Result EnableSixAxisSensorFusion(nn::applet::AppletResourceUserId aruid, nn::hid::SixAxisSensorHandle handle, bool enable) NN_NOEXCEPT;
        nn::Result SetSixAxisSensorFusionParameters(nn::applet::AppletResourceUserId aruid, nn::hid::SixAxisSensorHandle handle, float revisePower, float reviseRange) NN_NOEXCEPT;
        nn::Result GetSixAxisSensorFusionParameters(nn::sf::Out<float> outRevisePower, nn::sf::Out<float> outReviseRange, nn::applet::AppletResourceUserId aruid, nn::hid::SixAxisSensorHandle handle) NN_NOEXCEPT;
        nn::Result ResetSixAxisSensorFusionParameters(nn::applet::AppletResourceUserId aruid, nn::hid::SixAxisSensorHandle handle) NN_NOEXCEPT;
        nn::Result SetAccelerometerParameters(nn::applet::AppletResourceUserId aruid, nn::hid::SixAxisSensorHandle handle, float playRadius, float sensitivity) NN_NOEXCEPT;
        nn::Result GetAccelerometerParameters(nn::sf::Out<float> outPlayRadius, nn::sf::Out<float> outSensitivity, nn::applet::AppletResourceUserId aruid, nn::hid::SixAxisSensorHandle handle) NN_NOEXCEPT;
        nn::Result ResetAccelerometerParameters(nn::applet::AppletResourceUserId aruid, nn::hid::SixAxisSensorHandle handle) NN_NOEXCEPT;
        nn::Result SetAccelerometerPlayMode(nn::applet::AppletResourceUserId aruid, nn::hid::SixAxisSensorHandle handle, std::uint32_t mode) NN_NOEXCEPT;
        nn::Result GetAccelerometerPlayMode(nn::sf::Out<std::uint32_t> outMode, nn::applet::AppletResourceUserId aruid, nn::hid::SixAxisSensorHandle handle) NN_NOEXCEPT;
        nn::Result ResetAccelerometerPlayMode(nn::applet::AppletResourceUserId aruid, nn::hid::SixAxisSensorHandle handle) NN_NOEXCEPT;
        nn::Result SetGyroscopeZeroDriftMode(nn::applet::AppletResourceUserId aruid, nn::hid::SixAxisSensorHandle handle, std::uint32_t mode) NN_NOEXCEPT;
        nn::Result GetGyroscopeZeroDriftMode(nn::sf::Out<std::uint32_t> outMode, nn::applet::AppletResourceUserId aruid, nn::hid::SixAxisSensorHandle handle) NN_NOEXCEPT;
        nn::Result ResetGyroscopeZeroDriftMode(nn::applet::AppletResourceUserId aruid, nn::hid::SixAxisSensorHandle handle) NN_NOEXCEPT;
        nn::Result IsSixAxisSensorAtRest(nn::sf::Out<bool> outIsAtRest, nn::applet::AppletResourceUserId aruid, nn::hid::SixAxisSensorHandle handle) NN_NOEXCEPT;
        nn::Result ActivateGesture(nn::applet::AppletResourceUserId aruid, std::int32_t version) NN_NOEXCEPT;
        nn::Result SetSupportedNpadStyleSet(nn::applet::AppletResourceUserId aruid, nn::hid::NpadStyleSet style) NN_NOEXCEPT;
        nn::Result GetSupportedNpadStyleSet(nn::applet::AppletResourceUserId aruid, nn::sf::Out<nn::hid::NpadStyleSet> outValue) NN_NOEXCEPT;
        nn::Result SetSupportedNpadIdType(nn::applet::AppletResourceUserId aruid, const nn::sf::InArray<nn::hid::NpadIdType>& ids) NN_NOEXCEPT;
        nn::Result ActivateNpad(nn::applet::AppletResourceUserId aruid) NN_NOEXCEPT;
        nn::Result DeactivateNpad(nn::applet::AppletResourceUserId aruid) NN_NOEXCEPT;
        nn::Result AcquireNpadStyleSetUpdateEventHandle(nn::applet::AppletResourceUserId aruid, nn::sf::Out<nn::sf::NativeHandle> outValue, nn::hid::NpadIdType id, std::uint64_t clientId) NN_NOEXCEPT;
        nn::Result DisconnectNpad(nn::applet::AppletResourceUserId aruid, nn::hid::NpadIdType id) NN_NOEXCEPT;
        nn::Result GetPlayerLedPattern(nn::sf::Out<std::uint64_t> outValue, nn::hid::NpadIdType id) NN_NOEXCEPT;
        nn::Result ActivateNpadWithRevision(nn::applet::AppletResourceUserId aruid, std::int32_t revision) NN_NOEXCEPT;
        nn::Result SetNpadJoyHoldType(nn::applet::AppletResourceUserId aruid, std::int64_t holdType) NN_NOEXCEPT;
        nn::Result GetNpadJoyHoldType(nn::applet::AppletResourceUserId aruid, nn::sf::Out<std::int64_t> outValue) NN_NOEXCEPT;
        nn::Result SetNpadJoyAssignmentModeSingleByDefault(nn::applet::AppletResourceUserId aruid, nn::hid::NpadIdType id) NN_NOEXCEPT;
        nn::Result SetNpadJoyAssignmentModeSingle(nn::applet::AppletResourceUserId aruid, nn::hid::NpadIdType id, std::int64_t type) NN_NOEXCEPT;
        nn::Result SetNpadJoyAssignmentModeDual(nn::applet::AppletResourceUserId aruid, nn::hid::NpadIdType id) NN_NOEXCEPT;
        nn::Result MergeSingleJoyAsDualJoy(nn::applet::AppletResourceUserId aruid, nn::hid::NpadIdType id1, nn::hid::NpadIdType id2) NN_NOEXCEPT;
        nn::Result StartLrAssignmentMode(nn::applet::AppletResourceUserId aruid) NN_NOEXCEPT;
        nn::Result StopLrAssignmentMode(nn::applet::AppletResourceUserId aruid) NN_NOEXCEPT;
        nn::Result SetNpadHandheldActivationMode(nn::applet::AppletResourceUserId aruid, std::int64_t mode) NN_NOEXCEPT;
        nn::Result GetNpadHandheldActivationMode(nn::applet::AppletResourceUserId aruid, nn::sf::Out<std::int64_t> outValue) NN_NOEXCEPT;
        nn::Result SwapNpadAssignment(nn::applet::AppletResourceUserId aruid, nn::hid::NpadIdType id1, nn::hid::NpadIdType id2) NN_NOEXCEPT;
        nn::Result IsUnintendedHomeButtonInputProtectionEnabled(nn::sf::Out<bool> outIsEnabled, nn::applet::AppletResourceUserId aruid, nn::hid::NpadIdType id) NN_NOEXCEPT;
        nn::Result EnableUnintendedHomeButtonInputProtection(nn::applet::AppletResourceUserId aruid, nn::hid::NpadIdType id, bool enabled) NN_NOEXCEPT;
        nn::Result SetNpadJoyAssignmentModeSingleWithDestination(nn::sf::Out<bool> outIsAssigned, nn::sf::Out<nn::hid::NpadIdType> outId, nn::applet::AppletResourceUserId aruid, nn::hid::NpadIdType id, std::int64_t type) NN_NOEXCEPT;
        nn::Result GetVibrationDeviceInfo(nn::sf::Out<nn::hid::VibrationDeviceInfoForIpc> outValue, nn::hid::VibrationDeviceHandle handle) NN_NOEXCEPT;
        nn::Result SendVibrationValue(nn::applet::AppletResourceUserId aruid, nn::hid::VibrationDeviceHandle handle, const nn::hid::VibrationValue& value) NN_NOEXCEPT;
        nn::Result GetActualVibrationValue(nn::sf::Out<nn::hid::VibrationValue> outValue, nn::applet::AppletResourceUserId aruid, nn::hid::VibrationDeviceHandle handle) NN_NOEXCEPT;
        nn::Result CreateActiveVibrationDeviceList(nn::sf::Out<nn::sf::SharedPointer<nn::hid::IActiveVibrationDeviceList>> outValue) NN_NOEXCEPT;
        nn::Result PermitVibration(bool isPermitted) NN_NOEXCEPT;
        nn::Result IsVibrationPermitted(nn::sf::Out<bool> outValue) NN_NOEXCEPT;
        nn::Result SendVibrationValues(nn::applet::AppletResourceUserId aruid, const nn::sf::InArray<nn::hid::VibrationDeviceHandle>& handles, const nn::sf::InArray<nn::hid::VibrationValue>& values) NN_NOEXCEPT;
        nn::Result SendVibrationGcErmCommand(nn::applet::AppletResourceUserId aruid, nn::hid::VibrationDeviceHandle handle, nn::hid::VibrationGcErmCommand command) NN_NOEXCEPT;
        nn::Result GetActualVibrationGcErmCommand(nn::sf::Out<nn::hid::VibrationGcErmCommand> outValue, nn::applet::AppletResourceUserId aruid, nn::hid::VibrationDeviceHandle handle) NN_NOEXCEPT;
        nn::Result BeginPermitVibrationSession(nn::applet::AppletResourceUserId aruid) NN_NOEXCEPT;
        nn::Result EndPermitVibrationSession() NN_NOEXCEPT;
        nn::Result ActivateConsoleSixAxisSensor(nn::applet::AppletResourceUserId aruid) NN_NOEXCEPT;
        nn::Result StartConsoleSixAxisSensor(nn::applet::AppletResourceUserId aruid, nn::hid::ConsoleSixAxisSensorHandle handle) NN_NOEXCEPT;
        nn::Result StopConsoleSixAxisSensor(nn::applet::AppletResourceUserId aruid, nn::hid::ConsoleSixAxisSensorHandle handle) NN_NOEXCEPT;
        nn::Result ActivateSevenSixAxisSensor(nn::applet::AppletResourceUserId aruid) NN_NOEXCEPT;
        nn::Result StartSevenSixAxisSensor(nn::applet::AppletResourceUserId aruid) NN_NOEXCEPT;
        nn::Result StopSevenSixAxisSensor(nn::applet::AppletResourceUserId aruid) NN_NOEXCEPT;
        nn::Result InitializeSevenSixAxisSensor(nn::applet::AppletResourceUserId aruid, nn::sf::NativeHandle&& stateBufferHandle, std::uint64_t stateBufferSize, nn::sf::NativeHandle&& workBufferHandle, std::uint64_t workBufferSize) NN_NOEXCEPT;
        nn::Result FinalizeSevenSixAxisSensor(nn::applet::AppletResourceUserId aruid) NN_NOEXCEPT;
        nn::Result SetSevenSixAxisSensorFusionStrength(nn::applet::AppletResourceUserId aruid, float strength) NN_NOEXCEPT;
        nn::Result GetSevenSixAxisSensorFusionStrength(nn::sf::Out<float> strength, nn::applet::AppletResourceUserId aruid) NN_NOEXCEPT;
        nn::Result IsUsbFullKeyControllerEnabled(nn::sf::Out<bool> outIsEnabled) NN_NOEXCEPT;
        nn::Result EnableUsbFullKeyController(bool enabled) NN_NOEXCEPT;
        nn::Result IsUsbFullKeyControllerConnected(nn::sf::Out<bool> outIsConnected, nn::hid::NpadIdType id) NN_NOEXCEPT;
        nn::Result HasBattery(nn::sf::Out<bool> outHasBattery, nn::hid::NpadIdType id) NN_NOEXCEPT;
        nn::Result HasLeftRightBattery(nn::sf::Out<bool> outLeftJoyHasBattery, nn::sf::Out<bool> outRightJoyHasBattery, nn::hid::NpadIdType id) NN_NOEXCEPT;
        nn::Result GetNpadInterfaceType(nn::sf::Out<nn::hid::system::InterfaceType> outInterfaceType, nn::hid::NpadIdType id) NN_NOEXCEPT;
        nn::Result GetNpadLeftRightInterfaceType(nn::sf::Out<nn::hid::system::InterfaceType> outLeftJoyInterfaceType, nn::sf::Out<nn::hid::system::InterfaceType> outRightJoyInterfaceType, nn::hid::NpadIdType id) NN_NOEXCEPT;
        nn::Result GetPalmaConnectionHandle(nn::sf::Out<nn::hid::PalmaConnectionHandle> outHandle, nn::hid::NpadIdType id, nn::applet::AppletResourceUserId aruid) NN_NOEXCEPT;
        nn::Result InitializePalma(nn::hid::PalmaConnectionHandle handle) NN_NOEXCEPT;
        nn::Result AcquirePalmaOperationCompleteEvent(nn::sf::Out<nn::sf::NativeHandle> outValue, nn::hid::PalmaConnectionHandle handle) NN_NOEXCEPT;
        nn::Result GetPalmaOperationInfo(nn::sf::Out<std::uint64_t> outType, const nn::sf::OutBuffer& outBuffer, nn::hid::PalmaConnectionHandle handle) NN_NOEXCEPT;
        nn::Result PlayPalmaActivity(nn::hid::PalmaConnectionHandle handle, std::uint64_t index) NN_NOEXCEPT;
        nn::Result SetPalmaFrModeType(nn::hid::PalmaConnectionHandle handle, std::uint64_t type) NN_NOEXCEPT;
        nn::Result ReadPalmaStep(nn::hid::PalmaConnectionHandle handle) NN_NOEXCEPT;
        nn::Result EnablePalmaStep(nn::hid::PalmaConnectionHandle handle, bool isEnabled) NN_NOEXCEPT;
        nn::Result ResetPalmaStep(nn::hid::PalmaConnectionHandle handle) NN_NOEXCEPT;
        nn::Result ReadPalmaApplicationSection(nn::hid::PalmaConnectionHandle handle, std::uint64_t address, std::uint64_t size) NN_NOEXCEPT;
        nn::Result WritePalmaApplicationSection(nn::hid::PalmaConnectionHandle handle, std::uint64_t address, std::uint64_t size, const nn::hid::PalmaApplicationSectionAccessBuffer& buffer) NN_NOEXCEPT;
        nn::Result ReadPalmaUniqueCode(nn::hid::PalmaConnectionHandle handle) NN_NOEXCEPT;
        nn::Result SetPalmaUniqueCodeInvalid(nn::hid::PalmaConnectionHandle handle) NN_NOEXCEPT;
        nn::Result WritePalmaActivityEntry(nn::hid::PalmaConnectionHandle handle, std::uint64_t index, std::uint64_t ledIndex, std::uint64_t waveSet, std::uint64_t waveIndex) NN_NOEXCEPT;
        nn::Result WritePalmaRgbLedPatternEntry(nn::hid::PalmaConnectionHandle handle, std::uint64_t index, const nn::sf::InBuffer& pInBuffer) NN_NOEXCEPT;
        nn::Result WritePalmaWaveEntry(nn::hid::PalmaConnectionHandle handle, std::uint64_t waveSet, std::uint64_t index, nn::sf::NativeHandle&& transferMemoryHandle, std::uint64_t transferMemorySize, std::uint64_t waveDataSize) NN_NOEXCEPT;
        nn::Result SetPalmaDataBaseIdentificationVersion(nn::hid::PalmaConnectionHandle handle, std::int32_t version) NN_NOEXCEPT;
        nn::Result GetPalmaDataBaseIdentificationVersion(nn::hid::PalmaConnectionHandle handle) NN_NOEXCEPT;
        nn::Result SuspendPalmaFeature(nn::hid::PalmaConnectionHandle handle, nn::hid::PalmaFeatureSet suspendFeatureSet) NN_NOEXCEPT;
        nn::Result GetPalmaOperationResult(nn::hid::PalmaConnectionHandle handle) NN_NOEXCEPT;
        nn::Result ReadPalmaPlayLog(nn::hid::PalmaConnectionHandle handle, std::uint16_t index) NN_NOEXCEPT;
        nn::Result ResetPalmaPlayLog(nn::hid::PalmaConnectionHandle handle, std::uint16_t index) NN_NOEXCEPT;
        nn::Result SetIsPalmaAllConnectable(nn::applet::AppletResourceUserId aruid, bool connectable) NN_NOEXCEPT;
        nn::Result SetIsPalmaPairedConnectable(nn::applet::AppletResourceUserId aruid, bool connectable) NN_NOEXCEPT;
        nn::Result PairPalma(nn::hid::PalmaConnectionHandle handle) NN_NOEXCEPT;
        nn::Result SetPalmaBoostMode(bool enabled) NN_NOEXCEPT;
        nn::Result SetNpadCommunicationMode(nn::applet::AppletResourceUserId aruid, std::int64_t mode) NN_NOEXCEPT;
        nn::Result GetNpadCommunicationMode(nn::sf::Out<std::int64_t> outValue) NN_NOEXCEPT;
    };
#endif

}}

#if 0

// Template for implementation users
class Impl
{
public:
    nn::Result CreateAppletResource(nn::sf::Out<nn::sf::SharedPointer<nn::hid::IAppletResource>> outValue, nn::applet::AppletResourceUserId aruid) NN_NOEXCEPT;
    nn::Result ActivateDebugPad(nn::applet::AppletResourceUserId aruid) NN_NOEXCEPT;
    nn::Result ActivateTouchScreen(nn::applet::AppletResourceUserId aruid) NN_NOEXCEPT;
    nn::Result ActivateMouse(nn::applet::AppletResourceUserId aruid) NN_NOEXCEPT;
    nn::Result ActivateKeyboard(nn::applet::AppletResourceUserId aruid) NN_NOEXCEPT;
    nn::Result AcquireXpadIdEventHandle(nn::sf::Out<nn::sf::NativeHandle> outValue, std::uint64_t clientId) NN_NOEXCEPT;
    nn::Result ReleaseXpadIdEventHandle(std::uint64_t clientId) NN_NOEXCEPT;
    nn::Result ActivateXpad(nn::applet::AppletResourceUserId aruid, nn::hid::BasicXpadId xpadId) NN_NOEXCEPT;
    nn::Result GetXpadIds(nn::sf::Out<std::int64_t> outCount, const nn::sf::OutArray<nn::hid::BasicXpadId>& outXpadIds) NN_NOEXCEPT;
    nn::Result ActivateJoyXpad(nn::hid::JoyXpadId xpadId) NN_NOEXCEPT;
    nn::Result GetJoyXpadLifoHandle(nn::sf::Out<nn::sf::NativeHandle> outValue, nn::hid::JoyXpadId xpadId) NN_NOEXCEPT;
    nn::Result GetJoyXpadIds(nn::sf::Out<std::int64_t> outGotCount, const nn::sf::OutArray<nn::hid::JoyXpadId>& outXpadIds) NN_NOEXCEPT;
    nn::Result ActivateSixAxisSensor(nn::hid::BasicXpadId xpadId) NN_NOEXCEPT;
    nn::Result DeactivateSixAxisSensor(nn::hid::BasicXpadId xpadId) NN_NOEXCEPT;
    nn::Result GetSixAxisSensorLifoHandle(nn::sf::Out<nn::sf::NativeHandle> outValue, nn::hid::BasicXpadId xpadId) NN_NOEXCEPT;
    nn::Result ActivateJoySixAxisSensor(nn::hid::JoyXpadId xpadId) NN_NOEXCEPT;
    nn::Result DeactivateJoySixAxisSensor(nn::hid::JoyXpadId xpadId) NN_NOEXCEPT;
    nn::Result GetJoySixAxisSensorLifoHandle(nn::sf::Out<nn::sf::NativeHandle> outValue, nn::hid::JoyXpadId xpadId) NN_NOEXCEPT;
    nn::Result StartSixAxisSensor(nn::applet::AppletResourceUserId aruid, nn::hid::SixAxisSensorHandle handle) NN_NOEXCEPT;
    nn::Result StopSixAxisSensor(nn::applet::AppletResourceUserId aruid, nn::hid::SixAxisSensorHandle handle) NN_NOEXCEPT;
    nn::Result IsSixAxisSensorFusionEnabled(nn::sf::Out<bool> outIsEnabled, nn::applet::AppletResourceUserId aruid, nn::hid::SixAxisSensorHandle handle) NN_NOEXCEPT;
    nn::Result EnableSixAxisSensorFusion(nn::applet::AppletResourceUserId aruid, nn::hid::SixAxisSensorHandle handle, bool enable) NN_NOEXCEPT;
    nn::Result SetSixAxisSensorFusionParameters(nn::applet::AppletResourceUserId aruid, nn::hid::SixAxisSensorHandle handle, float revisePower, float reviseRange) NN_NOEXCEPT;
    nn::Result GetSixAxisSensorFusionParameters(nn::sf::Out<float> outRevisePower, nn::sf::Out<float> outReviseRange, nn::applet::AppletResourceUserId aruid, nn::hid::SixAxisSensorHandle handle) NN_NOEXCEPT;
    nn::Result ResetSixAxisSensorFusionParameters(nn::applet::AppletResourceUserId aruid, nn::hid::SixAxisSensorHandle handle) NN_NOEXCEPT;
    nn::Result SetAccelerometerParameters(nn::applet::AppletResourceUserId aruid, nn::hid::SixAxisSensorHandle handle, float playRadius, float sensitivity) NN_NOEXCEPT;
    nn::Result GetAccelerometerParameters(nn::sf::Out<float> outPlayRadius, nn::sf::Out<float> outSensitivity, nn::applet::AppletResourceUserId aruid, nn::hid::SixAxisSensorHandle handle) NN_NOEXCEPT;
    nn::Result ResetAccelerometerParameters(nn::applet::AppletResourceUserId aruid, nn::hid::SixAxisSensorHandle handle) NN_NOEXCEPT;
    nn::Result SetAccelerometerPlayMode(nn::applet::AppletResourceUserId aruid, nn::hid::SixAxisSensorHandle handle, std::uint32_t mode) NN_NOEXCEPT;
    nn::Result GetAccelerometerPlayMode(nn::sf::Out<std::uint32_t> outMode, nn::applet::AppletResourceUserId aruid, nn::hid::SixAxisSensorHandle handle) NN_NOEXCEPT;
    nn::Result ResetAccelerometerPlayMode(nn::applet::AppletResourceUserId aruid, nn::hid::SixAxisSensorHandle handle) NN_NOEXCEPT;
    nn::Result SetGyroscopeZeroDriftMode(nn::applet::AppletResourceUserId aruid, nn::hid::SixAxisSensorHandle handle, std::uint32_t mode) NN_NOEXCEPT;
    nn::Result GetGyroscopeZeroDriftMode(nn::sf::Out<std::uint32_t> outMode, nn::applet::AppletResourceUserId aruid, nn::hid::SixAxisSensorHandle handle) NN_NOEXCEPT;
    nn::Result ResetGyroscopeZeroDriftMode(nn::applet::AppletResourceUserId aruid, nn::hid::SixAxisSensorHandle handle) NN_NOEXCEPT;
    nn::Result IsSixAxisSensorAtRest(nn::sf::Out<bool> outIsAtRest, nn::applet::AppletResourceUserId aruid, nn::hid::SixAxisSensorHandle handle) NN_NOEXCEPT;
    nn::Result ActivateGesture(nn::applet::AppletResourceUserId aruid, std::int32_t version) NN_NOEXCEPT;
    nn::Result SetSupportedNpadStyleSet(nn::applet::AppletResourceUserId aruid, nn::hid::NpadStyleSet style) NN_NOEXCEPT;
    nn::Result GetSupportedNpadStyleSet(nn::applet::AppletResourceUserId aruid, nn::sf::Out<nn::hid::NpadStyleSet> outValue) NN_NOEXCEPT;
    nn::Result SetSupportedNpadIdType(nn::applet::AppletResourceUserId aruid, const nn::sf::InArray<nn::hid::NpadIdType>& ids) NN_NOEXCEPT;
    nn::Result ActivateNpad(nn::applet::AppletResourceUserId aruid) NN_NOEXCEPT;
    nn::Result DeactivateNpad(nn::applet::AppletResourceUserId aruid) NN_NOEXCEPT;
    nn::Result AcquireNpadStyleSetUpdateEventHandle(nn::applet::AppletResourceUserId aruid, nn::sf::Out<nn::sf::NativeHandle> outValue, nn::hid::NpadIdType id, std::uint64_t clientId) NN_NOEXCEPT;
    nn::Result DisconnectNpad(nn::applet::AppletResourceUserId aruid, nn::hid::NpadIdType id) NN_NOEXCEPT;
    nn::Result GetPlayerLedPattern(nn::sf::Out<std::uint64_t> outValue, nn::hid::NpadIdType id) NN_NOEXCEPT;
    nn::Result ActivateNpadWithRevision(nn::applet::AppletResourceUserId aruid, std::int32_t revision) NN_NOEXCEPT;
    nn::Result SetNpadJoyHoldType(nn::applet::AppletResourceUserId aruid, std::int64_t holdType) NN_NOEXCEPT;
    nn::Result GetNpadJoyHoldType(nn::applet::AppletResourceUserId aruid, nn::sf::Out<std::int64_t> outValue) NN_NOEXCEPT;
    nn::Result SetNpadJoyAssignmentModeSingleByDefault(nn::applet::AppletResourceUserId aruid, nn::hid::NpadIdType id) NN_NOEXCEPT;
    nn::Result SetNpadJoyAssignmentModeSingle(nn::applet::AppletResourceUserId aruid, nn::hid::NpadIdType id, std::int64_t type) NN_NOEXCEPT;
    nn::Result SetNpadJoyAssignmentModeDual(nn::applet::AppletResourceUserId aruid, nn::hid::NpadIdType id) NN_NOEXCEPT;
    nn::Result MergeSingleJoyAsDualJoy(nn::applet::AppletResourceUserId aruid, nn::hid::NpadIdType id1, nn::hid::NpadIdType id2) NN_NOEXCEPT;
    nn::Result StartLrAssignmentMode(nn::applet::AppletResourceUserId aruid) NN_NOEXCEPT;
    nn::Result StopLrAssignmentMode(nn::applet::AppletResourceUserId aruid) NN_NOEXCEPT;
    nn::Result SetNpadHandheldActivationMode(nn::applet::AppletResourceUserId aruid, std::int64_t mode) NN_NOEXCEPT;
    nn::Result GetNpadHandheldActivationMode(nn::applet::AppletResourceUserId aruid, nn::sf::Out<std::int64_t> outValue) NN_NOEXCEPT;
    nn::Result SwapNpadAssignment(nn::applet::AppletResourceUserId aruid, nn::hid::NpadIdType id1, nn::hid::NpadIdType id2) NN_NOEXCEPT;
    nn::Result IsUnintendedHomeButtonInputProtectionEnabled(nn::sf::Out<bool> outIsEnabled, nn::applet::AppletResourceUserId aruid, nn::hid::NpadIdType id) NN_NOEXCEPT;
    nn::Result EnableUnintendedHomeButtonInputProtection(nn::applet::AppletResourceUserId aruid, nn::hid::NpadIdType id, bool enabled) NN_NOEXCEPT;
    nn::Result SetNpadJoyAssignmentModeSingleWithDestination(nn::sf::Out<bool> outIsAssigned, nn::sf::Out<nn::hid::NpadIdType> outId, nn::applet::AppletResourceUserId aruid, nn::hid::NpadIdType id, std::int64_t type) NN_NOEXCEPT;
    nn::Result GetVibrationDeviceInfo(nn::sf::Out<nn::hid::VibrationDeviceInfoForIpc> outValue, nn::hid::VibrationDeviceHandle handle) NN_NOEXCEPT;
    nn::Result SendVibrationValue(nn::applet::AppletResourceUserId aruid, nn::hid::VibrationDeviceHandle handle, const nn::hid::VibrationValue& value) NN_NOEXCEPT;
    nn::Result GetActualVibrationValue(nn::sf::Out<nn::hid::VibrationValue> outValue, nn::applet::AppletResourceUserId aruid, nn::hid::VibrationDeviceHandle handle) NN_NOEXCEPT;
    nn::Result CreateActiveVibrationDeviceList(nn::sf::Out<nn::sf::SharedPointer<nn::hid::IActiveVibrationDeviceList>> outValue) NN_NOEXCEPT;
    nn::Result PermitVibration(bool isPermitted) NN_NOEXCEPT;
    nn::Result IsVibrationPermitted(nn::sf::Out<bool> outValue) NN_NOEXCEPT;
    nn::Result SendVibrationValues(nn::applet::AppletResourceUserId aruid, const nn::sf::InArray<nn::hid::VibrationDeviceHandle>& handles, const nn::sf::InArray<nn::hid::VibrationValue>& values) NN_NOEXCEPT;
    nn::Result SendVibrationGcErmCommand(nn::applet::AppletResourceUserId aruid, nn::hid::VibrationDeviceHandle handle, nn::hid::VibrationGcErmCommand command) NN_NOEXCEPT;
    nn::Result GetActualVibrationGcErmCommand(nn::sf::Out<nn::hid::VibrationGcErmCommand> outValue, nn::applet::AppletResourceUserId aruid, nn::hid::VibrationDeviceHandle handle) NN_NOEXCEPT;
    nn::Result BeginPermitVibrationSession(nn::applet::AppletResourceUserId aruid) NN_NOEXCEPT;
    nn::Result EndPermitVibrationSession() NN_NOEXCEPT;
    nn::Result ActivateConsoleSixAxisSensor(nn::applet::AppletResourceUserId aruid) NN_NOEXCEPT;
    nn::Result StartConsoleSixAxisSensor(nn::applet::AppletResourceUserId aruid, nn::hid::ConsoleSixAxisSensorHandle handle) NN_NOEXCEPT;
    nn::Result StopConsoleSixAxisSensor(nn::applet::AppletResourceUserId aruid, nn::hid::ConsoleSixAxisSensorHandle handle) NN_NOEXCEPT;
    nn::Result ActivateSevenSixAxisSensor(nn::applet::AppletResourceUserId aruid) NN_NOEXCEPT;
    nn::Result StartSevenSixAxisSensor(nn::applet::AppletResourceUserId aruid) NN_NOEXCEPT;
    nn::Result StopSevenSixAxisSensor(nn::applet::AppletResourceUserId aruid) NN_NOEXCEPT;
    nn::Result InitializeSevenSixAxisSensor(nn::applet::AppletResourceUserId aruid, nn::sf::NativeHandle&& stateBufferHandle, std::uint64_t stateBufferSize, nn::sf::NativeHandle&& workBufferHandle, std::uint64_t workBufferSize) NN_NOEXCEPT;
    nn::Result FinalizeSevenSixAxisSensor(nn::applet::AppletResourceUserId aruid) NN_NOEXCEPT;
    nn::Result SetSevenSixAxisSensorFusionStrength(nn::applet::AppletResourceUserId aruid, float strength) NN_NOEXCEPT;
    nn::Result GetSevenSixAxisSensorFusionStrength(nn::sf::Out<float> strength, nn::applet::AppletResourceUserId aruid) NN_NOEXCEPT;
    nn::Result IsUsbFullKeyControllerEnabled(nn::sf::Out<bool> outIsEnabled) NN_NOEXCEPT;
    nn::Result EnableUsbFullKeyController(bool enabled) NN_NOEXCEPT;
    nn::Result IsUsbFullKeyControllerConnected(nn::sf::Out<bool> outIsConnected, nn::hid::NpadIdType id) NN_NOEXCEPT;
    nn::Result HasBattery(nn::sf::Out<bool> outHasBattery, nn::hid::NpadIdType id) NN_NOEXCEPT;
    nn::Result HasLeftRightBattery(nn::sf::Out<bool> outLeftJoyHasBattery, nn::sf::Out<bool> outRightJoyHasBattery, nn::hid::NpadIdType id) NN_NOEXCEPT;
    nn::Result GetNpadInterfaceType(nn::sf::Out<nn::hid::system::InterfaceType> outInterfaceType, nn::hid::NpadIdType id) NN_NOEXCEPT;
    nn::Result GetNpadLeftRightInterfaceType(nn::sf::Out<nn::hid::system::InterfaceType> outLeftJoyInterfaceType, nn::sf::Out<nn::hid::system::InterfaceType> outRightJoyInterfaceType, nn::hid::NpadIdType id) NN_NOEXCEPT;
    nn::Result GetPalmaConnectionHandle(nn::sf::Out<nn::hid::PalmaConnectionHandle> outHandle, nn::hid::NpadIdType id, nn::applet::AppletResourceUserId aruid) NN_NOEXCEPT;
    nn::Result InitializePalma(nn::hid::PalmaConnectionHandle handle) NN_NOEXCEPT;
    nn::Result AcquirePalmaOperationCompleteEvent(nn::sf::Out<nn::sf::NativeHandle> outValue, nn::hid::PalmaConnectionHandle handle) NN_NOEXCEPT;
    nn::Result GetPalmaOperationInfo(nn::sf::Out<std::uint64_t> outType, const nn::sf::OutBuffer& outBuffer, nn::hid::PalmaConnectionHandle handle) NN_NOEXCEPT;
    nn::Result PlayPalmaActivity(nn::hid::PalmaConnectionHandle handle, std::uint64_t index) NN_NOEXCEPT;
    nn::Result SetPalmaFrModeType(nn::hid::PalmaConnectionHandle handle, std::uint64_t type) NN_NOEXCEPT;
    nn::Result ReadPalmaStep(nn::hid::PalmaConnectionHandle handle) NN_NOEXCEPT;
    nn::Result EnablePalmaStep(nn::hid::PalmaConnectionHandle handle, bool isEnabled) NN_NOEXCEPT;
    nn::Result ResetPalmaStep(nn::hid::PalmaConnectionHandle handle) NN_NOEXCEPT;
    nn::Result ReadPalmaApplicationSection(nn::hid::PalmaConnectionHandle handle, std::uint64_t address, std::uint64_t size) NN_NOEXCEPT;
    nn::Result WritePalmaApplicationSection(nn::hid::PalmaConnectionHandle handle, std::uint64_t address, std::uint64_t size, const nn::hid::PalmaApplicationSectionAccessBuffer& buffer) NN_NOEXCEPT;
    nn::Result ReadPalmaUniqueCode(nn::hid::PalmaConnectionHandle handle) NN_NOEXCEPT;
    nn::Result SetPalmaUniqueCodeInvalid(nn::hid::PalmaConnectionHandle handle) NN_NOEXCEPT;
    nn::Result WritePalmaActivityEntry(nn::hid::PalmaConnectionHandle handle, std::uint64_t index, std::uint64_t ledIndex, std::uint64_t waveSet, std::uint64_t waveIndex) NN_NOEXCEPT;
    nn::Result WritePalmaRgbLedPatternEntry(nn::hid::PalmaConnectionHandle handle, std::uint64_t index, const nn::sf::InBuffer& pInBuffer) NN_NOEXCEPT;
    nn::Result WritePalmaWaveEntry(nn::hid::PalmaConnectionHandle handle, std::uint64_t waveSet, std::uint64_t index, nn::sf::NativeHandle&& transferMemoryHandle, std::uint64_t transferMemorySize, std::uint64_t waveDataSize) NN_NOEXCEPT;
    nn::Result SetPalmaDataBaseIdentificationVersion(nn::hid::PalmaConnectionHandle handle, std::int32_t version) NN_NOEXCEPT;
    nn::Result GetPalmaDataBaseIdentificationVersion(nn::hid::PalmaConnectionHandle handle) NN_NOEXCEPT;
    nn::Result SuspendPalmaFeature(nn::hid::PalmaConnectionHandle handle, nn::hid::PalmaFeatureSet suspendFeatureSet) NN_NOEXCEPT;
    nn::Result GetPalmaOperationResult(nn::hid::PalmaConnectionHandle handle) NN_NOEXCEPT;
    nn::Result ReadPalmaPlayLog(nn::hid::PalmaConnectionHandle handle, std::uint16_t index) NN_NOEXCEPT;
    nn::Result ResetPalmaPlayLog(nn::hid::PalmaConnectionHandle handle, std::uint16_t index) NN_NOEXCEPT;
    nn::Result SetIsPalmaAllConnectable(nn::applet::AppletResourceUserId aruid, bool connectable) NN_NOEXCEPT;
    nn::Result SetIsPalmaPairedConnectable(nn::applet::AppletResourceUserId aruid, bool connectable) NN_NOEXCEPT;
    nn::Result PairPalma(nn::hid::PalmaConnectionHandle handle) NN_NOEXCEPT;
    nn::Result SetPalmaBoostMode(bool enabled) NN_NOEXCEPT;
    nn::Result SetNpadCommunicationMode(nn::applet::AppletResourceUserId aruid, std::int64_t mode) NN_NOEXCEPT;
    nn::Result GetNpadCommunicationMode(nn::sf::Out<std::int64_t> outValue) NN_NOEXCEPT;
};

#endif

NN_SF_IMPL_DETAIL_DEFINE_IMPL_TEMPLATE_BASE((::nn::hid::IHidServer))

    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(CreateAppletResource, (::nn::sf::Out<::nn::sf::SharedPointer<::nn::hid::IAppletResource>> outValue, ::nn::applet::AppletResourceUserId aruid))
    {
        NN_SF_IMPL_DETAIL_RETURN_IMPL_METHOD_RESULT_N(CreateAppletResource, (outValue, aruid));
    }

    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(ActivateDebugPad, (::nn::applet::AppletResourceUserId aruid))
    {
        NN_SF_IMPL_DETAIL_RETURN_IMPL_METHOD_RESULT_N(ActivateDebugPad, (aruid));
    }

    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(ActivateTouchScreen, (::nn::applet::AppletResourceUserId aruid))
    {
        NN_SF_IMPL_DETAIL_RETURN_IMPL_METHOD_RESULT_N(ActivateTouchScreen, (aruid));
    }

    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(ActivateMouse, (::nn::applet::AppletResourceUserId aruid))
    {
        NN_SF_IMPL_DETAIL_RETURN_IMPL_METHOD_RESULT_N(ActivateMouse, (aruid));
    }

    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(ActivateKeyboard, (::nn::applet::AppletResourceUserId aruid))
    {
        NN_SF_IMPL_DETAIL_RETURN_IMPL_METHOD_RESULT_N(ActivateKeyboard, (aruid));
    }

    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(AcquireXpadIdEventHandle, (::nn::sf::Out<::nn::sf::NativeHandle> outValue, ::std::uint64_t clientId))
    {
        NN_SF_IMPL_DETAIL_RETURN_IMPL_METHOD_RESULT_N(AcquireXpadIdEventHandle, (outValue, clientId));
    }

    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(ReleaseXpadIdEventHandle, (::std::uint64_t clientId))
    {
        NN_SF_IMPL_DETAIL_RETURN_IMPL_METHOD_RESULT_N(ReleaseXpadIdEventHandle, (clientId));
    }

    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(ActivateXpad, (::nn::applet::AppletResourceUserId aruid, ::nn::hid::BasicXpadId xpadId))
    {
        NN_SF_IMPL_DETAIL_RETURN_IMPL_METHOD_RESULT_N(ActivateXpad, (aruid, xpadId));
    }

    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(GetXpadIds, (::nn::sf::Out<::std::int64_t> outCount, const ::nn::sf::OutArray<::nn::hid::BasicXpadId>& outXpadIds))
    {
        NN_SF_IMPL_DETAIL_RETURN_IMPL_METHOD_RESULT_N(GetXpadIds, (outCount, outXpadIds));
    }

    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(ActivateJoyXpad, (::nn::hid::JoyXpadId xpadId))
    {
        NN_SF_IMPL_DETAIL_RETURN_IMPL_METHOD_RESULT_N(ActivateJoyXpad, (xpadId));
    }

    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(GetJoyXpadLifoHandle, (::nn::sf::Out<::nn::sf::NativeHandle> outValue, ::nn::hid::JoyXpadId xpadId))
    {
        NN_SF_IMPL_DETAIL_RETURN_IMPL_METHOD_RESULT_N(GetJoyXpadLifoHandle, (outValue, xpadId));
    }

    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(GetJoyXpadIds, (::nn::sf::Out<::std::int64_t> outGotCount, const ::nn::sf::OutArray<::nn::hid::JoyXpadId>& outXpadIds))
    {
        NN_SF_IMPL_DETAIL_RETURN_IMPL_METHOD_RESULT_N(GetJoyXpadIds, (outGotCount, outXpadIds));
    }

    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(ActivateSixAxisSensor, (::nn::hid::BasicXpadId xpadId))
    {
        NN_SF_IMPL_DETAIL_RETURN_IMPL_METHOD_RESULT_N(ActivateSixAxisSensor, (xpadId));
    }

    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(DeactivateSixAxisSensor, (::nn::hid::BasicXpadId xpadId))
    {
        NN_SF_IMPL_DETAIL_RETURN_IMPL_METHOD_RESULT_N(DeactivateSixAxisSensor, (xpadId));
    }

    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(GetSixAxisSensorLifoHandle, (::nn::sf::Out<::nn::sf::NativeHandle> outValue, ::nn::hid::BasicXpadId xpadId))
    {
        NN_SF_IMPL_DETAIL_RETURN_IMPL_METHOD_RESULT_N(GetSixAxisSensorLifoHandle, (outValue, xpadId));
    }

    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(ActivateJoySixAxisSensor, (::nn::hid::JoyXpadId xpadId))
    {
        NN_SF_IMPL_DETAIL_RETURN_IMPL_METHOD_RESULT_N(ActivateJoySixAxisSensor, (xpadId));
    }

    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(DeactivateJoySixAxisSensor, (::nn::hid::JoyXpadId xpadId))
    {
        NN_SF_IMPL_DETAIL_RETURN_IMPL_METHOD_RESULT_N(DeactivateJoySixAxisSensor, (xpadId));
    }

    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(GetJoySixAxisSensorLifoHandle, (::nn::sf::Out<::nn::sf::NativeHandle> outValue, ::nn::hid::JoyXpadId xpadId))
    {
        NN_SF_IMPL_DETAIL_RETURN_IMPL_METHOD_RESULT_N(GetJoySixAxisSensorLifoHandle, (outValue, xpadId));
    }

    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(StartSixAxisSensor, (::nn::applet::AppletResourceUserId aruid, ::nn::hid::SixAxisSensorHandle handle))
    {
        NN_SF_IMPL_DETAIL_RETURN_IMPL_METHOD_RESULT_N(StartSixAxisSensor, (aruid, handle));
    }

    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(StopSixAxisSensor, (::nn::applet::AppletResourceUserId aruid, ::nn::hid::SixAxisSensorHandle handle))
    {
        NN_SF_IMPL_DETAIL_RETURN_IMPL_METHOD_RESULT_N(StopSixAxisSensor, (aruid, handle));
    }

    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(IsSixAxisSensorFusionEnabled, (::nn::sf::Out<bool> outIsEnabled, ::nn::applet::AppletResourceUserId aruid, ::nn::hid::SixAxisSensorHandle handle))
    {
        NN_SF_IMPL_DETAIL_RETURN_IMPL_METHOD_RESULT_N(IsSixAxisSensorFusionEnabled, (outIsEnabled, aruid, handle));
    }

    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(EnableSixAxisSensorFusion, (::nn::applet::AppletResourceUserId aruid, ::nn::hid::SixAxisSensorHandle handle, bool enable))
    {
        NN_SF_IMPL_DETAIL_RETURN_IMPL_METHOD_RESULT_N(EnableSixAxisSensorFusion, (aruid, handle, enable));
    }

    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(SetSixAxisSensorFusionParameters, (::nn::applet::AppletResourceUserId aruid, ::nn::hid::SixAxisSensorHandle handle, float revisePower, float reviseRange))
    {
        NN_SF_IMPL_DETAIL_RETURN_IMPL_METHOD_RESULT_N(SetSixAxisSensorFusionParameters, (aruid, handle, revisePower, reviseRange));
    }

    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(GetSixAxisSensorFusionParameters, (::nn::sf::Out<float> outRevisePower, ::nn::sf::Out<float> outReviseRange, ::nn::applet::AppletResourceUserId aruid, ::nn::hid::SixAxisSensorHandle handle))
    {
        NN_SF_IMPL_DETAIL_RETURN_IMPL_METHOD_RESULT_N(GetSixAxisSensorFusionParameters, (outRevisePower, outReviseRange, aruid, handle));
    }

    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(ResetSixAxisSensorFusionParameters, (::nn::applet::AppletResourceUserId aruid, ::nn::hid::SixAxisSensorHandle handle))
    {
        NN_SF_IMPL_DETAIL_RETURN_IMPL_METHOD_RESULT_N(ResetSixAxisSensorFusionParameters, (aruid, handle));
    }

    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(SetAccelerometerParameters, (::nn::applet::AppletResourceUserId aruid, ::nn::hid::SixAxisSensorHandle handle, float playRadius, float sensitivity))
    {
        NN_SF_IMPL_DETAIL_RETURN_IMPL_METHOD_RESULT_N(SetAccelerometerParameters, (aruid, handle, playRadius, sensitivity));
    }

    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(GetAccelerometerParameters, (::nn::sf::Out<float> outPlayRadius, ::nn::sf::Out<float> outSensitivity, ::nn::applet::AppletResourceUserId aruid, ::nn::hid::SixAxisSensorHandle handle))
    {
        NN_SF_IMPL_DETAIL_RETURN_IMPL_METHOD_RESULT_N(GetAccelerometerParameters, (outPlayRadius, outSensitivity, aruid, handle));
    }

    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(ResetAccelerometerParameters, (::nn::applet::AppletResourceUserId aruid, ::nn::hid::SixAxisSensorHandle handle))
    {
        NN_SF_IMPL_DETAIL_RETURN_IMPL_METHOD_RESULT_N(ResetAccelerometerParameters, (aruid, handle));
    }

    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(SetAccelerometerPlayMode, (::nn::applet::AppletResourceUserId aruid, ::nn::hid::SixAxisSensorHandle handle, ::std::uint32_t mode))
    {
        NN_SF_IMPL_DETAIL_RETURN_IMPL_METHOD_RESULT_N(SetAccelerometerPlayMode, (aruid, handle, mode));
    }

    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(GetAccelerometerPlayMode, (::nn::sf::Out<::std::uint32_t> outMode, ::nn::applet::AppletResourceUserId aruid, ::nn::hid::SixAxisSensorHandle handle))
    {
        NN_SF_IMPL_DETAIL_RETURN_IMPL_METHOD_RESULT_N(GetAccelerometerPlayMode, (outMode, aruid, handle));
    }

    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(ResetAccelerometerPlayMode, (::nn::applet::AppletResourceUserId aruid, ::nn::hid::SixAxisSensorHandle handle))
    {
        NN_SF_IMPL_DETAIL_RETURN_IMPL_METHOD_RESULT_N(ResetAccelerometerPlayMode, (aruid, handle));
    }

    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(SetGyroscopeZeroDriftMode, (::nn::applet::AppletResourceUserId aruid, ::nn::hid::SixAxisSensorHandle handle, ::std::uint32_t mode))
    {
        NN_SF_IMPL_DETAIL_RETURN_IMPL_METHOD_RESULT_N(SetGyroscopeZeroDriftMode, (aruid, handle, mode));
    }

    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(GetGyroscopeZeroDriftMode, (::nn::sf::Out<::std::uint32_t> outMode, ::nn::applet::AppletResourceUserId aruid, ::nn::hid::SixAxisSensorHandle handle))
    {
        NN_SF_IMPL_DETAIL_RETURN_IMPL_METHOD_RESULT_N(GetGyroscopeZeroDriftMode, (outMode, aruid, handle));
    }

    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(ResetGyroscopeZeroDriftMode, (::nn::applet::AppletResourceUserId aruid, ::nn::hid::SixAxisSensorHandle handle))
    {
        NN_SF_IMPL_DETAIL_RETURN_IMPL_METHOD_RESULT_N(ResetGyroscopeZeroDriftMode, (aruid, handle));
    }

    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(IsSixAxisSensorAtRest, (::nn::sf::Out<bool> outIsAtRest, ::nn::applet::AppletResourceUserId aruid, ::nn::hid::SixAxisSensorHandle handle))
    {
        NN_SF_IMPL_DETAIL_RETURN_IMPL_METHOD_RESULT_N(IsSixAxisSensorAtRest, (outIsAtRest, aruid, handle));
    }

    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(ActivateGesture, (::nn::applet::AppletResourceUserId aruid, ::std::int32_t version))
    {
        NN_SF_IMPL_DETAIL_RETURN_IMPL_METHOD_RESULT_N(ActivateGesture, (aruid, version));
    }

    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(SetSupportedNpadStyleSet, (::nn::applet::AppletResourceUserId aruid, ::nn::hid::NpadStyleSet style))
    {
        NN_SF_IMPL_DETAIL_RETURN_IMPL_METHOD_RESULT_N(SetSupportedNpadStyleSet, (aruid, style));
    }

    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(GetSupportedNpadStyleSet, (::nn::applet::AppletResourceUserId aruid, ::nn::sf::Out<::nn::hid::NpadStyleSet> outValue))
    {
        NN_SF_IMPL_DETAIL_RETURN_IMPL_METHOD_RESULT_N(GetSupportedNpadStyleSet, (aruid, outValue));
    }

    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(SetSupportedNpadIdType, (::nn::applet::AppletResourceUserId aruid, const ::nn::sf::InArray<::nn::hid::NpadIdType>& ids))
    {
        NN_SF_IMPL_DETAIL_RETURN_IMPL_METHOD_RESULT_N(SetSupportedNpadIdType, (aruid, ids));
    }

    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(ActivateNpad, (::nn::applet::AppletResourceUserId aruid))
    {
        NN_SF_IMPL_DETAIL_RETURN_IMPL_METHOD_RESULT_N(ActivateNpad, (aruid));
    }

    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(DeactivateNpad, (::nn::applet::AppletResourceUserId aruid))
    {
        NN_SF_IMPL_DETAIL_RETURN_IMPL_METHOD_RESULT_N(DeactivateNpad, (aruid));
    }

    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(AcquireNpadStyleSetUpdateEventHandle, (::nn::applet::AppletResourceUserId aruid, ::nn::sf::Out<::nn::sf::NativeHandle> outValue, ::nn::hid::NpadIdType id, ::std::uint64_t clientId))
    {
        NN_SF_IMPL_DETAIL_RETURN_IMPL_METHOD_RESULT_N(AcquireNpadStyleSetUpdateEventHandle, (aruid, outValue, id, clientId));
    }

    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(DisconnectNpad, (::nn::applet::AppletResourceUserId aruid, ::nn::hid::NpadIdType id))
    {
        NN_SF_IMPL_DETAIL_RETURN_IMPL_METHOD_RESULT_N(DisconnectNpad, (aruid, id));
    }

    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(GetPlayerLedPattern, (::nn::sf::Out<::std::uint64_t> outValue, ::nn::hid::NpadIdType id))
    {
        NN_SF_IMPL_DETAIL_RETURN_IMPL_METHOD_RESULT_N(GetPlayerLedPattern, (outValue, id));
    }

    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(ActivateNpadWithRevision, (::nn::applet::AppletResourceUserId aruid, ::std::int32_t revision))
    {
        NN_SF_IMPL_DETAIL_RETURN_IMPL_METHOD_RESULT_N(ActivateNpadWithRevision, (aruid, revision));
    }

    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(SetNpadJoyHoldType, (::nn::applet::AppletResourceUserId aruid, ::std::int64_t holdType))
    {
        NN_SF_IMPL_DETAIL_RETURN_IMPL_METHOD_RESULT_N(SetNpadJoyHoldType, (aruid, holdType));
    }

    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(GetNpadJoyHoldType, (::nn::applet::AppletResourceUserId aruid, ::nn::sf::Out<::std::int64_t> outValue))
    {
        NN_SF_IMPL_DETAIL_RETURN_IMPL_METHOD_RESULT_N(GetNpadJoyHoldType, (aruid, outValue));
    }

    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(SetNpadJoyAssignmentModeSingleByDefault, (::nn::applet::AppletResourceUserId aruid, ::nn::hid::NpadIdType id))
    {
        NN_SF_IMPL_DETAIL_RETURN_IMPL_METHOD_RESULT_N(SetNpadJoyAssignmentModeSingleByDefault, (aruid, id));
    }

    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(SetNpadJoyAssignmentModeSingle, (::nn::applet::AppletResourceUserId aruid, ::nn::hid::NpadIdType id, ::std::int64_t type))
    {
        NN_SF_IMPL_DETAIL_RETURN_IMPL_METHOD_RESULT_N(SetNpadJoyAssignmentModeSingle, (aruid, id, type));
    }

    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(SetNpadJoyAssignmentModeDual, (::nn::applet::AppletResourceUserId aruid, ::nn::hid::NpadIdType id))
    {
        NN_SF_IMPL_DETAIL_RETURN_IMPL_METHOD_RESULT_N(SetNpadJoyAssignmentModeDual, (aruid, id));
    }

    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(MergeSingleJoyAsDualJoy, (::nn::applet::AppletResourceUserId aruid, ::nn::hid::NpadIdType id1, ::nn::hid::NpadIdType id2))
    {
        NN_SF_IMPL_DETAIL_RETURN_IMPL_METHOD_RESULT_N(MergeSingleJoyAsDualJoy, (aruid, id1, id2));
    }

    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(StartLrAssignmentMode, (::nn::applet::AppletResourceUserId aruid))
    {
        NN_SF_IMPL_DETAIL_RETURN_IMPL_METHOD_RESULT_N(StartLrAssignmentMode, (aruid));
    }

    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(StopLrAssignmentMode, (::nn::applet::AppletResourceUserId aruid))
    {
        NN_SF_IMPL_DETAIL_RETURN_IMPL_METHOD_RESULT_N(StopLrAssignmentMode, (aruid));
    }

    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(SetNpadHandheldActivationMode, (::nn::applet::AppletResourceUserId aruid, ::std::int64_t mode))
    {
        NN_SF_IMPL_DETAIL_RETURN_IMPL_METHOD_RESULT_N(SetNpadHandheldActivationMode, (aruid, mode));
    }

    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(GetNpadHandheldActivationMode, (::nn::applet::AppletResourceUserId aruid, ::nn::sf::Out<::std::int64_t> outValue))
    {
        NN_SF_IMPL_DETAIL_RETURN_IMPL_METHOD_RESULT_N(GetNpadHandheldActivationMode, (aruid, outValue));
    }

    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(SwapNpadAssignment, (::nn::applet::AppletResourceUserId aruid, ::nn::hid::NpadIdType id1, ::nn::hid::NpadIdType id2))
    {
        NN_SF_IMPL_DETAIL_RETURN_IMPL_METHOD_RESULT_N(SwapNpadAssignment, (aruid, id1, id2));
    }

    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(IsUnintendedHomeButtonInputProtectionEnabled, (::nn::sf::Out<bool> outIsEnabled, ::nn::applet::AppletResourceUserId aruid, ::nn::hid::NpadIdType id))
    {
        NN_SF_IMPL_DETAIL_RETURN_IMPL_METHOD_RESULT_N(IsUnintendedHomeButtonInputProtectionEnabled, (outIsEnabled, aruid, id));
    }

    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(EnableUnintendedHomeButtonInputProtection, (::nn::applet::AppletResourceUserId aruid, ::nn::hid::NpadIdType id, bool enabled))
    {
        NN_SF_IMPL_DETAIL_RETURN_IMPL_METHOD_RESULT_N(EnableUnintendedHomeButtonInputProtection, (aruid, id, enabled));
    }

    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(SetNpadJoyAssignmentModeSingleWithDestination, (::nn::sf::Out<bool> outIsAssigned, ::nn::sf::Out<::nn::hid::NpadIdType> outId, ::nn::applet::AppletResourceUserId aruid, ::nn::hid::NpadIdType id, ::std::int64_t type))
    {
        NN_SF_IMPL_DETAIL_RETURN_IMPL_METHOD_RESULT_N(SetNpadJoyAssignmentModeSingleWithDestination, (outIsAssigned, outId, aruid, id, type));
    }

    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(GetVibrationDeviceInfo, (::nn::sf::Out<::nn::hid::VibrationDeviceInfoForIpc> outValue, ::nn::hid::VibrationDeviceHandle handle))
    {
        NN_SF_IMPL_DETAIL_RETURN_IMPL_METHOD_RESULT_N(GetVibrationDeviceInfo, (outValue, handle));
    }

    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(SendVibrationValue, (::nn::applet::AppletResourceUserId aruid, ::nn::hid::VibrationDeviceHandle handle, const ::nn::hid::VibrationValue& value))
    {
        NN_SF_IMPL_DETAIL_RETURN_IMPL_METHOD_RESULT_N(SendVibrationValue, (aruid, handle, value));
    }

    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(GetActualVibrationValue, (::nn::sf::Out<::nn::hid::VibrationValue> outValue, ::nn::applet::AppletResourceUserId aruid, ::nn::hid::VibrationDeviceHandle handle))
    {
        NN_SF_IMPL_DETAIL_RETURN_IMPL_METHOD_RESULT_N(GetActualVibrationValue, (outValue, aruid, handle));
    }

    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(CreateActiveVibrationDeviceList, (::nn::sf::Out<::nn::sf::SharedPointer<::nn::hid::IActiveVibrationDeviceList>> outValue))
    {
        NN_SF_IMPL_DETAIL_RETURN_IMPL_METHOD_RESULT_N(CreateActiveVibrationDeviceList, (outValue));
    }

    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(PermitVibration, (bool isPermitted))
    {
        NN_SF_IMPL_DETAIL_RETURN_IMPL_METHOD_RESULT_N(PermitVibration, (isPermitted));
    }

    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(IsVibrationPermitted, (::nn::sf::Out<bool> outValue))
    {
        NN_SF_IMPL_DETAIL_RETURN_IMPL_METHOD_RESULT_N(IsVibrationPermitted, (outValue));
    }

    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(SendVibrationValues, (::nn::applet::AppletResourceUserId aruid, const ::nn::sf::InArray<::nn::hid::VibrationDeviceHandle>& handles, const ::nn::sf::InArray<::nn::hid::VibrationValue>& values))
    {
        NN_SF_IMPL_DETAIL_RETURN_IMPL_METHOD_RESULT_N(SendVibrationValues, (aruid, handles, values));
    }

    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(SendVibrationGcErmCommand, (::nn::applet::AppletResourceUserId aruid, ::nn::hid::VibrationDeviceHandle handle, ::nn::hid::VibrationGcErmCommand command))
    {
        NN_SF_IMPL_DETAIL_RETURN_IMPL_METHOD_RESULT_N(SendVibrationGcErmCommand, (aruid, handle, command));
    }

    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(GetActualVibrationGcErmCommand, (::nn::sf::Out<::nn::hid::VibrationGcErmCommand> outValue, ::nn::applet::AppletResourceUserId aruid, ::nn::hid::VibrationDeviceHandle handle))
    {
        NN_SF_IMPL_DETAIL_RETURN_IMPL_METHOD_RESULT_N(GetActualVibrationGcErmCommand, (outValue, aruid, handle));
    }

    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(BeginPermitVibrationSession, (::nn::applet::AppletResourceUserId aruid))
    {
        NN_SF_IMPL_DETAIL_RETURN_IMPL_METHOD_RESULT_N(BeginPermitVibrationSession, (aruid));
    }

    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_0(EndPermitVibrationSession)
    {
        NN_SF_IMPL_DETAIL_RETURN_IMPL_METHOD_RESULT_0(EndPermitVibrationSession);
    }

    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(ActivateConsoleSixAxisSensor, (::nn::applet::AppletResourceUserId aruid))
    {
        NN_SF_IMPL_DETAIL_RETURN_IMPL_METHOD_RESULT_N(ActivateConsoleSixAxisSensor, (aruid));
    }

    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(StartConsoleSixAxisSensor, (::nn::applet::AppletResourceUserId aruid, ::nn::hid::ConsoleSixAxisSensorHandle handle))
    {
        NN_SF_IMPL_DETAIL_RETURN_IMPL_METHOD_RESULT_N(StartConsoleSixAxisSensor, (aruid, handle));
    }

    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(StopConsoleSixAxisSensor, (::nn::applet::AppletResourceUserId aruid, ::nn::hid::ConsoleSixAxisSensorHandle handle))
    {
        NN_SF_IMPL_DETAIL_RETURN_IMPL_METHOD_RESULT_N(StopConsoleSixAxisSensor, (aruid, handle));
    }

    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(ActivateSevenSixAxisSensor, (::nn::applet::AppletResourceUserId aruid))
    {
        NN_SF_IMPL_DETAIL_RETURN_IMPL_METHOD_RESULT_N(ActivateSevenSixAxisSensor, (aruid));
    }

    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(StartSevenSixAxisSensor, (::nn::applet::AppletResourceUserId aruid))
    {
        NN_SF_IMPL_DETAIL_RETURN_IMPL_METHOD_RESULT_N(StartSevenSixAxisSensor, (aruid));
    }

    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(StopSevenSixAxisSensor, (::nn::applet::AppletResourceUserId aruid))
    {
        NN_SF_IMPL_DETAIL_RETURN_IMPL_METHOD_RESULT_N(StopSevenSixAxisSensor, (aruid));
    }

    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(InitializeSevenSixAxisSensor, (::nn::applet::AppletResourceUserId aruid, ::nn::sf::NativeHandle&& stateBufferHandle, ::std::uint64_t stateBufferSize, ::nn::sf::NativeHandle&& workBufferHandle, ::std::uint64_t workBufferSize))
    {
        NN_SF_IMPL_DETAIL_RETURN_IMPL_METHOD_RESULT_N(InitializeSevenSixAxisSensor, (aruid, ::std::move(stateBufferHandle), stateBufferSize, ::std::move(workBufferHandle), workBufferSize));
    }

    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(FinalizeSevenSixAxisSensor, (::nn::applet::AppletResourceUserId aruid))
    {
        NN_SF_IMPL_DETAIL_RETURN_IMPL_METHOD_RESULT_N(FinalizeSevenSixAxisSensor, (aruid));
    }

    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(SetSevenSixAxisSensorFusionStrength, (::nn::applet::AppletResourceUserId aruid, float strength))
    {
        NN_SF_IMPL_DETAIL_RETURN_IMPL_METHOD_RESULT_N(SetSevenSixAxisSensorFusionStrength, (aruid, strength));
    }

    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(GetSevenSixAxisSensorFusionStrength, (::nn::sf::Out<float> strength, ::nn::applet::AppletResourceUserId aruid))
    {
        NN_SF_IMPL_DETAIL_RETURN_IMPL_METHOD_RESULT_N(GetSevenSixAxisSensorFusionStrength, (strength, aruid));
    }

    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(IsUsbFullKeyControllerEnabled, (::nn::sf::Out<bool> outIsEnabled))
    {
        NN_SF_IMPL_DETAIL_RETURN_IMPL_METHOD_RESULT_N(IsUsbFullKeyControllerEnabled, (outIsEnabled));
    }

    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(EnableUsbFullKeyController, (bool enabled))
    {
        NN_SF_IMPL_DETAIL_RETURN_IMPL_METHOD_RESULT_N(EnableUsbFullKeyController, (enabled));
    }

    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(IsUsbFullKeyControllerConnected, (::nn::sf::Out<bool> outIsConnected, ::nn::hid::NpadIdType id))
    {
        NN_SF_IMPL_DETAIL_RETURN_IMPL_METHOD_RESULT_N(IsUsbFullKeyControllerConnected, (outIsConnected, id));
    }

    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(HasBattery, (::nn::sf::Out<bool> outHasBattery, ::nn::hid::NpadIdType id))
    {
        NN_SF_IMPL_DETAIL_RETURN_IMPL_METHOD_RESULT_N(HasBattery, (outHasBattery, id));
    }

    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(HasLeftRightBattery, (::nn::sf::Out<bool> outLeftJoyHasBattery, ::nn::sf::Out<bool> outRightJoyHasBattery, ::nn::hid::NpadIdType id))
    {
        NN_SF_IMPL_DETAIL_RETURN_IMPL_METHOD_RESULT_N(HasLeftRightBattery, (outLeftJoyHasBattery, outRightJoyHasBattery, id));
    }

    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(GetNpadInterfaceType, (::nn::sf::Out<::nn::hid::system::InterfaceType> outInterfaceType, ::nn::hid::NpadIdType id))
    {
        NN_SF_IMPL_DETAIL_RETURN_IMPL_METHOD_RESULT_N(GetNpadInterfaceType, (outInterfaceType, id));
    }

    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(GetNpadLeftRightInterfaceType, (::nn::sf::Out<::nn::hid::system::InterfaceType> outLeftJoyInterfaceType, ::nn::sf::Out<::nn::hid::system::InterfaceType> outRightJoyInterfaceType, ::nn::hid::NpadIdType id))
    {
        NN_SF_IMPL_DETAIL_RETURN_IMPL_METHOD_RESULT_N(GetNpadLeftRightInterfaceType, (outLeftJoyInterfaceType, outRightJoyInterfaceType, id));
    }

    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(GetPalmaConnectionHandle, (::nn::sf::Out<::nn::hid::PalmaConnectionHandle> outHandle, ::nn::hid::NpadIdType id, ::nn::applet::AppletResourceUserId aruid))
    {
        NN_SF_IMPL_DETAIL_RETURN_IMPL_METHOD_RESULT_N(GetPalmaConnectionHandle, (outHandle, id, aruid));
    }

    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(InitializePalma, (::nn::hid::PalmaConnectionHandle handle))
    {
        NN_SF_IMPL_DETAIL_RETURN_IMPL_METHOD_RESULT_N(InitializePalma, (handle));
    }

    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(AcquirePalmaOperationCompleteEvent, (::nn::sf::Out<::nn::sf::NativeHandle> outValue, ::nn::hid::PalmaConnectionHandle handle))
    {
        NN_SF_IMPL_DETAIL_RETURN_IMPL_METHOD_RESULT_N(AcquirePalmaOperationCompleteEvent, (outValue, handle));
    }

    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(GetPalmaOperationInfo, (::nn::sf::Out<::std::uint64_t> outType, const ::nn::sf::OutBuffer& outBuffer, ::nn::hid::PalmaConnectionHandle handle))
    {
        NN_SF_IMPL_DETAIL_RETURN_IMPL_METHOD_RESULT_N(GetPalmaOperationInfo, (outType, outBuffer, handle));
    }

    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(PlayPalmaActivity, (::nn::hid::PalmaConnectionHandle handle, ::std::uint64_t index))
    {
        NN_SF_IMPL_DETAIL_RETURN_IMPL_METHOD_RESULT_N(PlayPalmaActivity, (handle, index));
    }

    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(SetPalmaFrModeType, (::nn::hid::PalmaConnectionHandle handle, ::std::uint64_t type))
    {
        NN_SF_IMPL_DETAIL_RETURN_IMPL_METHOD_RESULT_N(SetPalmaFrModeType, (handle, type));
    }

    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(ReadPalmaStep, (::nn::hid::PalmaConnectionHandle handle))
    {
        NN_SF_IMPL_DETAIL_RETURN_IMPL_METHOD_RESULT_N(ReadPalmaStep, (handle));
    }

    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(EnablePalmaStep, (::nn::hid::PalmaConnectionHandle handle, bool isEnabled))
    {
        NN_SF_IMPL_DETAIL_RETURN_IMPL_METHOD_RESULT_N(EnablePalmaStep, (handle, isEnabled));
    }

    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(ResetPalmaStep, (::nn::hid::PalmaConnectionHandle handle))
    {
        NN_SF_IMPL_DETAIL_RETURN_IMPL_METHOD_RESULT_N(ResetPalmaStep, (handle));
    }

    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(ReadPalmaApplicationSection, (::nn::hid::PalmaConnectionHandle handle, ::std::uint64_t address, ::std::uint64_t size))
    {
        NN_SF_IMPL_DETAIL_RETURN_IMPL_METHOD_RESULT_N(ReadPalmaApplicationSection, (handle, address, size));
    }

    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(WritePalmaApplicationSection, (::nn::hid::PalmaConnectionHandle handle, ::std::uint64_t address, ::std::uint64_t size, const ::nn::hid::PalmaApplicationSectionAccessBuffer& buffer))
    {
        NN_SF_IMPL_DETAIL_RETURN_IMPL_METHOD_RESULT_N(WritePalmaApplicationSection, (handle, address, size, buffer));
    }

    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(ReadPalmaUniqueCode, (::nn::hid::PalmaConnectionHandle handle))
    {
        NN_SF_IMPL_DETAIL_RETURN_IMPL_METHOD_RESULT_N(ReadPalmaUniqueCode, (handle));
    }

    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(SetPalmaUniqueCodeInvalid, (::nn::hid::PalmaConnectionHandle handle))
    {
        NN_SF_IMPL_DETAIL_RETURN_IMPL_METHOD_RESULT_N(SetPalmaUniqueCodeInvalid, (handle));
    }

    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(WritePalmaActivityEntry, (::nn::hid::PalmaConnectionHandle handle, ::std::uint64_t index, ::std::uint64_t ledIndex, ::std::uint64_t waveSet, ::std::uint64_t waveIndex))
    {
        NN_SF_IMPL_DETAIL_RETURN_IMPL_METHOD_RESULT_N(WritePalmaActivityEntry, (handle, index, ledIndex, waveSet, waveIndex));
    }

    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(WritePalmaRgbLedPatternEntry, (::nn::hid::PalmaConnectionHandle handle, ::std::uint64_t index, const ::nn::sf::InBuffer& pInBuffer))
    {
        NN_SF_IMPL_DETAIL_RETURN_IMPL_METHOD_RESULT_N(WritePalmaRgbLedPatternEntry, (handle, index, pInBuffer));
    }

    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(WritePalmaWaveEntry, (::nn::hid::PalmaConnectionHandle handle, ::std::uint64_t waveSet, ::std::uint64_t index, ::nn::sf::NativeHandle&& transferMemoryHandle, ::std::uint64_t transferMemorySize, ::std::uint64_t waveDataSize))
    {
        NN_SF_IMPL_DETAIL_RETURN_IMPL_METHOD_RESULT_N(WritePalmaWaveEntry, (handle, waveSet, index, ::std::move(transferMemoryHandle), transferMemorySize, waveDataSize));
    }

    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(SetPalmaDataBaseIdentificationVersion, (::nn::hid::PalmaConnectionHandle handle, ::std::int32_t version))
    {
        NN_SF_IMPL_DETAIL_RETURN_IMPL_METHOD_RESULT_N(SetPalmaDataBaseIdentificationVersion, (handle, version));
    }

    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(GetPalmaDataBaseIdentificationVersion, (::nn::hid::PalmaConnectionHandle handle))
    {
        NN_SF_IMPL_DETAIL_RETURN_IMPL_METHOD_RESULT_N(GetPalmaDataBaseIdentificationVersion, (handle));
    }

    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(SuspendPalmaFeature, (::nn::hid::PalmaConnectionHandle handle, ::nn::hid::PalmaFeatureSet suspendFeatureSet))
    {
        NN_SF_IMPL_DETAIL_RETURN_IMPL_METHOD_RESULT_N(SuspendPalmaFeature, (handle, suspendFeatureSet));
    }

    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(GetPalmaOperationResult, (::nn::hid::PalmaConnectionHandle handle))
    {
        NN_SF_IMPL_DETAIL_RETURN_IMPL_METHOD_RESULT_N(GetPalmaOperationResult, (handle));
    }

    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(ReadPalmaPlayLog, (::nn::hid::PalmaConnectionHandle handle, ::std::uint16_t index))
    {
        NN_SF_IMPL_DETAIL_RETURN_IMPL_METHOD_RESULT_N(ReadPalmaPlayLog, (handle, index));
    }

    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(ResetPalmaPlayLog, (::nn::hid::PalmaConnectionHandle handle, ::std::uint16_t index))
    {
        NN_SF_IMPL_DETAIL_RETURN_IMPL_METHOD_RESULT_N(ResetPalmaPlayLog, (handle, index));
    }

    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(SetIsPalmaAllConnectable, (::nn::applet::AppletResourceUserId aruid, bool connectable))
    {
        NN_SF_IMPL_DETAIL_RETURN_IMPL_METHOD_RESULT_N(SetIsPalmaAllConnectable, (aruid, connectable));
    }

    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(SetIsPalmaPairedConnectable, (::nn::applet::AppletResourceUserId aruid, bool connectable))
    {
        NN_SF_IMPL_DETAIL_RETURN_IMPL_METHOD_RESULT_N(SetIsPalmaPairedConnectable, (aruid, connectable));
    }

    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(PairPalma, (::nn::hid::PalmaConnectionHandle handle))
    {
        NN_SF_IMPL_DETAIL_RETURN_IMPL_METHOD_RESULT_N(PairPalma, (handle));
    }

    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(SetPalmaBoostMode, (bool enabled))
    {
        NN_SF_IMPL_DETAIL_RETURN_IMPL_METHOD_RESULT_N(SetPalmaBoostMode, (enabled));
    }

    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(SetNpadCommunicationMode, (::nn::applet::AppletResourceUserId aruid, ::std::int64_t mode))
    {
        NN_SF_IMPL_DETAIL_RETURN_IMPL_METHOD_RESULT_N(SetNpadCommunicationMode, (aruid, mode));
    }

    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(GetNpadCommunicationMode, (::nn::sf::Out<::std::int64_t> outValue))
    {
        NN_SF_IMPL_DETAIL_RETURN_IMPL_METHOD_RESULT_N(GetNpadCommunicationMode, (outValue));
    }

NN_SF_IMPL_DETAIL_DEFINE_IMPL_TEMPLATE_BASE_END

// template <> struct nn::sf::cmif::detail::MethodInfos<nn::hid::IHidServer>
NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFOS((::nn::hid::IHidServer))

    // nn::Result CreateAppletResource(nn::sf::Out<nn::sf::SharedPointer<nn::hid::IAppletResource>> outValue, nn::applet::AppletResourceUserId aruid) NN_NOEXCEPT
    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO(CreateAppletResource)

        NN_SF_CMIF_DETAIL_METHOD_INFO_METHOD_ID(0)
        NN_SF_CMIF_DETAIL_METHOD_INFO_RETURN_TYPE_IS_RESULT(true)

        NN_SF_CMIF_DETAIL_METHOD_INFO_IN_PROCESS_ID_ENABLE()

        NN_SF_CMIF_DETAIL_METHOD_INFO_OUT_OBJECT_COUNT(1)
        NN_SF_CMIF_DETAIL_METHOD_INFO_OUT_OBJECT_INFOS
            NN_SF_CMIF_DETAIL_METHOD_INFO_OUT_OBJECT_INFO(outValue, 0, 0)
        NN_SF_CMIF_DETAIL_METHOD_INFO_OUT_OBJECT_INFOS_END(1, (outValue))

        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_MEMBER(aruid, (::nn::applet::AppletResourceUserId), 0)
        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_END(1, (aruid))
        NN_SF_CMIF_DETAIL_METHOD_INFO_IN_RAW_SIZE(8)

        NN_SF_CMIF_DETAIL_METHOD_INFO_ARGUMENT_INFOS((NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(outValue), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(aruid)))

    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO_END(CreateAppletResource)

    // nn::Result ActivateDebugPad(nn::applet::AppletResourceUserId aruid) NN_NOEXCEPT
    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO(ActivateDebugPad)

        NN_SF_CMIF_DETAIL_METHOD_INFO_METHOD_ID(1)
        NN_SF_CMIF_DETAIL_METHOD_INFO_RETURN_TYPE_IS_RESULT(true)

        NN_SF_CMIF_DETAIL_METHOD_INFO_IN_PROCESS_ID_ENABLE()

        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_MEMBER(aruid, (::nn::applet::AppletResourceUserId), 0)
        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_END(1, (aruid))
        NN_SF_CMIF_DETAIL_METHOD_INFO_IN_RAW_SIZE(8)

        NN_SF_CMIF_DETAIL_METHOD_INFO_ARGUMENT_INFOS((NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(aruid)))

    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO_END(ActivateDebugPad)

    // nn::Result ActivateTouchScreen(nn::applet::AppletResourceUserId aruid) NN_NOEXCEPT
    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO(ActivateTouchScreen)

        NN_SF_CMIF_DETAIL_METHOD_INFO_METHOD_ID(11)
        NN_SF_CMIF_DETAIL_METHOD_INFO_RETURN_TYPE_IS_RESULT(true)

        NN_SF_CMIF_DETAIL_METHOD_INFO_IN_PROCESS_ID_ENABLE()

        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_MEMBER(aruid, (::nn::applet::AppletResourceUserId), 0)
        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_END(1, (aruid))
        NN_SF_CMIF_DETAIL_METHOD_INFO_IN_RAW_SIZE(8)

        NN_SF_CMIF_DETAIL_METHOD_INFO_ARGUMENT_INFOS((NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(aruid)))

    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO_END(ActivateTouchScreen)

    // nn::Result ActivateMouse(nn::applet::AppletResourceUserId aruid) NN_NOEXCEPT
    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO(ActivateMouse)

        NN_SF_CMIF_DETAIL_METHOD_INFO_METHOD_ID(21)
        NN_SF_CMIF_DETAIL_METHOD_INFO_RETURN_TYPE_IS_RESULT(true)

        NN_SF_CMIF_DETAIL_METHOD_INFO_IN_PROCESS_ID_ENABLE()

        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_MEMBER(aruid, (::nn::applet::AppletResourceUserId), 0)
        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_END(1, (aruid))
        NN_SF_CMIF_DETAIL_METHOD_INFO_IN_RAW_SIZE(8)

        NN_SF_CMIF_DETAIL_METHOD_INFO_ARGUMENT_INFOS((NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(aruid)))

    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO_END(ActivateMouse)

    // nn::Result ActivateKeyboard(nn::applet::AppletResourceUserId aruid) NN_NOEXCEPT
    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO(ActivateKeyboard)

        NN_SF_CMIF_DETAIL_METHOD_INFO_METHOD_ID(31)
        NN_SF_CMIF_DETAIL_METHOD_INFO_RETURN_TYPE_IS_RESULT(true)

        NN_SF_CMIF_DETAIL_METHOD_INFO_IN_PROCESS_ID_ENABLE()

        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_MEMBER(aruid, (::nn::applet::AppletResourceUserId), 0)
        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_END(1, (aruid))
        NN_SF_CMIF_DETAIL_METHOD_INFO_IN_RAW_SIZE(8)

        NN_SF_CMIF_DETAIL_METHOD_INFO_ARGUMENT_INFOS((NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(aruid)))

    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO_END(ActivateKeyboard)

    // nn::Result AcquireXpadIdEventHandle(nn::sf::Out<nn::sf::NativeHandle> outValue, std::uint64_t clientId) NN_NOEXCEPT
    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO(AcquireXpadIdEventHandle)

        NN_SF_CMIF_DETAIL_METHOD_INFO_METHOD_ID(40)
        NN_SF_CMIF_DETAIL_METHOD_INFO_RETURN_TYPE_IS_RESULT(true)

        NN_SF_CMIF_DETAIL_METHOD_INFO_OUT_NATIVE_HANDLE_COUNT(1)
        NN_SF_CMIF_DETAIL_METHOD_INFO_OUT_NATIVE_HANDLE_INFOS
            NN_SF_CMIF_DETAIL_METHOD_INFO_OUT_NATIVE_HANDLE_INFO(outValue, 0, NN_SF_CMIF_DETAIL_NATIVE_HANDLE_ATTRIBUTE_HIPC_COPY)
        NN_SF_CMIF_DETAIL_METHOD_INFO_OUT_NATIVE_HANDLE_INFOS_END(1, (outValue))

        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_MEMBER(clientId, (::std::uint64_t), 0)
        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_END(1, (clientId))
        NN_SF_CMIF_DETAIL_METHOD_INFO_IN_RAW_SIZE(8)

        NN_SF_CMIF_DETAIL_METHOD_INFO_ARGUMENT_INFOS((NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(outValue), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(clientId)))

    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO_END(AcquireXpadIdEventHandle)

    // nn::Result ReleaseXpadIdEventHandle(std::uint64_t clientId) NN_NOEXCEPT
    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO(ReleaseXpadIdEventHandle)

        NN_SF_CMIF_DETAIL_METHOD_INFO_METHOD_ID(41)
        NN_SF_CMIF_DETAIL_METHOD_INFO_RETURN_TYPE_IS_RESULT(true)

        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_MEMBER(clientId, (::std::uint64_t), 0)
        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_END(1, (clientId))
        NN_SF_CMIF_DETAIL_METHOD_INFO_IN_RAW_SIZE(8)

        NN_SF_CMIF_DETAIL_METHOD_INFO_ARGUMENT_INFOS((NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(clientId)))

    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO_END(ReleaseXpadIdEventHandle)

    // nn::Result ActivateXpad(nn::applet::AppletResourceUserId aruid, nn::hid::BasicXpadId xpadId) NN_NOEXCEPT
    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO(ActivateXpad)

        NN_SF_CMIF_DETAIL_METHOD_INFO_METHOD_ID(51)
        NN_SF_CMIF_DETAIL_METHOD_INFO_RETURN_TYPE_IS_RESULT(true)

        NN_SF_CMIF_DETAIL_METHOD_INFO_IN_PROCESS_ID_ENABLE()

        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_MEMBER(xpadId, (::nn::hid::BasicXpadId), 0)
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_MEMBER(aruid, (::nn::applet::AppletResourceUserId), 8)
        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_END(2, (xpadId, aruid))
        NN_SF_CMIF_DETAIL_METHOD_INFO_IN_RAW_SIZE(16)

        NN_SF_CMIF_DETAIL_METHOD_INFO_ARGUMENT_INFOS((NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(aruid), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(xpadId)))

    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO_END(ActivateXpad)

    // nn::Result GetXpadIds(nn::sf::Out<std::int64_t> outCount, const nn::sf::OutArray<nn::hid::BasicXpadId>& outXpadIds) NN_NOEXCEPT
    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO(GetXpadIds)

        NN_SF_CMIF_DETAIL_METHOD_INFO_METHOD_ID(55)
        NN_SF_CMIF_DETAIL_METHOD_INFO_RETURN_TYPE_IS_RESULT(true)

        NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_COUNT(1)
        NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_INFOS
            NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_INFO(outXpadIds, 0, (const ::nn::sf::OutArray<::nn::hid::BasicXpadId>&), NN_SF_CMIF_DETAIL_BUFFER_ATTRIBUTE_OUT | NN_SF_CMIF_DETAIL_BUFFER_ATTRIBUTE_HIPC_POINTER)
        NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_INFOS_END(1, (outXpadIds))

        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT_MEMBER(outCount, (::std::int64_t), 0)
        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT_END(1, (outCount))
        NN_SF_CMIF_DETAIL_METHOD_INFO_OUT_RAW_SIZE(8)

        NN_SF_CMIF_DETAIL_METHOD_INFO_ARGUMENT_INFOS((NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(outCount), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(outXpadIds)))

    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO_END(GetXpadIds)

    // nn::Result ActivateJoyXpad(nn::hid::JoyXpadId xpadId) NN_NOEXCEPT
    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO(ActivateJoyXpad)

        NN_SF_CMIF_DETAIL_METHOD_INFO_METHOD_ID(56)
        NN_SF_CMIF_DETAIL_METHOD_INFO_RETURN_TYPE_IS_RESULT(true)

        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_MEMBER(xpadId, (::nn::hid::JoyXpadId), 0)
        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_END(1, (xpadId))
        NN_SF_CMIF_DETAIL_METHOD_INFO_IN_RAW_SIZE(4)

        NN_SF_CMIF_DETAIL_METHOD_INFO_ARGUMENT_INFOS((NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(xpadId)))

    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO_END(ActivateJoyXpad)

    // nn::Result GetJoyXpadLifoHandle(nn::sf::Out<nn::sf::NativeHandle> outValue, nn::hid::JoyXpadId xpadId) NN_NOEXCEPT
    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO(GetJoyXpadLifoHandle)

        NN_SF_CMIF_DETAIL_METHOD_INFO_METHOD_ID(58)
        NN_SF_CMIF_DETAIL_METHOD_INFO_RETURN_TYPE_IS_RESULT(true)

        NN_SF_CMIF_DETAIL_METHOD_INFO_OUT_NATIVE_HANDLE_COUNT(1)
        NN_SF_CMIF_DETAIL_METHOD_INFO_OUT_NATIVE_HANDLE_INFOS
            NN_SF_CMIF_DETAIL_METHOD_INFO_OUT_NATIVE_HANDLE_INFO(outValue, 0, NN_SF_CMIF_DETAIL_NATIVE_HANDLE_ATTRIBUTE_HIPC_COPY)
        NN_SF_CMIF_DETAIL_METHOD_INFO_OUT_NATIVE_HANDLE_INFOS_END(1, (outValue))

        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_MEMBER(xpadId, (::nn::hid::JoyXpadId), 0)
        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_END(1, (xpadId))
        NN_SF_CMIF_DETAIL_METHOD_INFO_IN_RAW_SIZE(4)

        NN_SF_CMIF_DETAIL_METHOD_INFO_ARGUMENT_INFOS((NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(outValue), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(xpadId)))

    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO_END(GetJoyXpadLifoHandle)

    // nn::Result GetJoyXpadIds(nn::sf::Out<std::int64_t> outGotCount, const nn::sf::OutArray<nn::hid::JoyXpadId>& outXpadIds) NN_NOEXCEPT
    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO(GetJoyXpadIds)

        NN_SF_CMIF_DETAIL_METHOD_INFO_METHOD_ID(59)
        NN_SF_CMIF_DETAIL_METHOD_INFO_RETURN_TYPE_IS_RESULT(true)

        NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_COUNT(1)
        NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_INFOS
            NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_INFO(outXpadIds, 0, (const ::nn::sf::OutArray<::nn::hid::JoyXpadId>&), NN_SF_CMIF_DETAIL_BUFFER_ATTRIBUTE_OUT | NN_SF_CMIF_DETAIL_BUFFER_ATTRIBUTE_HIPC_POINTER)
        NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_INFOS_END(1, (outXpadIds))

        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT_MEMBER(outGotCount, (::std::int64_t), 0)
        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT_END(1, (outGotCount))
        NN_SF_CMIF_DETAIL_METHOD_INFO_OUT_RAW_SIZE(8)

        NN_SF_CMIF_DETAIL_METHOD_INFO_ARGUMENT_INFOS((NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(outGotCount), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(outXpadIds)))

    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO_END(GetJoyXpadIds)

    // nn::Result ActivateSixAxisSensor(nn::hid::BasicXpadId xpadId) NN_NOEXCEPT
    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO(ActivateSixAxisSensor)

        NN_SF_CMIF_DETAIL_METHOD_INFO_METHOD_ID(60)
        NN_SF_CMIF_DETAIL_METHOD_INFO_RETURN_TYPE_IS_RESULT(true)

        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_MEMBER(xpadId, (::nn::hid::BasicXpadId), 0)
        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_END(1, (xpadId))
        NN_SF_CMIF_DETAIL_METHOD_INFO_IN_RAW_SIZE(4)

        NN_SF_CMIF_DETAIL_METHOD_INFO_ARGUMENT_INFOS((NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(xpadId)))

    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO_END(ActivateSixAxisSensor)

    // nn::Result DeactivateSixAxisSensor(nn::hid::BasicXpadId xpadId) NN_NOEXCEPT
    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO(DeactivateSixAxisSensor)

        NN_SF_CMIF_DETAIL_METHOD_INFO_METHOD_ID(61)
        NN_SF_CMIF_DETAIL_METHOD_INFO_RETURN_TYPE_IS_RESULT(true)

        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_MEMBER(xpadId, (::nn::hid::BasicXpadId), 0)
        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_END(1, (xpadId))
        NN_SF_CMIF_DETAIL_METHOD_INFO_IN_RAW_SIZE(4)

        NN_SF_CMIF_DETAIL_METHOD_INFO_ARGUMENT_INFOS((NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(xpadId)))

    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO_END(DeactivateSixAxisSensor)

    // nn::Result GetSixAxisSensorLifoHandle(nn::sf::Out<nn::sf::NativeHandle> outValue, nn::hid::BasicXpadId xpadId) NN_NOEXCEPT
    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO(GetSixAxisSensorLifoHandle)

        NN_SF_CMIF_DETAIL_METHOD_INFO_METHOD_ID(62)
        NN_SF_CMIF_DETAIL_METHOD_INFO_RETURN_TYPE_IS_RESULT(true)

        NN_SF_CMIF_DETAIL_METHOD_INFO_OUT_NATIVE_HANDLE_COUNT(1)
        NN_SF_CMIF_DETAIL_METHOD_INFO_OUT_NATIVE_HANDLE_INFOS
            NN_SF_CMIF_DETAIL_METHOD_INFO_OUT_NATIVE_HANDLE_INFO(outValue, 0, NN_SF_CMIF_DETAIL_NATIVE_HANDLE_ATTRIBUTE_HIPC_COPY)
        NN_SF_CMIF_DETAIL_METHOD_INFO_OUT_NATIVE_HANDLE_INFOS_END(1, (outValue))

        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_MEMBER(xpadId, (::nn::hid::BasicXpadId), 0)
        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_END(1, (xpadId))
        NN_SF_CMIF_DETAIL_METHOD_INFO_IN_RAW_SIZE(4)

        NN_SF_CMIF_DETAIL_METHOD_INFO_ARGUMENT_INFOS((NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(outValue), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(xpadId)))

    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO_END(GetSixAxisSensorLifoHandle)

    // nn::Result ActivateJoySixAxisSensor(nn::hid::JoyXpadId xpadId) NN_NOEXCEPT
    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO(ActivateJoySixAxisSensor)

        NN_SF_CMIF_DETAIL_METHOD_INFO_METHOD_ID(63)
        NN_SF_CMIF_DETAIL_METHOD_INFO_RETURN_TYPE_IS_RESULT(true)

        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_MEMBER(xpadId, (::nn::hid::JoyXpadId), 0)
        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_END(1, (xpadId))
        NN_SF_CMIF_DETAIL_METHOD_INFO_IN_RAW_SIZE(4)

        NN_SF_CMIF_DETAIL_METHOD_INFO_ARGUMENT_INFOS((NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(xpadId)))

    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO_END(ActivateJoySixAxisSensor)

    // nn::Result DeactivateJoySixAxisSensor(nn::hid::JoyXpadId xpadId) NN_NOEXCEPT
    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO(DeactivateJoySixAxisSensor)

        NN_SF_CMIF_DETAIL_METHOD_INFO_METHOD_ID(64)
        NN_SF_CMIF_DETAIL_METHOD_INFO_RETURN_TYPE_IS_RESULT(true)

        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_MEMBER(xpadId, (::nn::hid::JoyXpadId), 0)
        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_END(1, (xpadId))
        NN_SF_CMIF_DETAIL_METHOD_INFO_IN_RAW_SIZE(4)

        NN_SF_CMIF_DETAIL_METHOD_INFO_ARGUMENT_INFOS((NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(xpadId)))

    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO_END(DeactivateJoySixAxisSensor)

    // nn::Result GetJoySixAxisSensorLifoHandle(nn::sf::Out<nn::sf::NativeHandle> outValue, nn::hid::JoyXpadId xpadId) NN_NOEXCEPT
    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO(GetJoySixAxisSensorLifoHandle)

        NN_SF_CMIF_DETAIL_METHOD_INFO_METHOD_ID(65)
        NN_SF_CMIF_DETAIL_METHOD_INFO_RETURN_TYPE_IS_RESULT(true)

        NN_SF_CMIF_DETAIL_METHOD_INFO_OUT_NATIVE_HANDLE_COUNT(1)
        NN_SF_CMIF_DETAIL_METHOD_INFO_OUT_NATIVE_HANDLE_INFOS
            NN_SF_CMIF_DETAIL_METHOD_INFO_OUT_NATIVE_HANDLE_INFO(outValue, 0, NN_SF_CMIF_DETAIL_NATIVE_HANDLE_ATTRIBUTE_HIPC_COPY)
        NN_SF_CMIF_DETAIL_METHOD_INFO_OUT_NATIVE_HANDLE_INFOS_END(1, (outValue))

        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_MEMBER(xpadId, (::nn::hid::JoyXpadId), 0)
        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_END(1, (xpadId))
        NN_SF_CMIF_DETAIL_METHOD_INFO_IN_RAW_SIZE(4)

        NN_SF_CMIF_DETAIL_METHOD_INFO_ARGUMENT_INFOS((NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(outValue), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(xpadId)))

    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO_END(GetJoySixAxisSensorLifoHandle)

    // nn::Result StartSixAxisSensor(nn::applet::AppletResourceUserId aruid, nn::hid::SixAxisSensorHandle handle) NN_NOEXCEPT
    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO(StartSixAxisSensor)

        NN_SF_CMIF_DETAIL_METHOD_INFO_METHOD_ID(66)
        NN_SF_CMIF_DETAIL_METHOD_INFO_RETURN_TYPE_IS_RESULT(true)

        NN_SF_CMIF_DETAIL_METHOD_INFO_IN_PROCESS_ID_ENABLE()

        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_MEMBER(handle, (::nn::hid::SixAxisSensorHandle), 0)
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_MEMBER(aruid, (::nn::applet::AppletResourceUserId), 8)
        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_END(2, (handle, aruid))
        NN_SF_CMIF_DETAIL_METHOD_INFO_IN_RAW_SIZE(16)

        NN_SF_CMIF_DETAIL_METHOD_INFO_ARGUMENT_INFOS((NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(aruid), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(handle)))

    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO_END(StartSixAxisSensor)

    // nn::Result StopSixAxisSensor(nn::applet::AppletResourceUserId aruid, nn::hid::SixAxisSensorHandle handle) NN_NOEXCEPT
    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO(StopSixAxisSensor)

        NN_SF_CMIF_DETAIL_METHOD_INFO_METHOD_ID(67)
        NN_SF_CMIF_DETAIL_METHOD_INFO_RETURN_TYPE_IS_RESULT(true)

        NN_SF_CMIF_DETAIL_METHOD_INFO_IN_PROCESS_ID_ENABLE()

        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_MEMBER(handle, (::nn::hid::SixAxisSensorHandle), 0)
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_MEMBER(aruid, (::nn::applet::AppletResourceUserId), 8)
        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_END(2, (handle, aruid))
        NN_SF_CMIF_DETAIL_METHOD_INFO_IN_RAW_SIZE(16)

        NN_SF_CMIF_DETAIL_METHOD_INFO_ARGUMENT_INFOS((NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(aruid), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(handle)))

    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO_END(StopSixAxisSensor)

    // nn::Result IsSixAxisSensorFusionEnabled(nn::sf::Out<bool> outIsEnabled, nn::applet::AppletResourceUserId aruid, nn::hid::SixAxisSensorHandle handle) NN_NOEXCEPT
    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO(IsSixAxisSensorFusionEnabled)

        NN_SF_CMIF_DETAIL_METHOD_INFO_METHOD_ID(68)
        NN_SF_CMIF_DETAIL_METHOD_INFO_RETURN_TYPE_IS_RESULT(true)

        NN_SF_CMIF_DETAIL_METHOD_INFO_IN_PROCESS_ID_ENABLE()

        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_MEMBER(handle, (::nn::hid::SixAxisSensorHandle), 0)
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_MEMBER(aruid, (::nn::applet::AppletResourceUserId), 8)
        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_END(2, (handle, aruid))
        NN_SF_CMIF_DETAIL_METHOD_INFO_IN_RAW_SIZE(16)

        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT_MEMBER(outIsEnabled, (bool), 0)
        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT_END(1, (outIsEnabled))
        NN_SF_CMIF_DETAIL_METHOD_INFO_OUT_RAW_SIZE(1)

        NN_SF_CMIF_DETAIL_METHOD_INFO_ARGUMENT_INFOS((NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(outIsEnabled), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(aruid), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(handle)))

    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO_END(IsSixAxisSensorFusionEnabled)

    // nn::Result EnableSixAxisSensorFusion(nn::applet::AppletResourceUserId aruid, nn::hid::SixAxisSensorHandle handle, bool enable) NN_NOEXCEPT
    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO(EnableSixAxisSensorFusion)

        NN_SF_CMIF_DETAIL_METHOD_INFO_METHOD_ID(69)
        NN_SF_CMIF_DETAIL_METHOD_INFO_RETURN_TYPE_IS_RESULT(true)

        NN_SF_CMIF_DETAIL_METHOD_INFO_IN_PROCESS_ID_ENABLE()

        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_MEMBER(enable, (bool), 0)
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_MEMBER(handle, (::nn::hid::SixAxisSensorHandle), 4)
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_MEMBER(aruid, (::nn::applet::AppletResourceUserId), 8)
        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_END(3, (enable, handle, aruid))
        NN_SF_CMIF_DETAIL_METHOD_INFO_IN_RAW_SIZE(16)

        NN_SF_CMIF_DETAIL_METHOD_INFO_ARGUMENT_INFOS((NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(aruid), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(handle), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(enable)))

    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO_END(EnableSixAxisSensorFusion)

    // nn::Result SetSixAxisSensorFusionParameters(nn::applet::AppletResourceUserId aruid, nn::hid::SixAxisSensorHandle handle, float revisePower, float reviseRange) NN_NOEXCEPT
    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO(SetSixAxisSensorFusionParameters)

        NN_SF_CMIF_DETAIL_METHOD_INFO_METHOD_ID(70)
        NN_SF_CMIF_DETAIL_METHOD_INFO_RETURN_TYPE_IS_RESULT(true)

        NN_SF_CMIF_DETAIL_METHOD_INFO_IN_PROCESS_ID_ENABLE()

        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_MEMBER(handle, (::nn::hid::SixAxisSensorHandle), 0)
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_MEMBER(revisePower, (float), 4)
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_MEMBER(reviseRange, (float), 8)
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_MEMBER(aruid, (::nn::applet::AppletResourceUserId), 16)
        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_END(4, (handle, revisePower, reviseRange, aruid))
        NN_SF_CMIF_DETAIL_METHOD_INFO_IN_RAW_SIZE(24)

        NN_SF_CMIF_DETAIL_METHOD_INFO_ARGUMENT_INFOS((NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(aruid), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(handle), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(revisePower), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(reviseRange)))

    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO_END(SetSixAxisSensorFusionParameters)

    // nn::Result GetSixAxisSensorFusionParameters(nn::sf::Out<float> outRevisePower, nn::sf::Out<float> outReviseRange, nn::applet::AppletResourceUserId aruid, nn::hid::SixAxisSensorHandle handle) NN_NOEXCEPT
    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO(GetSixAxisSensorFusionParameters)

        NN_SF_CMIF_DETAIL_METHOD_INFO_METHOD_ID(71)
        NN_SF_CMIF_DETAIL_METHOD_INFO_RETURN_TYPE_IS_RESULT(true)

        NN_SF_CMIF_DETAIL_METHOD_INFO_IN_PROCESS_ID_ENABLE()

        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_MEMBER(handle, (::nn::hid::SixAxisSensorHandle), 0)
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_MEMBER(aruid, (::nn::applet::AppletResourceUserId), 8)
        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_END(2, (handle, aruid))
        NN_SF_CMIF_DETAIL_METHOD_INFO_IN_RAW_SIZE(16)

        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT_MEMBER(outRevisePower, (float), 0)
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT_MEMBER(outReviseRange, (float), 4)
        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT_END(2, (outRevisePower, outReviseRange))
        NN_SF_CMIF_DETAIL_METHOD_INFO_OUT_RAW_SIZE(8)

        NN_SF_CMIF_DETAIL_METHOD_INFO_ARGUMENT_INFOS((NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(outRevisePower), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(outReviseRange), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(aruid), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(handle)))

    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO_END(GetSixAxisSensorFusionParameters)

    // nn::Result ResetSixAxisSensorFusionParameters(nn::applet::AppletResourceUserId aruid, nn::hid::SixAxisSensorHandle handle) NN_NOEXCEPT
    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO(ResetSixAxisSensorFusionParameters)

        NN_SF_CMIF_DETAIL_METHOD_INFO_METHOD_ID(72)
        NN_SF_CMIF_DETAIL_METHOD_INFO_RETURN_TYPE_IS_RESULT(true)

        NN_SF_CMIF_DETAIL_METHOD_INFO_IN_PROCESS_ID_ENABLE()

        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_MEMBER(handle, (::nn::hid::SixAxisSensorHandle), 0)
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_MEMBER(aruid, (::nn::applet::AppletResourceUserId), 8)
        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_END(2, (handle, aruid))
        NN_SF_CMIF_DETAIL_METHOD_INFO_IN_RAW_SIZE(16)

        NN_SF_CMIF_DETAIL_METHOD_INFO_ARGUMENT_INFOS((NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(aruid), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(handle)))

    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO_END(ResetSixAxisSensorFusionParameters)

    // nn::Result SetAccelerometerParameters(nn::applet::AppletResourceUserId aruid, nn::hid::SixAxisSensorHandle handle, float playRadius, float sensitivity) NN_NOEXCEPT
    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO(SetAccelerometerParameters)

        NN_SF_CMIF_DETAIL_METHOD_INFO_METHOD_ID(73)
        NN_SF_CMIF_DETAIL_METHOD_INFO_RETURN_TYPE_IS_RESULT(true)

        NN_SF_CMIF_DETAIL_METHOD_INFO_IN_PROCESS_ID_ENABLE()

        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_MEMBER(handle, (::nn::hid::SixAxisSensorHandle), 0)
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_MEMBER(playRadius, (float), 4)
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_MEMBER(sensitivity, (float), 8)
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_MEMBER(aruid, (::nn::applet::AppletResourceUserId), 16)
        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_END(4, (handle, playRadius, sensitivity, aruid))
        NN_SF_CMIF_DETAIL_METHOD_INFO_IN_RAW_SIZE(24)

        NN_SF_CMIF_DETAIL_METHOD_INFO_ARGUMENT_INFOS((NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(aruid), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(handle), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(playRadius), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(sensitivity)))

    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO_END(SetAccelerometerParameters)

    // nn::Result GetAccelerometerParameters(nn::sf::Out<float> outPlayRadius, nn::sf::Out<float> outSensitivity, nn::applet::AppletResourceUserId aruid, nn::hid::SixAxisSensorHandle handle) NN_NOEXCEPT
    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO(GetAccelerometerParameters)

        NN_SF_CMIF_DETAIL_METHOD_INFO_METHOD_ID(74)
        NN_SF_CMIF_DETAIL_METHOD_INFO_RETURN_TYPE_IS_RESULT(true)

        NN_SF_CMIF_DETAIL_METHOD_INFO_IN_PROCESS_ID_ENABLE()

        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_MEMBER(handle, (::nn::hid::SixAxisSensorHandle), 0)
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_MEMBER(aruid, (::nn::applet::AppletResourceUserId), 8)
        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_END(2, (handle, aruid))
        NN_SF_CMIF_DETAIL_METHOD_INFO_IN_RAW_SIZE(16)

        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT_MEMBER(outPlayRadius, (float), 0)
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT_MEMBER(outSensitivity, (float), 4)
        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT_END(2, (outPlayRadius, outSensitivity))
        NN_SF_CMIF_DETAIL_METHOD_INFO_OUT_RAW_SIZE(8)

        NN_SF_CMIF_DETAIL_METHOD_INFO_ARGUMENT_INFOS((NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(outPlayRadius), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(outSensitivity), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(aruid), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(handle)))

    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO_END(GetAccelerometerParameters)

    // nn::Result ResetAccelerometerParameters(nn::applet::AppletResourceUserId aruid, nn::hid::SixAxisSensorHandle handle) NN_NOEXCEPT
    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO(ResetAccelerometerParameters)

        NN_SF_CMIF_DETAIL_METHOD_INFO_METHOD_ID(75)
        NN_SF_CMIF_DETAIL_METHOD_INFO_RETURN_TYPE_IS_RESULT(true)

        NN_SF_CMIF_DETAIL_METHOD_INFO_IN_PROCESS_ID_ENABLE()

        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_MEMBER(handle, (::nn::hid::SixAxisSensorHandle), 0)
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_MEMBER(aruid, (::nn::applet::AppletResourceUserId), 8)
        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_END(2, (handle, aruid))
        NN_SF_CMIF_DETAIL_METHOD_INFO_IN_RAW_SIZE(16)

        NN_SF_CMIF_DETAIL_METHOD_INFO_ARGUMENT_INFOS((NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(aruid), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(handle)))

    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO_END(ResetAccelerometerParameters)

    // nn::Result SetAccelerometerPlayMode(nn::applet::AppletResourceUserId aruid, nn::hid::SixAxisSensorHandle handle, std::uint32_t mode) NN_NOEXCEPT
    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO(SetAccelerometerPlayMode)

        NN_SF_CMIF_DETAIL_METHOD_INFO_METHOD_ID(76)
        NN_SF_CMIF_DETAIL_METHOD_INFO_RETURN_TYPE_IS_RESULT(true)

        NN_SF_CMIF_DETAIL_METHOD_INFO_IN_PROCESS_ID_ENABLE()

        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_MEMBER(handle, (::nn::hid::SixAxisSensorHandle), 0)
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_MEMBER(mode, (::std::uint32_t), 4)
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_MEMBER(aruid, (::nn::applet::AppletResourceUserId), 8)
        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_END(3, (handle, mode, aruid))
        NN_SF_CMIF_DETAIL_METHOD_INFO_IN_RAW_SIZE(16)

        NN_SF_CMIF_DETAIL_METHOD_INFO_ARGUMENT_INFOS((NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(aruid), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(handle), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(mode)))

    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO_END(SetAccelerometerPlayMode)

    // nn::Result GetAccelerometerPlayMode(nn::sf::Out<std::uint32_t> outMode, nn::applet::AppletResourceUserId aruid, nn::hid::SixAxisSensorHandle handle) NN_NOEXCEPT
    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO(GetAccelerometerPlayMode)

        NN_SF_CMIF_DETAIL_METHOD_INFO_METHOD_ID(77)
        NN_SF_CMIF_DETAIL_METHOD_INFO_RETURN_TYPE_IS_RESULT(true)

        NN_SF_CMIF_DETAIL_METHOD_INFO_IN_PROCESS_ID_ENABLE()

        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_MEMBER(handle, (::nn::hid::SixAxisSensorHandle), 0)
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_MEMBER(aruid, (::nn::applet::AppletResourceUserId), 8)
        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_END(2, (handle, aruid))
        NN_SF_CMIF_DETAIL_METHOD_INFO_IN_RAW_SIZE(16)

        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT_MEMBER(outMode, (::std::uint32_t), 0)
        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT_END(1, (outMode))
        NN_SF_CMIF_DETAIL_METHOD_INFO_OUT_RAW_SIZE(4)

        NN_SF_CMIF_DETAIL_METHOD_INFO_ARGUMENT_INFOS((NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(outMode), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(aruid), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(handle)))

    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO_END(GetAccelerometerPlayMode)

    // nn::Result ResetAccelerometerPlayMode(nn::applet::AppletResourceUserId aruid, nn::hid::SixAxisSensorHandle handle) NN_NOEXCEPT
    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO(ResetAccelerometerPlayMode)

        NN_SF_CMIF_DETAIL_METHOD_INFO_METHOD_ID(78)
        NN_SF_CMIF_DETAIL_METHOD_INFO_RETURN_TYPE_IS_RESULT(true)

        NN_SF_CMIF_DETAIL_METHOD_INFO_IN_PROCESS_ID_ENABLE()

        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_MEMBER(handle, (::nn::hid::SixAxisSensorHandle), 0)
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_MEMBER(aruid, (::nn::applet::AppletResourceUserId), 8)
        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_END(2, (handle, aruid))
        NN_SF_CMIF_DETAIL_METHOD_INFO_IN_RAW_SIZE(16)

        NN_SF_CMIF_DETAIL_METHOD_INFO_ARGUMENT_INFOS((NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(aruid), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(handle)))

    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO_END(ResetAccelerometerPlayMode)

    // nn::Result SetGyroscopeZeroDriftMode(nn::applet::AppletResourceUserId aruid, nn::hid::SixAxisSensorHandle handle, std::uint32_t mode) NN_NOEXCEPT
    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO(SetGyroscopeZeroDriftMode)

        NN_SF_CMIF_DETAIL_METHOD_INFO_METHOD_ID(79)
        NN_SF_CMIF_DETAIL_METHOD_INFO_RETURN_TYPE_IS_RESULT(true)

        NN_SF_CMIF_DETAIL_METHOD_INFO_IN_PROCESS_ID_ENABLE()

        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_MEMBER(handle, (::nn::hid::SixAxisSensorHandle), 0)
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_MEMBER(mode, (::std::uint32_t), 4)
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_MEMBER(aruid, (::nn::applet::AppletResourceUserId), 8)
        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_END(3, (handle, mode, aruid))
        NN_SF_CMIF_DETAIL_METHOD_INFO_IN_RAW_SIZE(16)

        NN_SF_CMIF_DETAIL_METHOD_INFO_ARGUMENT_INFOS((NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(aruid), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(handle), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(mode)))

    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO_END(SetGyroscopeZeroDriftMode)

    // nn::Result GetGyroscopeZeroDriftMode(nn::sf::Out<std::uint32_t> outMode, nn::applet::AppletResourceUserId aruid, nn::hid::SixAxisSensorHandle handle) NN_NOEXCEPT
    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO(GetGyroscopeZeroDriftMode)

        NN_SF_CMIF_DETAIL_METHOD_INFO_METHOD_ID(80)
        NN_SF_CMIF_DETAIL_METHOD_INFO_RETURN_TYPE_IS_RESULT(true)

        NN_SF_CMIF_DETAIL_METHOD_INFO_IN_PROCESS_ID_ENABLE()

        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_MEMBER(handle, (::nn::hid::SixAxisSensorHandle), 0)
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_MEMBER(aruid, (::nn::applet::AppletResourceUserId), 8)
        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_END(2, (handle, aruid))
        NN_SF_CMIF_DETAIL_METHOD_INFO_IN_RAW_SIZE(16)

        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT_MEMBER(outMode, (::std::uint32_t), 0)
        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT_END(1, (outMode))
        NN_SF_CMIF_DETAIL_METHOD_INFO_OUT_RAW_SIZE(4)

        NN_SF_CMIF_DETAIL_METHOD_INFO_ARGUMENT_INFOS((NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(outMode), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(aruid), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(handle)))

    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO_END(GetGyroscopeZeroDriftMode)

    // nn::Result ResetGyroscopeZeroDriftMode(nn::applet::AppletResourceUserId aruid, nn::hid::SixAxisSensorHandle handle) NN_NOEXCEPT
    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO(ResetGyroscopeZeroDriftMode)

        NN_SF_CMIF_DETAIL_METHOD_INFO_METHOD_ID(81)
        NN_SF_CMIF_DETAIL_METHOD_INFO_RETURN_TYPE_IS_RESULT(true)

        NN_SF_CMIF_DETAIL_METHOD_INFO_IN_PROCESS_ID_ENABLE()

        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_MEMBER(handle, (::nn::hid::SixAxisSensorHandle), 0)
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_MEMBER(aruid, (::nn::applet::AppletResourceUserId), 8)
        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_END(2, (handle, aruid))
        NN_SF_CMIF_DETAIL_METHOD_INFO_IN_RAW_SIZE(16)

        NN_SF_CMIF_DETAIL_METHOD_INFO_ARGUMENT_INFOS((NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(aruid), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(handle)))

    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO_END(ResetGyroscopeZeroDriftMode)

    // nn::Result IsSixAxisSensorAtRest(nn::sf::Out<bool> outIsAtRest, nn::applet::AppletResourceUserId aruid, nn::hid::SixAxisSensorHandle handle) NN_NOEXCEPT
    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO(IsSixAxisSensorAtRest)

        NN_SF_CMIF_DETAIL_METHOD_INFO_METHOD_ID(82)
        NN_SF_CMIF_DETAIL_METHOD_INFO_RETURN_TYPE_IS_RESULT(true)

        NN_SF_CMIF_DETAIL_METHOD_INFO_IN_PROCESS_ID_ENABLE()

        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_MEMBER(handle, (::nn::hid::SixAxisSensorHandle), 0)
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_MEMBER(aruid, (::nn::applet::AppletResourceUserId), 8)
        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_END(2, (handle, aruid))
        NN_SF_CMIF_DETAIL_METHOD_INFO_IN_RAW_SIZE(16)

        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT_MEMBER(outIsAtRest, (bool), 0)
        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT_END(1, (outIsAtRest))
        NN_SF_CMIF_DETAIL_METHOD_INFO_OUT_RAW_SIZE(1)

        NN_SF_CMIF_DETAIL_METHOD_INFO_ARGUMENT_INFOS((NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(outIsAtRest), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(aruid), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(handle)))

    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO_END(IsSixAxisSensorAtRest)

    // nn::Result ActivateGesture(nn::applet::AppletResourceUserId aruid, std::int32_t version) NN_NOEXCEPT
    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO(ActivateGesture)

        NN_SF_CMIF_DETAIL_METHOD_INFO_METHOD_ID(91)
        NN_SF_CMIF_DETAIL_METHOD_INFO_RETURN_TYPE_IS_RESULT(true)

        NN_SF_CMIF_DETAIL_METHOD_INFO_IN_PROCESS_ID_ENABLE()

        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_MEMBER(version, (::std::int32_t), 0)
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_MEMBER(aruid, (::nn::applet::AppletResourceUserId), 8)
        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_END(2, (version, aruid))
        NN_SF_CMIF_DETAIL_METHOD_INFO_IN_RAW_SIZE(16)

        NN_SF_CMIF_DETAIL_METHOD_INFO_ARGUMENT_INFOS((NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(aruid), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(version)))

    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO_END(ActivateGesture)

    // nn::Result SetSupportedNpadStyleSet(nn::applet::AppletResourceUserId aruid, nn::hid::NpadStyleSet style) NN_NOEXCEPT
    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO(SetSupportedNpadStyleSet)

        NN_SF_CMIF_DETAIL_METHOD_INFO_METHOD_ID(100)
        NN_SF_CMIF_DETAIL_METHOD_INFO_RETURN_TYPE_IS_RESULT(true)

        NN_SF_CMIF_DETAIL_METHOD_INFO_IN_PROCESS_ID_ENABLE()

        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_MEMBER(style, (::nn::hid::NpadStyleSet), 0)
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_MEMBER(aruid, (::nn::applet::AppletResourceUserId), 8)
        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_END(2, (style, aruid))
        NN_SF_CMIF_DETAIL_METHOD_INFO_IN_RAW_SIZE(16)

        NN_SF_CMIF_DETAIL_METHOD_INFO_ARGUMENT_INFOS((NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(aruid), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(style)))

    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO_END(SetSupportedNpadStyleSet)

    // nn::Result GetSupportedNpadStyleSet(nn::applet::AppletResourceUserId aruid, nn::sf::Out<nn::hid::NpadStyleSet> outValue) NN_NOEXCEPT
    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO(GetSupportedNpadStyleSet)

        NN_SF_CMIF_DETAIL_METHOD_INFO_METHOD_ID(101)
        NN_SF_CMIF_DETAIL_METHOD_INFO_RETURN_TYPE_IS_RESULT(true)

        NN_SF_CMIF_DETAIL_METHOD_INFO_IN_PROCESS_ID_ENABLE()

        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_MEMBER(aruid, (::nn::applet::AppletResourceUserId), 0)
        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_END(1, (aruid))
        NN_SF_CMIF_DETAIL_METHOD_INFO_IN_RAW_SIZE(8)

        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT_MEMBER(outValue, (::nn::hid::NpadStyleSet), 0)
        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT_END(1, (outValue))
        NN_SF_CMIF_DETAIL_METHOD_INFO_OUT_RAW_SIZE(4)

        NN_SF_CMIF_DETAIL_METHOD_INFO_ARGUMENT_INFOS((NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(aruid), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(outValue)))

    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO_END(GetSupportedNpadStyleSet)

    // nn::Result SetSupportedNpadIdType(nn::applet::AppletResourceUserId aruid, const nn::sf::InArray<nn::hid::NpadIdType>& ids) NN_NOEXCEPT
    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO(SetSupportedNpadIdType)

        NN_SF_CMIF_DETAIL_METHOD_INFO_METHOD_ID(102)
        NN_SF_CMIF_DETAIL_METHOD_INFO_RETURN_TYPE_IS_RESULT(true)

        NN_SF_CMIF_DETAIL_METHOD_INFO_IN_PROCESS_ID_ENABLE()

        NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_COUNT(1)
        NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_INFOS
            NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_INFO(ids, 0, (const ::nn::sf::InArray<::nn::hid::NpadIdType>&), NN_SF_CMIF_DETAIL_BUFFER_ATTRIBUTE_IN | NN_SF_CMIF_DETAIL_BUFFER_ATTRIBUTE_HIPC_POINTER)
        NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_INFOS_END(1, (ids))

        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_MEMBER(aruid, (::nn::applet::AppletResourceUserId), 0)
        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_END(1, (aruid))
        NN_SF_CMIF_DETAIL_METHOD_INFO_IN_RAW_SIZE(8)

        NN_SF_CMIF_DETAIL_METHOD_INFO_ARGUMENT_INFOS((NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(aruid), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(ids)))

    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO_END(SetSupportedNpadIdType)

    // nn::Result ActivateNpad(nn::applet::AppletResourceUserId aruid) NN_NOEXCEPT
    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO(ActivateNpad)

        NN_SF_CMIF_DETAIL_METHOD_INFO_METHOD_ID(103)
        NN_SF_CMIF_DETAIL_METHOD_INFO_RETURN_TYPE_IS_RESULT(true)

        NN_SF_CMIF_DETAIL_METHOD_INFO_IN_PROCESS_ID_ENABLE()

        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_MEMBER(aruid, (::nn::applet::AppletResourceUserId), 0)
        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_END(1, (aruid))
        NN_SF_CMIF_DETAIL_METHOD_INFO_IN_RAW_SIZE(8)

        NN_SF_CMIF_DETAIL_METHOD_INFO_ARGUMENT_INFOS((NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(aruid)))

    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO_END(ActivateNpad)

    // nn::Result DeactivateNpad(nn::applet::AppletResourceUserId aruid) NN_NOEXCEPT
    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO(DeactivateNpad)

        NN_SF_CMIF_DETAIL_METHOD_INFO_METHOD_ID(104)
        NN_SF_CMIF_DETAIL_METHOD_INFO_RETURN_TYPE_IS_RESULT(true)

        NN_SF_CMIF_DETAIL_METHOD_INFO_IN_PROCESS_ID_ENABLE()

        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_MEMBER(aruid, (::nn::applet::AppletResourceUserId), 0)
        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_END(1, (aruid))
        NN_SF_CMIF_DETAIL_METHOD_INFO_IN_RAW_SIZE(8)

        NN_SF_CMIF_DETAIL_METHOD_INFO_ARGUMENT_INFOS((NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(aruid)))

    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO_END(DeactivateNpad)

    // nn::Result AcquireNpadStyleSetUpdateEventHandle(nn::applet::AppletResourceUserId aruid, nn::sf::Out<nn::sf::NativeHandle> outValue, nn::hid::NpadIdType id, std::uint64_t clientId) NN_NOEXCEPT
    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO(AcquireNpadStyleSetUpdateEventHandle)

        NN_SF_CMIF_DETAIL_METHOD_INFO_METHOD_ID(106)
        NN_SF_CMIF_DETAIL_METHOD_INFO_RETURN_TYPE_IS_RESULT(true)

        NN_SF_CMIF_DETAIL_METHOD_INFO_IN_PROCESS_ID_ENABLE()

        NN_SF_CMIF_DETAIL_METHOD_INFO_OUT_NATIVE_HANDLE_COUNT(1)
        NN_SF_CMIF_DETAIL_METHOD_INFO_OUT_NATIVE_HANDLE_INFOS
            NN_SF_CMIF_DETAIL_METHOD_INFO_OUT_NATIVE_HANDLE_INFO(outValue, 0, NN_SF_CMIF_DETAIL_NATIVE_HANDLE_ATTRIBUTE_HIPC_COPY)
        NN_SF_CMIF_DETAIL_METHOD_INFO_OUT_NATIVE_HANDLE_INFOS_END(1, (outValue))

        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_MEMBER(id, (::nn::hid::NpadIdType), 0)
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_MEMBER(aruid, (::nn::applet::AppletResourceUserId), 8)
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_MEMBER(clientId, (::std::uint64_t), 16)
        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_END(3, (id, aruid, clientId))
        NN_SF_CMIF_DETAIL_METHOD_INFO_IN_RAW_SIZE(24)

        NN_SF_CMIF_DETAIL_METHOD_INFO_ARGUMENT_INFOS((NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(aruid), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(outValue), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(id), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(clientId)))

    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO_END(AcquireNpadStyleSetUpdateEventHandle)

    // nn::Result DisconnectNpad(nn::applet::AppletResourceUserId aruid, nn::hid::NpadIdType id) NN_NOEXCEPT
    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO(DisconnectNpad)

        NN_SF_CMIF_DETAIL_METHOD_INFO_METHOD_ID(107)
        NN_SF_CMIF_DETAIL_METHOD_INFO_RETURN_TYPE_IS_RESULT(true)

        NN_SF_CMIF_DETAIL_METHOD_INFO_IN_PROCESS_ID_ENABLE()

        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_MEMBER(id, (::nn::hid::NpadIdType), 0)
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_MEMBER(aruid, (::nn::applet::AppletResourceUserId), 8)
        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_END(2, (id, aruid))
        NN_SF_CMIF_DETAIL_METHOD_INFO_IN_RAW_SIZE(16)

        NN_SF_CMIF_DETAIL_METHOD_INFO_ARGUMENT_INFOS((NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(aruid), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(id)))

    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO_END(DisconnectNpad)

    // nn::Result GetPlayerLedPattern(nn::sf::Out<std::uint64_t> outValue, nn::hid::NpadIdType id) NN_NOEXCEPT
    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO(GetPlayerLedPattern)

        NN_SF_CMIF_DETAIL_METHOD_INFO_METHOD_ID(108)
        NN_SF_CMIF_DETAIL_METHOD_INFO_RETURN_TYPE_IS_RESULT(true)

        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_MEMBER(id, (::nn::hid::NpadIdType), 0)
        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_END(1, (id))
        NN_SF_CMIF_DETAIL_METHOD_INFO_IN_RAW_SIZE(4)

        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT_MEMBER(outValue, (::std::uint64_t), 0)
        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT_END(1, (outValue))
        NN_SF_CMIF_DETAIL_METHOD_INFO_OUT_RAW_SIZE(8)

        NN_SF_CMIF_DETAIL_METHOD_INFO_ARGUMENT_INFOS((NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(outValue), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(id)))

    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO_END(GetPlayerLedPattern)

    // nn::Result ActivateNpadWithRevision(nn::applet::AppletResourceUserId aruid, std::int32_t revision) NN_NOEXCEPT
    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO(ActivateNpadWithRevision)

        NN_SF_CMIF_DETAIL_METHOD_INFO_METHOD_ID(109)
        NN_SF_CMIF_DETAIL_METHOD_INFO_RETURN_TYPE_IS_RESULT(true)

        NN_SF_CMIF_DETAIL_METHOD_INFO_IN_PROCESS_ID_ENABLE()

        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_MEMBER(revision, (::std::int32_t), 0)
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_MEMBER(aruid, (::nn::applet::AppletResourceUserId), 8)
        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_END(2, (revision, aruid))
        NN_SF_CMIF_DETAIL_METHOD_INFO_IN_RAW_SIZE(16)

        NN_SF_CMIF_DETAIL_METHOD_INFO_ARGUMENT_INFOS((NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(aruid), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(revision)))

    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO_END(ActivateNpadWithRevision)

    // nn::Result SetNpadJoyHoldType(nn::applet::AppletResourceUserId aruid, std::int64_t holdType) NN_NOEXCEPT
    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO(SetNpadJoyHoldType)

        NN_SF_CMIF_DETAIL_METHOD_INFO_METHOD_ID(120)
        NN_SF_CMIF_DETAIL_METHOD_INFO_RETURN_TYPE_IS_RESULT(true)

        NN_SF_CMIF_DETAIL_METHOD_INFO_IN_PROCESS_ID_ENABLE()

        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_MEMBER(aruid, (::nn::applet::AppletResourceUserId), 0)
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_MEMBER(holdType, (::std::int64_t), 8)
        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_END(2, (aruid, holdType))
        NN_SF_CMIF_DETAIL_METHOD_INFO_IN_RAW_SIZE(16)

        NN_SF_CMIF_DETAIL_METHOD_INFO_ARGUMENT_INFOS((NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(aruid), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(holdType)))

    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO_END(SetNpadJoyHoldType)

    // nn::Result GetNpadJoyHoldType(nn::applet::AppletResourceUserId aruid, nn::sf::Out<std::int64_t> outValue) NN_NOEXCEPT
    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO(GetNpadJoyHoldType)

        NN_SF_CMIF_DETAIL_METHOD_INFO_METHOD_ID(121)
        NN_SF_CMIF_DETAIL_METHOD_INFO_RETURN_TYPE_IS_RESULT(true)

        NN_SF_CMIF_DETAIL_METHOD_INFO_IN_PROCESS_ID_ENABLE()

        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_MEMBER(aruid, (::nn::applet::AppletResourceUserId), 0)
        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_END(1, (aruid))
        NN_SF_CMIF_DETAIL_METHOD_INFO_IN_RAW_SIZE(8)

        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT_MEMBER(outValue, (::std::int64_t), 0)
        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT_END(1, (outValue))
        NN_SF_CMIF_DETAIL_METHOD_INFO_OUT_RAW_SIZE(8)

        NN_SF_CMIF_DETAIL_METHOD_INFO_ARGUMENT_INFOS((NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(aruid), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(outValue)))

    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO_END(GetNpadJoyHoldType)

    // nn::Result SetNpadJoyAssignmentModeSingleByDefault(nn::applet::AppletResourceUserId aruid, nn::hid::NpadIdType id) NN_NOEXCEPT
    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO(SetNpadJoyAssignmentModeSingleByDefault)

        NN_SF_CMIF_DETAIL_METHOD_INFO_METHOD_ID(122)
        NN_SF_CMIF_DETAIL_METHOD_INFO_RETURN_TYPE_IS_RESULT(true)

        NN_SF_CMIF_DETAIL_METHOD_INFO_IN_PROCESS_ID_ENABLE()

        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_MEMBER(id, (::nn::hid::NpadIdType), 0)
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_MEMBER(aruid, (::nn::applet::AppletResourceUserId), 8)
        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_END(2, (id, aruid))
        NN_SF_CMIF_DETAIL_METHOD_INFO_IN_RAW_SIZE(16)

        NN_SF_CMIF_DETAIL_METHOD_INFO_ARGUMENT_INFOS((NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(aruid), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(id)))

    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO_END(SetNpadJoyAssignmentModeSingleByDefault)

    // nn::Result SetNpadJoyAssignmentModeSingle(nn::applet::AppletResourceUserId aruid, nn::hid::NpadIdType id, std::int64_t type) NN_NOEXCEPT
    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO(SetNpadJoyAssignmentModeSingle)

        NN_SF_CMIF_DETAIL_METHOD_INFO_METHOD_ID(123)
        NN_SF_CMIF_DETAIL_METHOD_INFO_RETURN_TYPE_IS_RESULT(true)

        NN_SF_CMIF_DETAIL_METHOD_INFO_IN_PROCESS_ID_ENABLE()

        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_MEMBER(id, (::nn::hid::NpadIdType), 0)
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_MEMBER(aruid, (::nn::applet::AppletResourceUserId), 8)
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_MEMBER(type, (::std::int64_t), 16)
        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_END(3, (id, aruid, type))
        NN_SF_CMIF_DETAIL_METHOD_INFO_IN_RAW_SIZE(24)

        NN_SF_CMIF_DETAIL_METHOD_INFO_ARGUMENT_INFOS((NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(aruid), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(id), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(type)))

    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO_END(SetNpadJoyAssignmentModeSingle)

    // nn::Result SetNpadJoyAssignmentModeDual(nn::applet::AppletResourceUserId aruid, nn::hid::NpadIdType id) NN_NOEXCEPT
    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO(SetNpadJoyAssignmentModeDual)

        NN_SF_CMIF_DETAIL_METHOD_INFO_METHOD_ID(124)
        NN_SF_CMIF_DETAIL_METHOD_INFO_RETURN_TYPE_IS_RESULT(true)

        NN_SF_CMIF_DETAIL_METHOD_INFO_IN_PROCESS_ID_ENABLE()

        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_MEMBER(id, (::nn::hid::NpadIdType), 0)
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_MEMBER(aruid, (::nn::applet::AppletResourceUserId), 8)
        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_END(2, (id, aruid))
        NN_SF_CMIF_DETAIL_METHOD_INFO_IN_RAW_SIZE(16)

        NN_SF_CMIF_DETAIL_METHOD_INFO_ARGUMENT_INFOS((NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(aruid), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(id)))

    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO_END(SetNpadJoyAssignmentModeDual)

    // nn::Result MergeSingleJoyAsDualJoy(nn::applet::AppletResourceUserId aruid, nn::hid::NpadIdType id1, nn::hid::NpadIdType id2) NN_NOEXCEPT
    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO(MergeSingleJoyAsDualJoy)

        NN_SF_CMIF_DETAIL_METHOD_INFO_METHOD_ID(125)
        NN_SF_CMIF_DETAIL_METHOD_INFO_RETURN_TYPE_IS_RESULT(true)

        NN_SF_CMIF_DETAIL_METHOD_INFO_IN_PROCESS_ID_ENABLE()

        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_MEMBER(id1, (::nn::hid::NpadIdType), 0)
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_MEMBER(id2, (::nn::hid::NpadIdType), 4)
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_MEMBER(aruid, (::nn::applet::AppletResourceUserId), 8)
        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_END(3, (id1, id2, aruid))
        NN_SF_CMIF_DETAIL_METHOD_INFO_IN_RAW_SIZE(16)

        NN_SF_CMIF_DETAIL_METHOD_INFO_ARGUMENT_INFOS((NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(aruid), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(id1), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(id2)))

    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO_END(MergeSingleJoyAsDualJoy)

    // nn::Result StartLrAssignmentMode(nn::applet::AppletResourceUserId aruid) NN_NOEXCEPT
    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO(StartLrAssignmentMode)

        NN_SF_CMIF_DETAIL_METHOD_INFO_METHOD_ID(126)
        NN_SF_CMIF_DETAIL_METHOD_INFO_RETURN_TYPE_IS_RESULT(true)

        NN_SF_CMIF_DETAIL_METHOD_INFO_IN_PROCESS_ID_ENABLE()

        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_MEMBER(aruid, (::nn::applet::AppletResourceUserId), 0)
        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_END(1, (aruid))
        NN_SF_CMIF_DETAIL_METHOD_INFO_IN_RAW_SIZE(8)

        NN_SF_CMIF_DETAIL_METHOD_INFO_ARGUMENT_INFOS((NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(aruid)))

    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO_END(StartLrAssignmentMode)

    // nn::Result StopLrAssignmentMode(nn::applet::AppletResourceUserId aruid) NN_NOEXCEPT
    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO(StopLrAssignmentMode)

        NN_SF_CMIF_DETAIL_METHOD_INFO_METHOD_ID(127)
        NN_SF_CMIF_DETAIL_METHOD_INFO_RETURN_TYPE_IS_RESULT(true)

        NN_SF_CMIF_DETAIL_METHOD_INFO_IN_PROCESS_ID_ENABLE()

        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_MEMBER(aruid, (::nn::applet::AppletResourceUserId), 0)
        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_END(1, (aruid))
        NN_SF_CMIF_DETAIL_METHOD_INFO_IN_RAW_SIZE(8)

        NN_SF_CMIF_DETAIL_METHOD_INFO_ARGUMENT_INFOS((NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(aruid)))

    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO_END(StopLrAssignmentMode)

    // nn::Result SetNpadHandheldActivationMode(nn::applet::AppletResourceUserId aruid, std::int64_t mode) NN_NOEXCEPT
    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO(SetNpadHandheldActivationMode)

        NN_SF_CMIF_DETAIL_METHOD_INFO_METHOD_ID(128)
        NN_SF_CMIF_DETAIL_METHOD_INFO_RETURN_TYPE_IS_RESULT(true)

        NN_SF_CMIF_DETAIL_METHOD_INFO_IN_PROCESS_ID_ENABLE()

        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_MEMBER(aruid, (::nn::applet::AppletResourceUserId), 0)
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_MEMBER(mode, (::std::int64_t), 8)
        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_END(2, (aruid, mode))
        NN_SF_CMIF_DETAIL_METHOD_INFO_IN_RAW_SIZE(16)

        NN_SF_CMIF_DETAIL_METHOD_INFO_ARGUMENT_INFOS((NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(aruid), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(mode)))

    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO_END(SetNpadHandheldActivationMode)

    // nn::Result GetNpadHandheldActivationMode(nn::applet::AppletResourceUserId aruid, nn::sf::Out<std::int64_t> outValue) NN_NOEXCEPT
    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO(GetNpadHandheldActivationMode)

        NN_SF_CMIF_DETAIL_METHOD_INFO_METHOD_ID(129)
        NN_SF_CMIF_DETAIL_METHOD_INFO_RETURN_TYPE_IS_RESULT(true)

        NN_SF_CMIF_DETAIL_METHOD_INFO_IN_PROCESS_ID_ENABLE()

        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_MEMBER(aruid, (::nn::applet::AppletResourceUserId), 0)
        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_END(1, (aruid))
        NN_SF_CMIF_DETAIL_METHOD_INFO_IN_RAW_SIZE(8)

        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT_MEMBER(outValue, (::std::int64_t), 0)
        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT_END(1, (outValue))
        NN_SF_CMIF_DETAIL_METHOD_INFO_OUT_RAW_SIZE(8)

        NN_SF_CMIF_DETAIL_METHOD_INFO_ARGUMENT_INFOS((NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(aruid), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(outValue)))

    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO_END(GetNpadHandheldActivationMode)

    // nn::Result SwapNpadAssignment(nn::applet::AppletResourceUserId aruid, nn::hid::NpadIdType id1, nn::hid::NpadIdType id2) NN_NOEXCEPT
    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO(SwapNpadAssignment)

        NN_SF_CMIF_DETAIL_METHOD_INFO_METHOD_ID(130)
        NN_SF_CMIF_DETAIL_METHOD_INFO_RETURN_TYPE_IS_RESULT(true)

        NN_SF_CMIF_DETAIL_METHOD_INFO_IN_PROCESS_ID_ENABLE()

        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_MEMBER(id1, (::nn::hid::NpadIdType), 0)
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_MEMBER(id2, (::nn::hid::NpadIdType), 4)
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_MEMBER(aruid, (::nn::applet::AppletResourceUserId), 8)
        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_END(3, (id1, id2, aruid))
        NN_SF_CMIF_DETAIL_METHOD_INFO_IN_RAW_SIZE(16)

        NN_SF_CMIF_DETAIL_METHOD_INFO_ARGUMENT_INFOS((NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(aruid), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(id1), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(id2)))

    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO_END(SwapNpadAssignment)

    // nn::Result IsUnintendedHomeButtonInputProtectionEnabled(nn::sf::Out<bool> outIsEnabled, nn::applet::AppletResourceUserId aruid, nn::hid::NpadIdType id) NN_NOEXCEPT
    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO(IsUnintendedHomeButtonInputProtectionEnabled)

        NN_SF_CMIF_DETAIL_METHOD_INFO_METHOD_ID(131)
        NN_SF_CMIF_DETAIL_METHOD_INFO_RETURN_TYPE_IS_RESULT(true)

        NN_SF_CMIF_DETAIL_METHOD_INFO_IN_PROCESS_ID_ENABLE()

        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_MEMBER(id, (::nn::hid::NpadIdType), 0)
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_MEMBER(aruid, (::nn::applet::AppletResourceUserId), 8)
        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_END(2, (id, aruid))
        NN_SF_CMIF_DETAIL_METHOD_INFO_IN_RAW_SIZE(16)

        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT_MEMBER(outIsEnabled, (bool), 0)
        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT_END(1, (outIsEnabled))
        NN_SF_CMIF_DETAIL_METHOD_INFO_OUT_RAW_SIZE(1)

        NN_SF_CMIF_DETAIL_METHOD_INFO_ARGUMENT_INFOS((NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(outIsEnabled), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(aruid), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(id)))

    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO_END(IsUnintendedHomeButtonInputProtectionEnabled)

    // nn::Result EnableUnintendedHomeButtonInputProtection(nn::applet::AppletResourceUserId aruid, nn::hid::NpadIdType id, bool enabled) NN_NOEXCEPT
    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO(EnableUnintendedHomeButtonInputProtection)

        NN_SF_CMIF_DETAIL_METHOD_INFO_METHOD_ID(132)
        NN_SF_CMIF_DETAIL_METHOD_INFO_RETURN_TYPE_IS_RESULT(true)

        NN_SF_CMIF_DETAIL_METHOD_INFO_IN_PROCESS_ID_ENABLE()

        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_MEMBER(enabled, (bool), 0)
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_MEMBER(id, (::nn::hid::NpadIdType), 4)
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_MEMBER(aruid, (::nn::applet::AppletResourceUserId), 8)
        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_END(3, (enabled, id, aruid))
        NN_SF_CMIF_DETAIL_METHOD_INFO_IN_RAW_SIZE(16)

        NN_SF_CMIF_DETAIL_METHOD_INFO_ARGUMENT_INFOS((NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(aruid), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(id), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(enabled)))

    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO_END(EnableUnintendedHomeButtonInputProtection)

    // nn::Result SetNpadJoyAssignmentModeSingleWithDestination(nn::sf::Out<bool> outIsAssigned, nn::sf::Out<nn::hid::NpadIdType> outId, nn::applet::AppletResourceUserId aruid, nn::hid::NpadIdType id, std::int64_t type) NN_NOEXCEPT
    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO(SetNpadJoyAssignmentModeSingleWithDestination)

        NN_SF_CMIF_DETAIL_METHOD_INFO_METHOD_ID(133)
        NN_SF_CMIF_DETAIL_METHOD_INFO_RETURN_TYPE_IS_RESULT(true)

        NN_SF_CMIF_DETAIL_METHOD_INFO_IN_PROCESS_ID_ENABLE()

        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_MEMBER(id, (::nn::hid::NpadIdType), 0)
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_MEMBER(aruid, (::nn::applet::AppletResourceUserId), 8)
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_MEMBER(type, (::std::int64_t), 16)
        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_END(3, (id, aruid, type))
        NN_SF_CMIF_DETAIL_METHOD_INFO_IN_RAW_SIZE(24)

        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT_MEMBER(outIsAssigned, (bool), 0)
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT_MEMBER(outId, (::nn::hid::NpadIdType), 4)
        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT_END(2, (outIsAssigned, outId))
        NN_SF_CMIF_DETAIL_METHOD_INFO_OUT_RAW_SIZE(8)

        NN_SF_CMIF_DETAIL_METHOD_INFO_ARGUMENT_INFOS((NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(outIsAssigned), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(outId), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(aruid), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(id), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(type)))

    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO_END(SetNpadJoyAssignmentModeSingleWithDestination)

    // nn::Result GetVibrationDeviceInfo(nn::sf::Out<nn::hid::VibrationDeviceInfoForIpc> outValue, nn::hid::VibrationDeviceHandle handle) NN_NOEXCEPT
    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO(GetVibrationDeviceInfo)

        NN_SF_CMIF_DETAIL_METHOD_INFO_METHOD_ID(200)
        NN_SF_CMIF_DETAIL_METHOD_INFO_RETURN_TYPE_IS_RESULT(true)

        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_MEMBER(handle, (::nn::hid::VibrationDeviceHandle), 0)
        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_END(1, (handle))
        NN_SF_CMIF_DETAIL_METHOD_INFO_IN_RAW_SIZE(4)

        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT_MEMBER(outValue, (::nn::hid::VibrationDeviceInfoForIpc), 0)
        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT_END(1, (outValue))
        NN_SF_CMIF_DETAIL_METHOD_INFO_OUT_RAW_SIZE(8)

        NN_SF_CMIF_DETAIL_METHOD_INFO_ARGUMENT_INFOS((NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(outValue), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(handle)))

    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO_END(GetVibrationDeviceInfo)

    // nn::Result SendVibrationValue(nn::applet::AppletResourceUserId aruid, nn::hid::VibrationDeviceHandle handle, const nn::hid::VibrationValue& value) NN_NOEXCEPT
    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO(SendVibrationValue)

        NN_SF_CMIF_DETAIL_METHOD_INFO_METHOD_ID(201)
        NN_SF_CMIF_DETAIL_METHOD_INFO_RETURN_TYPE_IS_RESULT(true)

        NN_SF_CMIF_DETAIL_METHOD_INFO_IN_PROCESS_ID_ENABLE()

        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_MEMBER(handle, (::nn::hid::VibrationDeviceHandle), 0)
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_MEMBER(value, (::nn::hid::VibrationValue), 4)
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_MEMBER(aruid, (::nn::applet::AppletResourceUserId), 24)
        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_END(3, (handle, value, aruid))
        NN_SF_CMIF_DETAIL_METHOD_INFO_IN_RAW_SIZE(32)

        NN_SF_CMIF_DETAIL_METHOD_INFO_ARGUMENT_INFOS((NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(aruid), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(handle), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(value)))

    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO_END(SendVibrationValue)

    // nn::Result GetActualVibrationValue(nn::sf::Out<nn::hid::VibrationValue> outValue, nn::applet::AppletResourceUserId aruid, nn::hid::VibrationDeviceHandle handle) NN_NOEXCEPT
    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO(GetActualVibrationValue)

        NN_SF_CMIF_DETAIL_METHOD_INFO_METHOD_ID(202)
        NN_SF_CMIF_DETAIL_METHOD_INFO_RETURN_TYPE_IS_RESULT(true)

        NN_SF_CMIF_DETAIL_METHOD_INFO_IN_PROCESS_ID_ENABLE()

        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_MEMBER(handle, (::nn::hid::VibrationDeviceHandle), 0)
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_MEMBER(aruid, (::nn::applet::AppletResourceUserId), 8)
        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_END(2, (handle, aruid))
        NN_SF_CMIF_DETAIL_METHOD_INFO_IN_RAW_SIZE(16)

        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT_MEMBER(outValue, (::nn::hid::VibrationValue), 0)
        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT_END(1, (outValue))
        NN_SF_CMIF_DETAIL_METHOD_INFO_OUT_RAW_SIZE(16)

        NN_SF_CMIF_DETAIL_METHOD_INFO_ARGUMENT_INFOS((NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(outValue), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(aruid), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(handle)))

    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO_END(GetActualVibrationValue)

    // nn::Result CreateActiveVibrationDeviceList(nn::sf::Out<nn::sf::SharedPointer<nn::hid::IActiveVibrationDeviceList>> outValue) NN_NOEXCEPT
    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO(CreateActiveVibrationDeviceList)

        NN_SF_CMIF_DETAIL_METHOD_INFO_METHOD_ID(203)
        NN_SF_CMIF_DETAIL_METHOD_INFO_RETURN_TYPE_IS_RESULT(true)

        NN_SF_CMIF_DETAIL_METHOD_INFO_OUT_OBJECT_COUNT(1)
        NN_SF_CMIF_DETAIL_METHOD_INFO_OUT_OBJECT_INFOS
            NN_SF_CMIF_DETAIL_METHOD_INFO_OUT_OBJECT_INFO(outValue, 0, 0)
        NN_SF_CMIF_DETAIL_METHOD_INFO_OUT_OBJECT_INFOS_END(1, (outValue))

        NN_SF_CMIF_DETAIL_METHOD_INFO_ARGUMENT_INFOS((NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(outValue)))

    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO_END(CreateActiveVibrationDeviceList)

    // nn::Result PermitVibration(bool isPermitted) NN_NOEXCEPT
    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO(PermitVibration)

        NN_SF_CMIF_DETAIL_METHOD_INFO_METHOD_ID(204)
        NN_SF_CMIF_DETAIL_METHOD_INFO_RETURN_TYPE_IS_RESULT(true)

        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_MEMBER(isPermitted, (bool), 0)
        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_END(1, (isPermitted))
        NN_SF_CMIF_DETAIL_METHOD_INFO_IN_RAW_SIZE(1)

        NN_SF_CMIF_DETAIL_METHOD_INFO_ARGUMENT_INFOS((NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(isPermitted)))

    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO_END(PermitVibration)

    // nn::Result IsVibrationPermitted(nn::sf::Out<bool> outValue) NN_NOEXCEPT
    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO(IsVibrationPermitted)

        NN_SF_CMIF_DETAIL_METHOD_INFO_METHOD_ID(205)
        NN_SF_CMIF_DETAIL_METHOD_INFO_RETURN_TYPE_IS_RESULT(true)

        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT_MEMBER(outValue, (bool), 0)
        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT_END(1, (outValue))
        NN_SF_CMIF_DETAIL_METHOD_INFO_OUT_RAW_SIZE(1)

        NN_SF_CMIF_DETAIL_METHOD_INFO_ARGUMENT_INFOS((NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(outValue)))

    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO_END(IsVibrationPermitted)

    // nn::Result SendVibrationValues(nn::applet::AppletResourceUserId aruid, const nn::sf::InArray<nn::hid::VibrationDeviceHandle>& handles, const nn::sf::InArray<nn::hid::VibrationValue>& values) NN_NOEXCEPT
    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO(SendVibrationValues)

        NN_SF_CMIF_DETAIL_METHOD_INFO_METHOD_ID(206)
        NN_SF_CMIF_DETAIL_METHOD_INFO_RETURN_TYPE_IS_RESULT(true)

        NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_COUNT(2)
        NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_INFOS
            NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_INFO(handles, 0, (const ::nn::sf::InArray<::nn::hid::VibrationDeviceHandle>&), NN_SF_CMIF_DETAIL_BUFFER_ATTRIBUTE_IN | NN_SF_CMIF_DETAIL_BUFFER_ATTRIBUTE_HIPC_POINTER)
            NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_INFO(values, 1, (const ::nn::sf::InArray<::nn::hid::VibrationValue>&), NN_SF_CMIF_DETAIL_BUFFER_ATTRIBUTE_IN | NN_SF_CMIF_DETAIL_BUFFER_ATTRIBUTE_HIPC_POINTER)
        NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_INFOS_END(2, (handles, values))

        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_MEMBER(aruid, (::nn::applet::AppletResourceUserId), 0)
        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_END(1, (aruid))
        NN_SF_CMIF_DETAIL_METHOD_INFO_IN_RAW_SIZE(8)

        NN_SF_CMIF_DETAIL_METHOD_INFO_ARGUMENT_INFOS((NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(aruid), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(handles), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(values)))

    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO_END(SendVibrationValues)

    // nn::Result SendVibrationGcErmCommand(nn::applet::AppletResourceUserId aruid, nn::hid::VibrationDeviceHandle handle, nn::hid::VibrationGcErmCommand command) NN_NOEXCEPT
    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO(SendVibrationGcErmCommand)

        NN_SF_CMIF_DETAIL_METHOD_INFO_METHOD_ID(207)
        NN_SF_CMIF_DETAIL_METHOD_INFO_RETURN_TYPE_IS_RESULT(true)

        NN_SF_CMIF_DETAIL_METHOD_INFO_IN_PROCESS_ID_ENABLE()

        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_MEMBER(handle, (::nn::hid::VibrationDeviceHandle), 0)
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_MEMBER(aruid, (::nn::applet::AppletResourceUserId), 8)
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_MEMBER(command, (::nn::hid::VibrationGcErmCommand), 16)
        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_END(3, (handle, aruid, command))
        NN_SF_CMIF_DETAIL_METHOD_INFO_IN_RAW_SIZE(24)

        NN_SF_CMIF_DETAIL_METHOD_INFO_ARGUMENT_INFOS((NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(aruid), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(handle), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(command)))

    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO_END(SendVibrationGcErmCommand)

    // nn::Result GetActualVibrationGcErmCommand(nn::sf::Out<nn::hid::VibrationGcErmCommand> outValue, nn::applet::AppletResourceUserId aruid, nn::hid::VibrationDeviceHandle handle) NN_NOEXCEPT
    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO(GetActualVibrationGcErmCommand)

        NN_SF_CMIF_DETAIL_METHOD_INFO_METHOD_ID(208)
        NN_SF_CMIF_DETAIL_METHOD_INFO_RETURN_TYPE_IS_RESULT(true)

        NN_SF_CMIF_DETAIL_METHOD_INFO_IN_PROCESS_ID_ENABLE()

        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_MEMBER(handle, (::nn::hid::VibrationDeviceHandle), 0)
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_MEMBER(aruid, (::nn::applet::AppletResourceUserId), 8)
        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_END(2, (handle, aruid))
        NN_SF_CMIF_DETAIL_METHOD_INFO_IN_RAW_SIZE(16)

        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT_MEMBER(outValue, (::nn::hid::VibrationGcErmCommand), 0)
        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT_END(1, (outValue))
        NN_SF_CMIF_DETAIL_METHOD_INFO_OUT_RAW_SIZE(8)

        NN_SF_CMIF_DETAIL_METHOD_INFO_ARGUMENT_INFOS((NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(outValue), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(aruid), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(handle)))

    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO_END(GetActualVibrationGcErmCommand)

    // nn::Result BeginPermitVibrationSession(nn::applet::AppletResourceUserId aruid) NN_NOEXCEPT
    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO(BeginPermitVibrationSession)

        NN_SF_CMIF_DETAIL_METHOD_INFO_METHOD_ID(209)
        NN_SF_CMIF_DETAIL_METHOD_INFO_RETURN_TYPE_IS_RESULT(true)

        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_MEMBER(aruid, (::nn::applet::AppletResourceUserId), 0)
        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_END(1, (aruid))
        NN_SF_CMIF_DETAIL_METHOD_INFO_IN_RAW_SIZE(8)

        NN_SF_CMIF_DETAIL_METHOD_INFO_ARGUMENT_INFOS((NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(aruid)))

    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO_END(BeginPermitVibrationSession)

    // nn::Result EndPermitVibrationSession() NN_NOEXCEPT
    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO(EndPermitVibrationSession)

        NN_SF_CMIF_DETAIL_METHOD_INFO_METHOD_ID(210)
        NN_SF_CMIF_DETAIL_METHOD_INFO_RETURN_TYPE_IS_RESULT(true)

        NN_SF_CMIF_DETAIL_METHOD_INFO_ARGUMENT_INFOS(())

    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO_END(EndPermitVibrationSession)

    // nn::Result ActivateConsoleSixAxisSensor(nn::applet::AppletResourceUserId aruid) NN_NOEXCEPT
    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO(ActivateConsoleSixAxisSensor)

        NN_SF_CMIF_DETAIL_METHOD_INFO_METHOD_ID(300)
        NN_SF_CMIF_DETAIL_METHOD_INFO_RETURN_TYPE_IS_RESULT(true)

        NN_SF_CMIF_DETAIL_METHOD_INFO_IN_PROCESS_ID_ENABLE()

        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_MEMBER(aruid, (::nn::applet::AppletResourceUserId), 0)
        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_END(1, (aruid))
        NN_SF_CMIF_DETAIL_METHOD_INFO_IN_RAW_SIZE(8)

        NN_SF_CMIF_DETAIL_METHOD_INFO_ARGUMENT_INFOS((NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(aruid)))

    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO_END(ActivateConsoleSixAxisSensor)

    // nn::Result StartConsoleSixAxisSensor(nn::applet::AppletResourceUserId aruid, nn::hid::ConsoleSixAxisSensorHandle handle) NN_NOEXCEPT
    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO(StartConsoleSixAxisSensor)

        NN_SF_CMIF_DETAIL_METHOD_INFO_METHOD_ID(301)
        NN_SF_CMIF_DETAIL_METHOD_INFO_RETURN_TYPE_IS_RESULT(true)

        NN_SF_CMIF_DETAIL_METHOD_INFO_IN_PROCESS_ID_ENABLE()

        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_MEMBER(handle, (::nn::hid::ConsoleSixAxisSensorHandle), 0)
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_MEMBER(aruid, (::nn::applet::AppletResourceUserId), 8)
        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_END(2, (handle, aruid))
        NN_SF_CMIF_DETAIL_METHOD_INFO_IN_RAW_SIZE(16)

        NN_SF_CMIF_DETAIL_METHOD_INFO_ARGUMENT_INFOS((NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(aruid), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(handle)))

    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO_END(StartConsoleSixAxisSensor)

    // nn::Result StopConsoleSixAxisSensor(nn::applet::AppletResourceUserId aruid, nn::hid::ConsoleSixAxisSensorHandle handle) NN_NOEXCEPT
    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO(StopConsoleSixAxisSensor)

        NN_SF_CMIF_DETAIL_METHOD_INFO_METHOD_ID(302)
        NN_SF_CMIF_DETAIL_METHOD_INFO_RETURN_TYPE_IS_RESULT(true)

        NN_SF_CMIF_DETAIL_METHOD_INFO_IN_PROCESS_ID_ENABLE()

        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_MEMBER(handle, (::nn::hid::ConsoleSixAxisSensorHandle), 0)
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_MEMBER(aruid, (::nn::applet::AppletResourceUserId), 8)
        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_END(2, (handle, aruid))
        NN_SF_CMIF_DETAIL_METHOD_INFO_IN_RAW_SIZE(16)

        NN_SF_CMIF_DETAIL_METHOD_INFO_ARGUMENT_INFOS((NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(aruid), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(handle)))

    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO_END(StopConsoleSixAxisSensor)

    // nn::Result ActivateSevenSixAxisSensor(nn::applet::AppletResourceUserId aruid) NN_NOEXCEPT
    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO(ActivateSevenSixAxisSensor)

        NN_SF_CMIF_DETAIL_METHOD_INFO_METHOD_ID(303)
        NN_SF_CMIF_DETAIL_METHOD_INFO_RETURN_TYPE_IS_RESULT(true)

        NN_SF_CMIF_DETAIL_METHOD_INFO_IN_PROCESS_ID_ENABLE()

        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_MEMBER(aruid, (::nn::applet::AppletResourceUserId), 0)
        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_END(1, (aruid))
        NN_SF_CMIF_DETAIL_METHOD_INFO_IN_RAW_SIZE(8)

        NN_SF_CMIF_DETAIL_METHOD_INFO_ARGUMENT_INFOS((NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(aruid)))

    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO_END(ActivateSevenSixAxisSensor)

    // nn::Result StartSevenSixAxisSensor(nn::applet::AppletResourceUserId aruid) NN_NOEXCEPT
    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO(StartSevenSixAxisSensor)

        NN_SF_CMIF_DETAIL_METHOD_INFO_METHOD_ID(304)
        NN_SF_CMIF_DETAIL_METHOD_INFO_RETURN_TYPE_IS_RESULT(true)

        NN_SF_CMIF_DETAIL_METHOD_INFO_IN_PROCESS_ID_ENABLE()

        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_MEMBER(aruid, (::nn::applet::AppletResourceUserId), 0)
        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_END(1, (aruid))
        NN_SF_CMIF_DETAIL_METHOD_INFO_IN_RAW_SIZE(8)

        NN_SF_CMIF_DETAIL_METHOD_INFO_ARGUMENT_INFOS((NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(aruid)))

    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO_END(StartSevenSixAxisSensor)

    // nn::Result StopSevenSixAxisSensor(nn::applet::AppletResourceUserId aruid) NN_NOEXCEPT
    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO(StopSevenSixAxisSensor)

        NN_SF_CMIF_DETAIL_METHOD_INFO_METHOD_ID(305)
        NN_SF_CMIF_DETAIL_METHOD_INFO_RETURN_TYPE_IS_RESULT(true)

        NN_SF_CMIF_DETAIL_METHOD_INFO_IN_PROCESS_ID_ENABLE()

        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_MEMBER(aruid, (::nn::applet::AppletResourceUserId), 0)
        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_END(1, (aruid))
        NN_SF_CMIF_DETAIL_METHOD_INFO_IN_RAW_SIZE(8)

        NN_SF_CMIF_DETAIL_METHOD_INFO_ARGUMENT_INFOS((NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(aruid)))

    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO_END(StopSevenSixAxisSensor)

    // nn::Result InitializeSevenSixAxisSensor(nn::applet::AppletResourceUserId aruid, nn::sf::NativeHandle&& stateBufferHandle, std::uint64_t stateBufferSize, nn::sf::NativeHandle&& workBufferHandle, std::uint64_t workBufferSize) NN_NOEXCEPT
    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO(InitializeSevenSixAxisSensor)

        NN_SF_CMIF_DETAIL_METHOD_INFO_METHOD_ID(306)
        NN_SF_CMIF_DETAIL_METHOD_INFO_RETURN_TYPE_IS_RESULT(true)

        NN_SF_CMIF_DETAIL_METHOD_INFO_IN_PROCESS_ID_ENABLE()

        NN_SF_CMIF_DETAIL_METHOD_INFO_IN_NATIVE_HANDLE_COUNT(2)
        NN_SF_CMIF_DETAIL_METHOD_INFO_IN_NATIVE_HANDLE_INFOS
            NN_SF_CMIF_DETAIL_METHOD_INFO_IN_NATIVE_HANDLE_INFO(stateBufferHandle, 0, NN_SF_CMIF_DETAIL_NATIVE_HANDLE_ATTRIBUTE_HIPC_COPY)
            NN_SF_CMIF_DETAIL_METHOD_INFO_IN_NATIVE_HANDLE_INFO(workBufferHandle, 1, NN_SF_CMIF_DETAIL_NATIVE_HANDLE_ATTRIBUTE_HIPC_COPY)
        NN_SF_CMIF_DETAIL_METHOD_INFO_IN_NATIVE_HANDLE_INFOS_END(2, (stateBufferHandle, workBufferHandle))

        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_MEMBER(aruid, (::nn::applet::AppletResourceUserId), 0)
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_MEMBER(stateBufferSize, (::std::uint64_t), 8)
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_MEMBER(workBufferSize, (::std::uint64_t), 16)
        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_END(3, (aruid, stateBufferSize, workBufferSize))
        NN_SF_CMIF_DETAIL_METHOD_INFO_IN_RAW_SIZE(24)

        NN_SF_CMIF_DETAIL_METHOD_INFO_ARGUMENT_INFOS((NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(aruid), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(stateBufferHandle), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(stateBufferSize), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(workBufferHandle), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(workBufferSize)))

    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO_END(InitializeSevenSixAxisSensor)

    // nn::Result FinalizeSevenSixAxisSensor(nn::applet::AppletResourceUserId aruid) NN_NOEXCEPT
    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO(FinalizeSevenSixAxisSensor)

        NN_SF_CMIF_DETAIL_METHOD_INFO_METHOD_ID(307)
        NN_SF_CMIF_DETAIL_METHOD_INFO_RETURN_TYPE_IS_RESULT(true)

        NN_SF_CMIF_DETAIL_METHOD_INFO_IN_PROCESS_ID_ENABLE()

        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_MEMBER(aruid, (::nn::applet::AppletResourceUserId), 0)
        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_END(1, (aruid))
        NN_SF_CMIF_DETAIL_METHOD_INFO_IN_RAW_SIZE(8)

        NN_SF_CMIF_DETAIL_METHOD_INFO_ARGUMENT_INFOS((NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(aruid)))

    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO_END(FinalizeSevenSixAxisSensor)

    // nn::Result SetSevenSixAxisSensorFusionStrength(nn::applet::AppletResourceUserId aruid, float strength) NN_NOEXCEPT
    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO(SetSevenSixAxisSensorFusionStrength)

        NN_SF_CMIF_DETAIL_METHOD_INFO_METHOD_ID(308)
        NN_SF_CMIF_DETAIL_METHOD_INFO_RETURN_TYPE_IS_RESULT(true)

        NN_SF_CMIF_DETAIL_METHOD_INFO_IN_PROCESS_ID_ENABLE()

        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_MEMBER(strength, (float), 0)
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_MEMBER(aruid, (::nn::applet::AppletResourceUserId), 8)
        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_END(2, (strength, aruid))
        NN_SF_CMIF_DETAIL_METHOD_INFO_IN_RAW_SIZE(16)

        NN_SF_CMIF_DETAIL_METHOD_INFO_ARGUMENT_INFOS((NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(aruid), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(strength)))

    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO_END(SetSevenSixAxisSensorFusionStrength)

    // nn::Result GetSevenSixAxisSensorFusionStrength(nn::sf::Out<float> strength, nn::applet::AppletResourceUserId aruid) NN_NOEXCEPT
    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO(GetSevenSixAxisSensorFusionStrength)

        NN_SF_CMIF_DETAIL_METHOD_INFO_METHOD_ID(309)
        NN_SF_CMIF_DETAIL_METHOD_INFO_RETURN_TYPE_IS_RESULT(true)

        NN_SF_CMIF_DETAIL_METHOD_INFO_IN_PROCESS_ID_ENABLE()

        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_MEMBER(aruid, (::nn::applet::AppletResourceUserId), 0)
        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_END(1, (aruid))
        NN_SF_CMIF_DETAIL_METHOD_INFO_IN_RAW_SIZE(8)

        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT_MEMBER(strength, (float), 0)
        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT_END(1, (strength))
        NN_SF_CMIF_DETAIL_METHOD_INFO_OUT_RAW_SIZE(4)

        NN_SF_CMIF_DETAIL_METHOD_INFO_ARGUMENT_INFOS((NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(strength), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(aruid)))

    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO_END(GetSevenSixAxisSensorFusionStrength)

    // nn::Result IsUsbFullKeyControllerEnabled(nn::sf::Out<bool> outIsEnabled) NN_NOEXCEPT
    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO(IsUsbFullKeyControllerEnabled)

        NN_SF_CMIF_DETAIL_METHOD_INFO_METHOD_ID(400)
        NN_SF_CMIF_DETAIL_METHOD_INFO_RETURN_TYPE_IS_RESULT(true)

        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT_MEMBER(outIsEnabled, (bool), 0)
        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT_END(1, (outIsEnabled))
        NN_SF_CMIF_DETAIL_METHOD_INFO_OUT_RAW_SIZE(1)

        NN_SF_CMIF_DETAIL_METHOD_INFO_ARGUMENT_INFOS((NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(outIsEnabled)))

    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO_END(IsUsbFullKeyControllerEnabled)

    // nn::Result EnableUsbFullKeyController(bool enabled) NN_NOEXCEPT
    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO(EnableUsbFullKeyController)

        NN_SF_CMIF_DETAIL_METHOD_INFO_METHOD_ID(401)
        NN_SF_CMIF_DETAIL_METHOD_INFO_RETURN_TYPE_IS_RESULT(true)

        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_MEMBER(enabled, (bool), 0)
        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_END(1, (enabled))
        NN_SF_CMIF_DETAIL_METHOD_INFO_IN_RAW_SIZE(1)

        NN_SF_CMIF_DETAIL_METHOD_INFO_ARGUMENT_INFOS((NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(enabled)))

    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO_END(EnableUsbFullKeyController)

    // nn::Result IsUsbFullKeyControllerConnected(nn::sf::Out<bool> outIsConnected, nn::hid::NpadIdType id) NN_NOEXCEPT
    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO(IsUsbFullKeyControllerConnected)

        NN_SF_CMIF_DETAIL_METHOD_INFO_METHOD_ID(402)
        NN_SF_CMIF_DETAIL_METHOD_INFO_RETURN_TYPE_IS_RESULT(true)

        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_MEMBER(id, (::nn::hid::NpadIdType), 0)
        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_END(1, (id))
        NN_SF_CMIF_DETAIL_METHOD_INFO_IN_RAW_SIZE(4)

        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT_MEMBER(outIsConnected, (bool), 0)
        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT_END(1, (outIsConnected))
        NN_SF_CMIF_DETAIL_METHOD_INFO_OUT_RAW_SIZE(1)

        NN_SF_CMIF_DETAIL_METHOD_INFO_ARGUMENT_INFOS((NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(outIsConnected), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(id)))

    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO_END(IsUsbFullKeyControllerConnected)

    // nn::Result HasBattery(nn::sf::Out<bool> outHasBattery, nn::hid::NpadIdType id) NN_NOEXCEPT
    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO(HasBattery)

        NN_SF_CMIF_DETAIL_METHOD_INFO_METHOD_ID(403)
        NN_SF_CMIF_DETAIL_METHOD_INFO_RETURN_TYPE_IS_RESULT(true)

        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_MEMBER(id, (::nn::hid::NpadIdType), 0)
        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_END(1, (id))
        NN_SF_CMIF_DETAIL_METHOD_INFO_IN_RAW_SIZE(4)

        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT_MEMBER(outHasBattery, (bool), 0)
        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT_END(1, (outHasBattery))
        NN_SF_CMIF_DETAIL_METHOD_INFO_OUT_RAW_SIZE(1)

        NN_SF_CMIF_DETAIL_METHOD_INFO_ARGUMENT_INFOS((NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(outHasBattery), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(id)))

    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO_END(HasBattery)

    // nn::Result HasLeftRightBattery(nn::sf::Out<bool> outLeftJoyHasBattery, nn::sf::Out<bool> outRightJoyHasBattery, nn::hid::NpadIdType id) NN_NOEXCEPT
    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO(HasLeftRightBattery)

        NN_SF_CMIF_DETAIL_METHOD_INFO_METHOD_ID(404)
        NN_SF_CMIF_DETAIL_METHOD_INFO_RETURN_TYPE_IS_RESULT(true)

        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_MEMBER(id, (::nn::hid::NpadIdType), 0)
        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_END(1, (id))
        NN_SF_CMIF_DETAIL_METHOD_INFO_IN_RAW_SIZE(4)

        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT_MEMBER(outLeftJoyHasBattery, (bool), 0)
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT_MEMBER(outRightJoyHasBattery, (bool), 1)
        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT_END(2, (outLeftJoyHasBattery, outRightJoyHasBattery))
        NN_SF_CMIF_DETAIL_METHOD_INFO_OUT_RAW_SIZE(2)

        NN_SF_CMIF_DETAIL_METHOD_INFO_ARGUMENT_INFOS((NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(outLeftJoyHasBattery), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(outRightJoyHasBattery), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(id)))

    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO_END(HasLeftRightBattery)

    // nn::Result GetNpadInterfaceType(nn::sf::Out<nn::hid::system::InterfaceType> outInterfaceType, nn::hid::NpadIdType id) NN_NOEXCEPT
    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO(GetNpadInterfaceType)

        NN_SF_CMIF_DETAIL_METHOD_INFO_METHOD_ID(405)
        NN_SF_CMIF_DETAIL_METHOD_INFO_RETURN_TYPE_IS_RESULT(true)

        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_MEMBER(id, (::nn::hid::NpadIdType), 0)
        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_END(1, (id))
        NN_SF_CMIF_DETAIL_METHOD_INFO_IN_RAW_SIZE(4)

        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT_MEMBER(outInterfaceType, (::nn::hid::system::InterfaceType), 0)
        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT_END(1, (outInterfaceType))
        NN_SF_CMIF_DETAIL_METHOD_INFO_OUT_RAW_SIZE(1)

        NN_SF_CMIF_DETAIL_METHOD_INFO_ARGUMENT_INFOS((NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(outInterfaceType), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(id)))

    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO_END(GetNpadInterfaceType)

    // nn::Result GetNpadLeftRightInterfaceType(nn::sf::Out<nn::hid::system::InterfaceType> outLeftJoyInterfaceType, nn::sf::Out<nn::hid::system::InterfaceType> outRightJoyInterfaceType, nn::hid::NpadIdType id) NN_NOEXCEPT
    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO(GetNpadLeftRightInterfaceType)

        NN_SF_CMIF_DETAIL_METHOD_INFO_METHOD_ID(406)
        NN_SF_CMIF_DETAIL_METHOD_INFO_RETURN_TYPE_IS_RESULT(true)

        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_MEMBER(id, (::nn::hid::NpadIdType), 0)
        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_END(1, (id))
        NN_SF_CMIF_DETAIL_METHOD_INFO_IN_RAW_SIZE(4)

        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT_MEMBER(outLeftJoyInterfaceType, (::nn::hid::system::InterfaceType), 0)
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT_MEMBER(outRightJoyInterfaceType, (::nn::hid::system::InterfaceType), 1)
        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT_END(2, (outLeftJoyInterfaceType, outRightJoyInterfaceType))
        NN_SF_CMIF_DETAIL_METHOD_INFO_OUT_RAW_SIZE(2)

        NN_SF_CMIF_DETAIL_METHOD_INFO_ARGUMENT_INFOS((NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(outLeftJoyInterfaceType), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(outRightJoyInterfaceType), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(id)))

    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO_END(GetNpadLeftRightInterfaceType)

    // nn::Result GetPalmaConnectionHandle(nn::sf::Out<nn::hid::PalmaConnectionHandle> outHandle, nn::hid::NpadIdType id, nn::applet::AppletResourceUserId aruid) NN_NOEXCEPT
    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO(GetPalmaConnectionHandle)

        NN_SF_CMIF_DETAIL_METHOD_INFO_METHOD_ID(500)
        NN_SF_CMIF_DETAIL_METHOD_INFO_RETURN_TYPE_IS_RESULT(true)

        NN_SF_CMIF_DETAIL_METHOD_INFO_IN_PROCESS_ID_ENABLE()

        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_MEMBER(id, (::nn::hid::NpadIdType), 0)
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_MEMBER(aruid, (::nn::applet::AppletResourceUserId), 8)
        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_END(2, (id, aruid))
        NN_SF_CMIF_DETAIL_METHOD_INFO_IN_RAW_SIZE(16)

        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT_MEMBER(outHandle, (::nn::hid::PalmaConnectionHandle), 0)
        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT_END(1, (outHandle))
        NN_SF_CMIF_DETAIL_METHOD_INFO_OUT_RAW_SIZE(8)

        NN_SF_CMIF_DETAIL_METHOD_INFO_ARGUMENT_INFOS((NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(outHandle), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(id), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(aruid)))

    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO_END(GetPalmaConnectionHandle)

    // nn::Result InitializePalma(nn::hid::PalmaConnectionHandle handle) NN_NOEXCEPT
    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO(InitializePalma)

        NN_SF_CMIF_DETAIL_METHOD_INFO_METHOD_ID(501)
        NN_SF_CMIF_DETAIL_METHOD_INFO_RETURN_TYPE_IS_RESULT(true)

        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_MEMBER(handle, (::nn::hid::PalmaConnectionHandle), 0)
        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_END(1, (handle))
        NN_SF_CMIF_DETAIL_METHOD_INFO_IN_RAW_SIZE(8)

        NN_SF_CMIF_DETAIL_METHOD_INFO_ARGUMENT_INFOS((NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(handle)))

    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO_END(InitializePalma)

    // nn::Result AcquirePalmaOperationCompleteEvent(nn::sf::Out<nn::sf::NativeHandle> outValue, nn::hid::PalmaConnectionHandle handle) NN_NOEXCEPT
    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO(AcquirePalmaOperationCompleteEvent)

        NN_SF_CMIF_DETAIL_METHOD_INFO_METHOD_ID(502)
        NN_SF_CMIF_DETAIL_METHOD_INFO_RETURN_TYPE_IS_RESULT(true)

        NN_SF_CMIF_DETAIL_METHOD_INFO_OUT_NATIVE_HANDLE_COUNT(1)
        NN_SF_CMIF_DETAIL_METHOD_INFO_OUT_NATIVE_HANDLE_INFOS
            NN_SF_CMIF_DETAIL_METHOD_INFO_OUT_NATIVE_HANDLE_INFO(outValue, 0, NN_SF_CMIF_DETAIL_NATIVE_HANDLE_ATTRIBUTE_HIPC_COPY)
        NN_SF_CMIF_DETAIL_METHOD_INFO_OUT_NATIVE_HANDLE_INFOS_END(1, (outValue))

        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_MEMBER(handle, (::nn::hid::PalmaConnectionHandle), 0)
        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_END(1, (handle))
        NN_SF_CMIF_DETAIL_METHOD_INFO_IN_RAW_SIZE(8)

        NN_SF_CMIF_DETAIL_METHOD_INFO_ARGUMENT_INFOS((NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(outValue), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(handle)))

    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO_END(AcquirePalmaOperationCompleteEvent)

    // nn::Result GetPalmaOperationInfo(nn::sf::Out<std::uint64_t> outType, const nn::sf::OutBuffer& outBuffer, nn::hid::PalmaConnectionHandle handle) NN_NOEXCEPT
    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO(GetPalmaOperationInfo)

        NN_SF_CMIF_DETAIL_METHOD_INFO_METHOD_ID(503)
        NN_SF_CMIF_DETAIL_METHOD_INFO_RETURN_TYPE_IS_RESULT(true)

        NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_COUNT(1)
        NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_INFOS
            NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_INFO(outBuffer, 0, (const ::nn::sf::OutBuffer&), NN_SF_CMIF_DETAIL_BUFFER_ATTRIBUTE_OUT | NN_SF_CMIF_DETAIL_BUFFER_ATTRIBUTE_HIPC_MAP_ALIAS)
        NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_INFOS_END(1, (outBuffer))

        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_MEMBER(handle, (::nn::hid::PalmaConnectionHandle), 0)
        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_END(1, (handle))
        NN_SF_CMIF_DETAIL_METHOD_INFO_IN_RAW_SIZE(8)

        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT_MEMBER(outType, (::std::uint64_t), 0)
        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT_END(1, (outType))
        NN_SF_CMIF_DETAIL_METHOD_INFO_OUT_RAW_SIZE(8)

        NN_SF_CMIF_DETAIL_METHOD_INFO_ARGUMENT_INFOS((NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(outType), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(outBuffer), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(handle)))

    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO_END(GetPalmaOperationInfo)

    // nn::Result PlayPalmaActivity(nn::hid::PalmaConnectionHandle handle, std::uint64_t index) NN_NOEXCEPT
    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO(PlayPalmaActivity)

        NN_SF_CMIF_DETAIL_METHOD_INFO_METHOD_ID(504)
        NN_SF_CMIF_DETAIL_METHOD_INFO_RETURN_TYPE_IS_RESULT(true)

        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_MEMBER(handle, (::nn::hid::PalmaConnectionHandle), 0)
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_MEMBER(index, (::std::uint64_t), 8)
        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_END(2, (handle, index))
        NN_SF_CMIF_DETAIL_METHOD_INFO_IN_RAW_SIZE(16)

        NN_SF_CMIF_DETAIL_METHOD_INFO_ARGUMENT_INFOS((NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(handle), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(index)))

    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO_END(PlayPalmaActivity)

    // nn::Result SetPalmaFrModeType(nn::hid::PalmaConnectionHandle handle, std::uint64_t type) NN_NOEXCEPT
    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO(SetPalmaFrModeType)

        NN_SF_CMIF_DETAIL_METHOD_INFO_METHOD_ID(505)
        NN_SF_CMIF_DETAIL_METHOD_INFO_RETURN_TYPE_IS_RESULT(true)

        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_MEMBER(handle, (::nn::hid::PalmaConnectionHandle), 0)
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_MEMBER(type, (::std::uint64_t), 8)
        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_END(2, (handle, type))
        NN_SF_CMIF_DETAIL_METHOD_INFO_IN_RAW_SIZE(16)

        NN_SF_CMIF_DETAIL_METHOD_INFO_ARGUMENT_INFOS((NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(handle), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(type)))

    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO_END(SetPalmaFrModeType)

    // nn::Result ReadPalmaStep(nn::hid::PalmaConnectionHandle handle) NN_NOEXCEPT
    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO(ReadPalmaStep)

        NN_SF_CMIF_DETAIL_METHOD_INFO_METHOD_ID(506)
        NN_SF_CMIF_DETAIL_METHOD_INFO_RETURN_TYPE_IS_RESULT(true)

        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_MEMBER(handle, (::nn::hid::PalmaConnectionHandle), 0)
        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_END(1, (handle))
        NN_SF_CMIF_DETAIL_METHOD_INFO_IN_RAW_SIZE(8)

        NN_SF_CMIF_DETAIL_METHOD_INFO_ARGUMENT_INFOS((NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(handle)))

    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO_END(ReadPalmaStep)

    // nn::Result EnablePalmaStep(nn::hid::PalmaConnectionHandle handle, bool isEnabled) NN_NOEXCEPT
    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO(EnablePalmaStep)

        NN_SF_CMIF_DETAIL_METHOD_INFO_METHOD_ID(507)
        NN_SF_CMIF_DETAIL_METHOD_INFO_RETURN_TYPE_IS_RESULT(true)

        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_MEMBER(isEnabled, (bool), 0)
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_MEMBER(handle, (::nn::hid::PalmaConnectionHandle), 8)
        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_END(2, (isEnabled, handle))
        NN_SF_CMIF_DETAIL_METHOD_INFO_IN_RAW_SIZE(16)

        NN_SF_CMIF_DETAIL_METHOD_INFO_ARGUMENT_INFOS((NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(handle), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(isEnabled)))

    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO_END(EnablePalmaStep)

    // nn::Result ResetPalmaStep(nn::hid::PalmaConnectionHandle handle) NN_NOEXCEPT
    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO(ResetPalmaStep)

        NN_SF_CMIF_DETAIL_METHOD_INFO_METHOD_ID(508)
        NN_SF_CMIF_DETAIL_METHOD_INFO_RETURN_TYPE_IS_RESULT(true)

        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_MEMBER(handle, (::nn::hid::PalmaConnectionHandle), 0)
        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_END(1, (handle))
        NN_SF_CMIF_DETAIL_METHOD_INFO_IN_RAW_SIZE(8)

        NN_SF_CMIF_DETAIL_METHOD_INFO_ARGUMENT_INFOS((NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(handle)))

    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO_END(ResetPalmaStep)

    // nn::Result ReadPalmaApplicationSection(nn::hid::PalmaConnectionHandle handle, std::uint64_t address, std::uint64_t size) NN_NOEXCEPT
    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO(ReadPalmaApplicationSection)

        NN_SF_CMIF_DETAIL_METHOD_INFO_METHOD_ID(509)
        NN_SF_CMIF_DETAIL_METHOD_INFO_RETURN_TYPE_IS_RESULT(true)

        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_MEMBER(handle, (::nn::hid::PalmaConnectionHandle), 0)
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_MEMBER(address, (::std::uint64_t), 8)
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_MEMBER(size, (::std::uint64_t), 16)
        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_END(3, (handle, address, size))
        NN_SF_CMIF_DETAIL_METHOD_INFO_IN_RAW_SIZE(24)

        NN_SF_CMIF_DETAIL_METHOD_INFO_ARGUMENT_INFOS((NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(handle), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(address), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(size)))

    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO_END(ReadPalmaApplicationSection)

    // nn::Result WritePalmaApplicationSection(nn::hid::PalmaConnectionHandle handle, std::uint64_t address, std::uint64_t size, const nn::hid::PalmaApplicationSectionAccessBuffer& buffer) NN_NOEXCEPT
    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO(WritePalmaApplicationSection)

        NN_SF_CMIF_DETAIL_METHOD_INFO_METHOD_ID(510)
        NN_SF_CMIF_DETAIL_METHOD_INFO_RETURN_TYPE_IS_RESULT(true)

        NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_COUNT(1)
        NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_INFOS
            NN_SF_CMIF_DETAIL_METHOD_INFO_FIXED_SIZE_BUFFER_INFO(buffer, 0, (const ::nn::hid::PalmaApplicationSectionAccessBuffer&), 256, NN_SF_CMIF_DETAIL_BUFFER_ATTRIBUTE_IN | NN_SF_CMIF_DETAIL_BUFFER_ATTRIBUTE_HIPC_POINTER)
        NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_INFOS_END(1, (buffer))

        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_MEMBER(handle, (::nn::hid::PalmaConnectionHandle), 0)
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_MEMBER(address, (::std::uint64_t), 8)
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_MEMBER(size, (::std::uint64_t), 16)
        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_END(3, (handle, address, size))
        NN_SF_CMIF_DETAIL_METHOD_INFO_IN_RAW_SIZE(24)

        NN_SF_CMIF_DETAIL_METHOD_INFO_ARGUMENT_INFOS((NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(handle), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(address), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(size), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(buffer)))

    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO_END(WritePalmaApplicationSection)

    // nn::Result ReadPalmaUniqueCode(nn::hid::PalmaConnectionHandle handle) NN_NOEXCEPT
    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO(ReadPalmaUniqueCode)

        NN_SF_CMIF_DETAIL_METHOD_INFO_METHOD_ID(511)
        NN_SF_CMIF_DETAIL_METHOD_INFO_RETURN_TYPE_IS_RESULT(true)

        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_MEMBER(handle, (::nn::hid::PalmaConnectionHandle), 0)
        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_END(1, (handle))
        NN_SF_CMIF_DETAIL_METHOD_INFO_IN_RAW_SIZE(8)

        NN_SF_CMIF_DETAIL_METHOD_INFO_ARGUMENT_INFOS((NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(handle)))

    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO_END(ReadPalmaUniqueCode)

    // nn::Result SetPalmaUniqueCodeInvalid(nn::hid::PalmaConnectionHandle handle) NN_NOEXCEPT
    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO(SetPalmaUniqueCodeInvalid)

        NN_SF_CMIF_DETAIL_METHOD_INFO_METHOD_ID(512)
        NN_SF_CMIF_DETAIL_METHOD_INFO_RETURN_TYPE_IS_RESULT(true)

        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_MEMBER(handle, (::nn::hid::PalmaConnectionHandle), 0)
        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_END(1, (handle))
        NN_SF_CMIF_DETAIL_METHOD_INFO_IN_RAW_SIZE(8)

        NN_SF_CMIF_DETAIL_METHOD_INFO_ARGUMENT_INFOS((NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(handle)))

    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO_END(SetPalmaUniqueCodeInvalid)

    // nn::Result WritePalmaActivityEntry(nn::hid::PalmaConnectionHandle handle, std::uint64_t index, std::uint64_t ledIndex, std::uint64_t waveSet, std::uint64_t waveIndex) NN_NOEXCEPT
    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO(WritePalmaActivityEntry)

        NN_SF_CMIF_DETAIL_METHOD_INFO_METHOD_ID(513)
        NN_SF_CMIF_DETAIL_METHOD_INFO_RETURN_TYPE_IS_RESULT(true)

        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_MEMBER(handle, (::nn::hid::PalmaConnectionHandle), 0)
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_MEMBER(index, (::std::uint64_t), 8)
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_MEMBER(ledIndex, (::std::uint64_t), 16)
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_MEMBER(waveSet, (::std::uint64_t), 24)
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_MEMBER(waveIndex, (::std::uint64_t), 32)
        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_END(5, (handle, index, ledIndex, waveSet, waveIndex))
        NN_SF_CMIF_DETAIL_METHOD_INFO_IN_RAW_SIZE(40)

        NN_SF_CMIF_DETAIL_METHOD_INFO_ARGUMENT_INFOS((NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(handle), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(index), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(ledIndex), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(waveSet), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(waveIndex)))

    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO_END(WritePalmaActivityEntry)

    // nn::Result WritePalmaRgbLedPatternEntry(nn::hid::PalmaConnectionHandle handle, std::uint64_t index, const nn::sf::InBuffer& pInBuffer) NN_NOEXCEPT
    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO(WritePalmaRgbLedPatternEntry)

        NN_SF_CMIF_DETAIL_METHOD_INFO_METHOD_ID(514)
        NN_SF_CMIF_DETAIL_METHOD_INFO_RETURN_TYPE_IS_RESULT(true)

        NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_COUNT(1)
        NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_INFOS
            NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_INFO(pInBuffer, 0, (const ::nn::sf::InBuffer&), NN_SF_CMIF_DETAIL_BUFFER_ATTRIBUTE_IN | NN_SF_CMIF_DETAIL_BUFFER_ATTRIBUTE_HIPC_MAP_ALIAS)
        NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_INFOS_END(1, (pInBuffer))

        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_MEMBER(handle, (::nn::hid::PalmaConnectionHandle), 0)
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_MEMBER(index, (::std::uint64_t), 8)
        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_END(2, (handle, index))
        NN_SF_CMIF_DETAIL_METHOD_INFO_IN_RAW_SIZE(16)

        NN_SF_CMIF_DETAIL_METHOD_INFO_ARGUMENT_INFOS((NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(handle), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(index), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(pInBuffer)))

    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO_END(WritePalmaRgbLedPatternEntry)

    // nn::Result WritePalmaWaveEntry(nn::hid::PalmaConnectionHandle handle, std::uint64_t waveSet, std::uint64_t index, nn::sf::NativeHandle&& transferMemoryHandle, std::uint64_t transferMemorySize, std::uint64_t waveDataSize) NN_NOEXCEPT
    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO(WritePalmaWaveEntry)

        NN_SF_CMIF_DETAIL_METHOD_INFO_METHOD_ID(515)
        NN_SF_CMIF_DETAIL_METHOD_INFO_RETURN_TYPE_IS_RESULT(true)

        NN_SF_CMIF_DETAIL_METHOD_INFO_IN_NATIVE_HANDLE_COUNT(1)
        NN_SF_CMIF_DETAIL_METHOD_INFO_IN_NATIVE_HANDLE_INFOS
            NN_SF_CMIF_DETAIL_METHOD_INFO_IN_NATIVE_HANDLE_INFO(transferMemoryHandle, 0, NN_SF_CMIF_DETAIL_NATIVE_HANDLE_ATTRIBUTE_HIPC_COPY)
        NN_SF_CMIF_DETAIL_METHOD_INFO_IN_NATIVE_HANDLE_INFOS_END(1, (transferMemoryHandle))

        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_MEMBER(handle, (::nn::hid::PalmaConnectionHandle), 0)
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_MEMBER(waveSet, (::std::uint64_t), 8)
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_MEMBER(index, (::std::uint64_t), 16)
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_MEMBER(transferMemorySize, (::std::uint64_t), 24)
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_MEMBER(waveDataSize, (::std::uint64_t), 32)
        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_END(5, (handle, waveSet, index, transferMemorySize, waveDataSize))
        NN_SF_CMIF_DETAIL_METHOD_INFO_IN_RAW_SIZE(40)

        NN_SF_CMIF_DETAIL_METHOD_INFO_ARGUMENT_INFOS((NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(handle), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(waveSet), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(index), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(transferMemoryHandle), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(transferMemorySize), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(waveDataSize)))

    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO_END(WritePalmaWaveEntry)

    // nn::Result SetPalmaDataBaseIdentificationVersion(nn::hid::PalmaConnectionHandle handle, std::int32_t version) NN_NOEXCEPT
    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO(SetPalmaDataBaseIdentificationVersion)

        NN_SF_CMIF_DETAIL_METHOD_INFO_METHOD_ID(516)
        NN_SF_CMIF_DETAIL_METHOD_INFO_RETURN_TYPE_IS_RESULT(true)

        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_MEMBER(version, (::std::int32_t), 0)
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_MEMBER(handle, (::nn::hid::PalmaConnectionHandle), 8)
        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_END(2, (version, handle))
        NN_SF_CMIF_DETAIL_METHOD_INFO_IN_RAW_SIZE(16)

        NN_SF_CMIF_DETAIL_METHOD_INFO_ARGUMENT_INFOS((NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(handle), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(version)))

    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO_END(SetPalmaDataBaseIdentificationVersion)

    // nn::Result GetPalmaDataBaseIdentificationVersion(nn::hid::PalmaConnectionHandle handle) NN_NOEXCEPT
    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO(GetPalmaDataBaseIdentificationVersion)

        NN_SF_CMIF_DETAIL_METHOD_INFO_METHOD_ID(517)
        NN_SF_CMIF_DETAIL_METHOD_INFO_RETURN_TYPE_IS_RESULT(true)

        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_MEMBER(handle, (::nn::hid::PalmaConnectionHandle), 0)
        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_END(1, (handle))
        NN_SF_CMIF_DETAIL_METHOD_INFO_IN_RAW_SIZE(8)

        NN_SF_CMIF_DETAIL_METHOD_INFO_ARGUMENT_INFOS((NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(handle)))

    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO_END(GetPalmaDataBaseIdentificationVersion)

    // nn::Result SuspendPalmaFeature(nn::hid::PalmaConnectionHandle handle, nn::hid::PalmaFeatureSet suspendFeatureSet) NN_NOEXCEPT
    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO(SuspendPalmaFeature)

        NN_SF_CMIF_DETAIL_METHOD_INFO_METHOD_ID(518)
        NN_SF_CMIF_DETAIL_METHOD_INFO_RETURN_TYPE_IS_RESULT(true)

        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_MEMBER(suspendFeatureSet, (::nn::hid::PalmaFeatureSet), 0)
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_MEMBER(handle, (::nn::hid::PalmaConnectionHandle), 8)
        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_END(2, (suspendFeatureSet, handle))
        NN_SF_CMIF_DETAIL_METHOD_INFO_IN_RAW_SIZE(16)

        NN_SF_CMIF_DETAIL_METHOD_INFO_ARGUMENT_INFOS((NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(handle), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(suspendFeatureSet)))

    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO_END(SuspendPalmaFeature)

    // nn::Result GetPalmaOperationResult(nn::hid::PalmaConnectionHandle handle) NN_NOEXCEPT
    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO(GetPalmaOperationResult)

        NN_SF_CMIF_DETAIL_METHOD_INFO_METHOD_ID(519)
        NN_SF_CMIF_DETAIL_METHOD_INFO_RETURN_TYPE_IS_RESULT(true)

        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_MEMBER(handle, (::nn::hid::PalmaConnectionHandle), 0)
        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_END(1, (handle))
        NN_SF_CMIF_DETAIL_METHOD_INFO_IN_RAW_SIZE(8)

        NN_SF_CMIF_DETAIL_METHOD_INFO_ARGUMENT_INFOS((NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(handle)))

    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO_END(GetPalmaOperationResult)

    // nn::Result ReadPalmaPlayLog(nn::hid::PalmaConnectionHandle handle, std::uint16_t index) NN_NOEXCEPT
    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO(ReadPalmaPlayLog)

        NN_SF_CMIF_DETAIL_METHOD_INFO_METHOD_ID(520)
        NN_SF_CMIF_DETAIL_METHOD_INFO_RETURN_TYPE_IS_RESULT(true)

        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_MEMBER(index, (::std::uint16_t), 0)
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_MEMBER(handle, (::nn::hid::PalmaConnectionHandle), 8)
        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_END(2, (index, handle))
        NN_SF_CMIF_DETAIL_METHOD_INFO_IN_RAW_SIZE(16)

        NN_SF_CMIF_DETAIL_METHOD_INFO_ARGUMENT_INFOS((NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(handle), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(index)))

    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO_END(ReadPalmaPlayLog)

    // nn::Result ResetPalmaPlayLog(nn::hid::PalmaConnectionHandle handle, std::uint16_t index) NN_NOEXCEPT
    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO(ResetPalmaPlayLog)

        NN_SF_CMIF_DETAIL_METHOD_INFO_METHOD_ID(521)
        NN_SF_CMIF_DETAIL_METHOD_INFO_RETURN_TYPE_IS_RESULT(true)

        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_MEMBER(index, (::std::uint16_t), 0)
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_MEMBER(handle, (::nn::hid::PalmaConnectionHandle), 8)
        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_END(2, (index, handle))
        NN_SF_CMIF_DETAIL_METHOD_INFO_IN_RAW_SIZE(16)

        NN_SF_CMIF_DETAIL_METHOD_INFO_ARGUMENT_INFOS((NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(handle), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(index)))

    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO_END(ResetPalmaPlayLog)

    // nn::Result SetIsPalmaAllConnectable(nn::applet::AppletResourceUserId aruid, bool connectable) NN_NOEXCEPT
    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO(SetIsPalmaAllConnectable)

        NN_SF_CMIF_DETAIL_METHOD_INFO_METHOD_ID(522)
        NN_SF_CMIF_DETAIL_METHOD_INFO_RETURN_TYPE_IS_RESULT(true)

        NN_SF_CMIF_DETAIL_METHOD_INFO_IN_PROCESS_ID_ENABLE()

        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_MEMBER(connectable, (bool), 0)
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_MEMBER(aruid, (::nn::applet::AppletResourceUserId), 8)
        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_END(2, (connectable, aruid))
        NN_SF_CMIF_DETAIL_METHOD_INFO_IN_RAW_SIZE(16)

        NN_SF_CMIF_DETAIL_METHOD_INFO_ARGUMENT_INFOS((NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(aruid), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(connectable)))

    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO_END(SetIsPalmaAllConnectable)

    // nn::Result SetIsPalmaPairedConnectable(nn::applet::AppletResourceUserId aruid, bool connectable) NN_NOEXCEPT
    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO(SetIsPalmaPairedConnectable)

        NN_SF_CMIF_DETAIL_METHOD_INFO_METHOD_ID(523)
        NN_SF_CMIF_DETAIL_METHOD_INFO_RETURN_TYPE_IS_RESULT(true)

        NN_SF_CMIF_DETAIL_METHOD_INFO_IN_PROCESS_ID_ENABLE()

        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_MEMBER(connectable, (bool), 0)
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_MEMBER(aruid, (::nn::applet::AppletResourceUserId), 8)
        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_END(2, (connectable, aruid))
        NN_SF_CMIF_DETAIL_METHOD_INFO_IN_RAW_SIZE(16)

        NN_SF_CMIF_DETAIL_METHOD_INFO_ARGUMENT_INFOS((NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(aruid), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(connectable)))

    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO_END(SetIsPalmaPairedConnectable)

    // nn::Result PairPalma(nn::hid::PalmaConnectionHandle handle) NN_NOEXCEPT
    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO(PairPalma)

        NN_SF_CMIF_DETAIL_METHOD_INFO_METHOD_ID(524)
        NN_SF_CMIF_DETAIL_METHOD_INFO_RETURN_TYPE_IS_RESULT(true)

        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_MEMBER(handle, (::nn::hid::PalmaConnectionHandle), 0)
        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_END(1, (handle))
        NN_SF_CMIF_DETAIL_METHOD_INFO_IN_RAW_SIZE(8)

        NN_SF_CMIF_DETAIL_METHOD_INFO_ARGUMENT_INFOS((NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(handle)))

    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO_END(PairPalma)

    // nn::Result SetPalmaBoostMode(bool enabled) NN_NOEXCEPT
    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO(SetPalmaBoostMode)

        NN_SF_CMIF_DETAIL_METHOD_INFO_METHOD_ID(525)
        NN_SF_CMIF_DETAIL_METHOD_INFO_RETURN_TYPE_IS_RESULT(true)

        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_MEMBER(enabled, (bool), 0)
        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_END(1, (enabled))
        NN_SF_CMIF_DETAIL_METHOD_INFO_IN_RAW_SIZE(1)

        NN_SF_CMIF_DETAIL_METHOD_INFO_ARGUMENT_INFOS((NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(enabled)))

    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO_END(SetPalmaBoostMode)

    // nn::Result SetNpadCommunicationMode(nn::applet::AppletResourceUserId aruid, std::int64_t mode) NN_NOEXCEPT
    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO(SetNpadCommunicationMode)

        NN_SF_CMIF_DETAIL_METHOD_INFO_METHOD_ID(1000)
        NN_SF_CMIF_DETAIL_METHOD_INFO_RETURN_TYPE_IS_RESULT(true)

        NN_SF_CMIF_DETAIL_METHOD_INFO_IN_PROCESS_ID_ENABLE()

        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_MEMBER(aruid, (::nn::applet::AppletResourceUserId), 0)
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_MEMBER(mode, (::std::int64_t), 8)
        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_END(2, (aruid, mode))
        NN_SF_CMIF_DETAIL_METHOD_INFO_IN_RAW_SIZE(16)

        NN_SF_CMIF_DETAIL_METHOD_INFO_ARGUMENT_INFOS((NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(aruid), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(mode)))

    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO_END(SetNpadCommunicationMode)

    // nn::Result GetNpadCommunicationMode(nn::sf::Out<std::int64_t> outValue) NN_NOEXCEPT
    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO(GetNpadCommunicationMode)

        NN_SF_CMIF_DETAIL_METHOD_INFO_METHOD_ID(1001)
        NN_SF_CMIF_DETAIL_METHOD_INFO_RETURN_TYPE_IS_RESULT(true)

        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT_MEMBER(outValue, (::std::int64_t), 0)
        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT_END(1, (outValue))
        NN_SF_CMIF_DETAIL_METHOD_INFO_OUT_RAW_SIZE(8)

        NN_SF_CMIF_DETAIL_METHOD_INFO_ARGUMENT_INFOS((NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(outValue)))

    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO_END(GetNpadCommunicationMode)

    NN_SF_CMIF_DETAIL_METHOD_INFO_REFERRED_STRUCT_ASSERTION_CHECK((::nn::applet::AppletResourceUserId), 8, 8)
    NN_SF_CMIF_DETAIL_METHOD_INFO_REFERRED_STRUCT_ASSERTION_CHECK((::nn::hid::BasicXpadId), 4, 4)
    NN_SF_CMIF_DETAIL_METHOD_INFO_REFERRED_STRUCT_ASSERTION_CHECK((::nn::hid::JoyXpadId), 4, 4)
    NN_SF_CMIF_DETAIL_METHOD_INFO_REFERRED_STRUCT_ASSERTION_CHECK((::nn::hid::SixAxisSensorHandle), 4, 4)
    NN_SF_CMIF_DETAIL_METHOD_INFO_REFERRED_STRUCT_ASSERTION_CHECK((::nn::hid::NpadStyleSet), 4, 4)
    NN_SF_CMIF_DETAIL_METHOD_INFO_REFERRED_STRUCT_ASSERTION_CHECK((::nn::hid::NpadIdType), 4, 4)
    NN_SF_CMIF_DETAIL_METHOD_INFO_REFERRED_STRUCT_ASSERTION_CHECK((::nn::hid::VibrationDeviceInfoForIpc), 8, 4)
    NN_SF_CMIF_DETAIL_METHOD_INFO_REFERRED_STRUCT_ASSERTION_CHECK((::nn::hid::VibrationDeviceHandle), 4, 4)
    NN_SF_CMIF_DETAIL_METHOD_INFO_REFERRED_STRUCT_ASSERTION_CHECK((::nn::hid::VibrationValue), 16, 4)
    NN_SF_CMIF_DETAIL_METHOD_INFO_REFERRED_STRUCT_ASSERTION_CHECK((::nn::applet::AppletResourceUserId), 8, 8)
    NN_SF_CMIF_DETAIL_METHOD_INFO_REFERRED_STRUCT_ASSERTION_CHECK((::nn::hid::VibrationGcErmCommand), 8, 8)
    NN_SF_CMIF_DETAIL_METHOD_INFO_REFERRED_STRUCT_ASSERTION_CHECK((::nn::hid::ConsoleSixAxisSensorHandle), 4, 4)
    NN_SF_CMIF_DETAIL_METHOD_INFO_REFERRED_STRUCT_ASSERTION_CHECK((::nn::hid::system::InterfaceType), 1, 1)
    NN_SF_CMIF_DETAIL_METHOD_INFO_REFERRED_STRUCT_ASSERTION_CHECK((::nn::hid::PalmaConnectionHandle), 8, 8)
    NN_SF_CMIF_DETAIL_METHOD_INFO_REFERRED_STRUCT_ASSERTION_CHECK((::nn::hid::PalmaApplicationSectionAccessBuffer), 256, 4)
    NN_SF_CMIF_DETAIL_METHOD_INFO_REFERRED_STRUCT_ASSERTION_CHECK((::nn::hid::PalmaFeatureSet), 4, 4)

NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFOS_END

// template <...> class nn::sf::client::detail::CmifProxy<nn::hid::IHidServer, ...>
NN_SF_CMIF_CLIENT_DETAIL_DEFINE_PROXY((::nn::hid::IHidServer))

    // nn::Result CreateAppletResource(nn::sf::Out<nn::sf::SharedPointer<nn::hid::IAppletResource>> outValue, nn::applet::AppletResourceUserId aruid) NN_NOEXCEPT
    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(CreateAppletResource, (::nn::sf::Out<::nn::sf::SharedPointer<::nn::hid::IAppletResource>> outValue, ::nn::applet::AppletResourceUserId aruid))
    {
        NN_SF_CMIF_CLIENT_DETAIL_CALL_BEGIN(CreateAppletResource)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(outValue)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(aruid)
        NN_SF_CMIF_CLIENT_DETAIL_CALL_END(CreateAppletResource)
    }

    // nn::Result ActivateDebugPad(nn::applet::AppletResourceUserId aruid) NN_NOEXCEPT
    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(ActivateDebugPad, (::nn::applet::AppletResourceUserId aruid))
    {
        NN_SF_CMIF_CLIENT_DETAIL_CALL_BEGIN(ActivateDebugPad)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(aruid)
        NN_SF_CMIF_CLIENT_DETAIL_CALL_END(ActivateDebugPad)
    }

    // nn::Result ActivateTouchScreen(nn::applet::AppletResourceUserId aruid) NN_NOEXCEPT
    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(ActivateTouchScreen, (::nn::applet::AppletResourceUserId aruid))
    {
        NN_SF_CMIF_CLIENT_DETAIL_CALL_BEGIN(ActivateTouchScreen)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(aruid)
        NN_SF_CMIF_CLIENT_DETAIL_CALL_END(ActivateTouchScreen)
    }

    // nn::Result ActivateMouse(nn::applet::AppletResourceUserId aruid) NN_NOEXCEPT
    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(ActivateMouse, (::nn::applet::AppletResourceUserId aruid))
    {
        NN_SF_CMIF_CLIENT_DETAIL_CALL_BEGIN(ActivateMouse)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(aruid)
        NN_SF_CMIF_CLIENT_DETAIL_CALL_END(ActivateMouse)
    }

    // nn::Result ActivateKeyboard(nn::applet::AppletResourceUserId aruid) NN_NOEXCEPT
    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(ActivateKeyboard, (::nn::applet::AppletResourceUserId aruid))
    {
        NN_SF_CMIF_CLIENT_DETAIL_CALL_BEGIN(ActivateKeyboard)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(aruid)
        NN_SF_CMIF_CLIENT_DETAIL_CALL_END(ActivateKeyboard)
    }

    // nn::Result AcquireXpadIdEventHandle(nn::sf::Out<nn::sf::NativeHandle> outValue, std::uint64_t clientId) NN_NOEXCEPT
    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(AcquireXpadIdEventHandle, (::nn::sf::Out<::nn::sf::NativeHandle> outValue, ::std::uint64_t clientId))
    {
        NN_SF_CMIF_CLIENT_DETAIL_CALL_BEGIN(AcquireXpadIdEventHandle)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(outValue)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(clientId)
        NN_SF_CMIF_CLIENT_DETAIL_CALL_END(AcquireXpadIdEventHandle)
    }

    // nn::Result ReleaseXpadIdEventHandle(std::uint64_t clientId) NN_NOEXCEPT
    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(ReleaseXpadIdEventHandle, (::std::uint64_t clientId))
    {
        NN_SF_CMIF_CLIENT_DETAIL_CALL_BEGIN(ReleaseXpadIdEventHandle)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(clientId)
        NN_SF_CMIF_CLIENT_DETAIL_CALL_END(ReleaseXpadIdEventHandle)
    }

    // nn::Result ActivateXpad(nn::applet::AppletResourceUserId aruid, nn::hid::BasicXpadId xpadId) NN_NOEXCEPT
    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(ActivateXpad, (::nn::applet::AppletResourceUserId aruid, ::nn::hid::BasicXpadId xpadId))
    {
        NN_SF_CMIF_CLIENT_DETAIL_CALL_BEGIN(ActivateXpad)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(aruid)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(xpadId)
        NN_SF_CMIF_CLIENT_DETAIL_CALL_END(ActivateXpad)
    }

    // nn::Result GetXpadIds(nn::sf::Out<std::int64_t> outCount, const nn::sf::OutArray<nn::hid::BasicXpadId>& outXpadIds) NN_NOEXCEPT
    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(GetXpadIds, (::nn::sf::Out<::std::int64_t> outCount, const ::nn::sf::OutArray<::nn::hid::BasicXpadId>& outXpadIds))
    {
        NN_SF_CMIF_CLIENT_DETAIL_CALL_BEGIN(GetXpadIds)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(outCount)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(outXpadIds)
        NN_SF_CMIF_CLIENT_DETAIL_CALL_END(GetXpadIds)
    }

    // nn::Result ActivateJoyXpad(nn::hid::JoyXpadId xpadId) NN_NOEXCEPT
    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(ActivateJoyXpad, (::nn::hid::JoyXpadId xpadId))
    {
        NN_SF_CMIF_CLIENT_DETAIL_CALL_BEGIN(ActivateJoyXpad)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(xpadId)
        NN_SF_CMIF_CLIENT_DETAIL_CALL_END(ActivateJoyXpad)
    }

    // nn::Result GetJoyXpadLifoHandle(nn::sf::Out<nn::sf::NativeHandle> outValue, nn::hid::JoyXpadId xpadId) NN_NOEXCEPT
    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(GetJoyXpadLifoHandle, (::nn::sf::Out<::nn::sf::NativeHandle> outValue, ::nn::hid::JoyXpadId xpadId))
    {
        NN_SF_CMIF_CLIENT_DETAIL_CALL_BEGIN(GetJoyXpadLifoHandle)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(outValue)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(xpadId)
        NN_SF_CMIF_CLIENT_DETAIL_CALL_END(GetJoyXpadLifoHandle)
    }

    // nn::Result GetJoyXpadIds(nn::sf::Out<std::int64_t> outGotCount, const nn::sf::OutArray<nn::hid::JoyXpadId>& outXpadIds) NN_NOEXCEPT
    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(GetJoyXpadIds, (::nn::sf::Out<::std::int64_t> outGotCount, const ::nn::sf::OutArray<::nn::hid::JoyXpadId>& outXpadIds))
    {
        NN_SF_CMIF_CLIENT_DETAIL_CALL_BEGIN(GetJoyXpadIds)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(outGotCount)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(outXpadIds)
        NN_SF_CMIF_CLIENT_DETAIL_CALL_END(GetJoyXpadIds)
    }

    // nn::Result ActivateSixAxisSensor(nn::hid::BasicXpadId xpadId) NN_NOEXCEPT
    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(ActivateSixAxisSensor, (::nn::hid::BasicXpadId xpadId))
    {
        NN_SF_CMIF_CLIENT_DETAIL_CALL_BEGIN(ActivateSixAxisSensor)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(xpadId)
        NN_SF_CMIF_CLIENT_DETAIL_CALL_END(ActivateSixAxisSensor)
    }

    // nn::Result DeactivateSixAxisSensor(nn::hid::BasicXpadId xpadId) NN_NOEXCEPT
    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(DeactivateSixAxisSensor, (::nn::hid::BasicXpadId xpadId))
    {
        NN_SF_CMIF_CLIENT_DETAIL_CALL_BEGIN(DeactivateSixAxisSensor)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(xpadId)
        NN_SF_CMIF_CLIENT_DETAIL_CALL_END(DeactivateSixAxisSensor)
    }

    // nn::Result GetSixAxisSensorLifoHandle(nn::sf::Out<nn::sf::NativeHandle> outValue, nn::hid::BasicXpadId xpadId) NN_NOEXCEPT
    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(GetSixAxisSensorLifoHandle, (::nn::sf::Out<::nn::sf::NativeHandle> outValue, ::nn::hid::BasicXpadId xpadId))
    {
        NN_SF_CMIF_CLIENT_DETAIL_CALL_BEGIN(GetSixAxisSensorLifoHandle)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(outValue)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(xpadId)
        NN_SF_CMIF_CLIENT_DETAIL_CALL_END(GetSixAxisSensorLifoHandle)
    }

    // nn::Result ActivateJoySixAxisSensor(nn::hid::JoyXpadId xpadId) NN_NOEXCEPT
    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(ActivateJoySixAxisSensor, (::nn::hid::JoyXpadId xpadId))
    {
        NN_SF_CMIF_CLIENT_DETAIL_CALL_BEGIN(ActivateJoySixAxisSensor)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(xpadId)
        NN_SF_CMIF_CLIENT_DETAIL_CALL_END(ActivateJoySixAxisSensor)
    }

    // nn::Result DeactivateJoySixAxisSensor(nn::hid::JoyXpadId xpadId) NN_NOEXCEPT
    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(DeactivateJoySixAxisSensor, (::nn::hid::JoyXpadId xpadId))
    {
        NN_SF_CMIF_CLIENT_DETAIL_CALL_BEGIN(DeactivateJoySixAxisSensor)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(xpadId)
        NN_SF_CMIF_CLIENT_DETAIL_CALL_END(DeactivateJoySixAxisSensor)
    }

    // nn::Result GetJoySixAxisSensorLifoHandle(nn::sf::Out<nn::sf::NativeHandle> outValue, nn::hid::JoyXpadId xpadId) NN_NOEXCEPT
    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(GetJoySixAxisSensorLifoHandle, (::nn::sf::Out<::nn::sf::NativeHandle> outValue, ::nn::hid::JoyXpadId xpadId))
    {
        NN_SF_CMIF_CLIENT_DETAIL_CALL_BEGIN(GetJoySixAxisSensorLifoHandle)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(outValue)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(xpadId)
        NN_SF_CMIF_CLIENT_DETAIL_CALL_END(GetJoySixAxisSensorLifoHandle)
    }

    // nn::Result StartSixAxisSensor(nn::applet::AppletResourceUserId aruid, nn::hid::SixAxisSensorHandle handle) NN_NOEXCEPT
    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(StartSixAxisSensor, (::nn::applet::AppletResourceUserId aruid, ::nn::hid::SixAxisSensorHandle handle))
    {
        NN_SF_CMIF_CLIENT_DETAIL_CALL_BEGIN(StartSixAxisSensor)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(aruid)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(handle)
        NN_SF_CMIF_CLIENT_DETAIL_CALL_END(StartSixAxisSensor)
    }

    // nn::Result StopSixAxisSensor(nn::applet::AppletResourceUserId aruid, nn::hid::SixAxisSensorHandle handle) NN_NOEXCEPT
    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(StopSixAxisSensor, (::nn::applet::AppletResourceUserId aruid, ::nn::hid::SixAxisSensorHandle handle))
    {
        NN_SF_CMIF_CLIENT_DETAIL_CALL_BEGIN(StopSixAxisSensor)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(aruid)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(handle)
        NN_SF_CMIF_CLIENT_DETAIL_CALL_END(StopSixAxisSensor)
    }

    // nn::Result IsSixAxisSensorFusionEnabled(nn::sf::Out<bool> outIsEnabled, nn::applet::AppletResourceUserId aruid, nn::hid::SixAxisSensorHandle handle) NN_NOEXCEPT
    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(IsSixAxisSensorFusionEnabled, (::nn::sf::Out<bool> outIsEnabled, ::nn::applet::AppletResourceUserId aruid, ::nn::hid::SixAxisSensorHandle handle))
    {
        NN_SF_CMIF_CLIENT_DETAIL_CALL_BEGIN(IsSixAxisSensorFusionEnabled)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(outIsEnabled)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(aruid)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(handle)
        NN_SF_CMIF_CLIENT_DETAIL_CALL_END(IsSixAxisSensorFusionEnabled)
    }

    // nn::Result EnableSixAxisSensorFusion(nn::applet::AppletResourceUserId aruid, nn::hid::SixAxisSensorHandle handle, bool enable) NN_NOEXCEPT
    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(EnableSixAxisSensorFusion, (::nn::applet::AppletResourceUserId aruid, ::nn::hid::SixAxisSensorHandle handle, bool enable))
    {
        NN_SF_CMIF_CLIENT_DETAIL_CALL_BEGIN(EnableSixAxisSensorFusion)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(aruid)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(handle)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(enable)
        NN_SF_CMIF_CLIENT_DETAIL_CALL_END(EnableSixAxisSensorFusion)
    }

    // nn::Result SetSixAxisSensorFusionParameters(nn::applet::AppletResourceUserId aruid, nn::hid::SixAxisSensorHandle handle, float revisePower, float reviseRange) NN_NOEXCEPT
    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(SetSixAxisSensorFusionParameters, (::nn::applet::AppletResourceUserId aruid, ::nn::hid::SixAxisSensorHandle handle, float revisePower, float reviseRange))
    {
        NN_SF_CMIF_CLIENT_DETAIL_CALL_BEGIN(SetSixAxisSensorFusionParameters)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(aruid)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(handle)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(revisePower)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(reviseRange)
        NN_SF_CMIF_CLIENT_DETAIL_CALL_END(SetSixAxisSensorFusionParameters)
    }

    // nn::Result GetSixAxisSensorFusionParameters(nn::sf::Out<float> outRevisePower, nn::sf::Out<float> outReviseRange, nn::applet::AppletResourceUserId aruid, nn::hid::SixAxisSensorHandle handle) NN_NOEXCEPT
    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(GetSixAxisSensorFusionParameters, (::nn::sf::Out<float> outRevisePower, ::nn::sf::Out<float> outReviseRange, ::nn::applet::AppletResourceUserId aruid, ::nn::hid::SixAxisSensorHandle handle))
    {
        NN_SF_CMIF_CLIENT_DETAIL_CALL_BEGIN(GetSixAxisSensorFusionParameters)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(outRevisePower)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(outReviseRange)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(aruid)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(handle)
        NN_SF_CMIF_CLIENT_DETAIL_CALL_END(GetSixAxisSensorFusionParameters)
    }

    // nn::Result ResetSixAxisSensorFusionParameters(nn::applet::AppletResourceUserId aruid, nn::hid::SixAxisSensorHandle handle) NN_NOEXCEPT
    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(ResetSixAxisSensorFusionParameters, (::nn::applet::AppletResourceUserId aruid, ::nn::hid::SixAxisSensorHandle handle))
    {
        NN_SF_CMIF_CLIENT_DETAIL_CALL_BEGIN(ResetSixAxisSensorFusionParameters)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(aruid)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(handle)
        NN_SF_CMIF_CLIENT_DETAIL_CALL_END(ResetSixAxisSensorFusionParameters)
    }

    // nn::Result SetAccelerometerParameters(nn::applet::AppletResourceUserId aruid, nn::hid::SixAxisSensorHandle handle, float playRadius, float sensitivity) NN_NOEXCEPT
    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(SetAccelerometerParameters, (::nn::applet::AppletResourceUserId aruid, ::nn::hid::SixAxisSensorHandle handle, float playRadius, float sensitivity))
    {
        NN_SF_CMIF_CLIENT_DETAIL_CALL_BEGIN(SetAccelerometerParameters)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(aruid)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(handle)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(playRadius)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(sensitivity)
        NN_SF_CMIF_CLIENT_DETAIL_CALL_END(SetAccelerometerParameters)
    }

    // nn::Result GetAccelerometerParameters(nn::sf::Out<float> outPlayRadius, nn::sf::Out<float> outSensitivity, nn::applet::AppletResourceUserId aruid, nn::hid::SixAxisSensorHandle handle) NN_NOEXCEPT
    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(GetAccelerometerParameters, (::nn::sf::Out<float> outPlayRadius, ::nn::sf::Out<float> outSensitivity, ::nn::applet::AppletResourceUserId aruid, ::nn::hid::SixAxisSensorHandle handle))
    {
        NN_SF_CMIF_CLIENT_DETAIL_CALL_BEGIN(GetAccelerometerParameters)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(outPlayRadius)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(outSensitivity)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(aruid)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(handle)
        NN_SF_CMIF_CLIENT_DETAIL_CALL_END(GetAccelerometerParameters)
    }

    // nn::Result ResetAccelerometerParameters(nn::applet::AppletResourceUserId aruid, nn::hid::SixAxisSensorHandle handle) NN_NOEXCEPT
    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(ResetAccelerometerParameters, (::nn::applet::AppletResourceUserId aruid, ::nn::hid::SixAxisSensorHandle handle))
    {
        NN_SF_CMIF_CLIENT_DETAIL_CALL_BEGIN(ResetAccelerometerParameters)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(aruid)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(handle)
        NN_SF_CMIF_CLIENT_DETAIL_CALL_END(ResetAccelerometerParameters)
    }

    // nn::Result SetAccelerometerPlayMode(nn::applet::AppletResourceUserId aruid, nn::hid::SixAxisSensorHandle handle, std::uint32_t mode) NN_NOEXCEPT
    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(SetAccelerometerPlayMode, (::nn::applet::AppletResourceUserId aruid, ::nn::hid::SixAxisSensorHandle handle, ::std::uint32_t mode))
    {
        NN_SF_CMIF_CLIENT_DETAIL_CALL_BEGIN(SetAccelerometerPlayMode)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(aruid)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(handle)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(mode)
        NN_SF_CMIF_CLIENT_DETAIL_CALL_END(SetAccelerometerPlayMode)
    }

    // nn::Result GetAccelerometerPlayMode(nn::sf::Out<std::uint32_t> outMode, nn::applet::AppletResourceUserId aruid, nn::hid::SixAxisSensorHandle handle) NN_NOEXCEPT
    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(GetAccelerometerPlayMode, (::nn::sf::Out<::std::uint32_t> outMode, ::nn::applet::AppletResourceUserId aruid, ::nn::hid::SixAxisSensorHandle handle))
    {
        NN_SF_CMIF_CLIENT_DETAIL_CALL_BEGIN(GetAccelerometerPlayMode)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(outMode)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(aruid)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(handle)
        NN_SF_CMIF_CLIENT_DETAIL_CALL_END(GetAccelerometerPlayMode)
    }

    // nn::Result ResetAccelerometerPlayMode(nn::applet::AppletResourceUserId aruid, nn::hid::SixAxisSensorHandle handle) NN_NOEXCEPT
    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(ResetAccelerometerPlayMode, (::nn::applet::AppletResourceUserId aruid, ::nn::hid::SixAxisSensorHandle handle))
    {
        NN_SF_CMIF_CLIENT_DETAIL_CALL_BEGIN(ResetAccelerometerPlayMode)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(aruid)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(handle)
        NN_SF_CMIF_CLIENT_DETAIL_CALL_END(ResetAccelerometerPlayMode)
    }

    // nn::Result SetGyroscopeZeroDriftMode(nn::applet::AppletResourceUserId aruid, nn::hid::SixAxisSensorHandle handle, std::uint32_t mode) NN_NOEXCEPT
    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(SetGyroscopeZeroDriftMode, (::nn::applet::AppletResourceUserId aruid, ::nn::hid::SixAxisSensorHandle handle, ::std::uint32_t mode))
    {
        NN_SF_CMIF_CLIENT_DETAIL_CALL_BEGIN(SetGyroscopeZeroDriftMode)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(aruid)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(handle)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(mode)
        NN_SF_CMIF_CLIENT_DETAIL_CALL_END(SetGyroscopeZeroDriftMode)
    }

    // nn::Result GetGyroscopeZeroDriftMode(nn::sf::Out<std::uint32_t> outMode, nn::applet::AppletResourceUserId aruid, nn::hid::SixAxisSensorHandle handle) NN_NOEXCEPT
    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(GetGyroscopeZeroDriftMode, (::nn::sf::Out<::std::uint32_t> outMode, ::nn::applet::AppletResourceUserId aruid, ::nn::hid::SixAxisSensorHandle handle))
    {
        NN_SF_CMIF_CLIENT_DETAIL_CALL_BEGIN(GetGyroscopeZeroDriftMode)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(outMode)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(aruid)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(handle)
        NN_SF_CMIF_CLIENT_DETAIL_CALL_END(GetGyroscopeZeroDriftMode)
    }

    // nn::Result ResetGyroscopeZeroDriftMode(nn::applet::AppletResourceUserId aruid, nn::hid::SixAxisSensorHandle handle) NN_NOEXCEPT
    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(ResetGyroscopeZeroDriftMode, (::nn::applet::AppletResourceUserId aruid, ::nn::hid::SixAxisSensorHandle handle))
    {
        NN_SF_CMIF_CLIENT_DETAIL_CALL_BEGIN(ResetGyroscopeZeroDriftMode)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(aruid)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(handle)
        NN_SF_CMIF_CLIENT_DETAIL_CALL_END(ResetGyroscopeZeroDriftMode)
    }

    // nn::Result IsSixAxisSensorAtRest(nn::sf::Out<bool> outIsAtRest, nn::applet::AppletResourceUserId aruid, nn::hid::SixAxisSensorHandle handle) NN_NOEXCEPT
    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(IsSixAxisSensorAtRest, (::nn::sf::Out<bool> outIsAtRest, ::nn::applet::AppletResourceUserId aruid, ::nn::hid::SixAxisSensorHandle handle))
    {
        NN_SF_CMIF_CLIENT_DETAIL_CALL_BEGIN(IsSixAxisSensorAtRest)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(outIsAtRest)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(aruid)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(handle)
        NN_SF_CMIF_CLIENT_DETAIL_CALL_END(IsSixAxisSensorAtRest)
    }

    // nn::Result ActivateGesture(nn::applet::AppletResourceUserId aruid, std::int32_t version) NN_NOEXCEPT
    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(ActivateGesture, (::nn::applet::AppletResourceUserId aruid, ::std::int32_t version))
    {
        NN_SF_CMIF_CLIENT_DETAIL_CALL_BEGIN(ActivateGesture)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(aruid)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(version)
        NN_SF_CMIF_CLIENT_DETAIL_CALL_END(ActivateGesture)
    }

    // nn::Result SetSupportedNpadStyleSet(nn::applet::AppletResourceUserId aruid, nn::hid::NpadStyleSet style) NN_NOEXCEPT
    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(SetSupportedNpadStyleSet, (::nn::applet::AppletResourceUserId aruid, ::nn::hid::NpadStyleSet style))
    {
        NN_SF_CMIF_CLIENT_DETAIL_CALL_BEGIN(SetSupportedNpadStyleSet)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(aruid)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(style)
        NN_SF_CMIF_CLIENT_DETAIL_CALL_END(SetSupportedNpadStyleSet)
    }

    // nn::Result GetSupportedNpadStyleSet(nn::applet::AppletResourceUserId aruid, nn::sf::Out<nn::hid::NpadStyleSet> outValue) NN_NOEXCEPT
    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(GetSupportedNpadStyleSet, (::nn::applet::AppletResourceUserId aruid, ::nn::sf::Out<::nn::hid::NpadStyleSet> outValue))
    {
        NN_SF_CMIF_CLIENT_DETAIL_CALL_BEGIN(GetSupportedNpadStyleSet)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(aruid)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(outValue)
        NN_SF_CMIF_CLIENT_DETAIL_CALL_END(GetSupportedNpadStyleSet)
    }

    // nn::Result SetSupportedNpadIdType(nn::applet::AppletResourceUserId aruid, const nn::sf::InArray<nn::hid::NpadIdType>& ids) NN_NOEXCEPT
    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(SetSupportedNpadIdType, (::nn::applet::AppletResourceUserId aruid, const ::nn::sf::InArray<::nn::hid::NpadIdType>& ids))
    {
        NN_SF_CMIF_CLIENT_DETAIL_CALL_BEGIN(SetSupportedNpadIdType)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(aruid)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(ids)
        NN_SF_CMIF_CLIENT_DETAIL_CALL_END(SetSupportedNpadIdType)
    }

    // nn::Result ActivateNpad(nn::applet::AppletResourceUserId aruid) NN_NOEXCEPT
    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(ActivateNpad, (::nn::applet::AppletResourceUserId aruid))
    {
        NN_SF_CMIF_CLIENT_DETAIL_CALL_BEGIN(ActivateNpad)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(aruid)
        NN_SF_CMIF_CLIENT_DETAIL_CALL_END(ActivateNpad)
    }

    // nn::Result DeactivateNpad(nn::applet::AppletResourceUserId aruid) NN_NOEXCEPT
    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(DeactivateNpad, (::nn::applet::AppletResourceUserId aruid))
    {
        NN_SF_CMIF_CLIENT_DETAIL_CALL_BEGIN(DeactivateNpad)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(aruid)
        NN_SF_CMIF_CLIENT_DETAIL_CALL_END(DeactivateNpad)
    }

    // nn::Result AcquireNpadStyleSetUpdateEventHandle(nn::applet::AppletResourceUserId aruid, nn::sf::Out<nn::sf::NativeHandle> outValue, nn::hid::NpadIdType id, std::uint64_t clientId) NN_NOEXCEPT
    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(AcquireNpadStyleSetUpdateEventHandle, (::nn::applet::AppletResourceUserId aruid, ::nn::sf::Out<::nn::sf::NativeHandle> outValue, ::nn::hid::NpadIdType id, ::std::uint64_t clientId))
    {
        NN_SF_CMIF_CLIENT_DETAIL_CALL_BEGIN(AcquireNpadStyleSetUpdateEventHandle)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(aruid)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(outValue)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(id)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(clientId)
        NN_SF_CMIF_CLIENT_DETAIL_CALL_END(AcquireNpadStyleSetUpdateEventHandle)
    }

    // nn::Result DisconnectNpad(nn::applet::AppletResourceUserId aruid, nn::hid::NpadIdType id) NN_NOEXCEPT
    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(DisconnectNpad, (::nn::applet::AppletResourceUserId aruid, ::nn::hid::NpadIdType id))
    {
        NN_SF_CMIF_CLIENT_DETAIL_CALL_BEGIN(DisconnectNpad)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(aruid)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(id)
        NN_SF_CMIF_CLIENT_DETAIL_CALL_END(DisconnectNpad)
    }

    // nn::Result GetPlayerLedPattern(nn::sf::Out<std::uint64_t> outValue, nn::hid::NpadIdType id) NN_NOEXCEPT
    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(GetPlayerLedPattern, (::nn::sf::Out<::std::uint64_t> outValue, ::nn::hid::NpadIdType id))
    {
        NN_SF_CMIF_CLIENT_DETAIL_CALL_BEGIN(GetPlayerLedPattern)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(outValue)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(id)
        NN_SF_CMIF_CLIENT_DETAIL_CALL_END(GetPlayerLedPattern)
    }

    // nn::Result ActivateNpadWithRevision(nn::applet::AppletResourceUserId aruid, std::int32_t revision) NN_NOEXCEPT
    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(ActivateNpadWithRevision, (::nn::applet::AppletResourceUserId aruid, ::std::int32_t revision))
    {
        NN_SF_CMIF_CLIENT_DETAIL_CALL_BEGIN(ActivateNpadWithRevision)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(aruid)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(revision)
        NN_SF_CMIF_CLIENT_DETAIL_CALL_END(ActivateNpadWithRevision)
    }

    // nn::Result SetNpadJoyHoldType(nn::applet::AppletResourceUserId aruid, std::int64_t holdType) NN_NOEXCEPT
    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(SetNpadJoyHoldType, (::nn::applet::AppletResourceUserId aruid, ::std::int64_t holdType))
    {
        NN_SF_CMIF_CLIENT_DETAIL_CALL_BEGIN(SetNpadJoyHoldType)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(aruid)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(holdType)
        NN_SF_CMIF_CLIENT_DETAIL_CALL_END(SetNpadJoyHoldType)
    }

    // nn::Result GetNpadJoyHoldType(nn::applet::AppletResourceUserId aruid, nn::sf::Out<std::int64_t> outValue) NN_NOEXCEPT
    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(GetNpadJoyHoldType, (::nn::applet::AppletResourceUserId aruid, ::nn::sf::Out<::std::int64_t> outValue))
    {
        NN_SF_CMIF_CLIENT_DETAIL_CALL_BEGIN(GetNpadJoyHoldType)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(aruid)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(outValue)
        NN_SF_CMIF_CLIENT_DETAIL_CALL_END(GetNpadJoyHoldType)
    }

    // nn::Result SetNpadJoyAssignmentModeSingleByDefault(nn::applet::AppletResourceUserId aruid, nn::hid::NpadIdType id) NN_NOEXCEPT
    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(SetNpadJoyAssignmentModeSingleByDefault, (::nn::applet::AppletResourceUserId aruid, ::nn::hid::NpadIdType id))
    {
        NN_SF_CMIF_CLIENT_DETAIL_CALL_BEGIN(SetNpadJoyAssignmentModeSingleByDefault)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(aruid)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(id)
        NN_SF_CMIF_CLIENT_DETAIL_CALL_END(SetNpadJoyAssignmentModeSingleByDefault)
    }

    // nn::Result SetNpadJoyAssignmentModeSingle(nn::applet::AppletResourceUserId aruid, nn::hid::NpadIdType id, std::int64_t type) NN_NOEXCEPT
    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(SetNpadJoyAssignmentModeSingle, (::nn::applet::AppletResourceUserId aruid, ::nn::hid::NpadIdType id, ::std::int64_t type))
    {
        NN_SF_CMIF_CLIENT_DETAIL_CALL_BEGIN(SetNpadJoyAssignmentModeSingle)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(aruid)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(id)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(type)
        NN_SF_CMIF_CLIENT_DETAIL_CALL_END(SetNpadJoyAssignmentModeSingle)
    }

    // nn::Result SetNpadJoyAssignmentModeDual(nn::applet::AppletResourceUserId aruid, nn::hid::NpadIdType id) NN_NOEXCEPT
    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(SetNpadJoyAssignmentModeDual, (::nn::applet::AppletResourceUserId aruid, ::nn::hid::NpadIdType id))
    {
        NN_SF_CMIF_CLIENT_DETAIL_CALL_BEGIN(SetNpadJoyAssignmentModeDual)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(aruid)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(id)
        NN_SF_CMIF_CLIENT_DETAIL_CALL_END(SetNpadJoyAssignmentModeDual)
    }

    // nn::Result MergeSingleJoyAsDualJoy(nn::applet::AppletResourceUserId aruid, nn::hid::NpadIdType id1, nn::hid::NpadIdType id2) NN_NOEXCEPT
    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(MergeSingleJoyAsDualJoy, (::nn::applet::AppletResourceUserId aruid, ::nn::hid::NpadIdType id1, ::nn::hid::NpadIdType id2))
    {
        NN_SF_CMIF_CLIENT_DETAIL_CALL_BEGIN(MergeSingleJoyAsDualJoy)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(aruid)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(id1)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(id2)
        NN_SF_CMIF_CLIENT_DETAIL_CALL_END(MergeSingleJoyAsDualJoy)
    }

    // nn::Result StartLrAssignmentMode(nn::applet::AppletResourceUserId aruid) NN_NOEXCEPT
    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(StartLrAssignmentMode, (::nn::applet::AppletResourceUserId aruid))
    {
        NN_SF_CMIF_CLIENT_DETAIL_CALL_BEGIN(StartLrAssignmentMode)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(aruid)
        NN_SF_CMIF_CLIENT_DETAIL_CALL_END(StartLrAssignmentMode)
    }

    // nn::Result StopLrAssignmentMode(nn::applet::AppletResourceUserId aruid) NN_NOEXCEPT
    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(StopLrAssignmentMode, (::nn::applet::AppletResourceUserId aruid))
    {
        NN_SF_CMIF_CLIENT_DETAIL_CALL_BEGIN(StopLrAssignmentMode)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(aruid)
        NN_SF_CMIF_CLIENT_DETAIL_CALL_END(StopLrAssignmentMode)
    }

    // nn::Result SetNpadHandheldActivationMode(nn::applet::AppletResourceUserId aruid, std::int64_t mode) NN_NOEXCEPT
    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(SetNpadHandheldActivationMode, (::nn::applet::AppletResourceUserId aruid, ::std::int64_t mode))
    {
        NN_SF_CMIF_CLIENT_DETAIL_CALL_BEGIN(SetNpadHandheldActivationMode)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(aruid)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(mode)
        NN_SF_CMIF_CLIENT_DETAIL_CALL_END(SetNpadHandheldActivationMode)
    }

    // nn::Result GetNpadHandheldActivationMode(nn::applet::AppletResourceUserId aruid, nn::sf::Out<std::int64_t> outValue) NN_NOEXCEPT
    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(GetNpadHandheldActivationMode, (::nn::applet::AppletResourceUserId aruid, ::nn::sf::Out<::std::int64_t> outValue))
    {
        NN_SF_CMIF_CLIENT_DETAIL_CALL_BEGIN(GetNpadHandheldActivationMode)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(aruid)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(outValue)
        NN_SF_CMIF_CLIENT_DETAIL_CALL_END(GetNpadHandheldActivationMode)
    }

    // nn::Result SwapNpadAssignment(nn::applet::AppletResourceUserId aruid, nn::hid::NpadIdType id1, nn::hid::NpadIdType id2) NN_NOEXCEPT
    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(SwapNpadAssignment, (::nn::applet::AppletResourceUserId aruid, ::nn::hid::NpadIdType id1, ::nn::hid::NpadIdType id2))
    {
        NN_SF_CMIF_CLIENT_DETAIL_CALL_BEGIN(SwapNpadAssignment)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(aruid)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(id1)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(id2)
        NN_SF_CMIF_CLIENT_DETAIL_CALL_END(SwapNpadAssignment)
    }

    // nn::Result IsUnintendedHomeButtonInputProtectionEnabled(nn::sf::Out<bool> outIsEnabled, nn::applet::AppletResourceUserId aruid, nn::hid::NpadIdType id) NN_NOEXCEPT
    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(IsUnintendedHomeButtonInputProtectionEnabled, (::nn::sf::Out<bool> outIsEnabled, ::nn::applet::AppletResourceUserId aruid, ::nn::hid::NpadIdType id))
    {
        NN_SF_CMIF_CLIENT_DETAIL_CALL_BEGIN(IsUnintendedHomeButtonInputProtectionEnabled)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(outIsEnabled)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(aruid)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(id)
        NN_SF_CMIF_CLIENT_DETAIL_CALL_END(IsUnintendedHomeButtonInputProtectionEnabled)
    }

    // nn::Result EnableUnintendedHomeButtonInputProtection(nn::applet::AppletResourceUserId aruid, nn::hid::NpadIdType id, bool enabled) NN_NOEXCEPT
    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(EnableUnintendedHomeButtonInputProtection, (::nn::applet::AppletResourceUserId aruid, ::nn::hid::NpadIdType id, bool enabled))
    {
        NN_SF_CMIF_CLIENT_DETAIL_CALL_BEGIN(EnableUnintendedHomeButtonInputProtection)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(aruid)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(id)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(enabled)
        NN_SF_CMIF_CLIENT_DETAIL_CALL_END(EnableUnintendedHomeButtonInputProtection)
    }

    // nn::Result SetNpadJoyAssignmentModeSingleWithDestination(nn::sf::Out<bool> outIsAssigned, nn::sf::Out<nn::hid::NpadIdType> outId, nn::applet::AppletResourceUserId aruid, nn::hid::NpadIdType id, std::int64_t type) NN_NOEXCEPT
    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(SetNpadJoyAssignmentModeSingleWithDestination, (::nn::sf::Out<bool> outIsAssigned, ::nn::sf::Out<::nn::hid::NpadIdType> outId, ::nn::applet::AppletResourceUserId aruid, ::nn::hid::NpadIdType id, ::std::int64_t type))
    {
        NN_SF_CMIF_CLIENT_DETAIL_CALL_BEGIN(SetNpadJoyAssignmentModeSingleWithDestination)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(outIsAssigned)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(outId)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(aruid)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(id)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(type)
        NN_SF_CMIF_CLIENT_DETAIL_CALL_END(SetNpadJoyAssignmentModeSingleWithDestination)
    }

    // nn::Result GetVibrationDeviceInfo(nn::sf::Out<nn::hid::VibrationDeviceInfoForIpc> outValue, nn::hid::VibrationDeviceHandle handle) NN_NOEXCEPT
    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(GetVibrationDeviceInfo, (::nn::sf::Out<::nn::hid::VibrationDeviceInfoForIpc> outValue, ::nn::hid::VibrationDeviceHandle handle))
    {
        NN_SF_CMIF_CLIENT_DETAIL_CALL_BEGIN(GetVibrationDeviceInfo)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(outValue)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(handle)
        NN_SF_CMIF_CLIENT_DETAIL_CALL_END(GetVibrationDeviceInfo)
    }

    // nn::Result SendVibrationValue(nn::applet::AppletResourceUserId aruid, nn::hid::VibrationDeviceHandle handle, const nn::hid::VibrationValue& value) NN_NOEXCEPT
    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(SendVibrationValue, (::nn::applet::AppletResourceUserId aruid, ::nn::hid::VibrationDeviceHandle handle, const ::nn::hid::VibrationValue& value))
    {
        NN_SF_CMIF_CLIENT_DETAIL_CALL_BEGIN(SendVibrationValue)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(aruid)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(handle)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(value)
        NN_SF_CMIF_CLIENT_DETAIL_CALL_END(SendVibrationValue)
    }

    // nn::Result GetActualVibrationValue(nn::sf::Out<nn::hid::VibrationValue> outValue, nn::applet::AppletResourceUserId aruid, nn::hid::VibrationDeviceHandle handle) NN_NOEXCEPT
    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(GetActualVibrationValue, (::nn::sf::Out<::nn::hid::VibrationValue> outValue, ::nn::applet::AppletResourceUserId aruid, ::nn::hid::VibrationDeviceHandle handle))
    {
        NN_SF_CMIF_CLIENT_DETAIL_CALL_BEGIN(GetActualVibrationValue)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(outValue)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(aruid)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(handle)
        NN_SF_CMIF_CLIENT_DETAIL_CALL_END(GetActualVibrationValue)
    }

    // nn::Result CreateActiveVibrationDeviceList(nn::sf::Out<nn::sf::SharedPointer<nn::hid::IActiveVibrationDeviceList>> outValue) NN_NOEXCEPT
    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(CreateActiveVibrationDeviceList, (::nn::sf::Out<::nn::sf::SharedPointer<::nn::hid::IActiveVibrationDeviceList>> outValue))
    {
        NN_SF_CMIF_CLIENT_DETAIL_CALL_BEGIN(CreateActiveVibrationDeviceList)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(outValue)
        NN_SF_CMIF_CLIENT_DETAIL_CALL_END(CreateActiveVibrationDeviceList)
    }

    // nn::Result PermitVibration(bool isPermitted) NN_NOEXCEPT
    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(PermitVibration, (bool isPermitted))
    {
        NN_SF_CMIF_CLIENT_DETAIL_CALL_BEGIN(PermitVibration)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(isPermitted)
        NN_SF_CMIF_CLIENT_DETAIL_CALL_END(PermitVibration)
    }

    // nn::Result IsVibrationPermitted(nn::sf::Out<bool> outValue) NN_NOEXCEPT
    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(IsVibrationPermitted, (::nn::sf::Out<bool> outValue))
    {
        NN_SF_CMIF_CLIENT_DETAIL_CALL_BEGIN(IsVibrationPermitted)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(outValue)
        NN_SF_CMIF_CLIENT_DETAIL_CALL_END(IsVibrationPermitted)
    }

    // nn::Result SendVibrationValues(nn::applet::AppletResourceUserId aruid, const nn::sf::InArray<nn::hid::VibrationDeviceHandle>& handles, const nn::sf::InArray<nn::hid::VibrationValue>& values) NN_NOEXCEPT
    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(SendVibrationValues, (::nn::applet::AppletResourceUserId aruid, const ::nn::sf::InArray<::nn::hid::VibrationDeviceHandle>& handles, const ::nn::sf::InArray<::nn::hid::VibrationValue>& values))
    {
        NN_SF_CMIF_CLIENT_DETAIL_CALL_BEGIN(SendVibrationValues)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(aruid)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(handles)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(values)
        NN_SF_CMIF_CLIENT_DETAIL_CALL_END(SendVibrationValues)
    }

    // nn::Result SendVibrationGcErmCommand(nn::applet::AppletResourceUserId aruid, nn::hid::VibrationDeviceHandle handle, nn::hid::VibrationGcErmCommand command) NN_NOEXCEPT
    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(SendVibrationGcErmCommand, (::nn::applet::AppletResourceUserId aruid, ::nn::hid::VibrationDeviceHandle handle, ::nn::hid::VibrationGcErmCommand command))
    {
        NN_SF_CMIF_CLIENT_DETAIL_CALL_BEGIN(SendVibrationGcErmCommand)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(aruid)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(handle)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(command)
        NN_SF_CMIF_CLIENT_DETAIL_CALL_END(SendVibrationGcErmCommand)
    }

    // nn::Result GetActualVibrationGcErmCommand(nn::sf::Out<nn::hid::VibrationGcErmCommand> outValue, nn::applet::AppletResourceUserId aruid, nn::hid::VibrationDeviceHandle handle) NN_NOEXCEPT
    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(GetActualVibrationGcErmCommand, (::nn::sf::Out<::nn::hid::VibrationGcErmCommand> outValue, ::nn::applet::AppletResourceUserId aruid, ::nn::hid::VibrationDeviceHandle handle))
    {
        NN_SF_CMIF_CLIENT_DETAIL_CALL_BEGIN(GetActualVibrationGcErmCommand)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(outValue)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(aruid)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(handle)
        NN_SF_CMIF_CLIENT_DETAIL_CALL_END(GetActualVibrationGcErmCommand)
    }

    // nn::Result BeginPermitVibrationSession(nn::applet::AppletResourceUserId aruid) NN_NOEXCEPT
    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(BeginPermitVibrationSession, (::nn::applet::AppletResourceUserId aruid))
    {
        NN_SF_CMIF_CLIENT_DETAIL_CALL_BEGIN(BeginPermitVibrationSession)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(aruid)
        NN_SF_CMIF_CLIENT_DETAIL_CALL_END(BeginPermitVibrationSession)
    }

    // nn::Result EndPermitVibrationSession() NN_NOEXCEPT
    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_0(EndPermitVibrationSession)
    {
        NN_SF_CMIF_CLIENT_DETAIL_CALL_BEGIN(EndPermitVibrationSession)
        NN_SF_CMIF_CLIENT_DETAIL_CALL_END(EndPermitVibrationSession)
    }

    // nn::Result ActivateConsoleSixAxisSensor(nn::applet::AppletResourceUserId aruid) NN_NOEXCEPT
    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(ActivateConsoleSixAxisSensor, (::nn::applet::AppletResourceUserId aruid))
    {
        NN_SF_CMIF_CLIENT_DETAIL_CALL_BEGIN(ActivateConsoleSixAxisSensor)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(aruid)
        NN_SF_CMIF_CLIENT_DETAIL_CALL_END(ActivateConsoleSixAxisSensor)
    }

    // nn::Result StartConsoleSixAxisSensor(nn::applet::AppletResourceUserId aruid, nn::hid::ConsoleSixAxisSensorHandle handle) NN_NOEXCEPT
    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(StartConsoleSixAxisSensor, (::nn::applet::AppletResourceUserId aruid, ::nn::hid::ConsoleSixAxisSensorHandle handle))
    {
        NN_SF_CMIF_CLIENT_DETAIL_CALL_BEGIN(StartConsoleSixAxisSensor)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(aruid)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(handle)
        NN_SF_CMIF_CLIENT_DETAIL_CALL_END(StartConsoleSixAxisSensor)
    }

    // nn::Result StopConsoleSixAxisSensor(nn::applet::AppletResourceUserId aruid, nn::hid::ConsoleSixAxisSensorHandle handle) NN_NOEXCEPT
    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(StopConsoleSixAxisSensor, (::nn::applet::AppletResourceUserId aruid, ::nn::hid::ConsoleSixAxisSensorHandle handle))
    {
        NN_SF_CMIF_CLIENT_DETAIL_CALL_BEGIN(StopConsoleSixAxisSensor)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(aruid)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(handle)
        NN_SF_CMIF_CLIENT_DETAIL_CALL_END(StopConsoleSixAxisSensor)
    }

    // nn::Result ActivateSevenSixAxisSensor(nn::applet::AppletResourceUserId aruid) NN_NOEXCEPT
    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(ActivateSevenSixAxisSensor, (::nn::applet::AppletResourceUserId aruid))
    {
        NN_SF_CMIF_CLIENT_DETAIL_CALL_BEGIN(ActivateSevenSixAxisSensor)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(aruid)
        NN_SF_CMIF_CLIENT_DETAIL_CALL_END(ActivateSevenSixAxisSensor)
    }

    // nn::Result StartSevenSixAxisSensor(nn::applet::AppletResourceUserId aruid) NN_NOEXCEPT
    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(StartSevenSixAxisSensor, (::nn::applet::AppletResourceUserId aruid))
    {
        NN_SF_CMIF_CLIENT_DETAIL_CALL_BEGIN(StartSevenSixAxisSensor)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(aruid)
        NN_SF_CMIF_CLIENT_DETAIL_CALL_END(StartSevenSixAxisSensor)
    }

    // nn::Result StopSevenSixAxisSensor(nn::applet::AppletResourceUserId aruid) NN_NOEXCEPT
    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(StopSevenSixAxisSensor, (::nn::applet::AppletResourceUserId aruid))
    {
        NN_SF_CMIF_CLIENT_DETAIL_CALL_BEGIN(StopSevenSixAxisSensor)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(aruid)
        NN_SF_CMIF_CLIENT_DETAIL_CALL_END(StopSevenSixAxisSensor)
    }

    // nn::Result InitializeSevenSixAxisSensor(nn::applet::AppletResourceUserId aruid, nn::sf::NativeHandle&& stateBufferHandle, std::uint64_t stateBufferSize, nn::sf::NativeHandle&& workBufferHandle, std::uint64_t workBufferSize) NN_NOEXCEPT
    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(InitializeSevenSixAxisSensor, (::nn::applet::AppletResourceUserId aruid, ::nn::sf::NativeHandle&& stateBufferHandle, ::std::uint64_t stateBufferSize, ::nn::sf::NativeHandle&& workBufferHandle, ::std::uint64_t workBufferSize))
    {
        NN_SF_CMIF_CLIENT_DETAIL_CALL_BEGIN(InitializeSevenSixAxisSensor)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(aruid)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(stateBufferHandle)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(stateBufferSize)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(workBufferHandle)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(workBufferSize)
        NN_SF_CMIF_CLIENT_DETAIL_CALL_END(InitializeSevenSixAxisSensor)
    }

    // nn::Result FinalizeSevenSixAxisSensor(nn::applet::AppletResourceUserId aruid) NN_NOEXCEPT
    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(FinalizeSevenSixAxisSensor, (::nn::applet::AppletResourceUserId aruid))
    {
        NN_SF_CMIF_CLIENT_DETAIL_CALL_BEGIN(FinalizeSevenSixAxisSensor)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(aruid)
        NN_SF_CMIF_CLIENT_DETAIL_CALL_END(FinalizeSevenSixAxisSensor)
    }

    // nn::Result SetSevenSixAxisSensorFusionStrength(nn::applet::AppletResourceUserId aruid, float strength) NN_NOEXCEPT
    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(SetSevenSixAxisSensorFusionStrength, (::nn::applet::AppletResourceUserId aruid, float strength))
    {
        NN_SF_CMIF_CLIENT_DETAIL_CALL_BEGIN(SetSevenSixAxisSensorFusionStrength)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(aruid)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(strength)
        NN_SF_CMIF_CLIENT_DETAIL_CALL_END(SetSevenSixAxisSensorFusionStrength)
    }

    // nn::Result GetSevenSixAxisSensorFusionStrength(nn::sf::Out<float> strength, nn::applet::AppletResourceUserId aruid) NN_NOEXCEPT
    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(GetSevenSixAxisSensorFusionStrength, (::nn::sf::Out<float> strength, ::nn::applet::AppletResourceUserId aruid))
    {
        NN_SF_CMIF_CLIENT_DETAIL_CALL_BEGIN(GetSevenSixAxisSensorFusionStrength)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(strength)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(aruid)
        NN_SF_CMIF_CLIENT_DETAIL_CALL_END(GetSevenSixAxisSensorFusionStrength)
    }

    // nn::Result IsUsbFullKeyControllerEnabled(nn::sf::Out<bool> outIsEnabled) NN_NOEXCEPT
    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(IsUsbFullKeyControllerEnabled, (::nn::sf::Out<bool> outIsEnabled))
    {
        NN_SF_CMIF_CLIENT_DETAIL_CALL_BEGIN(IsUsbFullKeyControllerEnabled)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(outIsEnabled)
        NN_SF_CMIF_CLIENT_DETAIL_CALL_END(IsUsbFullKeyControllerEnabled)
    }

    // nn::Result EnableUsbFullKeyController(bool enabled) NN_NOEXCEPT
    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(EnableUsbFullKeyController, (bool enabled))
    {
        NN_SF_CMIF_CLIENT_DETAIL_CALL_BEGIN(EnableUsbFullKeyController)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(enabled)
        NN_SF_CMIF_CLIENT_DETAIL_CALL_END(EnableUsbFullKeyController)
    }

    // nn::Result IsUsbFullKeyControllerConnected(nn::sf::Out<bool> outIsConnected, nn::hid::NpadIdType id) NN_NOEXCEPT
    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(IsUsbFullKeyControllerConnected, (::nn::sf::Out<bool> outIsConnected, ::nn::hid::NpadIdType id))
    {
        NN_SF_CMIF_CLIENT_DETAIL_CALL_BEGIN(IsUsbFullKeyControllerConnected)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(outIsConnected)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(id)
        NN_SF_CMIF_CLIENT_DETAIL_CALL_END(IsUsbFullKeyControllerConnected)
    }

    // nn::Result HasBattery(nn::sf::Out<bool> outHasBattery, nn::hid::NpadIdType id) NN_NOEXCEPT
    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(HasBattery, (::nn::sf::Out<bool> outHasBattery, ::nn::hid::NpadIdType id))
    {
        NN_SF_CMIF_CLIENT_DETAIL_CALL_BEGIN(HasBattery)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(outHasBattery)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(id)
        NN_SF_CMIF_CLIENT_DETAIL_CALL_END(HasBattery)
    }

    // nn::Result HasLeftRightBattery(nn::sf::Out<bool> outLeftJoyHasBattery, nn::sf::Out<bool> outRightJoyHasBattery, nn::hid::NpadIdType id) NN_NOEXCEPT
    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(HasLeftRightBattery, (::nn::sf::Out<bool> outLeftJoyHasBattery, ::nn::sf::Out<bool> outRightJoyHasBattery, ::nn::hid::NpadIdType id))
    {
        NN_SF_CMIF_CLIENT_DETAIL_CALL_BEGIN(HasLeftRightBattery)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(outLeftJoyHasBattery)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(outRightJoyHasBattery)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(id)
        NN_SF_CMIF_CLIENT_DETAIL_CALL_END(HasLeftRightBattery)
    }

    // nn::Result GetNpadInterfaceType(nn::sf::Out<nn::hid::system::InterfaceType> outInterfaceType, nn::hid::NpadIdType id) NN_NOEXCEPT
    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(GetNpadInterfaceType, (::nn::sf::Out<::nn::hid::system::InterfaceType> outInterfaceType, ::nn::hid::NpadIdType id))
    {
        NN_SF_CMIF_CLIENT_DETAIL_CALL_BEGIN(GetNpadInterfaceType)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(outInterfaceType)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(id)
        NN_SF_CMIF_CLIENT_DETAIL_CALL_END(GetNpadInterfaceType)
    }

    // nn::Result GetNpadLeftRightInterfaceType(nn::sf::Out<nn::hid::system::InterfaceType> outLeftJoyInterfaceType, nn::sf::Out<nn::hid::system::InterfaceType> outRightJoyInterfaceType, nn::hid::NpadIdType id) NN_NOEXCEPT
    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(GetNpadLeftRightInterfaceType, (::nn::sf::Out<::nn::hid::system::InterfaceType> outLeftJoyInterfaceType, ::nn::sf::Out<::nn::hid::system::InterfaceType> outRightJoyInterfaceType, ::nn::hid::NpadIdType id))
    {
        NN_SF_CMIF_CLIENT_DETAIL_CALL_BEGIN(GetNpadLeftRightInterfaceType)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(outLeftJoyInterfaceType)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(outRightJoyInterfaceType)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(id)
        NN_SF_CMIF_CLIENT_DETAIL_CALL_END(GetNpadLeftRightInterfaceType)
    }

    // nn::Result GetPalmaConnectionHandle(nn::sf::Out<nn::hid::PalmaConnectionHandle> outHandle, nn::hid::NpadIdType id, nn::applet::AppletResourceUserId aruid) NN_NOEXCEPT
    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(GetPalmaConnectionHandle, (::nn::sf::Out<::nn::hid::PalmaConnectionHandle> outHandle, ::nn::hid::NpadIdType id, ::nn::applet::AppletResourceUserId aruid))
    {
        NN_SF_CMIF_CLIENT_DETAIL_CALL_BEGIN(GetPalmaConnectionHandle)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(outHandle)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(id)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(aruid)
        NN_SF_CMIF_CLIENT_DETAIL_CALL_END(GetPalmaConnectionHandle)
    }

    // nn::Result InitializePalma(nn::hid::PalmaConnectionHandle handle) NN_NOEXCEPT
    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(InitializePalma, (::nn::hid::PalmaConnectionHandle handle))
    {
        NN_SF_CMIF_CLIENT_DETAIL_CALL_BEGIN(InitializePalma)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(handle)
        NN_SF_CMIF_CLIENT_DETAIL_CALL_END(InitializePalma)
    }

    // nn::Result AcquirePalmaOperationCompleteEvent(nn::sf::Out<nn::sf::NativeHandle> outValue, nn::hid::PalmaConnectionHandle handle) NN_NOEXCEPT
    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(AcquirePalmaOperationCompleteEvent, (::nn::sf::Out<::nn::sf::NativeHandle> outValue, ::nn::hid::PalmaConnectionHandle handle))
    {
        NN_SF_CMIF_CLIENT_DETAIL_CALL_BEGIN(AcquirePalmaOperationCompleteEvent)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(outValue)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(handle)
        NN_SF_CMIF_CLIENT_DETAIL_CALL_END(AcquirePalmaOperationCompleteEvent)
    }

    // nn::Result GetPalmaOperationInfo(nn::sf::Out<std::uint64_t> outType, const nn::sf::OutBuffer& outBuffer, nn::hid::PalmaConnectionHandle handle) NN_NOEXCEPT
    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(GetPalmaOperationInfo, (::nn::sf::Out<::std::uint64_t> outType, const ::nn::sf::OutBuffer& outBuffer, ::nn::hid::PalmaConnectionHandle handle))
    {
        NN_SF_CMIF_CLIENT_DETAIL_CALL_BEGIN(GetPalmaOperationInfo)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(outType)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(outBuffer)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(handle)
        NN_SF_CMIF_CLIENT_DETAIL_CALL_END(GetPalmaOperationInfo)
    }

    // nn::Result PlayPalmaActivity(nn::hid::PalmaConnectionHandle handle, std::uint64_t index) NN_NOEXCEPT
    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(PlayPalmaActivity, (::nn::hid::PalmaConnectionHandle handle, ::std::uint64_t index))
    {
        NN_SF_CMIF_CLIENT_DETAIL_CALL_BEGIN(PlayPalmaActivity)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(handle)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(index)
        NN_SF_CMIF_CLIENT_DETAIL_CALL_END(PlayPalmaActivity)
    }

    // nn::Result SetPalmaFrModeType(nn::hid::PalmaConnectionHandle handle, std::uint64_t type) NN_NOEXCEPT
    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(SetPalmaFrModeType, (::nn::hid::PalmaConnectionHandle handle, ::std::uint64_t type))
    {
        NN_SF_CMIF_CLIENT_DETAIL_CALL_BEGIN(SetPalmaFrModeType)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(handle)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(type)
        NN_SF_CMIF_CLIENT_DETAIL_CALL_END(SetPalmaFrModeType)
    }

    // nn::Result ReadPalmaStep(nn::hid::PalmaConnectionHandle handle) NN_NOEXCEPT
    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(ReadPalmaStep, (::nn::hid::PalmaConnectionHandle handle))
    {
        NN_SF_CMIF_CLIENT_DETAIL_CALL_BEGIN(ReadPalmaStep)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(handle)
        NN_SF_CMIF_CLIENT_DETAIL_CALL_END(ReadPalmaStep)
    }

    // nn::Result EnablePalmaStep(nn::hid::PalmaConnectionHandle handle, bool isEnabled) NN_NOEXCEPT
    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(EnablePalmaStep, (::nn::hid::PalmaConnectionHandle handle, bool isEnabled))
    {
        NN_SF_CMIF_CLIENT_DETAIL_CALL_BEGIN(EnablePalmaStep)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(handle)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(isEnabled)
        NN_SF_CMIF_CLIENT_DETAIL_CALL_END(EnablePalmaStep)
    }

    // nn::Result ResetPalmaStep(nn::hid::PalmaConnectionHandle handle) NN_NOEXCEPT
    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(ResetPalmaStep, (::nn::hid::PalmaConnectionHandle handle))
    {
        NN_SF_CMIF_CLIENT_DETAIL_CALL_BEGIN(ResetPalmaStep)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(handle)
        NN_SF_CMIF_CLIENT_DETAIL_CALL_END(ResetPalmaStep)
    }

    // nn::Result ReadPalmaApplicationSection(nn::hid::PalmaConnectionHandle handle, std::uint64_t address, std::uint64_t size) NN_NOEXCEPT
    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(ReadPalmaApplicationSection, (::nn::hid::PalmaConnectionHandle handle, ::std::uint64_t address, ::std::uint64_t size))
    {
        NN_SF_CMIF_CLIENT_DETAIL_CALL_BEGIN(ReadPalmaApplicationSection)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(handle)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(address)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(size)
        NN_SF_CMIF_CLIENT_DETAIL_CALL_END(ReadPalmaApplicationSection)
    }

    // nn::Result WritePalmaApplicationSection(nn::hid::PalmaConnectionHandle handle, std::uint64_t address, std::uint64_t size, const nn::hid::PalmaApplicationSectionAccessBuffer& buffer) NN_NOEXCEPT
    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(WritePalmaApplicationSection, (::nn::hid::PalmaConnectionHandle handle, ::std::uint64_t address, ::std::uint64_t size, const ::nn::hid::PalmaApplicationSectionAccessBuffer& buffer))
    {
        NN_SF_CMIF_CLIENT_DETAIL_CALL_BEGIN(WritePalmaApplicationSection)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(handle)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(address)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(size)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(buffer)
        NN_SF_CMIF_CLIENT_DETAIL_CALL_END(WritePalmaApplicationSection)
    }

    // nn::Result ReadPalmaUniqueCode(nn::hid::PalmaConnectionHandle handle) NN_NOEXCEPT
    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(ReadPalmaUniqueCode, (::nn::hid::PalmaConnectionHandle handle))
    {
        NN_SF_CMIF_CLIENT_DETAIL_CALL_BEGIN(ReadPalmaUniqueCode)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(handle)
        NN_SF_CMIF_CLIENT_DETAIL_CALL_END(ReadPalmaUniqueCode)
    }

    // nn::Result SetPalmaUniqueCodeInvalid(nn::hid::PalmaConnectionHandle handle) NN_NOEXCEPT
    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(SetPalmaUniqueCodeInvalid, (::nn::hid::PalmaConnectionHandle handle))
    {
        NN_SF_CMIF_CLIENT_DETAIL_CALL_BEGIN(SetPalmaUniqueCodeInvalid)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(handle)
        NN_SF_CMIF_CLIENT_DETAIL_CALL_END(SetPalmaUniqueCodeInvalid)
    }

    // nn::Result WritePalmaActivityEntry(nn::hid::PalmaConnectionHandle handle, std::uint64_t index, std::uint64_t ledIndex, std::uint64_t waveSet, std::uint64_t waveIndex) NN_NOEXCEPT
    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(WritePalmaActivityEntry, (::nn::hid::PalmaConnectionHandle handle, ::std::uint64_t index, ::std::uint64_t ledIndex, ::std::uint64_t waveSet, ::std::uint64_t waveIndex))
    {
        NN_SF_CMIF_CLIENT_DETAIL_CALL_BEGIN(WritePalmaActivityEntry)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(handle)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(index)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(ledIndex)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(waveSet)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(waveIndex)
        NN_SF_CMIF_CLIENT_DETAIL_CALL_END(WritePalmaActivityEntry)
    }

    // nn::Result WritePalmaRgbLedPatternEntry(nn::hid::PalmaConnectionHandle handle, std::uint64_t index, const nn::sf::InBuffer& pInBuffer) NN_NOEXCEPT
    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(WritePalmaRgbLedPatternEntry, (::nn::hid::PalmaConnectionHandle handle, ::std::uint64_t index, const ::nn::sf::InBuffer& pInBuffer))
    {
        NN_SF_CMIF_CLIENT_DETAIL_CALL_BEGIN(WritePalmaRgbLedPatternEntry)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(handle)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(index)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(pInBuffer)
        NN_SF_CMIF_CLIENT_DETAIL_CALL_END(WritePalmaRgbLedPatternEntry)
    }

    // nn::Result WritePalmaWaveEntry(nn::hid::PalmaConnectionHandle handle, std::uint64_t waveSet, std::uint64_t index, nn::sf::NativeHandle&& transferMemoryHandle, std::uint64_t transferMemorySize, std::uint64_t waveDataSize) NN_NOEXCEPT
    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(WritePalmaWaveEntry, (::nn::hid::PalmaConnectionHandle handle, ::std::uint64_t waveSet, ::std::uint64_t index, ::nn::sf::NativeHandle&& transferMemoryHandle, ::std::uint64_t transferMemorySize, ::std::uint64_t waveDataSize))
    {
        NN_SF_CMIF_CLIENT_DETAIL_CALL_BEGIN(WritePalmaWaveEntry)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(handle)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(waveSet)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(index)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(transferMemoryHandle)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(transferMemorySize)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(waveDataSize)
        NN_SF_CMIF_CLIENT_DETAIL_CALL_END(WritePalmaWaveEntry)
    }

    // nn::Result SetPalmaDataBaseIdentificationVersion(nn::hid::PalmaConnectionHandle handle, std::int32_t version) NN_NOEXCEPT
    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(SetPalmaDataBaseIdentificationVersion, (::nn::hid::PalmaConnectionHandle handle, ::std::int32_t version))
    {
        NN_SF_CMIF_CLIENT_DETAIL_CALL_BEGIN(SetPalmaDataBaseIdentificationVersion)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(handle)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(version)
        NN_SF_CMIF_CLIENT_DETAIL_CALL_END(SetPalmaDataBaseIdentificationVersion)
    }

    // nn::Result GetPalmaDataBaseIdentificationVersion(nn::hid::PalmaConnectionHandle handle) NN_NOEXCEPT
    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(GetPalmaDataBaseIdentificationVersion, (::nn::hid::PalmaConnectionHandle handle))
    {
        NN_SF_CMIF_CLIENT_DETAIL_CALL_BEGIN(GetPalmaDataBaseIdentificationVersion)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(handle)
        NN_SF_CMIF_CLIENT_DETAIL_CALL_END(GetPalmaDataBaseIdentificationVersion)
    }

    // nn::Result SuspendPalmaFeature(nn::hid::PalmaConnectionHandle handle, nn::hid::PalmaFeatureSet suspendFeatureSet) NN_NOEXCEPT
    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(SuspendPalmaFeature, (::nn::hid::PalmaConnectionHandle handle, ::nn::hid::PalmaFeatureSet suspendFeatureSet))
    {
        NN_SF_CMIF_CLIENT_DETAIL_CALL_BEGIN(SuspendPalmaFeature)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(handle)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(suspendFeatureSet)
        NN_SF_CMIF_CLIENT_DETAIL_CALL_END(SuspendPalmaFeature)
    }

    // nn::Result GetPalmaOperationResult(nn::hid::PalmaConnectionHandle handle) NN_NOEXCEPT
    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(GetPalmaOperationResult, (::nn::hid::PalmaConnectionHandle handle))
    {
        NN_SF_CMIF_CLIENT_DETAIL_CALL_BEGIN(GetPalmaOperationResult)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(handle)
        NN_SF_CMIF_CLIENT_DETAIL_CALL_END(GetPalmaOperationResult)
    }

    // nn::Result ReadPalmaPlayLog(nn::hid::PalmaConnectionHandle handle, std::uint16_t index) NN_NOEXCEPT
    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(ReadPalmaPlayLog, (::nn::hid::PalmaConnectionHandle handle, ::std::uint16_t index))
    {
        NN_SF_CMIF_CLIENT_DETAIL_CALL_BEGIN(ReadPalmaPlayLog)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(handle)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(index)
        NN_SF_CMIF_CLIENT_DETAIL_CALL_END(ReadPalmaPlayLog)
    }

    // nn::Result ResetPalmaPlayLog(nn::hid::PalmaConnectionHandle handle, std::uint16_t index) NN_NOEXCEPT
    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(ResetPalmaPlayLog, (::nn::hid::PalmaConnectionHandle handle, ::std::uint16_t index))
    {
        NN_SF_CMIF_CLIENT_DETAIL_CALL_BEGIN(ResetPalmaPlayLog)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(handle)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(index)
        NN_SF_CMIF_CLIENT_DETAIL_CALL_END(ResetPalmaPlayLog)
    }

    // nn::Result SetIsPalmaAllConnectable(nn::applet::AppletResourceUserId aruid, bool connectable) NN_NOEXCEPT
    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(SetIsPalmaAllConnectable, (::nn::applet::AppletResourceUserId aruid, bool connectable))
    {
        NN_SF_CMIF_CLIENT_DETAIL_CALL_BEGIN(SetIsPalmaAllConnectable)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(aruid)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(connectable)
        NN_SF_CMIF_CLIENT_DETAIL_CALL_END(SetIsPalmaAllConnectable)
    }

    // nn::Result SetIsPalmaPairedConnectable(nn::applet::AppletResourceUserId aruid, bool connectable) NN_NOEXCEPT
    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(SetIsPalmaPairedConnectable, (::nn::applet::AppletResourceUserId aruid, bool connectable))
    {
        NN_SF_CMIF_CLIENT_DETAIL_CALL_BEGIN(SetIsPalmaPairedConnectable)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(aruid)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(connectable)
        NN_SF_CMIF_CLIENT_DETAIL_CALL_END(SetIsPalmaPairedConnectable)
    }

    // nn::Result PairPalma(nn::hid::PalmaConnectionHandle handle) NN_NOEXCEPT
    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(PairPalma, (::nn::hid::PalmaConnectionHandle handle))
    {
        NN_SF_CMIF_CLIENT_DETAIL_CALL_BEGIN(PairPalma)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(handle)
        NN_SF_CMIF_CLIENT_DETAIL_CALL_END(PairPalma)
    }

    // nn::Result SetPalmaBoostMode(bool enabled) NN_NOEXCEPT
    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(SetPalmaBoostMode, (bool enabled))
    {
        NN_SF_CMIF_CLIENT_DETAIL_CALL_BEGIN(SetPalmaBoostMode)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(enabled)
        NN_SF_CMIF_CLIENT_DETAIL_CALL_END(SetPalmaBoostMode)
    }

    // nn::Result SetNpadCommunicationMode(nn::applet::AppletResourceUserId aruid, std::int64_t mode) NN_NOEXCEPT
    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(SetNpadCommunicationMode, (::nn::applet::AppletResourceUserId aruid, ::std::int64_t mode))
    {
        NN_SF_CMIF_CLIENT_DETAIL_CALL_BEGIN(SetNpadCommunicationMode)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(aruid)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(mode)
        NN_SF_CMIF_CLIENT_DETAIL_CALL_END(SetNpadCommunicationMode)
    }

    // nn::Result GetNpadCommunicationMode(nn::sf::Out<std::int64_t> outValue) NN_NOEXCEPT
    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(GetNpadCommunicationMode, (::nn::sf::Out<::std::int64_t> outValue))
    {
        NN_SF_CMIF_CLIENT_DETAIL_CALL_BEGIN(GetNpadCommunicationMode)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(outValue)
        NN_SF_CMIF_CLIENT_DETAIL_CALL_END(GetNpadCommunicationMode)
    }

NN_SF_CMIF_CLIENT_DETAIL_DEFINE_PROXY_END

// template <> class nn::sf::server::detail::CmifProcessFunctionTableGetterImpl<nn::hid::IHidServer>
NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCHER((::nn::hid::IHidServer))

    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD(CreateAppletResource)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_DEFINE_OUT_OBJECT((::nn::sf::SharedPointer<::nn::hid::IAppletResource>), outValue)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_CHECK_PRE(NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_APPLY_PROCESS_ID(_, CheckAppletResourceUserId(_processId, _), NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(aruid)))
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE(CreateAppletResource)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_OUT_OBJECT(outValue),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(aruid)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_SET_OUT_OBJECT(outValue, 0)
    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_END

    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD(ActivateDebugPad)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_CHECK_PRE(NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_APPLY_PROCESS_ID(_, CheckAppletResourceUserId(_processId, _), NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(aruid)))
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE(ActivateDebugPad)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(aruid)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE_END
    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_END

    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD(ActivateTouchScreen)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_CHECK_PRE(NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_APPLY_PROCESS_ID(_, CheckAppletResourceUserId(_processId, _), NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(aruid)))
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE(ActivateTouchScreen)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(aruid)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE_END
    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_END

    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD(ActivateMouse)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_CHECK_PRE(NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_APPLY_PROCESS_ID(_, CheckAppletResourceUserId(_processId, _), NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(aruid)))
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE(ActivateMouse)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(aruid)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE_END
    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_END

    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD(ActivateKeyboard)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_CHECK_PRE(NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_APPLY_PROCESS_ID(_, CheckAppletResourceUserId(_processId, _), NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(aruid)))
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE(ActivateKeyboard)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(aruid)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE_END
    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_END

    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD(AcquireXpadIdEventHandle)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_OUT_NATIVE_HANDLES
                NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_OUT_NATIVE_HANDLE(outValue)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_OUT_NATIVE_HANDLES_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE(AcquireXpadIdEventHandle)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_OUT_NATIVE_HANDLE(outValue),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(clientId)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE_END
    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_END

    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD(ReleaseXpadIdEventHandle)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE(ReleaseXpadIdEventHandle)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(clientId)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE_END
    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_END

    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD(ActivateXpad)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_CHECK_PRE(NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_APPLY_PROCESS_ID(_, CheckAppletResourceUserId(_processId, _), NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(aruid)))
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE(ActivateXpad)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(aruid),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(xpadId)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE_END
    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_END

    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD(GetXpadIds)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_BUFFERS
                NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_BUFFER(outXpadIds)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_BUFFERS_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE(GetXpadIds)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_OUT_MEMBER(outCount),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_BUFFER(outXpadIds)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE_END
    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_END

    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD(ActivateJoyXpad)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE(ActivateJoyXpad)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(xpadId)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE_END
    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_END

    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD(GetJoyXpadLifoHandle)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_OUT_NATIVE_HANDLES
                NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_OUT_NATIVE_HANDLE(outValue)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_OUT_NATIVE_HANDLES_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE(GetJoyXpadLifoHandle)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_OUT_NATIVE_HANDLE(outValue),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(xpadId)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE_END
    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_END

    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD(GetJoyXpadIds)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_BUFFERS
                NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_BUFFER(outXpadIds)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_BUFFERS_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE(GetJoyXpadIds)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_OUT_MEMBER(outGotCount),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_BUFFER(outXpadIds)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE_END
    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_END

    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD(ActivateSixAxisSensor)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE(ActivateSixAxisSensor)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(xpadId)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE_END
    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_END

    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD(DeactivateSixAxisSensor)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE(DeactivateSixAxisSensor)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(xpadId)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE_END
    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_END

    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD(GetSixAxisSensorLifoHandle)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_OUT_NATIVE_HANDLES
                NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_OUT_NATIVE_HANDLE(outValue)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_OUT_NATIVE_HANDLES_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE(GetSixAxisSensorLifoHandle)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_OUT_NATIVE_HANDLE(outValue),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(xpadId)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE_END
    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_END

    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD(ActivateJoySixAxisSensor)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE(ActivateJoySixAxisSensor)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(xpadId)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE_END
    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_END

    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD(DeactivateJoySixAxisSensor)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE(DeactivateJoySixAxisSensor)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(xpadId)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE_END
    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_END

    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD(GetJoySixAxisSensorLifoHandle)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_OUT_NATIVE_HANDLES
                NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_OUT_NATIVE_HANDLE(outValue)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_OUT_NATIVE_HANDLES_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE(GetJoySixAxisSensorLifoHandle)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_OUT_NATIVE_HANDLE(outValue),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(xpadId)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE_END
    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_END

    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD(StartSixAxisSensor)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_CHECK_PRE(NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_APPLY_PROCESS_ID(_, CheckAppletResourceUserId(_processId, _), NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(aruid)))
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE(StartSixAxisSensor)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(aruid),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(handle)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE_END
    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_END

    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD(StopSixAxisSensor)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_CHECK_PRE(NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_APPLY_PROCESS_ID(_, CheckAppletResourceUserId(_processId, _), NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(aruid)))
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE(StopSixAxisSensor)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(aruid),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(handle)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE_END
    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_END

    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD(IsSixAxisSensorFusionEnabled)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_CHECK_PRE(NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_APPLY_PROCESS_ID(_, CheckAppletResourceUserId(_processId, _), NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(aruid)))
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE(IsSixAxisSensorFusionEnabled)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_OUT_MEMBER(outIsEnabled),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(aruid),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(handle)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE_END
    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_END

    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD(EnableSixAxisSensorFusion)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_CHECK_PRE(NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_APPLY_PROCESS_ID(_, CheckAppletResourceUserId(_processId, _), NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(aruid)))
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE(EnableSixAxisSensorFusion)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(aruid),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(handle),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(enable)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE_END
    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_END

    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD(SetSixAxisSensorFusionParameters)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_CHECK_PRE(NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_APPLY_PROCESS_ID(_, CheckAppletResourceUserId(_processId, _), NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(aruid)))
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE(SetSixAxisSensorFusionParameters)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(aruid),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(handle),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(revisePower),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(reviseRange)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE_END
    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_END

    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD(GetSixAxisSensorFusionParameters)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_CHECK_PRE(NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_APPLY_PROCESS_ID(_, CheckAppletResourceUserId(_processId, _), NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(aruid)))
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE(GetSixAxisSensorFusionParameters)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_OUT_MEMBER(outRevisePower),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_OUT_MEMBER(outReviseRange),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(aruid),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(handle)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE_END
    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_END

    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD(ResetSixAxisSensorFusionParameters)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_CHECK_PRE(NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_APPLY_PROCESS_ID(_, CheckAppletResourceUserId(_processId, _), NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(aruid)))
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE(ResetSixAxisSensorFusionParameters)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(aruid),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(handle)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE_END
    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_END

    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD(SetAccelerometerParameters)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_CHECK_PRE(NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_APPLY_PROCESS_ID(_, CheckAppletResourceUserId(_processId, _), NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(aruid)))
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE(SetAccelerometerParameters)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(aruid),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(handle),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(playRadius),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(sensitivity)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE_END
    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_END

    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD(GetAccelerometerParameters)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_CHECK_PRE(NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_APPLY_PROCESS_ID(_, CheckAppletResourceUserId(_processId, _), NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(aruid)))
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE(GetAccelerometerParameters)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_OUT_MEMBER(outPlayRadius),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_OUT_MEMBER(outSensitivity),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(aruid),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(handle)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE_END
    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_END

    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD(ResetAccelerometerParameters)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_CHECK_PRE(NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_APPLY_PROCESS_ID(_, CheckAppletResourceUserId(_processId, _), NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(aruid)))
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE(ResetAccelerometerParameters)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(aruid),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(handle)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE_END
    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_END

    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD(SetAccelerometerPlayMode)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_CHECK_PRE(NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_APPLY_PROCESS_ID(_, CheckAppletResourceUserId(_processId, _), NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(aruid)))
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE(SetAccelerometerPlayMode)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(aruid),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(handle),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(mode)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE_END
    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_END

    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD(GetAccelerometerPlayMode)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_CHECK_PRE(NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_APPLY_PROCESS_ID(_, CheckAppletResourceUserId(_processId, _), NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(aruid)))
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE(GetAccelerometerPlayMode)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_OUT_MEMBER(outMode),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(aruid),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(handle)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE_END
    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_END

    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD(ResetAccelerometerPlayMode)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_CHECK_PRE(NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_APPLY_PROCESS_ID(_, CheckAppletResourceUserId(_processId, _), NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(aruid)))
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE(ResetAccelerometerPlayMode)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(aruid),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(handle)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE_END
    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_END

    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD(SetGyroscopeZeroDriftMode)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_CHECK_PRE(NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_APPLY_PROCESS_ID(_, CheckAppletResourceUserId(_processId, _), NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(aruid)))
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE(SetGyroscopeZeroDriftMode)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(aruid),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(handle),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(mode)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE_END
    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_END

    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD(GetGyroscopeZeroDriftMode)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_CHECK_PRE(NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_APPLY_PROCESS_ID(_, CheckAppletResourceUserId(_processId, _), NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(aruid)))
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE(GetGyroscopeZeroDriftMode)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_OUT_MEMBER(outMode),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(aruid),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(handle)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE_END
    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_END

    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD(ResetGyroscopeZeroDriftMode)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_CHECK_PRE(NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_APPLY_PROCESS_ID(_, CheckAppletResourceUserId(_processId, _), NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(aruid)))
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE(ResetGyroscopeZeroDriftMode)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(aruid),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(handle)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE_END
    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_END

    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD(IsSixAxisSensorAtRest)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_CHECK_PRE(NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_APPLY_PROCESS_ID(_, CheckAppletResourceUserId(_processId, _), NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(aruid)))
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE(IsSixAxisSensorAtRest)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_OUT_MEMBER(outIsAtRest),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(aruid),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(handle)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE_END
    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_END

    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD(ActivateGesture)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_CHECK_PRE(NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_APPLY_PROCESS_ID(_, CheckAppletResourceUserId(_processId, _), NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(aruid)))
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE(ActivateGesture)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(aruid),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(version)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE_END
    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_END

    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD(SetSupportedNpadStyleSet)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_CHECK_PRE(NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_APPLY_PROCESS_ID(_, CheckAppletResourceUserId(_processId, _), NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(aruid)))
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE(SetSupportedNpadStyleSet)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(aruid),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(style)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE_END
    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_END

    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD(GetSupportedNpadStyleSet)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_CHECK_PRE(NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_APPLY_PROCESS_ID(_, CheckAppletResourceUserId(_processId, _), NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(aruid)))
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE(GetSupportedNpadStyleSet)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(aruid),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_OUT_MEMBER(outValue)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE_END
    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_END

    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD(SetSupportedNpadIdType)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_BUFFERS
                NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_BUFFER(ids)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_BUFFERS_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_CHECK_PRE(NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_APPLY_PROCESS_ID(_, CheckAppletResourceUserId(_processId, _), NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(aruid)))
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE(SetSupportedNpadIdType)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(aruid),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_BUFFER(ids)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE_END
    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_END

    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD(ActivateNpad)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_CHECK_PRE(NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_APPLY_PROCESS_ID(_, CheckAppletResourceUserId(_processId, _), NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(aruid)))
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE(ActivateNpad)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(aruid)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE_END
    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_END

    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD(DeactivateNpad)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_CHECK_PRE(NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_APPLY_PROCESS_ID(_, CheckAppletResourceUserId(_processId, _), NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(aruid)))
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE(DeactivateNpad)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(aruid)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE_END
    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_END

    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD(AcquireNpadStyleSetUpdateEventHandle)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_OUT_NATIVE_HANDLES
                NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_OUT_NATIVE_HANDLE(outValue)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_OUT_NATIVE_HANDLES_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_CHECK_PRE(NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_APPLY_PROCESS_ID(_, CheckAppletResourceUserId(_processId, _), NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(aruid)))
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE(AcquireNpadStyleSetUpdateEventHandle)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(aruid),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_OUT_NATIVE_HANDLE(outValue),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(id),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(clientId)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE_END
    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_END

    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD(DisconnectNpad)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_CHECK_PRE(NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_APPLY_PROCESS_ID(_, CheckAppletResourceUserId(_processId, _), NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(aruid)))
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE(DisconnectNpad)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(aruid),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(id)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE_END
    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_END

    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD(GetPlayerLedPattern)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE(GetPlayerLedPattern)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_OUT_MEMBER(outValue),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(id)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE_END
    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_END

    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD(ActivateNpadWithRevision)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_CHECK_PRE(NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_APPLY_PROCESS_ID(_, CheckAppletResourceUserId(_processId, _), NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(aruid)))
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE(ActivateNpadWithRevision)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(aruid),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(revision)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE_END
    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_END

    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD(SetNpadJoyHoldType)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_CHECK_PRE(NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_APPLY_PROCESS_ID(_, CheckAppletResourceUserId(_processId, _), NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(aruid)))
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE(SetNpadJoyHoldType)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(aruid),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(holdType)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE_END
    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_END

    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD(GetNpadJoyHoldType)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_CHECK_PRE(NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_APPLY_PROCESS_ID(_, CheckAppletResourceUserId(_processId, _), NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(aruid)))
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE(GetNpadJoyHoldType)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(aruid),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_OUT_MEMBER(outValue)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE_END
    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_END

    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD(SetNpadJoyAssignmentModeSingleByDefault)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_CHECK_PRE(NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_APPLY_PROCESS_ID(_, CheckAppletResourceUserId(_processId, _), NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(aruid)))
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE(SetNpadJoyAssignmentModeSingleByDefault)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(aruid),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(id)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE_END
    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_END

    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD(SetNpadJoyAssignmentModeSingle)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_CHECK_PRE(NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_APPLY_PROCESS_ID(_, CheckAppletResourceUserId(_processId, _), NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(aruid)))
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE(SetNpadJoyAssignmentModeSingle)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(aruid),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(id),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(type)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE_END
    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_END

    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD(SetNpadJoyAssignmentModeDual)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_CHECK_PRE(NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_APPLY_PROCESS_ID(_, CheckAppletResourceUserId(_processId, _), NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(aruid)))
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE(SetNpadJoyAssignmentModeDual)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(aruid),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(id)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE_END
    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_END

    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD(MergeSingleJoyAsDualJoy)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_CHECK_PRE(NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_APPLY_PROCESS_ID(_, CheckAppletResourceUserId(_processId, _), NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(aruid)))
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE(MergeSingleJoyAsDualJoy)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(aruid),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(id1),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(id2)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE_END
    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_END

    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD(StartLrAssignmentMode)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_CHECK_PRE(NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_APPLY_PROCESS_ID(_, CheckAppletResourceUserId(_processId, _), NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(aruid)))
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE(StartLrAssignmentMode)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(aruid)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE_END
    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_END

    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD(StopLrAssignmentMode)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_CHECK_PRE(NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_APPLY_PROCESS_ID(_, CheckAppletResourceUserId(_processId, _), NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(aruid)))
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE(StopLrAssignmentMode)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(aruid)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE_END
    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_END

    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD(SetNpadHandheldActivationMode)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_CHECK_PRE(NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_APPLY_PROCESS_ID(_, CheckAppletResourceUserId(_processId, _), NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(aruid)))
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE(SetNpadHandheldActivationMode)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(aruid),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(mode)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE_END
    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_END

    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD(GetNpadHandheldActivationMode)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_CHECK_PRE(NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_APPLY_PROCESS_ID(_, CheckAppletResourceUserId(_processId, _), NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(aruid)))
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE(GetNpadHandheldActivationMode)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(aruid),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_OUT_MEMBER(outValue)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE_END
    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_END

    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD(SwapNpadAssignment)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_CHECK_PRE(NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_APPLY_PROCESS_ID(_, CheckAppletResourceUserId(_processId, _), NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(aruid)))
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE(SwapNpadAssignment)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(aruid),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(id1),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(id2)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE_END
    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_END

    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD(IsUnintendedHomeButtonInputProtectionEnabled)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_CHECK_PRE(NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_APPLY_PROCESS_ID(_, CheckAppletResourceUserId(_processId, _), NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(aruid)))
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE(IsUnintendedHomeButtonInputProtectionEnabled)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_OUT_MEMBER(outIsEnabled),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(aruid),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(id)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE_END
    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_END

    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD(EnableUnintendedHomeButtonInputProtection)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_CHECK_PRE(NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_APPLY_PROCESS_ID(_, CheckAppletResourceUserId(_processId, _), NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(aruid)))
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE(EnableUnintendedHomeButtonInputProtection)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(aruid),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(id),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(enabled)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE_END
    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_END

    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD(SetNpadJoyAssignmentModeSingleWithDestination)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_CHECK_PRE(NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_APPLY_PROCESS_ID(_, CheckAppletResourceUserId(_processId, _), NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(aruid)))
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE(SetNpadJoyAssignmentModeSingleWithDestination)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_OUT_MEMBER(outIsAssigned),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_OUT_MEMBER(outId),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(aruid),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(id),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(type)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE_END
    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_END

    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD(GetVibrationDeviceInfo)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE(GetVibrationDeviceInfo)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_OUT_MEMBER(outValue),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(handle)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE_END
    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_END

    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD(SendVibrationValue)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_CHECK_PRE(NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_APPLY_PROCESS_ID(_, CheckAppletResourceUserId(_processId, _), NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(aruid)))
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE(SendVibrationValue)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(aruid),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(handle),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(value)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE_END
    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_END

    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD(GetActualVibrationValue)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_CHECK_PRE(NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_APPLY_PROCESS_ID(_, CheckAppletResourceUserId(_processId, _), NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(aruid)))
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE(GetActualVibrationValue)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_OUT_MEMBER(outValue),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(aruid),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(handle)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE_END
    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_END

    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD(CreateActiveVibrationDeviceList)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_DEFINE_OUT_OBJECT((::nn::sf::SharedPointer<::nn::hid::IActiveVibrationDeviceList>), outValue)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE(CreateActiveVibrationDeviceList)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_OUT_OBJECT(outValue)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_SET_OUT_OBJECT(outValue, 0)
    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_END

    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD(PermitVibration)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE(PermitVibration)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(isPermitted)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE_END
    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_END

    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD(IsVibrationPermitted)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE(IsVibrationPermitted)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_OUT_MEMBER(outValue)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE_END
    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_END

    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD(SendVibrationValues)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_BUFFERS
                NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_BUFFER(handles)
                NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_BUFFER(values)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_BUFFERS_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE(SendVibrationValues)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(aruid),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_BUFFER(handles),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_BUFFER(values)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE_END
    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_END

    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD(SendVibrationGcErmCommand)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_CHECK_PRE(NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_APPLY_PROCESS_ID(_, CheckAppletResourceUserId(_processId, _), NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(aruid)))
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE(SendVibrationGcErmCommand)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(aruid),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(handle),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(command)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE_END
    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_END

    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD(GetActualVibrationGcErmCommand)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_CHECK_PRE(NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_APPLY_PROCESS_ID(_, CheckAppletResourceUserId(_processId, _), NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(aruid)))
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE(GetActualVibrationGcErmCommand)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_OUT_MEMBER(outValue),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(aruid),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(handle)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE_END
    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_END

    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD(BeginPermitVibrationSession)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE(BeginPermitVibrationSession)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(aruid)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE_END
    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_END

    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD(EndPermitVibrationSession)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE(EndPermitVibrationSession)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE_END
    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_END

    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD(ActivateConsoleSixAxisSensor)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_CHECK_PRE(NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_APPLY_PROCESS_ID(_, CheckAppletResourceUserId(_processId, _), NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(aruid)))
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE(ActivateConsoleSixAxisSensor)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(aruid)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE_END
    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_END

    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD(StartConsoleSixAxisSensor)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_CHECK_PRE(NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_APPLY_PROCESS_ID(_, CheckAppletResourceUserId(_processId, _), NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(aruid)))
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE(StartConsoleSixAxisSensor)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(aruid),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(handle)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE_END
    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_END

    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD(StopConsoleSixAxisSensor)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_CHECK_PRE(NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_APPLY_PROCESS_ID(_, CheckAppletResourceUserId(_processId, _), NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(aruid)))
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE(StopConsoleSixAxisSensor)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(aruid),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(handle)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE_END
    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_END

    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD(ActivateSevenSixAxisSensor)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_CHECK_PRE(NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_APPLY_PROCESS_ID(_, CheckAppletResourceUserId(_processId, _), NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(aruid)))
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE(ActivateSevenSixAxisSensor)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(aruid)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE_END
    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_END

    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD(StartSevenSixAxisSensor)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_CHECK_PRE(NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_APPLY_PROCESS_ID(_, CheckAppletResourceUserId(_processId, _), NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(aruid)))
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE(StartSevenSixAxisSensor)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(aruid)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE_END
    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_END

    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD(StopSevenSixAxisSensor)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_CHECK_PRE(NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_APPLY_PROCESS_ID(_, CheckAppletResourceUserId(_processId, _), NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(aruid)))
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE(StopSevenSixAxisSensor)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(aruid)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE_END
    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_END

    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD(InitializeSevenSixAxisSensor)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_IN_NATIVE_HANDLES
                NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_IN_NATIVE_HANDLE(stateBufferHandle)
                NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_IN_NATIVE_HANDLE(workBufferHandle)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_IN_NATIVE_HANDLES_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_CHECK_PRE(NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_APPLY_PROCESS_ID(_, CheckAppletResourceUserId(_processId, _), NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(aruid)))
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE(InitializeSevenSixAxisSensor)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(aruid),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_NATIVE_HANDLE(stateBufferHandle),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(stateBufferSize),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_NATIVE_HANDLE(workBufferHandle),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(workBufferSize)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE_END
    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_END

    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD(FinalizeSevenSixAxisSensor)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_CHECK_PRE(NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_APPLY_PROCESS_ID(_, CheckAppletResourceUserId(_processId, _), NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(aruid)))
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE(FinalizeSevenSixAxisSensor)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(aruid)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE_END
    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_END

    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD(SetSevenSixAxisSensorFusionStrength)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_CHECK_PRE(NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_APPLY_PROCESS_ID(_, CheckAppletResourceUserId(_processId, _), NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(aruid)))
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE(SetSevenSixAxisSensorFusionStrength)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(aruid),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(strength)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE_END
    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_END

    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD(GetSevenSixAxisSensorFusionStrength)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_CHECK_PRE(NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_APPLY_PROCESS_ID(_, CheckAppletResourceUserId(_processId, _), NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(aruid)))
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE(GetSevenSixAxisSensorFusionStrength)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_OUT_MEMBER(strength),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(aruid)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE_END
    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_END

    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD(IsUsbFullKeyControllerEnabled)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE(IsUsbFullKeyControllerEnabled)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_OUT_MEMBER(outIsEnabled)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE_END
    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_END

    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD(EnableUsbFullKeyController)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE(EnableUsbFullKeyController)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(enabled)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE_END
    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_END

    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD(IsUsbFullKeyControllerConnected)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE(IsUsbFullKeyControllerConnected)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_OUT_MEMBER(outIsConnected),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(id)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE_END
    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_END

    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD(HasBattery)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE(HasBattery)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_OUT_MEMBER(outHasBattery),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(id)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE_END
    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_END

    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD(HasLeftRightBattery)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE(HasLeftRightBattery)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_OUT_MEMBER(outLeftJoyHasBattery),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_OUT_MEMBER(outRightJoyHasBattery),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(id)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE_END
    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_END

    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD(GetNpadInterfaceType)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE(GetNpadInterfaceType)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_OUT_MEMBER(outInterfaceType),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(id)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE_END
    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_END

    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD(GetNpadLeftRightInterfaceType)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE(GetNpadLeftRightInterfaceType)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_OUT_MEMBER(outLeftJoyInterfaceType),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_OUT_MEMBER(outRightJoyInterfaceType),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(id)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE_END
    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_END

    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD(GetPalmaConnectionHandle)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_CHECK_PRE(NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_APPLY_PROCESS_ID(_, CheckAppletResourceUserId(_processId, _), NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(aruid)))
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE(GetPalmaConnectionHandle)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_OUT_MEMBER(outHandle),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(id),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(aruid)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE_END
    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_END

    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD(InitializePalma)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE(InitializePalma)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(handle)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE_END
    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_END

    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD(AcquirePalmaOperationCompleteEvent)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_OUT_NATIVE_HANDLES
                NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_OUT_NATIVE_HANDLE(outValue)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_OUT_NATIVE_HANDLES_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE(AcquirePalmaOperationCompleteEvent)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_OUT_NATIVE_HANDLE(outValue),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(handle)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE_END
    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_END

    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD(GetPalmaOperationInfo)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_BUFFERS
                NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_BUFFER(outBuffer)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_BUFFERS_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE(GetPalmaOperationInfo)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_OUT_MEMBER(outType),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_BUFFER(outBuffer),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(handle)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE_END
    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_END

    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD(PlayPalmaActivity)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE(PlayPalmaActivity)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(handle),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(index)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE_END
    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_END

    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD(SetPalmaFrModeType)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE(SetPalmaFrModeType)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(handle),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(type)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE_END
    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_END

    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD(ReadPalmaStep)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE(ReadPalmaStep)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(handle)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE_END
    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_END

    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD(EnablePalmaStep)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE(EnablePalmaStep)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(handle),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(isEnabled)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE_END
    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_END

    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD(ResetPalmaStep)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE(ResetPalmaStep)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(handle)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE_END
    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_END

    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD(ReadPalmaApplicationSection)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE(ReadPalmaApplicationSection)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(handle),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(address),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(size)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE_END
    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_END

    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD(WritePalmaApplicationSection)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_BUFFERS
                NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_BUFFER(buffer)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_BUFFERS_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE(WritePalmaApplicationSection)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(handle),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(address),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(size),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_BUFFER(buffer)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE_END
    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_END

    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD(ReadPalmaUniqueCode)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE(ReadPalmaUniqueCode)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(handle)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE_END
    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_END

    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD(SetPalmaUniqueCodeInvalid)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE(SetPalmaUniqueCodeInvalid)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(handle)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE_END
    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_END

    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD(WritePalmaActivityEntry)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE(WritePalmaActivityEntry)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(handle),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(index),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(ledIndex),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(waveSet),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(waveIndex)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE_END
    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_END

    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD(WritePalmaRgbLedPatternEntry)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_BUFFERS
                NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_BUFFER(pInBuffer)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_BUFFERS_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE(WritePalmaRgbLedPatternEntry)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(handle),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(index),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_BUFFER(pInBuffer)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE_END
    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_END

    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD(WritePalmaWaveEntry)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_IN_NATIVE_HANDLES
                NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_IN_NATIVE_HANDLE(transferMemoryHandle)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_IN_NATIVE_HANDLES_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE(WritePalmaWaveEntry)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(handle),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(waveSet),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(index),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_NATIVE_HANDLE(transferMemoryHandle),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(transferMemorySize),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(waveDataSize)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE_END
    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_END

    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD(SetPalmaDataBaseIdentificationVersion)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE(SetPalmaDataBaseIdentificationVersion)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(handle),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(version)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE_END
    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_END

    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD(GetPalmaDataBaseIdentificationVersion)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE(GetPalmaDataBaseIdentificationVersion)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(handle)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE_END
    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_END

    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD(SuspendPalmaFeature)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE(SuspendPalmaFeature)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(handle),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(suspendFeatureSet)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE_END
    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_END

    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD(GetPalmaOperationResult)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE(GetPalmaOperationResult)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(handle)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE_END
    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_END

    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD(ReadPalmaPlayLog)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE(ReadPalmaPlayLog)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(handle),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(index)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE_END
    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_END

    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD(ResetPalmaPlayLog)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE(ResetPalmaPlayLog)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(handle),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(index)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE_END
    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_END

    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD(SetIsPalmaAllConnectable)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_CHECK_PRE(NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_APPLY_PROCESS_ID(_, CheckAppletResourceUserId(_processId, _), NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(aruid)))
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE(SetIsPalmaAllConnectable)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(aruid),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(connectable)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE_END
    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_END

    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD(SetIsPalmaPairedConnectable)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_CHECK_PRE(NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_APPLY_PROCESS_ID(_, CheckAppletResourceUserId(_processId, _), NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(aruid)))
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE(SetIsPalmaPairedConnectable)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(aruid),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(connectable)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE_END
    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_END

    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD(PairPalma)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE(PairPalma)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(handle)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE_END
    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_END

    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD(SetPalmaBoostMode)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE(SetPalmaBoostMode)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(enabled)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE_END
    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_END

    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD(SetNpadCommunicationMode)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_CHECK_PRE(NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_APPLY_PROCESS_ID(_, CheckAppletResourceUserId(_processId, _), NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(aruid)))
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE(SetNpadCommunicationMode)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(aruid),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(mode)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE_END
    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_END

    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD(GetNpadCommunicationMode)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE(GetNpadCommunicationMode)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_OUT_MEMBER(outValue)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE_END
    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_END

    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE_CASE(CreateAppletResource)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE_CASE(ActivateDebugPad)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE_CASE(ActivateTouchScreen)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE_CASE(ActivateMouse)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE_CASE(ActivateKeyboard)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE_CASE(AcquireXpadIdEventHandle)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE_CASE(ReleaseXpadIdEventHandle)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE_CASE(ActivateXpad)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE_CASE(GetXpadIds)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE_CASE(ActivateJoyXpad)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE_CASE(GetJoyXpadLifoHandle)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE_CASE(GetJoyXpadIds)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE_CASE(ActivateSixAxisSensor)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE_CASE(DeactivateSixAxisSensor)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE_CASE(GetSixAxisSensorLifoHandle)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE_CASE(ActivateJoySixAxisSensor)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE_CASE(DeactivateJoySixAxisSensor)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE_CASE(GetJoySixAxisSensorLifoHandle)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE_CASE(StartSixAxisSensor)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE_CASE(StopSixAxisSensor)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE_CASE(IsSixAxisSensorFusionEnabled)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE_CASE(EnableSixAxisSensorFusion)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE_CASE(SetSixAxisSensorFusionParameters)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE_CASE(GetSixAxisSensorFusionParameters)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE_CASE(ResetSixAxisSensorFusionParameters)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE_CASE(SetAccelerometerParameters)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE_CASE(GetAccelerometerParameters)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE_CASE(ResetAccelerometerParameters)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE_CASE(SetAccelerometerPlayMode)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE_CASE(GetAccelerometerPlayMode)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE_CASE(ResetAccelerometerPlayMode)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE_CASE(SetGyroscopeZeroDriftMode)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE_CASE(GetGyroscopeZeroDriftMode)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE_CASE(ResetGyroscopeZeroDriftMode)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE_CASE(IsSixAxisSensorAtRest)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE_CASE(ActivateGesture)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE_CASE(SetSupportedNpadStyleSet)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE_CASE(GetSupportedNpadStyleSet)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE_CASE(SetSupportedNpadIdType)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE_CASE(ActivateNpad)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE_CASE(DeactivateNpad)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE_CASE(AcquireNpadStyleSetUpdateEventHandle)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE_CASE(DisconnectNpad)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE_CASE(GetPlayerLedPattern)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE_CASE(ActivateNpadWithRevision)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE_CASE(SetNpadJoyHoldType)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE_CASE(GetNpadJoyHoldType)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE_CASE(SetNpadJoyAssignmentModeSingleByDefault)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE_CASE(SetNpadJoyAssignmentModeSingle)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE_CASE(SetNpadJoyAssignmentModeDual)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE_CASE(MergeSingleJoyAsDualJoy)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE_CASE(StartLrAssignmentMode)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE_CASE(StopLrAssignmentMode)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE_CASE(SetNpadHandheldActivationMode)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE_CASE(GetNpadHandheldActivationMode)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE_CASE(SwapNpadAssignment)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE_CASE(IsUnintendedHomeButtonInputProtectionEnabled)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE_CASE(EnableUnintendedHomeButtonInputProtection)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE_CASE(SetNpadJoyAssignmentModeSingleWithDestination)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE_CASE(GetVibrationDeviceInfo)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE_CASE(SendVibrationValue)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE_CASE(GetActualVibrationValue)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE_CASE(CreateActiveVibrationDeviceList)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE_CASE(PermitVibration)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE_CASE(IsVibrationPermitted)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE_CASE(SendVibrationValues)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE_CASE(SendVibrationGcErmCommand)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE_CASE(GetActualVibrationGcErmCommand)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE_CASE(BeginPermitVibrationSession)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE_CASE(EndPermitVibrationSession)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE_CASE(ActivateConsoleSixAxisSensor)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE_CASE(StartConsoleSixAxisSensor)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE_CASE(StopConsoleSixAxisSensor)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE_CASE(ActivateSevenSixAxisSensor)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE_CASE(StartSevenSixAxisSensor)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE_CASE(StopSevenSixAxisSensor)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE_CASE(InitializeSevenSixAxisSensor)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE_CASE(FinalizeSevenSixAxisSensor)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE_CASE(SetSevenSixAxisSensorFusionStrength)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE_CASE(GetSevenSixAxisSensorFusionStrength)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE_CASE(IsUsbFullKeyControllerEnabled)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE_CASE(EnableUsbFullKeyController)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE_CASE(IsUsbFullKeyControllerConnected)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE_CASE(HasBattery)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE_CASE(HasLeftRightBattery)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE_CASE(GetNpadInterfaceType)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE_CASE(GetNpadLeftRightInterfaceType)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE_CASE(GetPalmaConnectionHandle)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE_CASE(InitializePalma)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE_CASE(AcquirePalmaOperationCompleteEvent)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE_CASE(GetPalmaOperationInfo)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE_CASE(PlayPalmaActivity)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE_CASE(SetPalmaFrModeType)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE_CASE(ReadPalmaStep)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE_CASE(EnablePalmaStep)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE_CASE(ResetPalmaStep)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE_CASE(ReadPalmaApplicationSection)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE_CASE(WritePalmaApplicationSection)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE_CASE(ReadPalmaUniqueCode)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE_CASE(SetPalmaUniqueCodeInvalid)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE_CASE(WritePalmaActivityEntry)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE_CASE(WritePalmaRgbLedPatternEntry)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE_CASE(WritePalmaWaveEntry)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE_CASE(SetPalmaDataBaseIdentificationVersion)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE_CASE(GetPalmaDataBaseIdentificationVersion)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE_CASE(SuspendPalmaFeature)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE_CASE(GetPalmaOperationResult)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE_CASE(ReadPalmaPlayLog)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE_CASE(ResetPalmaPlayLog)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE_CASE(SetIsPalmaAllConnectable)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE_CASE(SetIsPalmaPairedConnectable)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE_CASE(PairPalma)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE_CASE(SetPalmaBoostMode)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE_CASE(SetNpadCommunicationMode)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE_CASE(GetNpadCommunicationMode)
    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE_END

NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCHER_END

NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCHER_FUNCTION_TABLE((::nn::hid::IHidServer))
