﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

/**
    @file
    @brief      hid モジュール用の、ログを出力する API の宣言です。
*/

#include <nn/nn_Common.h>
#include <nn/diag/detail/diag_DetailStructuredSdkLog.h>

#define NN_DETAIL_HID_TRACE(...)                    NN_DETAIL_STRUCTURED_SDK_LOG(hid, Trace, 0, ##__VA_ARGS__)
#define NN_DETAIL_HID_TRACE_V1(...)                 NN_DETAIL_STRUCTURED_SDK_LOG(hid, Trace, 1, ##__VA_ARGS__)
#define NN_DETAIL_HID_TRACE_V2(...)                 NN_DETAIL_STRUCTURED_SDK_LOG(hid, Trace, 2, ##__VA_ARGS__)
#define NN_DETAIL_HID_TRACE_V3(...)                 NN_DETAIL_STRUCTURED_SDK_LOG(hid, Trace, 3, ##__VA_ARGS__)

#define NN_DETAIL_HID_INFO(...)                     NN_DETAIL_STRUCTURED_SDK_LOG(hid, Info, 0, ##__VA_ARGS__)
#define NN_DETAIL_HID_INFO_V1(...)                  NN_DETAIL_STRUCTURED_SDK_LOG(hid, Info, 1, ##__VA_ARGS__)
#define NN_DETAIL_HID_INFO_V2(...)                  NN_DETAIL_STRUCTURED_SDK_LOG(hid, Info, 2, ##__VA_ARGS__)
#define NN_DETAIL_HID_INFO_V3(...)                  NN_DETAIL_STRUCTURED_SDK_LOG(hid, Info, 3, ##__VA_ARGS__)

#define NN_DETAIL_HID_WARN(...)                     NN_DETAIL_STRUCTURED_SDK_LOG(hid, Warn, 0, ##__VA_ARGS__)
#define NN_DETAIL_HID_WARN_V1(...)                  NN_DETAIL_STRUCTURED_SDK_LOG(hid, Warn, 1, ##__VA_ARGS__)
#define NN_DETAIL_HID_WARN_V2(...)                  NN_DETAIL_STRUCTURED_SDK_LOG(hid, Warn, 2, ##__VA_ARGS__)
#define NN_DETAIL_HID_WARN_V3(...)                  NN_DETAIL_STRUCTURED_SDK_LOG(hid, Warn, 3, ##__VA_ARGS__)

#define NN_DETAIL_HID_ERROR(...)                    NN_DETAIL_STRUCTURED_SDK_LOG(hid, Error, 0, ##__VA_ARGS__)
#define NN_DETAIL_HID_ERROR_V1(...)                 NN_DETAIL_STRUCTURED_SDK_LOG(hid, Error, 1, ##__VA_ARGS__)
#define NN_DETAIL_HID_ERROR_V2(...)                 NN_DETAIL_STRUCTURED_SDK_LOG(hid, Error, 2, ##__VA_ARGS__)
#define NN_DETAIL_HID_ERROR_V3(...)                 NN_DETAIL_STRUCTURED_SDK_LOG(hid, Error, 3, ##__VA_ARGS__)

#define NN_DETAIL_HID_FATAL(...)                    NN_DETAIL_STRUCTURED_SDK_LOG(hid, Fatal, 0, ##__VA_ARGS__)
#define NN_DETAIL_HID_FATAL_V1(...)                 NN_DETAIL_STRUCTURED_SDK_LOG(hid, Fatal, 1, ##__VA_ARGS__)
#define NN_DETAIL_HID_FATAL_V2(...)                 NN_DETAIL_STRUCTURED_SDK_LOG(hid, Fatal, 2, ##__VA_ARGS__)
#define NN_DETAIL_HID_FATAL_V3(...)                 NN_DETAIL_STRUCTURED_SDK_LOG(hid, Fatal, 3, ##__VA_ARGS__)

#define NN_DETAIL_HID_VTRACE(format, args)          NN_DETAIL_STRUCTURED_SDK_VLOG(hid, Trace, 0, format, args)
#define NN_DETAIL_HID_VTRACE_V1(format, args)       NN_DETAIL_STRUCTURED_SDK_VLOG(hid, Trace, 1, format, args)
#define NN_DETAIL_HID_VTRACE_V2(format, args)       NN_DETAIL_STRUCTURED_SDK_VLOG(hid, Trace, 2, format, args)
#define NN_DETAIL_HID_VTRACE_V3(format, args)       NN_DETAIL_STRUCTURED_SDK_VLOG(hid, Trace, 3, format, args)

#define NN_DETAIL_HID_VINFO(format, args)           NN_DETAIL_STRUCTURED_SDK_VLOG(hid, Info, 0, format, args)
#define NN_DETAIL_HID_VINFO_V1(format, args)        NN_DETAIL_STRUCTURED_SDK_VLOG(hid, Info, 1, format, args)
#define NN_DETAIL_HID_VINFO_V2(format, args)        NN_DETAIL_STRUCTURED_SDK_VLOG(hid, Info, 2, format, args)
#define NN_DETAIL_HID_VINFO_V3(format, args)        NN_DETAIL_STRUCTURED_SDK_VLOG(hid, Info, 3, format, args)

#define NN_DETAIL_HID_VWARN(format, args)           NN_DETAIL_STRUCTURED_SDK_VLOG(hid, Warn, 0, format, args)
#define NN_DETAIL_HID_VWARN_V1(format, args)        NN_DETAIL_STRUCTURED_SDK_VLOG(hid, Warn, 1, format, args)
#define NN_DETAIL_HID_VWARN_V2(format, args)        NN_DETAIL_STRUCTURED_SDK_VLOG(hid, Warn, 2, format, args)
#define NN_DETAIL_HID_VWARN_V3(format, args)        NN_DETAIL_STRUCTURED_SDK_VLOG(hid, Warn, 3, format, args)

#define NN_DETAIL_HID_VERROR(format, args)          NN_DETAIL_STRUCTURED_SDK_VLOG(hid, Error, 0, format, args)
#define NN_DETAIL_HID_VERROR_V1(format, args)       NN_DETAIL_STRUCTURED_SDK_VLOG(hid, Error, 1, format, args)
#define NN_DETAIL_HID_VERROR_V2(format, args)       NN_DETAIL_STRUCTURED_SDK_VLOG(hid, Error, 2, format, args)
#define NN_DETAIL_HID_VERROR_V3(format, args)       NN_DETAIL_STRUCTURED_SDK_VLOG(hid, Error, 3, format, args)

#define NN_DETAIL_HID_VFATAL(format, args)          NN_DETAIL_STRUCTURED_SDK_VLOG(hid, Fatal, 0, format, args)
#define NN_DETAIL_HID_VFATAL_V1(format, args)       NN_DETAIL_STRUCTURED_SDK_VLOG(hid, Fatal, 1, format, args)
#define NN_DETAIL_HID_VFATAL_V2(format, args)       NN_DETAIL_STRUCTURED_SDK_VLOG(hid, Fatal, 2, format, args)
#define NN_DETAIL_HID_VFATAL_V3(format, args)       NN_DETAIL_STRUCTURED_SDK_VLOG(hid, Fatal, 3, format, args)

#define NN_DETAIL_HID_PUT_TRACE(text, length)       NN_DETAIL_STRUCTURED_SDK_PUT(hid, Trace, 0, text, length)
#define NN_DETAIL_HID_PUT_TRACE_V1(text, length)    NN_DETAIL_STRUCTURED_SDK_PUT(hid, Trace, 1, text, length)
#define NN_DETAIL_HID_PUT_TRACE_V2(text, length)    NN_DETAIL_STRUCTURED_SDK_PUT(hid, Trace, 2, text, length)
#define NN_DETAIL_HID_PUT_TRACE_V3(text, length)    NN_DETAIL_STRUCTURED_SDK_PUT(hid, Trace, 3, text, length)

#define NN_DETAIL_HID_PUT_INFO(text, length)        NN_DETAIL_STRUCTURED_SDK_PUT(hid, Info, 0, text, length)
#define NN_DETAIL_HID_PUT_INFO_V1(text, length)     NN_DETAIL_STRUCTURED_SDK_PUT(hid, Info, 1, text, length)
#define NN_DETAIL_HID_PUT_INFO_V2(text, length)     NN_DETAIL_STRUCTURED_SDK_PUT(hid, Info, 2, text, length)
#define NN_DETAIL_HID_PUT_INFO_V3(text, length)     NN_DETAIL_STRUCTURED_SDK_PUT(hid, Info, 3, text, length)

#define NN_DETAIL_HID_PUT_WARN(text, length)        NN_DETAIL_STRUCTURED_SDK_PUT(hid, Warn, 0, text, length)
#define NN_DETAIL_HID_PUT_WARN_V1(text, length)     NN_DETAIL_STRUCTURED_SDK_PUT(hid, Warn, 1, text, length)
#define NN_DETAIL_HID_PUT_WARN_V2(text, length)     NN_DETAIL_STRUCTURED_SDK_PUT(hid, Warn, 2, text, length)
#define NN_DETAIL_HID_PUT_WARN_V3(text, length)     NN_DETAIL_STRUCTURED_SDK_PUT(hid, Warn, 3, text, length)

#define NN_DETAIL_HID_PUT_ERROR(text, length)       NN_DETAIL_STRUCTURED_SDK_PUT(hid, Error, 0, text, length)
#define NN_DETAIL_HID_PUT_ERROR_V1(text, length)    NN_DETAIL_STRUCTURED_SDK_PUT(hid, Error, 1, text, length)
#define NN_DETAIL_HID_PUT_ERROR_V2(text, length)    NN_DETAIL_STRUCTURED_SDK_PUT(hid, Error, 2, text, length)
#define NN_DETAIL_HID_PUT_ERROR_V3(text, length)    NN_DETAIL_STRUCTURED_SDK_PUT(hid, Error, 3, text, length)

#define NN_DETAIL_HID_PUT_FATAL(text, length)       NN_DETAIL_STRUCTURED_SDK_PUT(hid, Fatal, 0, text, length)
#define NN_DETAIL_HID_PUT_FATAL_V1(text, length)    NN_DETAIL_STRUCTURED_SDK_PUT(hid, Fatal, 1, text, length)
#define NN_DETAIL_HID_PUT_FATAL_V2(text, length)    NN_DETAIL_STRUCTURED_SDK_PUT(hid, Fatal, 2, text, length)
#define NN_DETAIL_HID_PUT_FATAL_V3(text, length)    NN_DETAIL_STRUCTURED_SDK_PUT(hid, Fatal, 3, text, length)
