﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

/**
 * @file
 * @brief       スリープボタンのデバッグ機能に関する API の宣言
 */

#pragma once

#include <nn/nn_Macro.h>
#include <nn/hid/system/hid_SleepButton.h>

namespace nn { namespace hid { namespace debug {

/**
 * @brief       スリープボタンの自動操作状態を表す構造体です。
 */
struct SleepButtonAutoPilotState
{
    ::nn::hid::system::SleepButtonSet buttons;  //!< スリープボタンのデジタルボタンの状態です。
};

/**
 * @brief       スリープボタンをファイナライズします。
 *
 * @details     事前に nn::hid::system::InitializeSleepButton() を呼び出した
 *              回数と同じだけ呼びだされた際にホームボタンが初期化状態を
 *              解除します。
 *
 * @pre
 *              - スリープボタンが初期化状態にある
 */
void FinalizeSleepButton() NN_NOEXCEPT;

/**
 * @brief       スリープボタンに自動操作状態を設定します。
 *
 * @param[in]   value                       スリープボタンの自動操作状態
 *
 * @pre
 *              - スリープボタンが初期化状態にある
 */
void SetSleepButtonAutoPilotState(const SleepButtonAutoPilotState& value
                                 ) NN_NOEXCEPT;

/**
 * @brief       スリープボタンの自動操作状態を解除します。
 *
 * @pre
 *              - スリープボタンが初期化状態にある
 */
void UnsetSleepButtonAutoPilotState() NN_NOEXCEPT;

}}} // namespace nn::hid::debug
