﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

/**
 * @file
 * @brief       Keyboard のデバッグ機能に関する API の宣言
 */

#pragma once

#include <nn/nn_Macro.h>
#include <nn/hid/hid_Keyboard.h>
#include <nn/hid/hid_KeyboardKey.h>

namespace nn { namespace hid { namespace debug {

/**
 * @brief       Keyboard の自動操作状態を表す構造体です。
 */
struct KeyboardAutoPilotState
{
    KeyboardModifierSet modifiers;      //!< Keyboard の修飾情報です。
    KeyboardAttributeSet attributes;    //!< Keyboard の入力状態の属性です。
    KeyboardKeySet keys;                //!< Keyboard のキーの状態です。
};

/**
 * @brief       Keyboard をファイナライズします。
 *
 * @details     事前に nn::hid::InitializeKeyboard() を呼び出した回数と同じだけ
 *              呼びだされた際に Keyboard の初期化状態を解除します。
 *
 * @pre
 *              - Keyboard が初期化状態にある
 */
void FinalizeKeyboard() NN_NOEXCEPT;

/**
 * @brief       Keyboard に自動操作状態を設定します。
 *
 * @param[in]   value                       Keyboard の自動操作状態
 *
 * @pre
 *              - Keyboard が初期化状態にある
 */
void SetKeyboardAutoPilotState(const KeyboardAutoPilotState& value) NN_NOEXCEPT;

/**
 * @brief       Keyboard の自動操作状態を解除します。
 *
 * @pre
 *              - Keyboard が初期化状態にある
 */
void UnsetKeyboardAutoPilotState() NN_NOEXCEPT;

}}} // namespace nn::hid::debug
