﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

/**
 * @file
 * @brief       入力変化の検知処理のデバッグ機能に関する API の宣言
 */

#pragma once

#include <nn/nn_Macro.h>
#include <nn/hid/system/hid_InputDetection.h>

namespace nn { namespace hid { namespace debug {

/**
 * @brief       InputDetector をファイナライズします。
 *
 * @details     事前に nn::hid::system::InitializeInputDetector() を呼び出した
 *              回数と同じだけ呼びだされた際に InputDetector が初期化状態を
 *              解除します。
 *
 * @pre
 *              - InputDetector が初期化状態にある
 */
void FinalizeInputDetector() NN_NOEXCEPT;

}}} // namespace nn::hid::debug
