﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

/**
 * @file
 * @brief       Npad のデバッグ機能に関する API の宣言
 */

#pragma once

#include <nn/nn_Common.h>
#include <nn/nn_Macro.h>
#include <nn/hid/system/hid_UniquePad.h>
#include <nn/util/util_MathTypes.h>

namespace nn { namespace hid { namespace debug {

/**
 * @brief       コントローラーの色を更新します
 *
 */
Result UpdateControllerColor(const nn::util::Color4u8Type& mainColor,
                           const nn::util::Color4u8Type& subColor,
                           const system::UniquePadId& id) NN_NOEXCEPT;

/**
 * @brief       コントローラーのデザイン情報を更新します
 *
 */
Result UpdateDesignInfo(const nn::util::Color4u8Type& mainColor,
                      const nn::util::Color4u8Type& subColor,
                      const nn::util::Color4u8Type& thirdColor,
                      const nn::util::Color4u8Type& forthColor,
                      uint8_t variation,
                      const system::UniquePadId& id) NN_NOEXCEPT;

}}} // namespace nn::hid::debug
