﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include <nn/nn_Common.h>
#include <nn/nn_Macro.h>
#include <nn/os/os_SystemEvent.h>
#include <nn/os/os_TransferMemory.h>

namespace nn { namespace grc { namespace server {

#define NN_GRC_LOG(...) NN_SDK_LOG("[grc]" __VA_ARGS__)

// エラーログ
#define NN_GRC_LOG_ERR(...) NN_SDK_LOG("[grc][ERROR]" __VA_ARGS__)
// 警告ログ
#define NN_GRC_LOG_WARN(...) NN_SDK_LOG("[grc][WARNING]" __VA_ARGS__)
// 実行ログ
#define NN_GRC_LOG_INFO(...) NN_SDK_LOG("[grc]" __VA_ARGS__)

}}} // namespace nn::gamecast::server
