﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include <nn/nn_Common.h>
#include <nn/nn_Result.h>
#include <nn/os.h>
#include <nn/vi/vi_Types.h>
#include <nn/sf/sf_ISharedObject.h>
#include <nn/sf/sf_Buffers.h>
#include <nn/grc/grc_CommonTypes.h>
#include <nn/album/album_ImageSize.h>

namespace nn{ namespace grcsrv{
    class IMovieMaker;
}}

namespace nn{ namespace grc{

    class MovieLayer;
    typedef OffscreenRecordingParameter MovieMakerMovieParameter;

    namespace dev{
        nn::Result InitializeMovieMakerProxy(nn::sf::SharedPointer<nn::grcsrv::IMovieMaker>&& pProxy) NN_NOEXCEPT;
        void FinalizeMovieMakerProxy() NN_NOEXCEPT;

        nn::Result InitializeMovieVideoProxy() NN_NOEXCEPT;
        void FinalizeMovieVideoProxy() NN_NOEXCEPT;
    }

    nn::Result InitializeForApplication(nn::sf::SharedPointer<nn::grcsrv::IMovieMaker>&& pMovieMakerProxy) NN_NOEXCEPT;
    void FinalizeForApplication() NN_NOEXCEPT;

    namespace dev{
        nn::Result OpenOffscreenLayer(int32_t* pOutProducerHandle, uint64_t layerHandle) NN_NOEXCEPT;
        void CloseOffscreenLayer(uint64_t layerHandle) NN_NOEXCEPT;

        nn::Result RegisterOffscreenLayer(uint64_t layerHandle, int32_t producerHandle, int width, int height) NN_NOEXCEPT;
        void UnregisterOffscreenLayer(uint64_t layerHandle) NN_NOEXCEPT;

        void CloseAllMovieLayers() NN_NOEXCEPT;
    }

    nn::Result OpenMovieLayer(MovieLayer** pOutLayer, uint64_t layerHandle, int width, int height) NN_NOEXCEPT;
    void CloseMovieLayer(MovieLayer* pLayer) NN_NOEXCEPT;

    nn::Result GetVideoNativeWindow(nn::vi::NativeWindowHandle* pOutNativeWindow, MovieLayer* pLayer) NN_NOEXCEPT;

    nn::Result StartMovieFile(MovieLayer* pLayer, const MovieMakerMovieParameter& param) NN_NOEXCEPT;
    nn::Result AbortMovieFile(MovieLayer* pLayer) NN_NOEXCEPT;

    nn::Result RequestFinishMovieFile(MovieLayer* pLayer) NN_NOEXCEPT;
    nn::Result CompleteFinishMovieFile(MovieLayer* pLayer, const sf::InBuffer& userData, const sf::InBuffer& thumbnailImage, album::ImageSize imageSize) NN_NOEXCEPT;

    nn::Result CheckMovieFileError(MovieLayer* pLayer) NN_NOEXCEPT;

    nn::Result EncodeMovieAudioSample(size_t* pOutEncodedSize, MovieLayer* pLayer, const void* buffer, size_t size) NN_NOEXCEPT;

    nn::Result InitializeFinishMovieFileReadyEvent(nn::os::SystemEventType* pEvent, MovieLayer* pLayer) NN_NOEXCEPT;
    void FinalizeFinishMovieFileReadyEvent(nn::os::SystemEventType* pEvent, MovieLayer* pLayer) NN_NOEXCEPT;

    nn::Result InitializeMovieAudioEncodeReadyEvent(nn::os::SystemEventType* pEvent, MovieLayer* pLayer) NN_NOEXCEPT;
    void FinalizeMovieAudioEncodeReadyEvent(nn::os::SystemEventType* pEvent, MovieLayer* pLayer) NN_NOEXCEPT;

}}
