﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

// NOLINT(build/header_guard)

#include <istream>
#include <algorithm>
#include <string>

#if defined( NN_GFXTOOL_DEFINE_ENUM_BEGIN )
    #undef NN_GFXTOOL_DEFINE_ENUM_BEGIN
#endif
#if defined( NN_GFXTOOL_DEFINE_ENUM_CLASS_BEGIN )
    #undef NN_GFXTOOL_DEFINE_ENUM_CLASS_BEGIN
#endif

#if defined( NN_GFXTOOL_DEFINE_ENUM )
    #undef NN_GFXTOOL_DEFINE_ENUM
#endif

#if defined( NN_GFXTOOL_DEFINE_ENUM_END )
    #undef NN_GFXTOOL_DEFINE_ENUM_END
#endif
#if defined( NN_GFXTOOL_DEFINE_ENUM_CLASS_END )
    #undef NN_GFXTOOL_DEFINE_ENUM_CLASS_END
#endif

#if defined( NN_GFXTOOL_DEFINE_ENUM_AS_STRING )
    #define NN_GFXTOOL_DEFINE_ENUM_BEGIN( x ) static const char* const s_ ## x ## Table[] = {
    #define NN_GFXTOOL_DEFINE_ENUM_CLASS_BEGIN( x ) NN_GFXTOOL_DEFINE_ENUM_BEGIN( x )
    #define NN_GFXTOOL_DEFINE_ENUM( x ) #x ,
    #define NN_GFXTOOL_DEFINE_ENUM_END( x ) }; \
        const char* x ## ToString( x value ) { return s_ ## x ## Table [ static_cast< int >( value ) ]; } \
        x StringTo ## x( const char* pValue ) {\
        auto found = std::find_if( s_ ## x ## Table, s_ ## x ## Table + sizeof( s_ ## x ## Table ) / \
            sizeof( *( s_ ## x ## Table ) ), [ pValue ]( const char* const pString ) { \
            return pString && nn::gfxTool::CaseInsensiveEquals( pValue, pString ); } ); \
            if( found == s_ ## x ## Table + sizeof( s_ ## x ## Table ) / sizeof( *( s_ ## x ## Table ) ) ) \
            { \
                std::string message( "Invalid Argument: " ); \
                message.append( pValue ).append( "\n" ); \
                throw std::exception( message.c_str() ); \
            } \
            return static_cast< x >( std::distance( s_ ## x ## Table, found ) ); \
        } \
        std::istream& operator >>( std::istream& is, x& value ) { \
            std::string str; \
            is >> str; \
            value = StringTo ## x ( str.data() ); \
            return is; \
        }
#else
    #define NN_GFXTOOL_DEFINE_ENUM_BEGIN( x ) enum x {
    #define NN_GFXTOOL_DEFINE_ENUM_CLASS_BEGIN( x ) enum class x {
    #define NN_GFXTOOL_DEFINE_ENUM( x ) x ,
    #define NN_GFXTOOL_DEFINE_ENUM_END( x ) }; \
        const char* x ## ToString ( x ); \
        x StringTo ## x ( const char* pValue ); \
        std::istream& operator >>( std::istream&, x& );
#endif

#define NN_GFXTOOL_DEFINE_ENUM_CLASS_END( x ) NN_GFXTOOL_DEFINE_ENUM_END( x )

namespace nn {
namespace gfxTool {
bool CaseInsensiveEquals( const char*, const char* );
}
}
