﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

/**
* @file
* @brief 型に関する定義（VK1 特殊版）
*/

#pragma once

#include <nn/gfx/gfx_Common.h>
#include <nn/gfx/gfx_Variation-api.vk.h>
#include <nn/gfx/gfx_Device.h>

#include <nn/gfx/detail/gfx_Declare.h>
#include <nn/gfx/detail/gfx_Core-api.vk.1.h>
#include <nn/gfx/detail/gfx_Texture-api.vk.1.h>
#include <nn/gfx/detail/gfx_Device-api.vk.1.h>
#include <nn/gfx/detail/gfx_BufferLayout-api.vk.1.h>

NN_PRAGMA_PUSH_WARNINGS
NN_DISABLE_WARNING_DEPRECATED_DECLARATIONS

namespace nn {
namespace gfx {

/**
* @brief バッファーを表す型定義です（VK1 特殊版）
*/
typedef TBuffer< ApiVariationVk1 >
    NN_MACRO_CONCATENATE( Buffer, NN_MACRO_CONCATENATE( NN_GFX_VK_SUFFIX, 1 ) );

/**
* @brief バッファーテクスチャービューを表す型定義です（VK1 特殊版）
*/
typedef TBufferTextureView< ApiVariationVk1 >
    NN_MACRO_CONCATENATE( BufferTextureView, NN_MACRO_CONCATENATE( NN_GFX_VK_SUFFIX, 1 ) );

/**
* @brief コマンドバッファーを表す型定義です（VK1 特殊版）
*/
typedef TCommandBuffer< ApiVariationVk1 >
    NN_MACRO_CONCATENATE( CommandBuffer, NN_MACRO_CONCATENATE( NN_GFX_VK_SUFFIX, 1 ) );

/**
* @brief デスクリプタープールを表す型定義です（VK1 特殊版）
*/
typedef TDescriptorPool< ApiVariationVk1 >
    NN_MACRO_CONCATENATE( DescriptorPool, NN_MACRO_CONCATENATE( NN_GFX_VK_SUFFIX, 1 ) );

/**
* @brief デバイスを表す型定義です（VK1 特殊版）
*/
typedef TDevice< ApiVariationVk1 >
    NN_MACRO_CONCATENATE( Device, NN_MACRO_CONCATENATE( NN_GFX_VK_SUFFIX, 1 ) );

/**
* @brief メモリープールを表す型定義です（VK1 特殊版）
*/
typedef TMemoryPool< ApiVariationVk1 >
    NN_MACRO_CONCATENATE( MemoryPool, NN_MACRO_CONCATENATE( NN_GFX_VK_SUFFIX, 1 ) );

/**
* @brief パイプラインを表す型定義です（VK1 特殊版）
*/
typedef TPipeline< ApiVariationVk1 >
    NN_MACRO_CONCATENATE( Pipeline, NN_MACRO_CONCATENATE( NN_GFX_VK_SUFFIX, 1 ) );

/**
* @brief キューを表す型定義です（VK1 特殊版）
*/
typedef TQueue< ApiVariationVk1 >
    NN_MACRO_CONCATENATE( Queue, NN_MACRO_CONCATENATE( NN_GFX_VK_SUFFIX, 1 ) );

/**
* @brief ルートシグネチャーを表す型定義です（VK1 特殊版）
*
* @deprecated 廃止予定です。nn::gfx::CommandBuffer::SetTextureAndSampler 等のバインド API を使用してください。
*/
NN_DEPRECATED typedef TRootSignature< ApiVariationVk1 >
    NN_MACRO_CONCATENATE( RootSignature, NN_MACRO_CONCATENATE( NN_GFX_VK_SUFFIX, 1 ) );

/**
* @brief サンプラーを表す型定義です（VK1 特殊版）。
*/
typedef TSampler< ApiVariationVk1 >
    NN_MACRO_CONCATENATE( Sampler, NN_MACRO_CONCATENATE( NN_GFX_VK_SUFFIX, 1 ) );

/**
* @brief シェーダーを表す型定義です（VK1 特殊版）
*/
typedef TShader< ApiVariationVk1 >
    NN_MACRO_CONCATENATE( Shader, NN_MACRO_CONCATENATE( NN_GFX_VK_SUFFIX, 1 ) );

/**
* @brief ラスタライザーステートを表す型定義です（VK1 特殊版）
*/
typedef TRasterizerState< ApiVariationVk1 >
    NN_MACRO_CONCATENATE( RasterizerState, NN_MACRO_CONCATENATE( NN_GFX_VK_SUFFIX, 1 ) );

/**
* @brief ブレンドステートを表す型定義です（VK1 特殊版）
*/
typedef TBlendState< ApiVariationVk1 >
    NN_MACRO_CONCATENATE( BlendState, NN_MACRO_CONCATENATE( NN_GFX_VK_SUFFIX, 1 ) );

/**
* @brief 深度ステンシルステートを表す型定義です（VK1 特殊版）
*/
typedef TDepthStencilState< ApiVariationVk1 >
    NN_MACRO_CONCATENATE( DepthStencilState, NN_MACRO_CONCATENATE( NN_GFX_VK_SUFFIX, 1 ) );

/**
* @brief 頂点ステートを表す型定義です（VK1 特殊版）
*/
typedef TVertexState< ApiVariationVk1 >
    NN_MACRO_CONCATENATE( VertexState, NN_MACRO_CONCATENATE( NN_GFX_VK_SUFFIX, 1 ) );

/**
* @brief テセレーションステートを表す型定義です（VK1 特殊版）
*/
typedef TTessellationState< ApiVariationVk1 >
    NN_MACRO_CONCATENATE( TessellationState, NN_MACRO_CONCATENATE( NN_GFX_VK_SUFFIX, 1 ) );

/**
* @brief ビューポートシザーステートを表す型定義です（VK1 特殊版）
*/
typedef TViewportScissorState< ApiVariationVk1 >
    NN_MACRO_CONCATENATE( ViewportScissorState, NN_MACRO_CONCATENATE( NN_GFX_VK_SUFFIX, 1 ) );

/**
* @brief スワップチェーンを表す型定義です（VK1 特殊版）
*/
typedef TSwapChain< ApiVariationVk1 >
    NN_MACRO_CONCATENATE( SwapChain, NN_MACRO_CONCATENATE( NN_GFX_VK_SUFFIX, 1 ) );

/**
* @brief フェンスを表す型定義です（VK1 特殊版）
*/
typedef TFence< ApiVariationVk1 >
    NN_MACRO_CONCATENATE( Fence, NN_MACRO_CONCATENATE( NN_GFX_VK_SUFFIX, 1 ) );

/**
* @brief セマフォを表す型定義です（VK1 特殊版）
*/
typedef TSemaphore< ApiVariationVk1 >
    NN_MACRO_CONCATENATE( Semaphore, NN_MACRO_CONCATENATE( NN_GFX_VK_SUFFIX, 1 ) );

/**
* @brief テクスチャーを表す型定義です（VK1 特殊版）
*/
typedef TTexture< ApiVariationVk1 >
    NN_MACRO_CONCATENATE( Texture, NN_MACRO_CONCATENATE( NN_GFX_VK_SUFFIX, 1 ) );

/**
* @brief テクスチャービューを表す型定義です（VK1 特殊版）
*/
typedef TTextureView< ApiVariationVk1 >
    NN_MACRO_CONCATENATE( TextureView, NN_MACRO_CONCATENATE( NN_GFX_VK_SUFFIX, 1 ) );

/**
* @brief カラーターゲットビューを表す型定義です（VK1 特殊版）
*/
typedef TColorTargetView< ApiVariationVk1 >
    NN_MACRO_CONCATENATE( ColorTargetView, NN_MACRO_CONCATENATE( NN_GFX_VK_SUFFIX, 1 ) );

/**
* @brief 深度ステンシルビューを表す型定義です（VK1 特殊版）
*/
typedef TDepthStencilView< ApiVariationVk1 >
    NN_MACRO_CONCATENATE( DepthStencilView, NN_MACRO_CONCATENATE( NN_GFX_VK_SUFFIX, 1 ) );

/**
* @brief 相互運用を行うためのクラスの型定義です（VK1 特殊版）
*/
typedef TInteroperation< ApiVariationVk1 >
    NN_MACRO_CONCATENATE( Interoperation, NN_MACRO_CONCATENATE( NN_GFX_VK_SUFFIX, 1 ) );

/**
* @brief タイムスタンプに使われるバッファーを表す型定義です（VK1 特殊版）
*/
typedef TTimestampBuffer< ApiVariationVk1 >
    NN_MACRO_CONCATENATE( TimestampBuffer, NN_MACRO_CONCATENATE( NN_GFX_VK_SUFFIX, 1 ) );

/**
* @brief クエリーに使われるバッファーを表す型定義です（VK1 特殊版）
*/
typedef TQueryBuffer< ApiVariationVk1 >
    NN_MACRO_CONCATENATE( QueryBuffer, NN_MACRO_CONCATENATE( NN_GFX_VK_SUFFIX, 1 ) );

/**
* @brief クエリーに使われるバッファーを表す型定義です（VK1 特殊版）
*/
typedef TGraphicsPipelineStatisticsQueriesBuffer< ApiVariationVk1 >
    NN_MACRO_CONCATENATE( GraphicsPipelineStatisticsQueriesBuffer, NN_MACRO_CONCATENATE( NN_GFX_VK_SUFFIX, 1 ) );

/**
* @brief gfx ライブラリーを初期化します（VK1 特殊版）
*
* @post
* gfx ライブラリーが初期化されている。
*/
inline void NN_MACRO_CONCATENATE( Initialize, NN_MACRO_CONCATENATE(
    NN_GFX_VK_SUFFIX, 1 ) )() NN_NOEXCEPT
{
    return detail::Initialize< ApiVariationVk1 >();
}

/**
* @brief gfx ライブラリーを終了します（VK1 特殊版）
*
* @post
* gfx ライブラリーが終了されている。
*/
inline void NN_MACRO_CONCATENATE( Finalize, NN_MACRO_CONCATENATE(
    NN_GFX_VK_SUFFIX, 1 ) )() NN_NOEXCEPT
{
    return detail::Finalize< ApiVariationVk1 >();
}

/**
* @brief イメージフォーマットのプロパティーを取得します（VK1 特殊版）
*
* @param[out] pOutImageFormatProperty 取得したイメージフォーマットのプロパティーを格納する領域へのポインター
* @param[in] pDevice デバイスへのポインター
* @param[in] imageFormat 取得する対象のイメージフォーマット
*
* @pre
* - pOutImageFormatProperty != NULL
* - pDevice != NULL
* - pDevice が初期化されている
*
* @post
* - pOutImageFormatProperty の指す領域に取得されたイメージフォーマットのプロパティーが格納されている
*/
inline void GetImageFormatPropertyVk1( ImageFormatProperty* pOutImageFormatProperty,
    TDevice< ApiVariationVk1 >* pDevice, ImageFormat imageFormat ) NN_NOEXCEPT
{
    return detail::GetImageFormatProperty< ApiVariationVk1 >(
        pOutImageFormatProperty, pDevice, imageFormat );
}

/**
* @brief 2 つのタイムスタンプ値の間の時間を取得します（VK1 特殊版）
*
* @param[in] startTimestampValue 始点のタイムスタンプの値
* @param[in] endTimestampValue 終点のタイムスタンプの値
*
* @return 指定された始点と終点の間の時間を返します。
*
* @details
* タイムスタンプの値には nn::gfx::TimestampBuffer::GetValue で得られる値を使うことができます。
*/
inline nn::TimeSpan GetDurationVk1(
    int64_t startTimestampValue, int64_t endTimestampValue ) NN_NOEXCEPT
{
    return detail::GetDuration< ApiVariationVk1 >( startTimestampValue, endTimestampValue );
}

}
}

NN_PRAGMA_POP_WARNINGS
