﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

/**
* @file
* @brief 型に関する定義（GX 特殊版）
*/

#pragma once

#include <nn/gfx/gfx_Common.h>
#include <nn/gfx/gfx_Variation-api.gx.h>
#include <nn/gfx/gfx_Device.h>

#include <nn/gfx/detail/gfx_Declare.h>

#if defined( NN_GFX_CONFIG_INCLUDE_GX2 )
    #include <nn/gfx/gfx_Types-api.gx.2.h>
#endif

namespace nn {
namespace gfx {

/**
* @brief バッファを表す型定義です（GX 特殊版）
*/
typedef TBuffer< ApiTypeGx >
    NN_MACRO_CONCATENATE( Buffer, NN_GFX_GX_SUFFIX );

/**
* @brief バッファテクスチャビューを表す型定義です（GX 特殊版）
*/
typedef TBuffer< ApiTypeGx >
    NN_MACRO_CONCATENATE( BufferTextureView, NN_GFX_GX_SUFFIX );

/**
* @brief コマンドバッファを表す型定義です（GX 特殊版）
*/
typedef TCommandBuffer< ApiTypeGx >
    NN_MACRO_CONCATENATE( CommandBuffer, NN_GFX_GX_SUFFIX );

/**
* @brief デスクリプタプールを表す型定義です（GX 特殊版）
*/
typedef TDescriptorPool< ApiTypeGx >
    NN_MACRO_CONCATENATE( DescriptorPool, NN_GFX_GX_SUFFIX );

/**
* @brief デバイスを表す型定義です（GX 特殊版）
*/
typedef TDevice< ApiTypeGx >
    NN_MACRO_CONCATENATE( Device, NN_GFX_GX_SUFFIX );

/**
* @brief メモリプールを表す型定義です（GX 特殊版９
*/
typedef TMemoryPool< ApiTypeGx >
    NN_MACRO_CONCATENATE( MemoryPool, NN_GFX_GX_SUFFIX );

/**
* @brief パイプラインを表す型定義です（GX 特殊版）
*/
typedef TPipeline< ApiTypeGx >
    NN_MACRO_CONCATENATE( Pipeline, NN_GFX_GX_SUFFIX );

/**
* @brief キューを表す型定義です（GX 特殊版）
*/
typedef TQueue< ApiTypeGx >
    NN_MACRO_CONCATENATE( Queue, NN_GFX_GX_SUFFIX );

/**
* @brief ルートシグネチャを表す型定義です（GX 特殊版）
*/
typedef TRootSignature< ApiTypeGx >
    NN_MACRO_CONCATENATE( RootSignature, NN_GFX_GX_SUFFIX );

/**
* @brief サンプラを表す型定義です（GX 特殊版）。
*/
typedef TSampler< ApiTypeGx >
    NN_MACRO_CONCATENATE( Sampler, NN_GFX_GX_SUFFIX );

/**
* @brief シェーダを表す型定義です（GX 特殊版）
*/
typedef TShader< ApiTypeGx >
    NN_MACRO_CONCATENATE( Shader, NN_GFX_GX_SUFFIX );

/**
* @brief ラスタライザステートを表す型定義です（GX 特殊版）
*/
typedef TRasterizerState< ApiTypeGx >
    NN_MACRO_CONCATENATE( RasterizerState, NN_GFX_GX_SUFFIX );

/**
* @brief ブレンドステートを表す型定義です（GX 特殊版）
*/
typedef TBlendState< ApiTypeGx >
    NN_MACRO_CONCATENATE( BlendState, NN_GFX_GX_SUFFIX );

/**
* @brief 深度ステンシルステートを表す型定義です（GX 特殊版）
*/
typedef TDepthStencilState< ApiTypeGx >
    NN_MACRO_CONCATENATE( DepthStencilState, NN_GFX_GX_SUFFIX );

/**
* @brief 頂点ステートを表す型定義です（GX 特殊版）
*/
typedef TVertexState< ApiTypeGx >
    NN_MACRO_CONCATENATE( VertexState, NN_GFX_GX_SUFFIX );

/**
* @brief テセレーションステートを表す型定義です（GX 特殊版）
*/
typedef TTessellationState< ApiTypeGx >
    NN_MACRO_CONCATENATE( TessellationState, NN_GFX_GX_SUFFIX );

/**
* @brief ビューポートシザーステートを表す型定義です（GX 特殊版）
*/
typedef TViewportScissorState< ApiTypeGx >
    NN_MACRO_CONCATENATE( ViewportScissorState, NN_GFX_GX_SUFFIX );

/**
* @brief スワップチェーンを表す型定義です（GX 特殊版）
*/
typedef TSwapChain< ApiTypeGx >
    NN_MACRO_CONCATENATE( SwapChain, NN_GFX_GX_SUFFIX );

/**
* @brief フェンスを表す型定義です（GX 特殊版）
*/
typedef TFence< ApiTypeGx >
    NN_MACRO_CONCATENATE( Fence, NN_GFX_GX_SUFFIX );

/**
* @brief セマフォを表す型定義です（GX 特殊版）
*/
typedef TSemaphore< ApiTypeGx >
    NN_MACRO_CONCATENATE( Semaphore, NN_GFX_GX_SUFFIX );

/**
* @brief テクスチャを表す型定義です（GX 特殊版）
*/
typedef TTexture< ApiTypeGx >
    NN_MACRO_CONCATENATE( Texture, NN_GFX_GX_SUFFIX );

/**
* @brief テクスチャビューを表す型定義です（GX 特殊版）
*/
typedef TTextureView< ApiTypeGx >
    NN_MACRO_CONCATENATE( TextureView, NN_GFX_GX_SUFFIX );

/**
* @brief カラーターゲットビューを表す型定義です（GX 特殊版）
*/
typedef TColorTargetView< ApiTypeGx >
    NN_MACRO_CONCATENATE( ColorTargetView, NN_GFX_GX_SUFFIX );

/**
* @brief 深度ステンシルビューを表す型定義です（GX 特殊版）
*/
typedef TDepthStencilView< ApiTypeGx >
    NN_MACRO_CONCATENATE( DepthStencilView, NN_GFX_GX_SUFFIX );

/**
* @brief タイムスタンプに使われるバッファを表す型定義です（GX 特殊版）
*/
typedef TTimestampBuffer< ApiTypeGx >
    NN_MACRO_CONCATENATE( TimestampBuffer, NN_GFX_GX_SUFFIX );

/**
* @brief クエリに使われるバッファを表す型定義です（GX 特殊版）
*/
typedef TQueryBuffer< ApiTypeGx >
    NN_MACRO_CONCATENATE( QueryBuffer, NN_GFX_GX_SUFFIX );

/**
* @brief gfx ライブラリを初期化します（GX 特殊版）
*
* @post
* gfx ライブラリが初期化されている。
*/
inline void NN_MACRO_CONCATENATE( Initialize, NN_GFX_GX_SUFFIX )() NN_NOEXCEPT
{
    return detail::Initialize< ApiTypeGx >();
}

/**
* @brief gfx ライブラリを終了します（GX 特殊版）
*
* @post
* gfx ライブラリが終了されている。
*/
inline void NN_MACRO_CONCATENATE( Finalize, NN_GFX_GX_SUFFIX )() NN_NOEXCEPT
{
    return detail::Finalize< ApiTypeGx >();
}

/**
* @brief イメージフォーマットのプロパティを取得します（GX 特殊版）
*
* @param[out] pOutImageFormatProperty 取得したイメージフォーマットのプロパティを格納する領域へのポインタ
* @param[in] pDevice デバイスへのポインタ
* @param[in] imageFormat 取得する対象のイメージフォーマット
*
* @pre
* - pOutImageFormatProperty != NULL
* - pDevice != NULL
* - pDevice が初期化されている
*
* @post
* - pOutImageFormatProperty の指す領域に取得されたイメージフォーマットのプロパティが格納されている
*/
inline void GetImageFormatPropertyGx(
    ImageFormatProperty* pOutImageFormatProperty, TDevice< typename
    detail::TargetVariation< ApiTypeGx >::Type >* pDevice, ImageFormat imageFormat ) NN_NOEXCEPT
{
    return detail::GetImageFormatProperty< typename detail::TargetVariation<
        ApiTypeGx >::Type >( pOutImageFormatProperty, pDevice, imageFormat );
}

/**
* @brief 2 つのタイムスタンプ値の間の時間を取得します（GX 特殊版）
*
* @param[in] startTimestampValue 始点のタイムスタンプの値
* @param[in] endTimestampValue 終点のタイムスタンプの値
*
* @return 指定された始点と終点の間の時間を返します。
*
* @details
* タイムスタンプの値には nn::gfx::TimestampBuffer::GetValue で得られる値を使うことができます。
*/
inline nn::TimeSpan GetDurationGx(
    int64_t startTimestampValue, int64_t endTimestampValue ) NN_NOEXCEPT
{
    return detail::GetDuration< typename detail::TargetVariation<
        ApiTypeGx >::Type >( startTimestampValue, endTimestampValue );
}

}
}
