﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

/**
* @file
* @brief 型に関する定義（GX2 特殊版）
*/

#pragma once

#include <nn/gfx/gfx_Common.h>
#include <nn/gfx/gfx_Variation-api.gx.h>
#include <nn/gfx/gfx_Device.h>

#include <nn/gfx/detail/gfx_Declare.h>
#include <nn/gfx/detail/gfx_Core-api.gx.2.h>
#include <nn/gfx/detail/gfx_Texture-api.gx.2.h>
#include <nn/gfx/detail/gfx_Device-api.gx.2.h>
#include <nn/gfx/detail/gfx_BufferLayout-api.gx.2.h>

namespace nn {
namespace gfx {

/**
* @brief バッファを表す型定義です（GX2 特殊版）
*/
typedef TBuffer< ApiVariationGx2 >
    NN_MACRO_CONCATENATE( Buffer, NN_MACRO_CONCATENATE( NN_GFX_GX_SUFFIX, 2 ) );

/**
* @brief バッファテクスチャビューを表す型定義です（GX2 特殊版）
*/
typedef TBuffer< ApiVariationGx2 >
    NN_MACRO_CONCATENATE( BufferTextureView, NN_MACRO_CONCATENATE( NN_GFX_GX_SUFFIX, 2 ) );

/**
* @brief コマンドバッファを表す型定義です（GX2 特殊版）
*/
typedef TCommandBuffer< ApiVariationGx2 >
    NN_MACRO_CONCATENATE( CommandBuffer, NN_MACRO_CONCATENATE( NN_GFX_GX_SUFFIX, 2 ) );

/**
* @brief デスクリプタプールを表す型定義です（GX2 特殊版）
*/
typedef TDescriptorPool< ApiVariationGx2 >
    NN_MACRO_CONCATENATE( DescriptorPool, NN_MACRO_CONCATENATE( NN_GFX_GX_SUFFIX, 2 ) );

/**
* @brief デバイスを表す型定義です（GX2 特殊版）
*/
typedef TDevice< ApiVariationGx2 >
    NN_MACRO_CONCATENATE( Device, NN_MACRO_CONCATENATE( NN_GFX_GX_SUFFIX, 2 ) );

/**
* @brief メモリプールを表す型定義です（GX2 特殊版）
*/
typedef TMemoryPool< ApiVariationGx2 >
    NN_MACRO_CONCATENATE( MemoryPool, NN_MACRO_CONCATENATE( NN_GFX_GX_SUFFIX, 2 ) );

/**
* @brief パイプラインを表す型定義です（GX2 特殊版）
*/
typedef TPipeline< ApiVariationGx2 >
    NN_MACRO_CONCATENATE( Pipeline, NN_MACRO_CONCATENATE( NN_GFX_GX_SUFFIX, 2 ) );

/**
* @brief キューを表す型定義です（GX2 特殊版）
*/
typedef TQueue< ApiVariationGx2 >
    NN_MACRO_CONCATENATE( Queue, NN_MACRO_CONCATENATE( NN_GFX_GX_SUFFIX, 2 ) );

/**
* @brief ルートシグネチャを表す型定義です（GX2 特殊版）
*/
typedef TRootSignature< ApiVariationGx2 >
    NN_MACRO_CONCATENATE( RootSignature, NN_MACRO_CONCATENATE( NN_GFX_GX_SUFFIX, 2 ) );

/**
* @brief サンプラを表す型定義です（GX2 特殊版）。
*/
typedef TSampler< ApiVariationGx2 >
    NN_MACRO_CONCATENATE( Sampler, NN_MACRO_CONCATENATE( NN_GFX_GX_SUFFIX, 2 ) );

/**
* @brief シェーダを表す型定義です（GX2 特殊版）
*/
typedef TShader< ApiVariationGx2 >
    NN_MACRO_CONCATENATE( Shader, NN_MACRO_CONCATENATE( NN_GFX_GX_SUFFIX, 2 ) );

/**
* @brief ラスタライザステートを表す型定義です（GX2 特殊版）
*/
typedef TRasterizerState< ApiVariationGx2 >
    NN_MACRO_CONCATENATE( RasterizerState, NN_MACRO_CONCATENATE( NN_GFX_GX_SUFFIX, 2 ) );

/**
* @brief ブレンドステートを表す型定義です（GX2 特殊版）
*/
typedef TBlendState< ApiVariationGx2 >
    NN_MACRO_CONCATENATE( BlendState, NN_MACRO_CONCATENATE( NN_GFX_GX_SUFFIX, 2 ) );

/**
* @brief 深度ステンシルステートを表す型定義です（GX2 特殊版）
*/
typedef TDepthStencilState< ApiVariationGx2 >
    NN_MACRO_CONCATENATE( DepthStencilState, NN_MACRO_CONCATENATE( NN_GFX_GX_SUFFIX, 2 ) );

/**
* @brief 頂点ステートを表す型定義です（GX2 特殊版）
*/
typedef TVertexState< ApiVariationGx2 >
    NN_MACRO_CONCATENATE( VertexState, NN_MACRO_CONCATENATE( NN_GFX_GX_SUFFIX, 2 ) );

/**
* @brief テセレーションステートを表す型定義です（GX2 特殊版）
*/
typedef TTessellationState< ApiVariationGx2 >
    NN_MACRO_CONCATENATE( TessellationState, NN_MACRO_CONCATENATE( NN_GFX_GX_SUFFIX, 2 ) );

/**
* @brief ビューポートシザーステートを表す型定義です（GX2 特殊版）
*/
typedef TViewportScissorState< ApiVariationGx2 >
    NN_MACRO_CONCATENATE( ViewportScissorState, NN_MACRO_CONCATENATE( NN_GFX_GX_SUFFIX, 2 ) );

/**
* @brief スワップチェーンを表す型定義です（GX2 特殊版）
*/
typedef TSwapChain< ApiVariationGx2 >
    NN_MACRO_CONCATENATE( SwapChain, NN_MACRO_CONCATENATE( NN_GFX_GX_SUFFIX, 2 ) );

/**
* @brief フェンスを表す型定義です（GX2 特殊版）
*/
typedef TFence< ApiVariationGx2 >
    NN_MACRO_CONCATENATE( Fence, NN_MACRO_CONCATENATE( NN_GFX_GX_SUFFIX, 2 ) );

/**
* @brief セマフォを表す型定義です（GX2 特殊版）
*/
typedef TSemaphore< ApiVariationGx2 >
    NN_MACRO_CONCATENATE( Semaphore, NN_MACRO_CONCATENATE( NN_GFX_GX_SUFFIX, 2 ) );

/**
* @brief テクスチャを表す型定義です（GX2 特殊版）
*/
typedef TTexture< ApiVariationGx2 >
    NN_MACRO_CONCATENATE( Texture, NN_MACRO_CONCATENATE( NN_GFX_GX_SUFFIX, 2 ) );

/**
* @brief テクスチャビューを表す型定義です（GX2 特殊版）
*/
typedef TTextureView< ApiVariationGx2 >
    NN_MACRO_CONCATENATE( TextureView, NN_MACRO_CONCATENATE( NN_GFX_GX_SUFFIX, 2 ) );

/**
* @brief カラーターゲットビューを表す型定義です（GX2 特殊版）
*/
typedef TColorTargetView< ApiVariationGx2 >
    NN_MACRO_CONCATENATE( ColorTargetView, NN_MACRO_CONCATENATE( NN_GFX_GX_SUFFIX, 2 ) );

/**
* @brief 深度ステンシルビューを表す型定義です（GX2 特殊版）
*/
typedef TDepthStencilView< ApiVariationGx2 >
    NN_MACRO_CONCATENATE( DepthStencilView, NN_MACRO_CONCATENATE( NN_GFX_GX_SUFFIX, 2 ) );

/**
* @brief 相互運用を行うためのクラスの型定義です(（GX2 特殊版）
*/
typedef TInteroperation< ApiVariationGx2 >
    NN_MACRO_CONCATENATE( Interoperation, NN_MACRO_CONCATENATE( NN_GFX_GX_SUFFIX, 2 ) );

/**
* @brief タイムスタンプに使われるバッファを表す型定義です（GX2 特殊版）
*/
typedef TTimestampBuffer< ApiVariationGx2 >
    NN_MACRO_CONCATENATE( TimestampBuffer, NN_MACRO_CONCATENATE( NN_GFX_GX_SUFFIX, 2 ) );

/**
* @brief クエリに使われるバッファを表す型定義です（GX2 特殊版）
*/
typedef TQueryBuffer< ApiVariationGx2 >
    NN_MACRO_CONCATENATE( QueryBuffer, NN_MACRO_CONCATENATE( NN_GFX_GX_SUFFIX, 2 ) );

/**
* @brief gfx ライブラリを初期化します（GX2 特殊版）
*
* @post
* gfx ライブラリが初期化されている。
*/
inline void NN_MACRO_CONCATENATE( Initialize, NN_MACRO_CONCATENATE(
    NN_GFX_GX_SUFFIX, 2 ) )() NN_NOEXCEPT
{
    return detail::Initialize< ApiVariationGx2 >();
}

/**
* @brief gfx ライブラリを終了します（GX2 特殊版）
*
* @post
* gfx ライブラリが終了されている。
*/
inline void NN_MACRO_CONCATENATE( Finalize, NN_MACRO_CONCATENATE(
    NN_GFX_GX_SUFFIX, 2 ) )() NN_NOEXCEPT
{
    return detail::Finalize< ApiVariationGx2 >();
}

/**
* @brief イメージフォーマットのプロパティを取得します（GX2 特殊版）
*
* @param[out] pOutImageFormatProperty 取得したイメージフォーマットのプロパティを格納する領域へのポインタ
* @param[in] pDevice デバイスへのポインタ
* @param[in] imageFormat 取得する対象のイメージフォーマット
*
* @pre
* - pOutImageFormatProperty != NULL
* - pDevice != NULL
* - pDevice が初期化されている
*
* @post
* - pOutImageFormatProperty の指す領域に取得されたイメージフォーマットのプロパティが格納されている
*/
inline void GetImageFormatPropertyGx2( ImageFormatProperty* pOutImageFormatProperty,
    TDevice< ApiVariationGx2 >* pDevice, ImageFormat imageFormat ) NN_NOEXCEPT
{
    return detail::GetImageFormatProperty< ApiVariationGx2 >(
        pOutImageFormatProperty, pDevice, imageFormat );
}

/**
* @brief 2 つのタイムスタンプ値の間の時間を取得します（GX2 特殊版）
*
* @param[in] startTimestampValue 始点のタイムスタンプの値
* @param[in] endTimestampValue 終点のタイムスタンプの値
*
* @return 指定された始点と終点の間の時間を返します。
*
* @details
* タイムスタンプの値には nn::gfx::TimestampBuffer::GetValue で得られる値を使うことができます。
*/
inline nn::TimeSpan GetDurationGx2( int64_t startTimestampValue, int64_t endTimestampValue ) NN_NOEXCEPT
{
    return detail::GetDuration< ApiVariationGx2 >( startTimestampValue, endTimestampValue );
}

}
}
