﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

/**
* @file
* @brief スワップチェーンのデータに関する API の宣言（VK1 特殊版）
*/

#pragma once

#include <nn/nn_Common.h>

#if !defined( NN_BUILD_CONFIG_OS_SUPPORTS_WIN32 )
    #error "OS 種別として Win32 が指定されていません。"
#endif

#include <nn/util/util_BitPack.h>

#include <nn/gfx/gfx_Common.h>
#include <nn/gfx/gfx_Variation-api.vk.h>
#include <nn/gfx/gfx_TextureData-api.vk.1.h>
#include <nn/gfx/gfx_SyncData-api.vk.1.h>

#include <nn/gfx/detail/gfx_Common-api.vk.h>
#include <nn/gfx/detail/gfx_Declare.h>
#include <nn/gfx/detail/gfx_Misc.h>

namespace nn {
namespace gfx {

/**
* @brief スワップチェーンを表す構造体です（VK1 特殊版）
*/
template<>
struct SwapChainImplData< ApiVariationVk1 >
{
    enum State
    {
        State_NotInitialized,
        State_Initialized
    };

    enum Flag
    {
        Flag_IsFirstPresentation
    };

    static const uint32_t VkMaxScanBufferCount = 6;

    detail::Ptr< const detail::DeviceImpl< ApiVariationVk1 > > pGfxDevice; //!< デバイスへのポインターです
    detail::Ptr< void > hWnd; //!< ウインドウハンドルです
    detail::Ptr< void > hDc; //!< デバイスコンテキストです
    detail::VkHandle hSurfaceKHR; //!< サーフェイスハンドルです
    detail::VkHandle hSwapChainKHR; //!< スワップチェーンハンドルです
    Bit64 extent2D; //!< サーフェイスの解像度です

    Bit8 state; //!< オブジェクトの状態です。
    nn::util::BitPack8 flag; //!< フラグです
    char reserved[2]; //!< 予約領域です
    uint32_t currentScanBufferIndex;
    uint32_t currentPresentSemaphoreIndex;
    uint32_t totalScanBuffers;
    TextureImplData< ApiVariationVk1 > scanBufferTextures[ VkMaxScanBufferCount ]; // スキャンバッファーです
    ColorTargetViewImplData< ApiVariationVk1 > scanBufferViews[ VkMaxScanBufferCount ]; //!< スキャンバッファービューです
    SemaphoreImplData< ApiVariationVk1 > presentSemaphore[ VkMaxScanBufferCount ];

    detail::Ptr< void > userPtr; //!< ユーザーポインターです
};

}
}
