﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

/**
* @file
* @brief ステートのデータに関する API の宣言（D3D11 特殊版）
*/

#pragma once

#include <nn/nn_Common.h>

#include <nn/util/util_BitPack.h>

#include <nn/gfx/gfx_Common.h>
#include <nn/gfx/gfx_Variation-api.d3d.h>
#include <nn/gfx/gfx_StateInfoData.h>

#include <nn/gfx/detail/gfx_Common-api.d3d.h>
#include <nn/gfx/detail/gfx_Declare.h>

namespace nn {
namespace gfx {

/**
* @brief ラスタライザーステートを表す構造体です（D3D11 特殊版）
*/
template<>
struct RasterizerStateImplData< ApiVariationD3d11 >
{
    enum State
    {
        State_NotInitialized,
        State_Initialized
    };
    Bit8 state; //!< オブジェクトの状態です。
    char reserved[ 3 ]; //!< 予約領域です。
    detail::Ptr< void > pRasterizerState; //!< ラスタライザーステートハンドルです
    uint32_t sampleMask; //!< サンプルマスクです
};

/**
* @brief ブレンドステートを表す構造体です（D3D11 特殊版）
*/
template<>
struct BlendStateImplData< ApiVariationD3d11 >
{
    /**
    * ブレンドターゲットステートを表す構造体です（D3D11 特殊版）
    */
    enum State
    {
        State_NotInitialized,
        State_Initialized
    };
    Bit8 state; //!< オブジェクトの状態です。
    char reserved[3]; //!< 予約領域です。
    float blendColor[ 4 ]; //!< ブレンド定数です
    int32_t blendTargetCount; //!< ブレンドターゲットの数です

    detail::Ptr< void > pBlendState; //!< ブレンドステートのハンドルです
};

/**
* @brief 深度ステンシルステートを表す構造体です（D3D11 特殊版）
*/
template<>
struct DepthStencilStateImplData< ApiVariationD3d11 >
{
    /**
    * @brief ステンシルステートを表す構造体です（D3D11 特殊版）
    */
    enum State
    {
        State_NotInitialized,
        State_Initialized
    };
    Bit8 state; //!< オブジェクトの状態です。
    char reserved[ 3 ]; //!< 予約領域です。
    uint32_t stencilRef; //!< ステンシルテストの参照値です
    detail::Ptr< void > pDepthStencilState; //!< 深度ステンシルステートのハンドルです
};

/**
* @brief 頂点ステートを表す構造体です（D3D11 特殊版）
*/
template<>
struct VertexStateImplData< ApiVariationD3d11 >
{
    /**
    * @brief 頂点属性ステートを表す構造体です（D3D11 特殊版）
    */
    enum State
    {
        State_NotInitialized,
        State_Initialized
    };
    Bit8 state; //!< オブジェクトの状態です。
    char reserved[ 3 ]; //!< 予約領域です。
    int32_t attributeCount; //!< 頂点属性の数です
    int32_t bufferCount; //!< 頂点バッファの数です
    detail::Ptr< void > pInputLayout; //!< 入力レイアウトオブジェクトのハンドルです
};

/**
* @brief テセレーションステートを表す構造体です（D3D11 特殊版）
*/
template<>
struct TessellationStateImplData< ApiVariationD3d11 >
{
    enum State
    {
        State_NotInitialized,
        State_Initialized
    };

    Bit8 state; //!< オブジェクトの状態です
    char reserved[ 3 ]; //!< 予約領域です。
    int32_t patchControlPointCount; //!< パッチの制御点の数です
};

/**
* @brief ビューポートシザーステートを表す構造体です（D3D11 特殊版）
*/
template<>
struct ViewportScissorStateImplData< ApiVariationD3d11 >
{
    enum Flag
    {
        Flag_ScissorEnable = ViewportScissorStateInfoData::Flag_ScissorEnable
    };
    enum State
    {
        State_NotInitialized,
        State_Initialized
    };
    Bit8 state; //!< オブジェクトの状態です。
    nn::util::BitPack8 flag; //!< フラグです
    char reserved[ 2 ]; //!< 予約領域です。
    int32_t viewportCount; //!< ビューポートの数です
    uint32_t memorySize; //!< バイトでの作業メモリーのサイズです
    char reserved2[ 4 ]; //!< 予約領域です。
    float viewport[ 6 ]; //!< viewport設定です。（depthRangeも含みます。）
    uint32_t scissor[ 4 ]; //!< scissor設定です。left, top, right, bottomの順です。
    detail::Ptr< void > pWorkMemory; //!< 作業メモリーへのポインターです
};

}
}
