﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

/**
* @file
* @brief パイプラインのデータに関する API の宣言（GX2 特殊版）
*/

#pragma once

#include <nn/nn_Common.h>

#include <nn/gfx/gfx_Common.h>
#include <nn/gfx/gfx_Variation-api.gx.h>

#include <nn/gfx/detail/gfx_Declare.h>
#include <nn/gfx/detail/gfx_Shader-api.gx.2.h>
#include <nn/gfx/detail/gfx_State-api.gx.2.h>

namespace nn {
namespace gfx {

/**
* @brief パイプラインを表す構造体です（GX2 特殊版）
*/
template<>
struct PipelineImplData< ApiVariationGx2 >
{
    enum PipelineType
    {
        PipelineType_Graphics,
        PipelineType_Compute
    };
    enum State
    {
        State_NotInitialized,
        State_Initialized
    };

    Bit8 state; //!< オブジェクトの状態です。
    Bit8 pipelineType;
    NN_PADDING6;

    detail::RasterizerStateImpl< ApiVariationGx2 > rasterizerState;
    detail::BlendStateImpl< ApiVariationGx2 > blendState;
    detail::DepthStencilStateImpl< ApiVariationGx2 > depthStencilState;
    detail::VertexStateImpl< ApiVariationGx2 > vertexState;
    detail::Ptr< const detail::ShaderImpl< ApiVariationGx2 > > pShader;
    detail::Ptr< void > pMemory;
    uint32_t memorySize;

    detail::Ptr< void > userPtr; //!< ユーザポインタです
};


}
}
