﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

/**
* @file
* @brief バッファーのデータに関する API の宣言（VK1 特殊版）
*/

#pragma once

#include <nn/nn_Common.h>

#include <nn/util/util_BitPack.h>

#include <nn/gfx/gfx_Common.h>
#include <nn/gfx/gfx_Variation-api.vk.h>

#include <nn/gfx/detail/gfx_Common-api.vk.h>
#include <nn/gfx/detail/gfx_Declare.h>
#include <nn/gfx/detail/gfx_Misc.h>

namespace nn {
namespace gfx {

/**
* @brief Buffer を表す構造体です（VK1 特殊版）
*/
template<>
struct BufferImplData< ApiVariationVk1 >
{
    enum State
    {
        State_NotInitialized,
        State_Initialized
    };

    enum Flag
    {
        Flag_Shared,
        Flag_FlushExplicit
    };

    Bit8 state; //!< オブジェクトの状態です。
    nn::util::BitPack8 flags; //!< フラグです。
    char reserved[6]; //!< 予約領域です。
    uint64_t bufferOffset; //!< 占有するVulkanMemory内でのオフセットです。
    uint64_t bufferSize; //!< 占有するVulkanMemory内でのサイズです。

    detail::Ptr< detail::DeviceImpl< ApiVariationVk1 > > pGfxDevice; //!< デバイスへのポインターです

    detail::Ptr< void > pMapping; //!< Global mapping to avoid remap errors.

    detail::VkHandle hBuffer; //!< バッファーハンドルです
    detail::VkHandle hBufferMemory; //!< バッファーメモリーハンドルです
};

/**
* @brief BufferTextureView を表す構造体です（VK1 特殊版）
*/
template<>
struct BufferTextureViewImplData< ApiVariationVk1 >
{
    enum State
    {
        State_NotInitialized,
        State_Initialized
    };

    enum Flag
    {
        Flag_Shared
    };

    Bit8 state; //!< オブジェクトの状態です。
    nn::util::BitPack8 flags; //!< フラグです。
    char reserved[6]; //!< 予約領域です。

    detail::Ptr< detail::DeviceImpl< ApiVariationVk1 > > pGfxDevice; //!< nn::gfx::Deviceオブジェクトです
    detail::VkHandle hBufferView; //!< バッファービューハンドルです
};

}
}
