﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include <nn/gfx/gfx_Common.h>
#include <nn/gfx/gfx_DeviceData-api.gx.2-os.cos.h>

#include <nn/gfx/detail/gfx_Declare.h>
#include <nn/gfx/detail/gfx_DataContainer.h>

#if !defined( NN_BUILD_CONFIG_OS_COS )
#   error
#endif

namespace nn {
namespace gfx {

class DeviceInfo;
class DisplayHandle;

namespace detail {

template<>
class DeviceImpl< ApiVariationGx2 >
    : public DataContainer< DeviceImplData< ApiVariationGx2 > >
{
    NN_DISALLOW_COPY( DeviceImpl );

public:
    typedef ApiVariationGx2 Target;
    typedef DeviceInfo InfoType;

    static const bool IsWorkingMemoryRequired = false;

    DeviceImpl() NN_NOEXCEPT;

    ~DeviceImpl() NN_NOEXCEPT;

    void Initialize( const InfoType& info ) NN_NOEXCEPT;

    void Finalize() NN_NOEXCEPT;
};

}
}
}
