﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include <nn/nn_Common.h>

#include <nn/os/os_MutexTypes.h>

#include <nn/gfx/detail/gfx_Misc.h>

namespace nn {
namespace gfx {
namespace detail {

typedef void* D3dHandle;

struct D3dRenderingContext
{
    Ptr< void > hD3dDevice;
    Ptr< void > hD3dDeviceContext;
};

inline bool IsD3dHandleValid( D3dHandle handle )
{
    return handle != NULL;
}

}
}
}
