﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include <nn/nn_Common.h>
#include <nn/nn_Macro.h>

#include <nn/gfx/gfx_Common.h>
#include <nn/gfx/gfx_BufferLayoutData-api.vk.1.h>

#include <nn/gfx/detail/gfx_Declare.h>
#include <nn/gfx/detail/gfx_DataContainer.h>

namespace nn {
namespace gfx {

/**
* 共通機能として公開されるときにgfx_Declare.hへ移動します。
*/
template< typename TTarget >
class TGraphicsPipelineStatisticsQueriesBuffer;

namespace detail {

template<>
class TimestampBufferImpl< ApiVariationVk1 >
    : public DataContainer< TimestampBufferImplData< ApiVariationVk1 > >
{
public:
    typedef ApiVariationVk1 Target;

    int64_t GetValue() const NN_NOEXCEPT;
};

template<>
class QueryBufferImpl< ApiVariationVk1 >
    : public DataContainer< QueryBufferImplData< ApiVariationVk1 > >
{
public:
    typedef ApiVariationVk1 Target;

    int64_t GetValue() const NN_NOEXCEPT;
};

/**
* 共通機能として公開されるときにgfx_Declare.hへ移動します。
*/
template< typename TTarget >
class GraphicsPipelineStatisticsQueriesBufferImpl;

template<>
class GraphicsPipelineStatisticsQueriesBufferImpl< ApiVariationVk1 >
    : public DataContainer< GraphicsPipelineStatisticsQueriesBufferImplData< ApiVariationVk1 > >
{
public:
    typedef ApiVariationVk1 Target;

    int64_t GetValue( QueryTarget target ) const NN_NOEXCEPT;
};

template<>
nn::TimeSpan GetDuration< ApiVariationVk1 >(
    int64_t startTimestampValue, int64_t endTimestampValue ) NN_NOEXCEPT;

}

/**
* @brief クエリーに使われるバッファーのレイアウトを表すグラフィックス抽象レイヤーです。
*
* @tparam TTarget 対象の低レベルグラフィックス API
*
* @details
* このクラスは GPU が書き込む内容のレイアウトを表現します。
* 低レベルグラフィックス API のオブジェクトを表現しません。
*/
template< typename TTarget >
class TGraphicsPipelineStatisticsQueriesBuffer
    : public detail::GraphicsPipelineStatisticsQueriesBufferImpl< typename detail::TargetVariation< TTarget >::Type >
{
    typedef detail::GraphicsPipelineStatisticsQueriesBufferImpl< typename detail::TargetVariation< TTarget >::Type > Impl;

public:
    /**
    * @brief 対象の低レベルグラフィックス API です。
    */
    typedef typename Impl::Target Target;

    /**
    * @brief クエリー結果を取得します。
    *
    * @return クエリー結果を返します。
    */
    int64_t GetValue( QueryTarget target ) const NN_NOEXCEPT
    {
        return Impl::GetValue( target );
    }
};

}
}
