﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include <nn/ens/detail/util/rapidjson/ens_RapidJsonInputStream.h>

namespace nn { namespace ens { namespace detail { namespace util { namespace rapidjson {

/**
 * @brief   RapidJSON 用の入力ストリーム（メモリ）
 *
 * @details
 */
class RapidJsonMemoryInputStream : public RapidJsonInputStream
{
public:
    //
    typedef RapidJsonInputStream::Ch Ch;

public:
    /**
     * @brief   コンストラクタ
     *
     * @details
     */
    RapidJsonMemoryInputStream() NN_NOEXCEPT;

    /**
     * @brief   デストラクタ
     *
     * @details
     */
    virtual ~RapidJsonMemoryInputStream() NN_NOEXCEPT;

    /**
     * @brief   入力ストリームを開きます。
     *
     * @param[in]   pData   データ
     * @param[in]   size    データのサイズ
     *
     * @pre
     *  - pData != nullptr
     *  - size > 0
     *
     * @details
     */
    void Open(const void* pData, size_t size) NN_NOEXCEPT;

    /**
     * @brief   入力ストリームを閉じます。
     *
     * @details
     */
    void Close() NN_NOEXCEPT;

protected:
    //
    virtual nn::Result FillImpl(size_t* pOutRead, void* pOutData, size_t dataSize) NN_NOEXCEPT NN_OVERRIDE;

private:
    //
    const nn::Bit8* m_pData;
    size_t m_Size;
    //
    size_t m_Position;
    //
    bool m_IsOpened;
};

}}}}}
