﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include <nn/nn_Common.h>

namespace nn { namespace ens { namespace detail { namespace util { namespace rapidjson {

/**
 * @brief   メモリの動的確保を禁止したアロケータ
 *
 * @details
 */
class NullAllocator
{
public:
    // RapidJSON に Free が不要であることを指定する。
    static const bool kNeedFree = false;

public:
    /**
     * @brief   メモリ確保関数
     *
     * @details
     */
    void* Malloc(size_t) NN_NOEXCEPT
    {
        return nullptr;
    }

    /**
     * @brief   メモリ再確保関数
     *
     * @details
     */
    void* Realloc(void*, size_t, size_t) NN_NOEXCEPT
    {
        return nullptr;
    }

    /**
     * @brief   メモリ解放関数
     *
     * @details
     */
    static void Free(void*) NN_NOEXCEPT
    {
    }
};

}}}}}
