﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include <nn/ens/detail/ens_Common.h>
#include <nn/ens/detail/util/ens_ResponseReader.h>

namespace nn { namespace ens { namespace detail { namespace util {

/**
 * @brief   JSON を読み込むクラス
 *
 * @details
 */
class JsonReader : public ResponseReader
{
public:
    /**
     * @brief   コンストラクタ
     *
     * @details
     */
    JsonReader() NN_NOEXCEPT;

    /**
     * @brief   データの読み込みコールバックを設定します。
     *
     * @param[in]   pCallback   コールバック
     * @param[in]   pParam      コールバックパラメータ
     *
     * @details
     */
    virtual void SetCallback(ReadCallback pCallback, void* pParam) NN_NOEXCEPT NN_OVERRIDE;

    /**
     * @brief   JSON を読み込みます。
     *
     * @param[in]   pData   JSON データ
     * @param[in]   size    JSON データのサイズ
     *
     * @return  妥当な JSON を読み込んだかどうか
     *
     * @pre
     *  - pData != nullptr
     *
     * @details
     */
    virtual bool Read(const void* pData, size_t size) NN_NOEXCEPT NN_OVERRIDE;

private:
    //
    class EventHandler
    {
    public:
        //
        EventHandler() NN_NOEXCEPT;

        //
        void Clear() NN_NOEXCEPT;
        //
        void SetCallback(ReadCallback pCallback, void* pParam) NN_NOEXCEPT;

        //
        bool StartObject() NN_NOEXCEPT;
        //
        bool EndObject(size_t num) NN_NOEXCEPT;
        //
        bool StartArray() NN_NOEXCEPT;
        //
        bool EndArray(size_t num) NN_NOEXCEPT;
        //
        bool Key(const char* pKey, size_t length, bool copy) NN_NOEXCEPT;
        //
        bool Null() NN_NOEXCEPT;
        //
        bool Bool(bool value) NN_NOEXCEPT;
        //
        bool Int(int32_t value) NN_NOEXCEPT;
        //
        bool Uint(uint32_t value) NN_NOEXCEPT;
        //
        bool Int64(int64_t value) NN_NOEXCEPT;
        //
        bool Uint64(uint64_t value) NN_NOEXCEPT;
        //
        bool Double(double value) NN_NOEXCEPT;
        //
        bool String(const char* pValue, size_t length, bool copy) NN_NOEXCEPT;

    private:
        //
        JsonPath m_JsonPath;
        //
        ReadCallback m_pCallback;
        void* m_pCallbackParam;

    private:
        //
        bool DoCallbackForNode(const DataHolder& holder) NN_NOEXCEPT;
        //
        bool DoCallbackForLeaf(const DataHolder& holder) NN_NOEXCEPT;
    };

private:
    //
    EventHandler m_EventHandler;
};

}}}}
