﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include <nn/nn_Common.h>
#include <nn/nn_TimeSpan.h>

namespace nn { namespace ens { namespace detail {

/**
 * @brief   ライブラリのグローバルな設定
 *
 * @details
 */
class LibrarySettings
{
public:
    /**
     * @brief   HTTP 通信の詳細情報出力オプションを取得します。
     *
     * @return  HTTP 通信の詳細情報出力オプション
     *
     * @details
     */
    static long GetHttpVerboseInformationOption() NN_NOEXCEPT;

    /**
     * @brief   HTTP 通信の Keep-Alive タイムアウトを取得します。
     *
     * @return  HTTP 通信の Keep-Alive タイムアウト
     *
     * @details
     */
    static nn::TimeSpan GetHttpKeepAliveTimeout() NN_NOEXCEPT;

    /**
     * @brief   通信性能のダンプが有効かどうかを取得します。
     *
     * @return  通信性能のダンプが有効かどうか
     *
     * @details
     */
    static bool IsCommunicationPerformanceDumpEnabled() NN_NOEXCEPT;

    /**
     * @brief   受信データのダンプが有効かどうかを取得します。
     *
     * @return  受信データのダンプが有効かどうか
     *
     * @details
     */
    static bool IsResponseDumpEnabled() NN_NOEXCEPT;

public:
    /**
     * @brief   HTTP 通信の詳細情報出力オプションを設定します。
     *
     * @param[in]   option  HTTP 通信の詳細情報出力オプション
     *
     * @details
     */
    static void SetHttpVerboseInformationOption(long option) NN_NOEXCEPT;

    /**
     * @brief   HTTP 通信の Keep-Alive タイムアウトを設定します。
     *
     * @param[in]   timeout HTTP 通信の Keep-Alive タイムアウト
     *
     * @details
     */
    static void SetHttpKeepAliveTimeout(nn::TimeSpan timeout) NN_NOEXCEPT;

    /**
     * @brief   通信性能のダンプが有効かどうかを設定します。
     *
     * @param[in]   isEnabled   通信性能のダンプが有効かどうか
     *
     * @details
     */
    static void SetCommunicationPerformanceDumpEnabled(bool isEnabled) NN_NOEXCEPT;

    /**
     * @brief   受信データのダンプが有効かどうかを設定します。
     *
     * @param[in]   isEnabled   受信データのダンプが有効かどうか
     *
     * @details
     */
    static void SetResponseDumpEnabled(bool isEnabled) NN_NOEXCEPT;
};

}}}
