﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include <nn/ens/detail/ens_Common.h>

namespace nn { namespace ens { namespace detail { namespace core {

/**
 * @brief   サーバーキーを設定します。
 *
 * @param[in]   pServerKey  利用するサーバーを示すキー文字列
 *
 * @details
 */
void SetServerKey(const char* pServerKey) NN_NOEXCEPT;

/**
 * @brief   URL を生成します。
 *
 * @param[out]  pOutUrl URL
 * @param[in]   size    URL バッファのサイズ
 * @param[in]   pModule API モジュール
 * @param[in]   pPath   API パス
 * @param[in]   ...     API パスに指定するパラメータ
 *
 * @pre
 *  - pModule != nullptr
 *  - pPath != nullptr
 *
 * @details
 */
void MakeUrl(char* pOutUrl, size_t size, const char* pModule, const char* pPath, ...) NN_NOEXCEPT;

}}}}
