﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include <nn/ens/detail/ens_Common.h>
#include <nn/ens/ens_ServiceThreadContext.h>
#include <nn/ens/detail/core/ens_Task.h>

namespace nn { namespace ens { namespace detail { namespace core {

/**
 * @brief   サービスを開始します。
 *
 * @param[in]   context サービススレッドの実行コンテキスト
 *
 * @pre
 *  - context.GetBuffer() != nullptr
 *
 * @details
 *  本関数は detail::core::StopServiceLoop() が呼ばれるまでブロックします。
 */
void StartServiceLoop(ServiceThreadContext& context) NN_NOEXCEPT;

/**
 * @brief   サービスを終了します。
 *
 * @param[in]   context サービススレッドの実行コンテキスト
 *
 * @details
 */
void StopServiceLoop(ServiceThreadContext& context) NN_NOEXCEPT;

/**
 * @brief   タスクを登録します。
 *
 * @param[in]   pTask       タスク
 * @param[in]   pContext    非同期コンテキスト
 *
 * @pre
 *  - pTask != nullptr
 *  - pContext != nullptr
 *
 * @details
 *  登録されたタスクはタスクリストの末尾に追加され、順次処理されます。
 */
void RegisterTask(Task* pTask, AsyncContext* pContext) NN_NOEXCEPT;

/**
 * @brief   未実行の全タスクの登録を解除します。
 *
 * @details
 */
void UnregisterTaskAll() NN_NOEXCEPT;

/**
 * @brief   認証トークンキャッシュに認証トークンを設定します。
 *
 * @param[in]   userId  ユーザー ID
 * @param[in]   token   認証トークン
 *
 * @pre
 *  - userId != InvalidUserId
 *
 * @details
 *  グローバルに管理している認証トークンキャッシュに認証トークンを設定します。
 */
void SetAuthTokenToCache(const UserId& userId, const AuthToken& token) NN_NOEXCEPT;

/**
 * @brief   認証トークンキャッシュをクリアします。
 *
 * @details
 *  グローバルに管理している認証トークンキャッシュをクリアします。
 */
void ClearAuthTokenCache() NN_NOEXCEPT;

}}}}
