﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include <nn/ens/detail/ens_Common.h>
#include <nn/mem.h>

namespace nn { namespace ens { namespace detail { namespace core {

/**
 * @brief   アロケータを作成します。
 *
 * @param[in]   pBuffer     バッファ
 * @param[in]   bufferSize  バッファのサイズ
 *
 * @pre
 *  - pBuffer != nullptr
 *  - bufferSize > 0
 *
 * @details
 */
void CreateAllocator(void* pBuffer, size_t bufferSize) NN_NOEXCEPT;

/**
 * @brief   アロケータを破棄します。
 *
 * @details
 */
void DestroyAllocator() NN_NOEXCEPT;

/**
 * @brief   アロケータが作成されるまで待機します。
 *
 * @details
 *
 * @note
 *  複数スレッドで同時に待機しても問題ありません。
 */
void WaitUntilAllocatorCreation() NN_NOEXCEPT;

/**
 * @brief   メモリを確保します。
 *
 * @param[in]   size    確保したいサイズ
 *
 * @return  メモリ
 *
 * @details
 */
void* AllocateMemory(size_t size) NN_NOEXCEPT;

/**
 * @brief   メモリを解放します。
 *
 * @param[in]   pMemory メモリ
 *
 * @details
 */
void FreeMemory(void* pMemory) NN_NOEXCEPT;

}}}}
