﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include <nn/ens/detail/core/ens_AuthenticationTask.h>
#include <nn/ens/ens_TypesForAcbaa.h>

namespace nn { namespace ens { namespace detail { namespace app_acbaa { namespace task {

/**
 * @brief   GetMyDesignBody の非同期処理実装タスク
 *
 * @details
 */
class TaskGetMyDesignBody : public detail::core::AuthenticationTask
{
public:
    /**
     * @brief   コンストラクタ
     *
     * @details
     */
    TaskGetMyDesignBody() NN_NOEXCEPT;

    /**
     * @brief   デストラクタ
     *
     * @details
     */
    ~TaskGetMyDesignBody() NN_NOEXCEPT;

    /**
     * @brief   パラメータを設定します。
     *
     * @param[out]  pOutBody    ボディ
     * @param[in]   myDesignId  マイデザイン ID
     *
     * @details
     */
    void SetParameter(ReceiveBuffer* pOutBody, const MyDesignId& myDesignId) NN_NOEXCEPT;

protected:
    //
    virtual nn::Result ExecuteSteps() NN_NOEXCEPT NN_OVERRIDE;

private:
    //
    ReceiveBuffer* m_pOutBody;
    MyDesignId m_MyDesignId;

private:
    //
    nn::Result StepGet() NN_NOEXCEPT;
};

}}}}}
