﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include <nn/nn_Common.h>
#include <nn/nn_Result.h>
#include "../capsrv_AlbumFileSizeLimit.h"

namespace nn{ namespace capsrv{ namespace movie{

    static const int64_t MovieDataSizeMax = AlbumMovieDataSizeMax;
    static const int64_t MovieDataChunkUnitSize = AlbumMovieDataUnitSize;

    static const int MovieFilenameLengthMax = 15;

    static const int MovieReaderFileSystemFileCountMax = 4;
    static const int MovieWriterFileSystemFileCountMax = 4;

    static const int MovieReaderCacheChunkCountMax = 4;
    static const int MovieWriterCacheChunkCountMax = 4;

    static const size_t MovieMetaImageDataSize = 500 * 1024;
    static const size_t MovieMetaInfoDataSize  =  12 * 1024;
    static const size_t MovieMetaDataSize = MovieMetaImageDataSize + MovieMetaInfoDataSize;

}}}

