﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include <nn/gfx/gfx_Enum.h>

namespace nn{ namespace capsrv{

    //! @brief PhotoViewer 用サムネイル画像の大きさです。
    enum ViewerThumbnailImageSize
    {
        //! @brief PhotoViewer 用サムネイル画像の幅（ピクセル）です。
        ViewerThumbnailImageSize_Width  = 320,

        //! @brief PhotoViewer 用サムネイル画像の高さ（ピクセル）です。
        ViewerThumbnailImageSize_Height = 180,
    };

    enum ViewerThumbnailImageFormat
    {
        //! @brief 既定のサムネイル画像のフォーマットです。
        //! @details
        //! 1 ピクセルあたり 4 バイトです。
        ViewerThumbnailImageFormat_Default = nn::gfx::ImageFormat_R8_G8_B8_A8_Unorm,
    };

    //! @brief サムネイル画像のデータサイズです。
    enum ViewerThumbnailImageDataSize
    {
        //! @brief 無圧縮のサムネイル画像のデータサイズ（バイト）です。
        ViewerThumbnailImageDataSize_Raw = 4 * ViewerThumbnailImageSize_Width * ViewerThumbnailImageSize_Height,

        //! @brief エンコード済のサムネイル画像のデータサイズの上限（バイト）です。
        ViewerThumbnailImageDataSize_EncodedLimit = 40 * 1024,
    };

}}
