﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include <nn/nn_Common.h>
#include <nn/nn_StaticAssert.h>
#include <nn/account/account_Types.h>

namespace nn { namespace capsrv {

    //! @brief  UserIdList 構造体が保持できるユーザアカウント情報の最大数
    //!
    //! @details
    //!  account::UserCountMax の変更に単純に追従できるものではないため、
    //!  account::UserCountMax を使った定義にはしない。
    //!
    const int UserIdListCountMax = 8;

    //! @brief  オープン中のユーザアカウント情報を格納しておく構造体です。
    //!
    //! @details
    //!  この構造体で保持できるアカウント情報の最大数は、
    //!  nn::capsrv::UserIdListCountMax であり、
    //!  この値は必ずしも nn::account:UserCountMax に一致するとは限らない。
    //!
    struct NN_ALIGNAS(8) UserIdList
    {
        account::Uid uid[UserIdListCountMax];   //!< ユーザアカウント情報
        uint8_t uidCount;                       //!< 有効な要素数
        uint8_t _padding[7];
    };


    //-------------------------------------------------------------------------
    //! @brief  MakerNoteInfo に格納するシステム情報
    //!
    //! @details
    //!  各メンバの中身が全てゼロの場合は、それらの要素が無効であることを
    //!  示すようになっていなければならない。
    //!
    struct NN_ALIGNAS(8) SystemReservedInfo
    {
        UserIdList uidList;     //!< ユーザアカウント情報（有効要素数は中）

        uint8_t _reserved[888];
    };

    NN_STATIC_ASSERT(sizeof(SystemReservedInfo) == 1024);


}}  // namespace nn::capsrv
