﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include <nn/nn_Common.h>
#include <nn/nn_Result.h>
#include <nn/capsrv/capsrv_AlbumFileId.h>

namespace nn { namespace capsrv {

/**
    @brief 動画操作のためのリソースを予約します。

    @return 予約に成功すれば true を、そうでなければ false を返します。

    @details
     TrimGameMovie() などで使用される動画操作用リソースの予約を試行し、予約に成功すれば true を返します。
     すでにリソース予約がされていた場合には、何も行いません。

     予約に成功した際、次に呼ばれる TrimGameMovie() などの動画操作関数は、
     動画操作リソース不足のエラーを返すことがなくなります。
     また、予約が解除されるまでの間、ほかのプログラムが動画操作関連の API を使用を試みた場合には使用できず、
     エラーが返ったりブロックされたりします。

     この予約状態は、以下の際に解除されます。

     - UnreserveResourceForMovieOperation() が呼ばれたとき
     - TrimGameMovie() が呼ばれたとき (失敗時を含む)
*/
bool ReserveResourceForMovieOperation() NN_NOEXCEPT;

/**
    @brief ReserveResourceForMovieOperation() でのリソース予約を解除します。
*/
void UnreserveResourceForMovieOperation() NN_NOEXCEPT;

struct TrimGameMovieParameters
{
    AlbumFileId sourceId;
    int beginIndex;
    int endIndex;
    const void* thumbnailImageRgba = nullptr;
    size_t thumbnailImageRgbaSize = 0;
};

/**
    @brief アルバムにある動画をトリミングし、保存します。

    @param[out] pOut 保存された動画の id を格納するバッファへのポインタを指定します。
    @param[in] p トリミングパラメータを指定します。
    @param[in] workMemory 作業バッファのポインタを指定します。
    @param[in] workMemorySize 作業バッファのサイズを指定します。
    @return 処理結果が返ります。

    @pre *pOut へ書き込みが可能
    @pre workMemory および workMemorySize が os::MemoryPageSize でアラインされている
*/
Result TrimGameMovie(AlbumFileId* pOut, const TrimGameMovieParameters& p, void* workMemory, size_t workMemorySize) NN_NOEXCEPT;

}}
