﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include <nn/nn_Common.h>
#include <nn/ncm/ncm_ContentMetaId.h>
#include "capsrv_AlbumFileContents.h"
#include "capsrv_AlbumFileDateTime.h"
#include "capsrv_AlbumStorage.h"

namespace nn{ namespace capsrv{

    //! @brief アルバム内のファイルの識別子の構造体です。
    //! @details
    //! この識別子は単純コピー可能であり、バイナリ比較で同一性の判定が可能です。
    struct AlbumFileId
    {
        //! @brief アプリケーション ID です。
        nn::ncm::ApplicationId applicationId;

        //! @brief ファイルの作成日時です。
        AlbumFileDateTime time;

        //! @brief ファイルが保存されているストレージです。
        AlbumStorageType storage;

        //! @brief ファイルの種類です。
        AlbumFileContentsType contents;

        //! @brief 予約領域です。
        //! @details 将来の拡張のために予約されています。
        char _reserved[6];
    };

}}
