﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include <nn/nn_Common.h>
#include <nn/nn_Result.h>

namespace nn{ namespace capsrv{

    //! @brief アルバムにあるファイルの詳細な区分を示す変数の型です。
    typedef uint32_t AlbumFileDescriptionType;

    //! @brief アルバムにあるファイルの詳細区分を示す値です。
    //! @details
    //! この値は AlbumFileId に含まれません。
    //! この値の取得にはファイルを開く必要があります。
    enum AlbumFileDescription
    {

        //! @brief 画面写真ファイルです。
        AlbumFileDescription_ScreenShot         = 0x0000,

        //! @brief スクリーンショット撮影機能により作成された画面写真ファイルです。
        AlbumFileDescription_ScreenShotCaptured = 0x0001,

        //! @brief 画面写真編集機能により作成された画面写真ファイルです。
        AlbumFileDescription_ScreenShotEdited   = 0x0002,

        //! @brief 画面写真保存機能により作成された画面写真ファイルです。
        AlbumFileDescription_ScreenShotSaved    = 0x0003,


        //! @brief 動画ファイルです。
        AlbumFileDescription_Movie              = 0x0100,

        //! @brief 常時録画機能により作成された動画ファイルです。
        AlbumFileDescription_MovieContinuous    = 0x0101,

        //! @brief 動画のトリミング機能により作成された動画ファイルです。
        AlbumFileDescription_MovieTrimmed       = 0x0102,

        //! @brief nn::album::MovieMaker により作成された動画ファイルです。
        AlbumFileDescription_MovieMakerSaved    = 0x0103,
    };

}}
