﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

namespace nn{ namespace capsrv{

    //! @brief ストレージごとのファイル数の上限値です。
    enum AlbumFileCountLimit
    {
        //! @brief NAND ストレージの画面写真ファイルの数の上限です。
        AlbumFileCountLimit_NandScreenShot = 1000,

        //! @brief NAND ストレージの動画ファイルの数の上限です。
        AlbumFileCountLimit_NandMovie = 100,

        //! @brief SD ストレージの画面写真ファイルの数の上限です。
        AlbumFileCountLimit_SdScreenShot = 10000,

        //! @brief SD ストレージの動画ファイルの数の上限です。
        AlbumFileCountLimit_SdMovie = 1000,

        //! @brief NAND ストレージのファイル数の上限です。
        AlbumFileCountLimit_Nand =
            AlbumFileCountLimit_NandScreenShot +
            AlbumFileCountLimit_NandMovie,

        //! @brief SD ストレージのファイル数の上限です。
        AlbumFileCountLimit_Sd =
            AlbumFileCountLimit_SdScreenShot +
            AlbumFileCountLimit_SdMovie,

        //! @brief 全ストレージの画面写真ファイルの数の上限の合算値です。
        AlbumFileCountLimit_ScreenShot =
            AlbumFileCountLimit_NandScreenShot +
            AlbumFileCountLimit_SdScreenShot,

        //! @brief 全ストレージの動画ファイルの数の上限の合算値です。
        AlbumFileCountLimit_Movie =
            AlbumFileCountLimit_NandMovie +
            AlbumFileCountLimit_SdMovie,

        //! @brief 全ストレージのアプリ独自動画ファイル数の上限の合算値です。
        AlbumFileCountLimit_ExtraMovie =
            AlbumFileCountLimit_SdMovie,
    };

}}
