﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include <nn/nn_Common.h>

namespace nn{ namespace capsrv{

    //! @brief 高速化のためキャッシュしているアルバムの情報です。
    //! @details
    //!   この情報は起動ごとに作成しなおす必要があります。
    struct AlbumCacheData
    {
        //! @brief アルバム内の全ファイル数です。
        //! @details
        //!   capsrv 管理対象外のファイルもカウントされます。
        //!   サブディレクトリやサブディレクトリ内のファイルはカウントされません。
        int64_t fileCount;

        int64_t _reserved;
    };

}}
