﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include <nn/nn_Common.h>
#include <nn/nn_Result.h>
#include "capsrv_Result.h"
#include "capsrv_AlbumFileId.h"
#include "capsrv_ScreenShotAttribute.h"
#include "capsrv_ScreenShotDecodeOption.h"
#include "capsrv_AppletData.h"
#include "capsrv_ApplicationData.h"
#include "capsrv_SystemReservedInfo.h"

namespace nn{ namespace capsrv{

    //! @brief アルバムファイル中の MakerNoteInfo 情報を取得します。
    //!
    //! @param[out] pOutFileSize    ファイルサイズの格納先
    //! @param[out] pOutInfoBuffer  MakerNoteInfo の格納先バッファ
    //! @param[in]  infoBufferSize  MakerNoteInfo の格納先バッファのサイズ
    //! @param[in]  fileId          対象ファイルの識別子
    //! @param[in]  pWorkBuffer     作業用バッファ
    //! @param[in]  workBufferSize  作業用バッファの大きさ（バイト）
    //!
    //! @pre アルバムへのアクセス機能が初期化されている
    //! @pre infoBufferSize >= sizeof(nn::capsrv::server::detail::MakerNoteInfo)
    //! @pre workBufferSize >= nn::capsrv::AlbumFileSizeLimit_ScreenShot
    //! @post 成功失敗に関わらず pWorkBuffer は 0 埋めされる
    //!
    //! @details
    //! この関数は開発機専用です。
    //  製品機では常に nn::capsrv::ResultNotSupported でアボートします。
    //!
    //! fileId で指定されたアルバムファイルの MakerNoteInfo を取得し、
    //! pOutInfoBuffer, infoBufferSize で指定されたバッファに格納します。
    //! 対象ファイルに含まれる実際の MakerNoteInfo よりも infoBufferSize が
    //! 大きい場合には、pOutInfoBuffer の残りの領域はゼロ埋めされます。
    //!
    nn::Result LoadMakerNoteInfoForDebug(
        uint64_t* pOutFileSize,
        void* pOutInfoBuffer,
        size_t infoBufferSize,
        const AlbumFileId& fileId,
        void* pWorkBuffer,
        size_t workBufferSize
        ) NN_NOEXCEPT;

//! @}

}}
